package net.tlotd.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import net.minecraft.class_1277;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1869;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3956;
import net.minecraft.class_5455;
import net.minecraft.recipe.*;

public class IncubatonRecipe implements class_1860<class_1277> {

    private final class_2960 id;
    private final class_1799 output;
    private final class_2371<class_1856> recipeItems;

    public IncubatonRecipe(class_2960 id, class_1799 output, class_2371<class_1856> recipeItems) {
        this.id = id;
        this.output = output;
        this.recipeItems = recipeItems;
    }

    @Override
    public boolean matches(class_1277 inventory, class_1937 world) {
        if(world.method_8608()) {
            return false;
        }
        return (recipeItems.get(0).method_8093((inventory.method_5438(0))) && recipeItems.get(1).method_8093(inventory.method_5438(1)));
    }

    @Override
    public class_1799 craft(class_1277 inventory, class_5455 registryManager) {
        return output;
    }

    @Override
    public boolean method_8113(int width, int height) {
        return true;
    }

    @Override
    public class_1799 method_8110(class_5455 registryManager) {
        return output.method_7972();
    }

    @Override
    public class_2960 method_8114() {
        return id;
    }

    @Override
    public class_1865<?> method_8119() {
        return Serializer.INSTANCE;
    }

    @Override
    public class_3956<?> method_17716() {
        return Type.INSTANCE;
    }

    public static class Type implements class_3956<IncubatonRecipe> {
        private Type() { }
        public static final Type INSTANCE = new Type();
        public static final String ID = "incubation";
    }

    public static class Serializer implements class_1865<IncubatonRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final String ID = "incubation";

        @Override
        public IncubatonRecipe method_8121(class_2960 id, JsonObject json) {
            class_1799 output = class_1869.method_35228(class_3518.method_15296(json, "output"));

            JsonArray ingredients = class_3518.method_15261(json, "ingredients");
            class_2371<class_1856> inputs = class_2371.method_10213(2, class_1856.field_9017);

            for (int i = 0; i < ingredients.size(); i++) {
                inputs.set(i, class_1856.method_52177(ingredients.get(i)));
            }

            return new IncubatonRecipe(id, output, inputs);
        }

        @Override
        public IncubatonRecipe method_8122(class_2960 id, class_2540 buf) {
            class_2371<class_1856> inputs = class_2371.method_10213(buf.readInt(), class_1856.field_9017);

            inputs.replaceAll(ignored -> class_1856.method_8086(buf));

            class_1799 output = buf.method_10819();
            return new IncubatonRecipe(id, output, inputs);
        }

        @Override
        public void write(class_2540 buf, IncubatonRecipe recipe) {
            buf.writeInt(recipe.method_8117().size());
            for (class_1856 ing : recipe.method_8117()) {
                ing.method_8088(buf);
            }
            buf.method_10793(recipe.method_8110(null));
        }
    }
}
