package net.tlotd.world.dimension;

import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_1992;
import net.minecraft.class_2874;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_5363;
import net.minecraft.class_6019;
import net.minecraft.class_6880;
import net.minecraft.class_7134;
import net.minecraft.class_7871;
import net.minecraft.class_7891;
import net.minecraft.class_7924;
import net.minecraft.registry.*;
import net.tlotd.TLOTD;
import net.tlotd.util.ModTags;
import net.tlotd.world.biome.ModBiomes;

import java.util.OptionalLong;

public class ModDimensions {
    public static final class_5321<class_5363> PREHISTORIC_KEY = class_5321.method_29179(class_7924.field_41224,
            new class_2960(TLOTD.MOD_ID, "prehistoric"));
    public static final class_5321<class_1937> PREHISTORIC_LEVEL_KEY = class_5321.method_29179(class_7924.field_41223,
            new class_2960(TLOTD.MOD_ID, "prehistoric"));
    public static final class_5321<class_2874> PREHISTORIC_TYPE = class_5321.method_29179(class_7924.field_41241,
            new class_2960(TLOTD.MOD_ID, "prehistoric"));

    public static final class_5321<class_5363> LUNA_KEY = class_5321.method_29179(class_7924.field_41224,
            new class_2960(TLOTD.MOD_ID, "luna"));
    public static final class_5321<class_1937> LUNA_LEVEL_KEY = class_5321.method_29179(class_7924.field_41223,
            new class_2960(TLOTD.MOD_ID, "luna"));
    public static final class_5321<class_2874> LUNA_TYPE = class_5321.method_29179(class_7924.field_41241,
            new class_2960(TLOTD.MOD_ID, "luna"));

    public static void bootstrapType(class_7891<class_2874> context) {
        context.method_46838(PREHISTORIC_TYPE, new class_2874(
                OptionalLong.of(12000), // fixedTime
                true, // hasSkylight
                false, // hasCeiling
                false, // ultraWarm
                true, // natural
                1.0, // coordinateScale
                true, // bedWorks
                true, // respawnAnchorWorks
                -64, // minY
                384, // height
                320, // logicalHeight
                ModTags.Blocks.INFINIBURN_PREHISTORIC, // infiniburn
                class_7134.field_37670, // effectsLocation
                0f, // ambientLight
                new class_2874.class_7512(false, false, class_6019.method_35017(0, 0), 0)));

        context.method_46838(LUNA_TYPE, new class_2874(
                OptionalLong.of(0), // fixedTime
                true, // hasSkylight
                false, // hasCeiling
                false, // ultraWarm
                false, // natural
                1.0, // coordinateScale
                false, // bedWorks
                true, // respawnAnchorWorks
                -64, // minY
                384, // height
                320, // logicalHeight
                ModTags.Blocks.INFINIBURN_LUNA, // infiniburn
                class_7134.field_37672, // effectsLocation
                0f, // ambientLight
                new class_2874.class_7512(false, false, class_6019.method_35017(0, 0), 0)));
    }

    public static void bootstrapDimension(class_7891<class_5363> context) {
        class_7871<class_2874> dimensionTypes = context.method_46799(class_7924.field_41241);
        class_7871<class_1959> biomes = context.method_46799(class_7924.field_41236);

        class_6880<class_2874> prehistoricDimensionType = dimensionTypes.method_46747(PREHISTORIC_TYPE);
        class_6880<class_2874> lunaDimensionType = dimensionTypes.method_46747(LUNA_TYPE);

        class_6880<class_1959> prehistoricJungle = biomes.method_46747(ModBiomes.PREHISTORIC_JUNGLE);
        class_6880<class_1959> lunarHighlands = biomes.method_46747(ModBiomes.LUNAR_HIGHLANDS);

        class_1992 prehistoricSource = new class_1992(prehistoricJungle);
        class_1992 lunarSource = new class_1992(lunarHighlands);

        PrehistoricChunkGenerator prehistoricGenerator = new PrehistoricChunkGenerator(prehistoricSource);
        LunarChunkGenerator lunarGenerator = new LunarChunkGenerator(lunarSource);

        context.method_46838(PREHISTORIC_KEY, new class_5363(prehistoricDimensionType, prehistoricGenerator));
        context.method_46838(LUNA_KEY, new class_5363(lunaDimensionType, lunarGenerator));
    }
}