/*
 * Decompiled with CFR 0.152.
 */
package net.tlotd.world.dimension;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.class_1923;
import net.minecraft.class_1966;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2794;
import net.minecraft.class_2893;
import net.minecraft.class_2902;
import net.minecraft.class_3233;
import net.minecraft.class_3756;
import net.minecraft.class_4543;
import net.minecraft.class_4966;
import net.minecraft.class_5138;
import net.minecraft.class_5539;
import net.minecraft.class_5819;
import net.minecraft.class_6748;
import net.minecraft.class_7138;
import net.tlotd.block.ModBlocks;
import net.tlotd.config.ModConfigs;

public class LunarChunkGenerator
extends class_2794 {
    public static final Codec<LunarChunkGenerator> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_1966.field_24713.fieldOf("biome_source").forGetter(generator -> generator.biomeSource)).apply((Applicative)instance, LunarChunkGenerator::new));
    private final class_1966 biomeSource;
    private final class_3756 heightNoise;

    public LunarChunkGenerator(class_1966 biomeSource) {
        super(biomeSource);
        this.biomeSource = biomeSource;
        this.heightNoise = new class_3756(class_5819.method_43049((long)ModConfigs.LUNAR_SEED));
    }

    protected Codec<? extends class_2794> method_28506() {
        return CODEC;
    }

    public void method_12108(class_3233 chunkRegion, long seed, class_7138 noiseConfig, class_4543 biomeAccess, class_5138 structureAccessor, class_2791 chunk, class_2893.class_2894 carverStep) {
    }

    public void method_12110(class_3233 region, class_5138 structures, class_7138 noiseConfig, class_2791 chunk) {
    }

    public void method_12107(class_3233 region) {
    }

    public int method_12104() {
        return 320;
    }

    public CompletableFuture<class_2791> method_12088(Executor executor, class_6748 blender, class_7138 noiseConfig, class_5138 structureAccessor, class_2791 chunk) {
        class_1923 chunkPos = chunk.method_12004();
        for (int dx = 0; dx < 16; ++dx) {
            for (int dz = 0; dz < 16; ++dz) {
                int dy;
                int worldX = chunkPos.method_8326() + dx;
                int worldZ = chunkPos.method_8328() + dz;
                double noise = this.heightNoise.method_33658((double)worldX * 0.05, 0.0, (double)worldZ * 0.05);
                int height = 48 + (int)(noise * 16.0);
                for (dy = chunk.method_31607(); dy <= height && dy < chunk.method_31600(); ++dy) {
                    class_2680 state = dy == height ? ModBlocks.LUNAR_REGOLITH.method_9564() : ModBlocks.MEGAREGOLITH.method_9564();
                    if (dy < chunk.method_31607() || dy >= chunk.method_31600()) continue;
                    chunk.method_12010(new class_2338(dx, dy, dz), state, false);
                }
                chunk.method_12010(new class_2338(dx, chunk.method_31607(), dz), class_2246.field_9987.method_9564(), false);
                for (dy = chunk.method_31607() + 1; dy < chunk.method_31607() + 5; ++dy) {
                    long seed = class_2338.method_10064((int)worldX, (int)dy, (int)worldZ) ^ (long)ModConfigs.LUNAR_SEED ^ 0xDEADBEEFL;
                    class_5819 random = class_5819.method_43049((long)seed);
                    if (random.method_43048(5) <= dy - chunk.method_31607()) continue;
                    chunk.method_12010(new class_2338(dx, dy, dz), class_2246.field_9987.method_9564(), false);
                }
            }
        }
        return CompletableFuture.completedFuture(chunk);
    }

    public int method_16398() {
        return -64;
    }

    public int method_33730() {
        return -64;
    }

    public int method_16397(int x, int z, class_2902.class_2903 heightmap, class_5539 world, class_7138 config) {
        double noise = this.heightNoise.method_33658((double)x * 0.05, 0.0, (double)z * 0.05);
        return 48 + (int)(noise * 16.0);
    }

    public class_4966 method_26261(int x, int z, class_5539 world, class_7138 config) {
        int height = this.method_16397(x, z, class_2902.class_2903.field_13202, world, config);
        Object[] states = new class_2680[height];
        Arrays.fill(states, class_2246.field_10340.method_9564());
        return new class_4966(0, (class_2680[])states);
    }

    public void method_40450(List<String> text, class_7138 config, class_2338 pos) {
        text.add("LunarChunkGenerator: moon terrain");
    }
}

