/*
 * Decompiled with CFR 0.152.
 */
package net.tlotd.api;

import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.world.ServerWorld;
import net.minecraft.util.Hand;
import net.minecraft.util.Identifier;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.tlotd.block.custom.ComputerBlock;
import net.tlotd.block.custom.TelevisionBlock;
import net.tlotd.util.TelevisionSignalRegistry;
import net.tlotd.util.VideoGameRegistry;
import net.tlotd.world.CustomTextureManager;
import net.tlotd.world.ModGlobalState;
import net.tlotd.world.SignalTrackingArray;

public class TlotdAPI {
    public static int getCustomTexture(MinecraftServer server, UUID player) {
        return CustomTextureManager.get((MinecraftServer)server).getTexture(player);
    }

    public static boolean hasCustomTexture(MinecraftServer server, UUID player) {
        return CustomTextureManager.get((MinecraftServer)server).hasTexture(player);
    }

    public static BlockState handleTelevisionUse(BlockState state, World world, BlockPos pos, PlayerEntity player) {
        return TelevisionBlock.handleTelevisionUse((BlockState)state, (World)world, (BlockPos)pos, (PlayerEntity)player);
    }

    public static Collection<TelevisionSignal> getAllTelevisionSignals() {
        return TelevisionSignalRegistry.getAll().stream().map(e -> new TelevisionSignal(e.signalItem(), e.offBlock(), e.onBlock(), e.channel())).toList();
    }

    public static Optional<TelevisionSignal> findTelevisionSignal(Identifier signalId) {
        return TelevisionSignalRegistry.findBySignal((Identifier)signalId).map(e -> new TelevisionSignal(e.signalItem(), e.offBlock(), e.onBlock(), e.channel()));
    }

    public static void registerTelevisionSignal(TelevisionSignal entry) {
        TelevisionSignalRegistry.register((TelevisionSignalRegistry.SignalEntry)new TelevisionSignalRegistry.SignalEntry(entry.signalItem(), entry.offBlock(), entry.onBlock(), entry.channel()));
    }

    public static void registerTelevisionSignalBatch(Identifier[] itemIds, Block offBlock, Block onBlock, int startingChannel) {
        TelevisionSignalRegistry.registerBatch((Identifier[])itemIds, (Block)offBlock, (Block)onBlock, (int)startingChannel);
    }

    public static BlockState handleComputerUse(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand) {
        return ComputerBlock.handleComputerUse((BlockState)state, (World)world, (BlockPos)pos, (PlayerEntity)player, (Hand)hand);
    }

    public static Collection<VideoGame> getAllVideoGames() {
        return VideoGameRegistry.getAll().stream().map(e -> new VideoGame(e.signalItem(), e.tvBlock(), e.computerBlock(), e.gameID())).toList();
    }

    public static Optional<VideoGame> findVideoGame(Identifier signalId) {
        return VideoGameRegistry.findBySignal((Identifier)signalId).map(e -> new VideoGame(e.signalItem(), e.tvBlock(), e.computerBlock(), e.gameID()));
    }

    public static void registerVideoGame(VideoGame entry) {
        VideoGameRegistry.register((VideoGameRegistry.SignalEntry)new VideoGameRegistry.SignalEntry(entry.signalItem(), entry.tvBlock(), entry.computerBlock(), entry.gameID()));
    }

    public static void registerVideoGameBatch(Identifier[] itemIds, Block offBlock, Block onBlock, int startingGameID) {
        VideoGameRegistry.registerBatch((Identifier[])itemIds, (Block)offBlock, (Block)onBlock, (int)startingGameID);
    }

    public static boolean hasAnySignals(ServerWorld world) {
        return SignalTrackingArray.get((ServerWorld)world).hasAnySignals();
    }

    public static boolean hasSignal(ServerWorld world, Identifier id) {
        return SignalTrackingArray.get((ServerWorld)world).hasSignal(id);
    }

    public static boolean hasSignal(ServerWorld world, Item item) {
        return SignalTrackingArray.get((ServerWorld)world).hasSignal(item);
    }

    public static int getSignalCount(ServerWorld world) {
        return SignalTrackingArray.get((ServerWorld)world).getSignalCount();
    }

    public static Set<Identifier> getAllSignals(ServerWorld world) {
        return SignalTrackingArray.get((ServerWorld)world).getAllSignals();
    }

    public void addSignal(ServerWorld world, Item item) {
        SignalTrackingArray.get((ServerWorld)world).addSignal(item);
    }

    public void removeSignal(ServerWorld world, Item item) {
        SignalTrackingArray.get((ServerWorld)world).removeSignal(item);
    }

    public void clearSignals(ServerWorld world) {
        SignalTrackingArray.get((ServerWorld)world).clearSignals();
    }

    public static boolean formerTlotdRewards(MinecraftServer server) {
        return ModGlobalState.get((MinecraftServer)server).formerTlotdRewards();
    }

    public record TelevisionSignal(Identifier signalItem, Block offBlock, Block onBlock, int channel) {
    }

    public record VideoGame(Identifier signalItem, Block tvBlock, Block computerBlock, int gameID) {
    }
}

