package net.tlotd;

import com.terraformersmc.terraform.boat.api.client.TerraformBoatClientHelper;
import com.terraformersmc.terraform.sign.SpriteIdentifierRegistry;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.render.fluid.v1.FluidRenderHandlerRegistry;
import net.fabricmc.fabric.api.client.render.fluid.v1.SimpleFluidRenderHandler;
import net.fabricmc.fabric.api.client.rendering.v1.EntityModelLayerRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.EntityRendererRegistry;
import net.minecraft.class_2960;
import net.minecraft.class_3929;
import net.minecraft.class_4722;
import net.minecraft.class_4730;
import net.minecraft.class_5616;
import net.tlotd.block.ModBlocks;
import net.tlotd.block.entity.ModBlockEntities;
import net.tlotd.block.entity.renderer.*;
import net.tlotd.client.ModBlockRenderLayerMap;
import net.tlotd.client.ModItemRenderLayerMap;
import net.tlotd.entity.ModBoats;
import net.tlotd.entity.ModEntities;
import net.tlotd.entity.client.*;
import net.tlotd.fluid.ModFluids;
import net.tlotd.gui.*;
import net.tlotd.networking.ModMessages;

public class TLOTDClient implements ClientModInitializer {
    @Override
    public void onInitializeClient() {
        FluidRenderHandlerRegistry.INSTANCE.register(ModFluids.STILL_SPEZI, ModFluids.FLOWING_SPEZI, new SimpleFluidRenderHandler(new class_2960("tlotd:block/spezi_still"), new class_2960("tlotd:block/spezi_flow")));
        FluidRenderHandlerRegistry.INSTANCE.register(ModFluids.STILL_BEER, ModFluids.FLOWING_BEER, new SimpleFluidRenderHandler(new class_2960("tlotd:block/beer_still"), new class_2960("tlotd:block/beer_flow")));
        FluidRenderHandlerRegistry.INSTANCE.register(ModFluids.STILL_MEAD, ModFluids.FLOWING_MEAD, new SimpleFluidRenderHandler(new class_2960("tlotd:block/mead_still"), new class_2960("tlotd:block/mead_flow")));
        FluidRenderHandlerRegistry.INSTANCE.register(ModFluids.STILL_HOT_MILK, ModFluids.FLOWING_HOT_MILK, new SimpleFluidRenderHandler(new class_2960("tlotd:block/hot_milk_still"), new class_2960("tlotd:block/hot_milk_flow")));
        FluidRenderHandlerRegistry.INSTANCE.register(ModFluids.STILL_HOT_CHOCOLATE, ModFluids.FLOWING_HOT_CHOCOLATE, new SimpleFluidRenderHandler(new class_2960("tlotd:block/hot_chocolate_still"), new class_2960("tlotd:block/hot_chocolate_flow")));
        FluidRenderHandlerRegistry.INSTANCE.register(ModFluids.STILL_OIL, ModFluids.FLOWING_OIL, new SimpleFluidRenderHandler(new class_2960("tlotd:block/oil_still"), new class_2960("tlotd:block/oil_flow")));
        FluidRenderHandlerRegistry.INSTANCE.register(ModFluids.STILL_BLOOD, ModFluids.FLOWING_BLOOD, new SimpleFluidRenderHandler(new class_2960("tlotd:block/blood_still"), new class_2960("tlotd:block/blood_flow")));
        FluidRenderHandlerRegistry.INSTANCE.register(ModFluids.STILL_CHEMICAL_WASTE, ModFluids.FLOWING_CHEMICAL_WASTE, new SimpleFluidRenderHandler(new class_2960("tlotd:block/chemical_waste_still"), new class_2960("tlotd:block/chemical_waste_flow")));
        FluidRenderHandlerRegistry.INSTANCE.register(ModFluids.STILL_SWEET_BERRY_JAM, ModFluids.FLOWING_SWEET_BERRY_JAM, new SimpleFluidRenderHandler(new class_2960("tlotd:block/sweet_berry_jam_still"), new class_2960("tlotd:block/sweet_berry_jam_flow")));
        FluidRenderHandlerRegistry.INSTANCE.register(ModFluids.STILL_GLOW_BERRY_JAM, ModFluids.FLOWING_GLOW_BERRY_JAM, new SimpleFluidRenderHandler(new class_2960("tlotd:block/glow_berry_jam_still"), new class_2960("tlotd:block/glow_berry_jam_flow")));
        FluidRenderHandlerRegistry.INSTANCE.register(ModFluids.STILL_STRAWBERRY_JAM, ModFluids.FLOWING_STRAWBERRY_JAM, new SimpleFluidRenderHandler(new class_2960("tlotd:block/strawberry_jam_still"), new class_2960("tlotd:block/strawberry_jam_flow")));
        FluidRenderHandlerRegistry.INSTANCE.register(ModFluids.STILL_ORANGE_MARMELADE, ModFluids.FLOWING_ORANGE_MARMELADE, new SimpleFluidRenderHandler(new class_2960("tlotd:block/orange_marmelade_still"), new class_2960("tlotd:block/orange_marmelade_flow")));
        FluidRenderHandlerRegistry.INSTANCE.register(ModFluids.STILL_BLUE_BERRY_JAM, ModFluids.FLOWING_BLUE_BERRY_JAM, new SimpleFluidRenderHandler(new class_2960("tlotd:block/blue_berry_jam_still"), new class_2960("tlotd:block/blue_berry_jam_flow")));
        FluidRenderHandlerRegistry.INSTANCE.register(ModFluids.STILL_DROOPFRUIT_JAM, ModFluids.FLOWING_DROOPFRUIT_JAM, new SimpleFluidRenderHandler(new class_2960("tlotd:block/droopfruit_jam_still"), new class_2960("tlotd:block/droopfruit_jam_flow")));
        FluidRenderHandlerRegistry.INSTANCE.register(ModFluids.STILL_ANCIENT_SOULBERRY_JAM, ModFluids.FLOWING_ANCIENT_SOULBERRY_JAM, new SimpleFluidRenderHandler(new class_2960("tlotd:block/ancient_soulberry_jam_still"), new class_2960("tlotd:block/ancient_soulberry_jam_flow")));

        ModBlockRenderLayerMap.registerBlockRenderLayerMaps();
        ModItemRenderLayerMap.registerItemRenderLayerMaps();

        EntityRendererRegistry.register(ModEntities.TREX, TRexRenderer::new);
        EntityModelLayerRegistry.registerModelLayer(ModModelLayers.TREX, TRexModel::getTexturedModelData);

        EntityRendererRegistry.register(ModEntities.INFECTED_TREX, InfectedTRexRenderer::new);
        EntityModelLayerRegistry.registerModelLayer(ModModelLayers.INFECTED_TREX, InfectedTRexModel::getTexturedModelData);

        EntityRendererRegistry.register(ModEntities.SEAT, SeatRenderer::new);

        EntityRendererRegistry.register(ModEntities.ARMOR_PIERCING_ARROW, SilverthornArrowEntityRenderer::new);

        SpriteIdentifierRegistry.INSTANCE.addIdentifier(new class_4730(class_4722.field_21708, ModBlocks.GINKGO_SIGN_TEXTURE));
        SpriteIdentifierRegistry.INSTANCE.addIdentifier(new class_4730(class_4722.field_21708, ModBlocks.GINKGO_HANGING_SIGN_TEXTURE));

        TerraformBoatClientHelper.registerModelLayers(ModBoats.GINKGO_BOAT_ID, false);

        class_3929.method_17542(ModGUIHandlers.MITHRIL_ANVIL_GUI_HANDLER, MithrilAnvilGUI::new);
        class_5616.method_32144(ModBlockEntities.MITHRIL_ANVIL_BLOCK_ENTITY, MithrilAnvilBlockEntityRenderer::new);

        class_3929.method_17542(ModGUIHandlers.WITCHING_TABLE_GUI_HANDLER, WitchingTableGUI::new);
        class_5616.method_32144(ModBlockEntities.WITCHING_TABLE_BLOCK_ENTITY, WitchingTableBlockEntityRenderer::new);

        class_3929.method_17542(ModGUIHandlers.INCUBATOR_GUI_HANDLER, IncubatorGUI::new);

        class_3929.method_17542(ModGUIHandlers.OXYGEN_COLLECTOR_GUI_HANDLER, OxygenCollectorGUI::new);

        class_3929.method_17542(ModGUIHandlers.KEYCARD_PROGRAMMER_GUI_HANDLER, KeycardProgrammerGUI::new);

        ModMessages.registerS2CPackets();
    }
}
