package net.tlotd.api;

import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.server.MinecraftServer;
import net.tlotd.util.VideoGameRegistry;

import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;

public class TlotdAPI {

    public record TelevisionSignal(class_2960 signalItem, class_2248 offBlock, class_2248 onBlock, int channel) {}

    public record VideoGame(class_2960 signalItem, class_2248 tvBlock, class_2248 computerBlock, int gameID) {}

    //Textures
    public static int getCustomTexture(MinecraftServer server, UUID player) {
        return net.tlotd.world.CustomTextureManager.get(server).getTexture(player);
    }
    public static boolean hasCustomTexture(MinecraftServer server, UUID player) {
        return net.tlotd.world.CustomTextureManager.get(server).hasTexture(player);
    }

    //TV Signal List
    public static class_2680 handleTelevisionUse(class_2680 state, class_1937 world, class_2338 pos, class_1657 player) {
        return net.tlotd.block.custom.TelevisionBlock.handleTelevisionUse(state, world, pos, player);
    }
    public static Collection<TelevisionSignal> getAllTelevisionSignals() {
        return net.tlotd.util.TelevisionSignalRegistry.getAll().stream()
                .map(e -> new TelevisionSignal(e.signalItem(), e.offBlock(), e.onBlock(), e.channel()))
                .toList();
    }
    public static Optional<TelevisionSignal> findTelevisionSignal(class_2960 signalId) {
        return net.tlotd.util.TelevisionSignalRegistry.findBySignal(signalId)
                .map(e -> new TelevisionSignal(e.signalItem(), e.offBlock(), e.onBlock(), e.channel()));
    }
    public static void registerTelevisionSignal(TelevisionSignal entry) {
        net.tlotd.util.TelevisionSignalRegistry.register(new net.tlotd.util.TelevisionSignalRegistry.SignalEntry(
                entry.signalItem(),
                entry.offBlock(),
                entry.onBlock(),
                entry.channel()
        ));
    }
    public static void registerTelevisionSignalBatch(class_2960[] itemIds, class_2248 offBlock, class_2248 onBlock, int startingChannel) {
        net.tlotd.util.TelevisionSignalRegistry.registerBatch(itemIds, offBlock, onBlock, startingChannel);
    }

    //Video Game Registry
    public static class_2680 handleComputerUse(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand) {
        return net.tlotd.block.custom.ComputerBlock.handleComputerUse(state, world, pos, player, hand);
    }

    public static Collection<VideoGame> getAllVideoGames() {
        return net.tlotd.util.VideoGameRegistry.getAll().stream()
                .map(e -> new VideoGame(e.signalItem(), e.tvBlock(), e.computerBlock(), e.gameID()))
                .toList();
    }
    public static Optional<VideoGame> findVideoGame(class_2960 signalId) {
        return net.tlotd.util.VideoGameRegistry.findBySignal(signalId)
                .map(e -> new VideoGame(e.signalItem(), e.tvBlock(), e.computerBlock(), e.gameID()));
    }
    public static void registerVideoGame(VideoGame entry) {
        net.tlotd.util.VideoGameRegistry.register(new net.tlotd.util.VideoGameRegistry.SignalEntry(
                entry.signalItem(),
                entry.tvBlock(),
                entry.computerBlock(),
                entry.gameID()
        ));
    }
    public static void registerVideoGameBatch(class_2960[] itemIds, class_2248 offBlock, class_2248 onBlock, int startingGameID) {
        net.tlotd.util.VideoGameRegistry.registerBatch(itemIds, offBlock, onBlock, startingGameID);
    }

    //Signals
    public static boolean hasAnySignals(class_3218 world) {
        return net.tlotd.world.SignalTrackingArray.get(world).hasAnySignals();
    }
    public static boolean hasSignal(class_3218 world, class_2960 id) {
        return net.tlotd.world.SignalTrackingArray.get(world).hasSignal(id);
    }
    public static boolean hasSignal(class_3218 world, class_1792 item) {
        return net.tlotd.world.SignalTrackingArray.get(world).hasSignal(item);
    }
    public static int getSignalCount(class_3218 world) {
        return net.tlotd.world.SignalTrackingArray.get(world).getSignalCount();
    }
    public static Set<class_2960> getAllSignals(class_3218 world) {
        return net.tlotd.world.SignalTrackingArray.get(world).getAllSignals();
    }
    public void addSignal(class_3218 world, class_1792 item) {
        net.tlotd.world.SignalTrackingArray.get(world).addSignal(item);
    }
    public void removeSignal(class_3218 world, class_1792 item) {
        net.tlotd.world.SignalTrackingArray.get(world).removeSignal(item);
    }
    public void clearSignals(class_3218 world) {
        net.tlotd.world.SignalTrackingArray.get(world).clearSignals();
    }

    //TLOTD Stuff
    public static boolean formerTlotdRewards(MinecraftServer server) {
        return net.tlotd.world.ModGlobalState.get(server).formerTlotdRewards();
    }
}