package net.tlotd.block.custom;

import net.minecraft.block.*;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2383;
import net.minecraft.class_2464;
import net.minecraft.class_2470;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2753;
import net.minecraft.class_2758;
import net.minecraft.class_3218;
import net.minecraft.class_3610;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3730;
import net.minecraft.class_3965;
import net.tlotd.block.ModBlocks;
import net.tlotd.entity.ModEntities;
import net.tlotd.entity.custom.SeatEntity;
import org.jetbrains.annotations.Nullable;

import java.util.List;

public class BenchBlock extends class_2248 {

    public static final class_2746 WATERLOGGED = class_2741.field_12508;
    public static final class_2753 FACING = class_2383.field_11177;
    public static final class_2758 BENCH = class_2758.method_11867("bench", 0,3);

    @Override
    public class_2680 method_9605(class_1750 ctx) {
        return this.method_9564()
                .method_11657(FACING, ctx.method_8042())
                .method_11657(WATERLOGGED, ctx.method_8045().method_8316(ctx.method_8037()).method_39360(class_3612.field_15910))
                .method_11657(BENCH, 0);

    }

    @Override
    public class_3610 method_9545(class_2680 state) {
        return state.method_11654(WATERLOGGED) ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState,
                                                class_1936 world, class_2338 pos, class_2338 neighborPos) {
        if (state.method_11654(WATERLOGGED)) {
            world.method_39281(pos, class_3612.field_15910, class_3612.field_15910.method_15789(world));
        }

        if (!world.method_8608()) {
            class_2680 newState = updateBenchState(world, pos, state);
            if (newState != state) {
                world.method_8652(pos, newState, class_2248.field_31036);
            }
        }

        return state;
    }

    @Override
    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return state.method_11657(FACING, rotation.method_10503(state.method_11654(FACING)));
    }

    @Override
    public void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(FACING, WATERLOGGED, BENCH);
    }

    public BenchBlock(class_2251 settings) {
        super(settings);
        this.method_9590(this.field_10647.method_11664().method_11657(FACING, class_2350.field_11043).method_11657(WATERLOGGED, false).method_11657(BENCH, 0));
    }

    private static final class_265 BASE_SHAPE = class_2248.method_9541(0,0,0,16,8,16);

    public static final class_265 WEST_SHAPE = class_259.method_1084(
            class_2248.method_9541(0, 8, 0, 1, 21, 16),
            BASE_SHAPE
    );
    public static final class_265 NORTH_SHAPE = class_259.method_1084(
            class_2248.method_9541(0, 8, 0, 16, 21, 1),
            BASE_SHAPE
    );
    public static final class_265 EAST_SHAPE = class_259.method_1084(
            class_2248.method_9541(15, 8, 0, 16, 21, 16),
            BASE_SHAPE
    );
    public static final class_265 SOUTH_SHAPE = class_259.method_1084(
            class_2248.method_9541(0, 8, 15, 16, 21, 16),
            BASE_SHAPE
    );

    @Override
    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return switch (state.method_11654(FACING)) {
            case field_11043 -> NORTH_SHAPE;
            case field_11035 -> SOUTH_SHAPE;
            case field_11034 -> EAST_SHAPE;
            case field_11039 -> WEST_SHAPE;
            default -> BASE_SHAPE;
        };
    }

    @Override
    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    @Override
    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        if(!world.field_9236){
            class_1297 entity = null;
            List<SeatEntity> entities = world.method_18023(ModEntities.SEAT, new class_238(pos), chair -> true);
            if(entities.isEmpty()) {
                entity = ModEntities.SEAT.method_47821((class_3218) world, pos, class_3730.field_16461);
            } else {
                entity = entities.get(0);
            }
            player.method_5804(entity);
        }
        return class_1269.field_5812;
    }

    private class_2680 updateBenchState(class_1936 world, class_2338 pos, class_2680 state) {
        class_2350 facing = state.method_11654(FACING);
        boolean leftConnected = false;
        boolean rightConnected = false;
        class_2350 leftDir = facing.method_10160();
        class_2350 rightDir = facing.method_10170();
        class_2680 leftState = world.method_8320(pos.method_10093(leftDir));
        class_2680 rightState = world.method_8320(pos.method_10093(rightDir));
        if (leftState.method_27852(ModBlocks.BENCH) && leftState.method_11654(FACING) == facing) {
            leftConnected = true;
        }
        if (rightState.method_27852(ModBlocks.BENCH) && rightState.method_11654(FACING) == facing) {
            rightConnected = true;
        }
        int benchType;
        if (leftConnected && rightConnected) {
            benchType = 2;
        } else if (leftConnected) {
            benchType = 3;
        } else if (rightConnected) {
            benchType = 1;
        } else {
            benchType = 0;
        }
        return state.method_11657(BENCH, benchType);
    }

    @Override
    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 itemStack) {
        if (!world.field_9236) {
            class_2680 newState = updateBenchState(world, pos, state);
            world.method_8652(pos, newState, class_2248.field_31036);
            for (class_2350 dir : class_2350.class_2353.field_11062) {
                class_2338 neighborPos = pos.method_10093(dir);
                class_2680 neighbor = world.method_8320(neighborPos);
                if (neighbor.method_27852(ModBlocks.BENCH)) {
                    world.method_8652(neighborPos, updateBenchState(world, neighborPos, neighbor), class_2248.field_31036);
                }
            }
        }
        super.method_9567(world, pos, state, placer, itemStack);
    }
}
