package net.tlotd.block.custom;

import net.minecraft.block.*;
import net.minecraft.class_10;
import net.minecraft.class_124;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_2398;
import net.minecraft.class_2470;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2753;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_3610;
import net.minecraft.class_3612;
import net.minecraft.class_437;
import net.minecraft.class_4538;
import net.minecraft.class_5819;
import net.tlotd.block.ModBlocks;
import org.jetbrains.annotations.Nullable;

import java.util.List;

import static net.tlotd.block.custom.BloodCauldronBlock.LEVEL;

public class EffigiesBlock extends class_2248 {

    public static final class_2746 WATERLOGGED = class_2741.field_12508;
    public static final class_2753 FACING = class_2383.field_11177;

    @Override
    public boolean method_9558(class_2680 state, class_4538 world, class_2338 pos) {
        class_2350 direction = class_2350.field_11036;
        return (class_2248.method_20044(world, pos.method_10093(direction), direction.method_10153())|| world.method_8320(pos.method_10093(direction)).method_26164(class_3481.field_15503));
    }

    @Override
    public boolean method_9516(class_2680 state, class_1922 world, class_2338 pos, class_10 type) {
        return true;
    }

    @Override
    public void method_9548(class_2680 state, class_1937 world, class_2338 pos, class_1297 entity) {
        if (!world.field_9236) {
            if (entity.method_31747()) {
                class_3222 player = (class_3222) entity;
                if (!player.method_6059(class_1294.field_16595) || !player.method_6059(class_1294.field_18980)) {
                    player.method_6092(new class_1293(class_1294.field_16595, 60,0,true,false));
                }
            }
        }
        super.method_9548(state, world, pos, entity);
    }

    @Override
    public class_2680 method_9605(class_1750 ctx) {
        return this.method_9564()
                .method_11657(FACING, ctx.method_8042())
                .method_11657(WATERLOGGED, ctx.method_8045().method_8316(ctx.method_8037()).method_39360(class_3612.field_15910));
    }

    @Override
    public class_3610 method_9545(class_2680 state) {
        return state.method_11654(WATERLOGGED) ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    @Override
    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        if (state.method_11654(WATERLOGGED)) {
            world.method_39281(pos, class_3612.field_15910, class_3612.field_15910.method_15789(world));
        }

        return !state.method_26184(world, pos) ? class_2246.field_10124.method_9564() : super.method_9559(state, direction, neighborState, world, pos, neighborPos);
    }

    @Override
    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return state.method_11657(FACING, rotation.method_10503(state.method_11654(FACING)));
    }

    @Override
    public void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(FACING, WATERLOGGED);
    }

    public EffigiesBlock(class_2251 settings) {
        super(settings);
        this.method_9590(this.field_10647.method_11664().method_11657(FACING, class_2350.field_11043).method_11657(WATERLOGGED, false));
    }

    @Override
    public void method_9514(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        super.method_9514(state, world, pos, random);
        int search_y;
        for(search_y = 0; search_y>=-10; search_y--){
            if((world.method_8320(pos.method_10069(0, search_y,0)).method_27852(class_2246.field_10593)) || (world.method_8320(pos.method_10069(0, search_y,0)).method_27852(ModBlocks.BLOOD_CAULDRON) && world.method_8320(pos.method_10069(0, search_y,0)).method_11654(LEVEL) < 3)) {
                if (world.method_8320(pos.method_10069(0, search_y,0)).method_27852(class_2246.field_10593)) {
                    world.method_8501(pos.method_10069(0, search_y,0), ModBlocks.BLOOD_CAULDRON.method_34725(state));
                } else if (world.method_8320(pos.method_10069(0, search_y,0)).method_27852(ModBlocks.BLOOD_CAULDRON)) {
                    if (world.method_8320(pos.method_10069(0, search_y,0)).method_11654(LEVEL) == 1) {
                        world.method_8501(pos.method_10069(0, search_y,0), ModBlocks.BLOOD_CAULDRON.method_34725(state).method_11657(LEVEL,2));
                    } else if (world.method_8320(pos.method_10069(0, search_y,0)).method_11654(LEVEL) == 2) {
                        world.method_8501(pos.method_10069(0, search_y,0), ModBlocks.BLOOD_CAULDRON.method_34725(state).method_11657(LEVEL,3));
                    }
                }
                world.method_8396(null, pos.method_10069(0, search_y,0), class_3417.field_14817, class_3419.field_15245, 1.0f, 1.0f);
                world.method_8406(class_2398.field_11223,pos.method_10263(), pos.method_10264(), pos.method_10260(),0.0F, 0.5F, 0.0F);
            }
        }
    }

    public static final class_2960 ILLAGER_FONT_ID = new class_2960("minecraft", "illageralt");

    @Override
    public void method_9568(class_1799 stack, @Nullable class_1922 world, List<class_2561> tooltip, class_1836 options) {
        if (class_437.method_25442()) {
            tooltip.add(class_2561.method_43471("block.tlotd.effigies.tooltip").method_27692(class_124.field_1080));
            tooltip.add(class_2561.method_43471("block.tlotd.effigies.tooltip_2").method_27692(class_124.field_1080));
            tooltip.add(class_2561.method_43471("block.tlotd.effigies.tooltip_3").method_27692(class_124.field_1080));
        } else {
            class_2583 style = method_9518().method_10866();
            tooltip.add(class_2561.method_43471("block.tlotd.effigies.tooltip").method_10862(style.method_27704(ILLAGER_FONT_ID)).method_27692(class_124.field_1080));
            tooltip.add(class_2561.method_43471("block.tlotd.effigies.tooltip_2").method_10862(style.method_27704(ILLAGER_FONT_ID)).method_27692(class_124.field_1080));
            tooltip.add(class_2561.method_43471("block.tlotd.effigies.tooltip_3").method_10862(style.method_27704(ILLAGER_FONT_ID)).method_27692(class_124.field_1080));
        }
        tooltip.add(class_2561.method_43471("item.tlotd.desc_occult").method_27692(class_124.field_1061));
        super.method_9568(stack, world, tooltip, options);
    }
}
