package net.tlotd.block.custom;

import net.minecraft.block.*;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1922;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2746;
import net.minecraft.class_2758;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3612;
import net.minecraft.class_437;
import net.tlotd.config.ModConfigs;
import net.tlotd.world.CustomTextureManager;
import net.tlotd.world.ModGlobalState;
import org.jetbrains.annotations.Nullable;

import java.util.List;

public class PlayerPlushieBlock extends HumanPlushieBlock {

    public static final class_2758 SKIN = class_2758.method_11867("skin", 0, 127);
    public static final class_2746 ALTERNATIVE = class_2746.method_11825("alternative");
    public static final class_2746 CUSTOM = class_2746.method_11825("custom");

    private int getDefaultSkinFor(String uuid, boolean formerTLOTD) {
        return switch (uuid) {
            case "212aa6f5-69a9-47d9-9ad5-19b359744edf" -> 1;
            case "67148bd0-1a00-4bca-9d9e-ec246afbcf51" -> 2;
            case "53c68d22-726b-4a37-b92d-8d7c4670a87d" -> 3;
            case "660605b0-a3ac-404c-8f85-039cfddf36de" -> formerTLOTD ? 4 : 0; //AliaSophie
            case "0b026440-781b-40c3-bfee-78a2ee71f042" -> formerTLOTD ? 5 : 0; //Teneba
            case "d9ffb72a-f473-4ebc-936f-6f7d5d694145" -> 6;
            case "ebcc701d-5e03-4e57-9279-1dd595f6a4d4" -> formerTLOTD ? 7 : 0; //ISSO_21_
            case "9d978ae8-0368-442b-b4c4-fd27ad9f4888" -> formerTLOTD ? 8 : 0; //Akitorlp
            case "08c6cfba-40cd-43e2-a929-764e9fadc442" -> 9;
            case "d3018dca-9a16-43f0-8d72-19b93e33fa6b" -> 10;
            case "7c2b3137-729f-47af-b3f8-55a0994a8c61" -> formerTLOTD ? 11 : 0; //VANDAGR
            case "2dc144f0-3e65-4e80-978b-d6356e5d3008" -> 12;
            case "125cda9f-1a5b-40c5-b3a9-02c7988940f6" -> 13;
            case "9b293ed4-2a42-4db7-b615-246d81dc5d0f" -> 14;
            case "75fcce95-16a1-417b-801d-04ebb925d56b" -> 15;
            case "c639c27d-b32b-4785-805e-ba4889006a8b" -> 16;
            case "f31b18df-5db5-4e00-9adc-b66e89c69792" -> 17;
            case "4488478f-78d4-4885-be12-1f2179874912" -> 18;
            case "8365d4fc-c514-4c2e-a4e5-cf39fb26b0f0" -> 19;
            case "1987a906-540f-4ae8-90df-43504c06a6e7" -> 20;
            case "7af13cd9-4c28-4d48-a3f4-3cfbbce46438" -> 21;
            default -> 0;
        };
    }

    private boolean hasDefaultAlternate(String uuid, boolean formerTLOTD) {
        return switch (uuid) {
            case "212aa6f5-69a9-47d9-9ad5-19b359744edf",
                 "67148bd0-1a00-4bca-9d9e-ec246afbcf51",
                 "53c68d22-726b-4a37-b92d-8d7c4670a87d",
                 "d3018dca-9a16-43f0-8d72-19b93e33fa6b",
                 "125cda9f-1a5b-40c5-b3a9-02c7988940f6" -> true;
            case "ebcc701d-5e03-4e57-9279-1dd595f6a4d4" -> formerTLOTD;
            default -> false;
        };
    }

    @Override
    public class_2680 method_9605(class_1750 ctx) {
        class_1657 player = ctx.method_8036();
        class_3218 world = null;
        boolean formerTLOTD = false;
        if (player != null && !ctx.method_8045().field_9236 && player.method_5682() != null) {
            world = player.method_5682().method_30002();
            ModGlobalState globalState = ModGlobalState.get(player.method_5682());
            formerTLOTD = globalState.formerTlotdRewards();
        }
        int skin = 0;
        boolean alternative = false;
        boolean custom = false;
        if (world != null) {
            CustomTextureManager manager = CustomTextureManager.get(player.method_5682());
            int customId = manager.getTexture(player.method_5667());
            if (customId >= 0) {
                skin = customId;
                custom = true;
            } else {
                skin = getDefaultSkinFor(player.method_5845(), formerTLOTD);
                if (player.method_5715() && (skin == 0 || hasDefaultAlternate(player.method_5845(), formerTLOTD))) {
                    alternative = true;
                }
            }
        }
        return this.method_9564()
                .method_11657(FACING, ctx.method_8042())
                .method_11657(WATERLOGGED, ctx.method_8045().method_8316(ctx.method_8037()).method_39360(class_3612.field_15910))
                .method_11657(SKIN, skin)
                .method_11657(ALTERNATIVE, alternative)
                .method_11657(CUSTOM, custom);
    }

    @Override
    public void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(FACING, WATERLOGGED, SKIN, ALTERNATIVE, CUSTOM);
    }

    public PlayerPlushieBlock(class_2251 settings) {
        super(settings);
        this.method_9590(this.field_10647.method_11664().method_11657(FACING, class_2350.field_11043).method_11657(SKIN, 0).method_11657(ALTERNATIVE, false).method_11657(CUSTOM, false).method_11657(WATERLOGGED, false));
    }

    public static final class_2960 DEFAULT_FONT_ID = new class_2960("minecraft", "default");
    public static final class_2960 PLAYERS_FONT_ID = new class_2960("tlotd", "players");

    @Override
    public void method_9568(class_1799 stack, @Nullable class_1922 world, List<class_2561> tooltip, class_1836 options) {
        if (class_437.method_25442()) {
            tooltip.add(class_2561.method_43471("block.tlotd.player_plushie.tooltip").method_27692(class_124.field_1080));
            tooltip.add(class_2561.method_43471("block.tlotd.player_plushie.tooltip_2").method_27692(class_124.field_1080));
            tooltip.add(class_2561.method_43470(""));
            tooltip.add(class_2561.method_43469("text.tlotd.player_plushie.ponder", class_2561.method_43471("key.keyboard.shift").method_27692(class_124.field_1068)).method_27692(class_124.field_1063));
            class_2583 style = this.method_9518().method_10866();
            tooltip.add(class_2561.method_43471("block.tlotd.player_plushie.tooltip_shift").method_27692(class_124.field_1080));
            tooltip.add(class_2561.method_43470("\uE000").method_10862(style.method_27704(PLAYERS_FONT_ID)).method_10852(class_2561.method_43470(" TLOTD").method_10862(style.method_27704(DEFAULT_FONT_ID))));
            tooltip.add(class_2561.method_43470("\uE001").method_10862(style.method_27704(PLAYERS_FONT_ID)).method_10852(class_2561.method_43470(" Isla_Nublar").method_10862(style.method_27704(DEFAULT_FONT_ID))));
            tooltip.add(class_2561.method_43470("\uE002").method_10862(style.method_27704(PLAYERS_FONT_ID)).method_10852(class_2561.method_43470(" EinsDarki").method_10862(style.method_27704(DEFAULT_FONT_ID))));
            if (ModConfigs.FORMER_TLOTD_REWARDS) {
                tooltip.add(class_2561.method_43470("\uE003").method_10862(style.method_27704(PLAYERS_FONT_ID)).method_10852(class_2561.method_43470(" AliaSophie").method_10862(style.method_27704(DEFAULT_FONT_ID))));
                tooltip.add(class_2561.method_43470("\uE004").method_10862(style.method_27704(PLAYERS_FONT_ID)).method_10852(class_2561.method_43470(" Teneba").method_10862(style.method_27704(DEFAULT_FONT_ID))));
            }
            tooltip.add(class_2561.method_43470("\uE005").method_10862(style.method_27704(PLAYERS_FONT_ID)).method_10852(class_2561.method_43470(" Alex1666").method_10862(style.method_27704(DEFAULT_FONT_ID))));
            if (ModConfigs.FORMER_TLOTD_REWARDS) {
                tooltip.add(class_2561.method_43470("\uE006").method_10862(style.method_27704(PLAYERS_FONT_ID)).method_10852(class_2561.method_43470(" ISSO_21_").method_10862(style.method_27704(DEFAULT_FONT_ID))));
                tooltip.add(class_2561.method_43470("\uE007").method_10862(style.method_27704(PLAYERS_FONT_ID)).method_10852(class_2561.method_43470(" Akitorlp").method_10862(style.method_27704(DEFAULT_FONT_ID))));
            }
            tooltip.add(class_2561.method_43470("\uE008").method_10862(style.method_27704(PLAYERS_FONT_ID)).method_10852(class_2561.method_43470(" Polarfoxtm").method_10862(style.method_27704(DEFAULT_FONT_ID))));
            tooltip.add(class_2561.method_43470("\uE009").method_10862(style.method_27704(PLAYERS_FONT_ID)).method_10852(class_2561.method_43470(" Salsafox").method_10862(style.method_27704(DEFAULT_FONT_ID))));
            if (ModConfigs.FORMER_TLOTD_REWARDS) {
                tooltip.add(class_2561.method_43470("\uE00A").method_10862(style.method_27704(PLAYERS_FONT_ID)).method_10852(class_2561.method_43470(" VANDAGR").method_10862(style.method_27704(DEFAULT_FONT_ID))));
            }
            tooltip.add(class_2561.method_43470("\uE00B").method_10862(style.method_27704(PLAYERS_FONT_ID)).method_10852(class_2561.method_43470(" TLOTDShido").method_10862(style.method_27704(DEFAULT_FONT_ID))));
            tooltip.add(class_2561.method_43470("\uE00C").method_10862(style.method_27704(PLAYERS_FONT_ID)).method_10852(class_2561.method_43470(" nischi2612").method_10862(style.method_27704(DEFAULT_FONT_ID))));
            tooltip.add(class_2561.method_43470("\uE00D").method_10862(style.method_27704(PLAYERS_FONT_ID)).method_10852(class_2561.method_43470(" SK_Chuuya").method_10862(style.method_27704(DEFAULT_FONT_ID))));
            tooltip.add(class_2561.method_43470("\uE00E").method_10862(style.method_27704(PLAYERS_FONT_ID)).method_10852(class_2561.method_43470(" akashic_system").method_10862(style.method_27704(DEFAULT_FONT_ID))));
            tooltip.add(class_2561.method_43470("\uE00F").method_10862(style.method_27704(PLAYERS_FONT_ID)).method_10852(class_2561.method_43470(" MagicKVO").method_10862(style.method_27704(DEFAULT_FONT_ID))));
            tooltip.add(class_2561.method_43470("\uE010").method_10862(style.method_27704(PLAYERS_FONT_ID)).method_10852(class_2561.method_43470(" TheVexTv").method_10862(style.method_27704(DEFAULT_FONT_ID))));
            tooltip.add(class_2561.method_43470("\uE011").method_10862(style.method_27704(PLAYERS_FONT_ID)).method_10852(class_2561.method_43470(" Glamin").method_10862(style.method_27704(DEFAULT_FONT_ID))));
            tooltip.add(class_2561.method_43470("\uE012").method_10862(style.method_27704(PLAYERS_FONT_ID)).method_10852(class_2561.method_43470(" Jakx444").method_10862(style.method_27704(DEFAULT_FONT_ID))));
            tooltip.add(class_2561.method_43470("\uE013").method_10862(style.method_27704(PLAYERS_FONT_ID)).method_10852(class_2561.method_43470(" NightHawk241199").method_10862(style.method_27704(DEFAULT_FONT_ID))));
            tooltip.add(class_2561.method_43470("\uE014").method_10862(style.method_27704(PLAYERS_FONT_ID)).method_10852(class_2561.method_43470(" Red_ice").method_10862(style.method_27704(DEFAULT_FONT_ID))));
            //tooltip.add(Text.literal("\uE015").setStyle(style.withFont(PLAYERS_FONT_ID)).append(Text.literal(" Jxst_Freezy").setStyle(style.withFont(DEFAULT_FONT_ID)))); (dont know his ign)
            tooltip.add(class_2561.method_43470("...").method_27692(class_124.field_1080));
            tooltip.add(class_2561.method_43471("block.tlotd.player_plushie.tooltip_custom"));
        } else {
            tooltip.add(class_2561.method_43471("block.tlotd.player_plushie.tooltip").method_27692(class_124.field_1080));
            tooltip.add(class_2561.method_43471("block.tlotd.player_plushie.tooltip_2").method_27692(class_124.field_1080));
            tooltip.add(class_2561.method_43470(""));
            tooltip.add(class_2561.method_43469("text.tlotd.player_plushie.ponder", class_2561.method_43471("key.keyboard.shift").method_27692(class_124.field_1080)).method_27692(class_124.field_1063));
        }
        super.method_9568(stack, world, tooltip, options);
    }
}
