package net.tlotd.block.custom;

import net.minecraft.block.*;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_2464;
import net.minecraft.class_2470;
import net.minecraft.class_2561;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2753;
import net.minecraft.class_2960;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_3610;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.util.*;
import net.tlotd.block.ModBlocks;
import net.tlotd.item.ModItems;
import net.tlotd.sound.ModSounds;
import net.tlotd.util.ModTags;
import net.tlotd.util.TelevisionSignalRegistry;
import net.tlotd.util.VideoGameRegistry;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import java.util.Optional;

import static net.tlotd.block.custom.TelevisionBlock.*;

public class TelevisionModifierBlock extends class_2248 {

    public static final class_2746 WATERLOGGED = class_2741.field_12508;
    public static final class_2753 FACING = class_2383.field_11177;

    public TelevisionModifierBlock(class_2251 settings) {
        super(settings);
        this.method_9590(this.field_10647.method_11664().method_11657(FACING, class_2350.field_11043).method_11657(WATERLOGGED, false));
    }

    @Override
    public class_2680 method_9605(class_1750 ctx) {
        return this.method_9564()
                .method_11657(FACING, ctx.method_8042())
                .method_11657(WATERLOGGED, ctx.method_8045().method_8316(ctx.method_8037()).method_39360(class_3612.field_15910));
    }

    @Override
    public class_3610 method_9545(class_2680 state) {
        return state.method_11654(WATERLOGGED) ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    @Override
    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        if (state.method_11654(WATERLOGGED)) {
            world.method_39281(pos, class_3612.field_15910, class_3612.field_15910.method_15789(world));
        }

        return super.method_9559(state, direction, neighborState, world, pos, neighborPos);
    }

    @Override
    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return state.method_11657(FACING, rotation.method_10503(state.method_11654(FACING)));
    }

    @Override
    public void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(FACING, WATERLOGGED);
    }

    public static final class_265 SHAPE = class_2248.method_9541(0, 0, 0, 16, 16, 16);
    public static final class_265 VCR = class_2248.method_9541(1, 0, 1, 15, 6.5, 15);
    public static final class_265 CONSOLE = class_2248.method_9541(1, 0, 1, 15, 5, 15);

    @Override
    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        if (state.method_26204().equals(ModBlocks.VIDEOCASSETTE_RECORDER)) {
            return VCR;
        } else if (state.method_26204().equals(ModBlocks.GAME_CONSOLE)) {
            return CONSOLE;
        } else {
            return SHAPE;
        }
    }

    @Override
    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    @Override
    public void method_9568(class_1799 stack, @Nullable class_1922 world, List<class_2561> tooltip, class_1836 options) {
        tooltip.add(class_2561.method_43470(""));
        tooltip.add(class_2561.method_43471("block.tlotd.videocassette_recorder.tooltip").method_27692(class_124.field_1080));
        tooltip.add(class_2561.method_43470(" ").method_10852(class_2561.method_43471("block.minecraft.chiseled_bookshelf").method_27692(class_124.field_1078)));
        super.method_9568(stack, world, tooltip, options);
    }

    @Override
    public class_1799 method_9574(class_1922 world, class_2338 pos, class_2680 state) {
        if (state.method_26204().equals(ModBlocks.VIDEOCASSETTE_RECORDER)) {
            return ModBlocks.VIDEOCASSETTE_RECORDER.method_8389().method_7854();
        } else if (state.method_26204().equals(ModBlocks.GAME_CONSOLE)) {
            return ModBlocks.GAME_CONSOLE.method_8389().method_7854();
        } else {
            return class_2246.field_40276.method_8389().method_7854();
        }
    }

    @Override
    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        class_1799 stack = player.method_5998(hand);
        class_2338 tvPos = pos.method_10084();
        class_2680 tvState = world.method_8320(tvPos);
        boolean tvOn = tvState.method_26164(ModTags.Blocks.TELEVISIONS_ON);
        if ((state.method_27852(ModBlocks.VIDEOCASSETTE_RECORDER) || state.method_27852(ModBlocks.VIDEOCASSETTE_RECORDER_BOOKSHELF) || state.method_27852(ModBlocks.MEDIA_SYSTEM_BOOKSHELF)) && stack.method_31573(ModTags.Items.VHS_CASSETTES) && tvOn) {
            if (!world.field_9236) {
                Optional<TelevisionSignalRegistry.SignalEntry> match = TelevisionSignalRegistry.findBySignal(class_7923.field_41178.method_10221(stack.method_7909()));
                if (match.isPresent()) {
                    TelevisionSignalRegistry.SignalEntry entry = match.get();
                    class_2680 newState = entry.onBlock().method_34725(tvState)
                            .method_11657(CHANNEL, entry.channel());
                    world.method_8652(tvPos, newState, 3);
                } else if (stack.method_31574(ModItems.VHS_CASSETTE)) {
                        Optional<TelevisionSignalRegistry.SignalEntry> currentEntry =
                                TelevisionSignalRegistry.getAll().stream()
                                        .filter(e -> e.onBlock() == tvState.method_26204())
                                        .findFirst();
                        stack.method_7934(1);
                        if (currentEntry.isPresent()) {
                            class_2960 signalId = currentEntry.get().signalItem();
                            class_1792 recordedItem = class_7923.field_41178.method_10223(signalId);
                            class_1799 recorded = new class_1799(recordedItem);
                            player.method_7270(recorded);
                        } else {
                            player.method_7270(ModItems.VHS_CASSETTE_BROKEN.method_7854());
                        }
                    }
                player.method_7259(class_3468.field_15372.method_14956(stack.method_7909()));
                world.method_8396(null, pos, ModSounds.BLOCK_VIDEOCASSETTE_RECORDER, class_3419.field_15245, 1.0f, 1.0f);
            }
            return class_1269.field_5812;
        } else if ((state.method_27852(ModBlocks.GAME_CONSOLE) || state.method_27852(ModBlocks.GAME_CONSOLE_BOOKSHELF) || state.method_27852(ModBlocks.MEDIA_SYSTEM_BOOKSHELF)) && stack.method_31573(ModTags.Items.GAME_CARTRIDGES) && tvOn) {
            if (!world.field_9236) {
                Optional<VideoGameRegistry.SignalEntry> match = VideoGameRegistry.findBySignal(class_7923.field_41178.method_10221(stack.method_7909()));
                if (match.isPresent()) {
                    VideoGameRegistry.SignalEntry entry = match.get();
                    class_2680 newState = entry.tvBlock().method_34725(tvState)
                            .method_11657(CHANNEL, entry.gameID());
                    world.method_8652(tvPos, newState, 3);
                }
                player.method_7259(class_3468.field_15372.method_14956(stack.method_7909()));
                world.method_8396(null, pos, ModSounds.BLOCK_VIDEOCASSETTE_RECORDER, class_3419.field_15245, 1.0f, 1.0f);
            }
            return class_1269.field_5812;
        } else if (player.method_5715() && state.method_26164(class_6862.method_40092(class_7924.field_41254, new class_2960("c", "bookshelves")))) {
            if (!world.field_9236) {
                if (state.method_26204() == ModBlocks.MEDIA_SYSTEM_BOOKSHELF) {
                    world.method_8501(pos, ModBlocks.VIDEOCASSETTE_RECORDER_BOOKSHELF.method_9564().method_11657(FACING, state.method_11654(FACING)));
                } else {
                    world.method_8501(pos, class_2246.field_40276.method_9564().method_11657(FACING, state.method_11654(FACING)));
                }
                if (state.method_26204() == ModBlocks.VIDEOCASSETTE_RECORDER_BOOKSHELF) {
                    player.method_7270(ModBlocks.VIDEOCASSETTE_RECORDER.method_8389().method_7854());
                } else {
                    player.method_7270(ModBlocks.GAME_CONSOLE.method_8389().method_7854());
                }
                world.method_8396(null, pos, class_3417.field_14718, class_3419.field_15245, 1.0f, 1.0f);
            }
            return class_1269.field_5812;
        }
        return class_1269.field_5814;
    }
}