package net.tlotd.block.entity;

import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.minecraft.class_1262;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3913;
import net.tlotd.gui.IncubatorGUIHandler;
import net.tlotd.recipe.IncubatonRecipe;
import org.jetbrains.annotations.Nullable;

import java.util.Optional;

public class IncubatorBlockEntity extends class_2586 implements ExtendedScreenHandlerFactory, ImplementedInventory {

    private final class_2371<class_1799> inventory = class_2371.method_10213(3, class_1799.field_8037);

    private static final int OUTPUT_SLOT = 2;

    protected final class_3913 propertyDelegate;
    private int progress = 0;
    private int maxProgress = 72;

    public IncubatorBlockEntity(class_2338 pos, class_2680 state) {
        super(ModBlockEntities.INCUBATOR_BLOCK_ENTITY, pos, state);
        this.propertyDelegate = new class_3913() {
            @Override
            public int method_17390(int index) {
                return switch (index) {
                    case 0 -> IncubatorBlockEntity.this.progress;
                    case 1 -> IncubatorBlockEntity.this.maxProgress;
                    default -> 0;
                };
            }

            @Override
            public void method_17391(int index, int value) {
                switch (index) {
                    case 0 -> IncubatorBlockEntity.this.progress = value;
                    case 1 -> IncubatorBlockEntity.this.maxProgress = value;
                }

            }

            @Override
            public int method_17389() {
                return 2;
            }
        };
    }

    @Override
    public void writeScreenOpeningData(class_3222 serverPlayerEntity, class_2540 buf) {
        buf.method_10807(this.field_11867);
    }

    @Override
    public class_2561 method_5476() {
        return class_2561.method_43471("block.tlotd.incubator");
    }

    @Override
    public class_2371<class_1799> getItems() {
        return inventory;
    }

    @Override
    protected void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        class_1262.method_5426(nbt, inventory);
        nbt.method_10569("progress", progress);
    }

    @Override
    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        class_1262.method_5429(nbt, inventory);
        progress = nbt.method_10550("progress");
    }

    @Override
    public @Nullable class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
        return new IncubatorGUIHandler(syncId, playerInventory, this, this.propertyDelegate);
    }

    public void tick(class_1937 world, class_2338 pos, class_2680 state) {
        if(world.method_8608()) {
            return;
        }
        if(isOutputSlotEmptyOrReceivable()) {
            if (this.hasRecipe()) {
                progress++;
                method_31663(world, pos, state);
                if (progress >= maxProgress) {
                    this.craftItem();
                    this.resetProgress();
                }
            } else {
                this.resetProgress();
            }
        } else {
            this.resetProgress();
            method_31663(world, pos, state);
        }
    }

    private void resetProgress() {
        this.progress = 0;
    }

    private void craftItem() {
        Optional<IncubatonRecipe> recipe = getCurrentRecipe();

        this.method_5434(0, 1);
        this.method_5434(1, 1);

        this.method_5447(OUTPUT_SLOT, new class_1799(recipe.get().method_8110(null).method_7909(), method_5438(OUTPUT_SLOT).method_7947() + recipe.get().method_8110(null).method_7947()));
    }

    private boolean hasRecipe() {
        Optional<IncubatonRecipe> recipe = getCurrentRecipe();

        return recipe.isPresent() && canInsertAmountIntoOutputSlot(recipe.get().method_8110(null)) && canInsertItemIntoOutputSlot(recipe.get().method_8110(null).method_7909());
    }

    private Optional<IncubatonRecipe> getCurrentRecipe() {
        class_1277 inv = new class_1277(this.method_5439());
        for(int i = 0; i < this.method_5439(); i++) {
            inv.method_5447(i, this.method_5438(i));
        }

        return method_10997().method_8433().method_8132(IncubatonRecipe.Type.INSTANCE, inv, method_10997());
    }

    private boolean canInsertItemIntoOutputSlot(class_1792 item) {
        return this.method_5438(OUTPUT_SLOT).method_31574(item) || this.method_5438(OUTPUT_SLOT).method_7960();
    }

    private boolean canInsertAmountIntoOutputSlot(class_1799 result) {
        return this.method_5438(OUTPUT_SLOT).method_7947() + result.method_7947() <= method_5438(OUTPUT_SLOT).method_7914();
    }

    private boolean isOutputSlotEmptyOrReceivable() {
        return this.method_5438(OUTPUT_SLOT).method_7960() || this.method_5438(OUTPUT_SLOT).method_7947() < this.method_5438(OUTPUT_SLOT).method_7914();
    }

    @Override
    public @Nullable class_2596<class_2602> method_38235() {
        return class_2622.method_38585(this);
    }

    @Override
    public class_2487 method_16887() {
        return method_38244();
    }
}
