package net.tlotd.block.entity;

import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.minecraft.class_1262;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3913;
import net.tlotd.config.ModConfigs;
import net.tlotd.gui.MithrilAnvilGUIHandler;
import net.tlotd.recipe.MithrilSmithingRecipe;
import org.jetbrains.annotations.Nullable;


import java.util.Optional;

import static net.tlotd.world.dimension.ModDimensions.LUNA_LEVEL_KEY;

public class MithrilAnvilBlockEntity extends class_2586 implements ExtendedScreenHandlerFactory, ImplementedInventory {

    private final class_2371<class_1799> inventory = class_2371.method_10213(7, class_1799.field_8037);

    private static final int OUTPUT_SLOT = 6;

    protected final class_3913 propertyDelegate;
    private int progress = 0;
    private int maxProgress = 72;

    public MithrilAnvilBlockEntity(class_2338 pos, class_2680 state) {
        super(ModBlockEntities.MITHRIL_ANVIL_BLOCK_ENTITY, pos, state);
        this.propertyDelegate = new class_3913() {
            @Override
            public int method_17390(int index) {
                return switch (index) {
                    case 0 -> MithrilAnvilBlockEntity.this.progress;
                    case 1 -> MithrilAnvilBlockEntity.this.maxProgress;
                    default -> 0;
                };
            }

            @Override
            public void method_17391(int index, int value) {
                switch (index) {
                    case 0 -> MithrilAnvilBlockEntity.this.progress = value;
                    case 1 -> MithrilAnvilBlockEntity.this.maxProgress = value;
                }
            }

            @Override
            public int method_17389() {
                return 2;
            }
        };
    }

    public class_1799 getRenderStack() {
        if(!this.method_5438(OUTPUT_SLOT).method_7960()) {
            return this.method_5438(OUTPUT_SLOT);
        } else if (!this.method_5438(2).method_7960()) {
            return this.method_5438(2);
        } else if (!this.method_5438(3).method_7960()) {
            return this.method_5438(3);
        } else if (!this.method_5438(4).method_7960()) {
            return this.method_5438(4);
        } else if (!this.method_5438(5).method_7960()) {
            return this.method_5438(5);
        } else if (!this.method_5438(1).method_7960()) {
            return this.method_5438(1);
        } else {
            return this.method_5438(0);
        }
    }

    @Override
    public void method_5431() {
        field_11863.method_8413(field_11867,method_11010(),method_11010(),3);
        super.method_5431();
    }

    @Override
    public void writeScreenOpeningData(class_3222 serverPlayerEntity, class_2540 packetByteBuf) {
        packetByteBuf.method_10807(this.field_11867);
    }

    @Override
    public class_2561 method_5476() {
        return class_2561.method_43471("block.tlotd.mithril_anvil");
    }

    @Override
    public class_2371<class_1799> getItems() {
        return inventory;
    }

    @Override
    protected void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        class_1262.method_5426(nbt, inventory);
        nbt.method_10569("mithril_anvil.progress", progress);
    }

    @Override
    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        class_1262.method_5429(nbt, inventory);
        progress = nbt.method_10550("mithril_anvil.progress");
    }

    @Override
    public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
        return new MithrilAnvilGUIHandler(syncId, playerInventory, this, this.propertyDelegate);
    }

    public void tick(class_1937 world, class_2338 pos, class_2680 state) {
        if (world.method_8608()) {
            return;
        }
        if (isOutputSlotEmptyOrReceivable() && (world.method_27983().equals(LUNA_LEVEL_KEY) || !ModConfigs.MITHRIL_ANVIL_NEEDS_DIRECT_MOONLIGHT || (world.method_23886() && world.method_22348(pos)))) {
            if (this.hasRecipe()) {
                progress++;
                method_31663(world, pos, state);
                if (progress >= maxProgress) {
                    this.craftItem();
                    this.resetProgress();
                }
            } else {
                this.resetProgress();
            }
        } else {
            this.resetProgress();
            method_31663(world, pos, state);
        }
    }

    private void resetProgress() {
        this.progress = 0;
    }

    private void craftItem() {
        Optional<MithrilSmithingRecipe> recipe = getCurrentRecipe();

        this.method_5434(1, 1);
        this.method_5434(2, 1);
        this.method_5434(3, 1);
        this.method_5434(4, 1);
        this.method_5434(5, 1);

        this.method_5447(OUTPUT_SLOT, new class_1799(recipe.get().method_8110(null).method_7909(), method_5438(OUTPUT_SLOT).method_7947() + recipe.get().method_8110(null).method_7947()));

        field_11863.method_8396(null, method_11016(), class_3417.field_14559, class_3419.field_15245, 1.0f, 1.0f);
    }

    private boolean hasRecipe() {
        Optional<MithrilSmithingRecipe> recipe = getCurrentRecipe();

        return recipe.isPresent() && canInsertAmountIntoOutputSlot(recipe.get().method_8110(null)) && canInsertItemIntoOutputSlot(recipe.get().method_8110(null).method_7909());
    }

    private Optional<MithrilSmithingRecipe> getCurrentRecipe() {
        class_1277 inv = new class_1277(this.method_5439());
        for(int i = 0; i < this.method_5439(); i++) {
            inv.method_5447(i, this.method_5438(i));
        }

        return method_10997().method_8433().method_8132(MithrilSmithingRecipe.Type.INSTANCE, inv, method_10997());
    }

    private boolean canInsertItemIntoOutputSlot(class_1792 item) {
        return this.method_5438(OUTPUT_SLOT).method_31574(item) || this.method_5438(OUTPUT_SLOT).method_7960();
    }

    private boolean canInsertAmountIntoOutputSlot(class_1799 result) {
        return this.method_5438(OUTPUT_SLOT).method_7947() + result.method_7947() <= method_5438(OUTPUT_SLOT).method_7914();
    }

    private boolean isOutputSlotEmptyOrReceivable() {
        return this.method_5438(OUTPUT_SLOT).method_7960() || this.method_5438(OUTPUT_SLOT).method_7947() < this.method_5438(OUTPUT_SLOT).method_7914();
    }

    @Override
    public @Nullable class_2596<class_2602> method_38235() {
        return class_2622.method_38585(this);
    }

    @Override
    public class_2487 method_16887() {
        return method_38244();
    }
}