package net.tlotd.block.entity;

import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidConstants;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleVariantStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.minecraft.class_1262;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_3913;
import net.tlotd.block.ModBlocks;
import net.tlotd.config.ModConfigs;
import net.tlotd.fluid.ModFluids;
import net.tlotd.gui.WitchingTableGUIHandler;
import net.tlotd.item.ModItems;
import net.tlotd.networking.ModMessages;
import net.tlotd.recipe.WitchingRecipe;
import net.tlotd.util.ModTags;
import org.jetbrains.annotations.Nullable;

import java.util.Optional;

import static net.minecraft.class_5544.field_27175;
import static net.tlotd.block.custom.RitualisticCircleBlock.STATE;
import static net.tlotd.block.custom.StickCrossBlock.FLIPPED;
import static net.tlotd.block.custom.WitchingTableBlock.*;

public class WitchingTableBlockEntity extends class_2586 implements ExtendedScreenHandlerFactory, ImplementedInventory {

    private final class_2371<class_1799> inventory = class_2371.method_10213(12, class_1799.field_8037);

    private static final int OUTPUT_SLOT = 11;

    public final SingleVariantStorage<FluidVariant> fluidStorage = new SingleVariantStorage<FluidVariant>() {
        @Override
        protected FluidVariant getBlankVariant() {
            return FluidVariant.blank();
        }

        @Override
        public long getCapacity(FluidVariant fluidVariant) {
            return FluidConstants.BUCKET * 8;
        }

        @Override
        protected void onFinalCommit() {
            method_5431();
            if(!field_11863.method_8608()) {
                sendFluidPacket();
            }
        }
    };

    private void sendFluidPacket() {
        class_2540 data = PacketByteBufs.create();
        fluidStorage.variant.toPacket(data);
        data.writeLong(fluidStorage.amount);
        data.method_10807(method_11016());

        for (class_3222 player : PlayerLookup.tracking((class_3218) field_11863, method_11016())) {
            ServerPlayNetworking.send(player, ModMessages.FLUID_SYNC, data);
        }
    }

    public void setFluidLevel(FluidVariant fluidVariant, long fluidLevel) {
        this.fluidStorage.variant = fluidVariant;
        this.fluidStorage.amount = fluidLevel;
    }

    protected final class_3913 propertyDelegate;
    private int progress = 0;
    private int maxProgress = 126;

    public WitchingTableBlockEntity(class_2338 pos, class_2680 state) {
        super(ModBlockEntities.WITCHING_TABLE_BLOCK_ENTITY, pos, state);
        this.propertyDelegate = new class_3913() {
            @Override
            public int method_17390(int index) {
                return switch (index) {
                    case 0 -> WitchingTableBlockEntity.this.progress;
                    case 1 -> WitchingTableBlockEntity.this.maxProgress;
                    default -> 0;
                };
            }

            @Override
            public void method_17391(int index, int value) {
                switch (index) {
                    case 0 -> WitchingTableBlockEntity.this.progress = value;
                    case 1 -> WitchingTableBlockEntity.this.maxProgress = value;
                }
            }

            @Override
            public int method_17389() {
                return 2;
            }
        };
    }

    public class_1799 getRenderStack() {
        if(!this.method_5438(OUTPUT_SLOT).method_7960()) {
            return this.method_5438(OUTPUT_SLOT);
        } else if (!this.method_5438(8).method_7960()) {
            return this.method_5438(8);
        } else if (!this.method_5438(7).method_7960()) {
            return this.method_5438(7);
        } else if (!this.method_5438(6).method_7960()) {
            return this.method_5438(6);
        } else if (!this.method_5438(5).method_7960()) {
            return this.method_5438(5);
        } else if (!this.method_5438(4).method_7960()) {
            return this.method_5438(4);
        } else if (!this.method_5438(3).method_7960()) {
            return this.method_5438(3);
        } else if (!this.method_5438(2).method_7960()) {
            return this.method_5438(2);
        } else if (!this.method_5438(1).method_7960()) {
            return this.method_5438(1);
        } else {
            return this.method_5438(0);
        }
    }

    @Override
    public void method_5431() {
        field_11863.method_8413(field_11867,method_11010(),method_11010(),3);
        super.method_5431();
    }

    @Override
    public void writeScreenOpeningData(class_3222 serverPlayerEntity, class_2540 packetByteBuf) {
        packetByteBuf.method_10807(this.field_11867);
    }

    @Override
    public class_2561 method_5476() {
        return class_2561.method_43471("block.tlotd.witching_table");
    }

    @Override
    public class_2371<class_1799> getItems() {
        return inventory;
    }

    @Override
    protected void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        class_1262.method_5426(nbt, inventory);
        nbt.method_10569("witching_table.progress", progress);
        nbt.method_10566("witching_table.fluid", fluidStorage.variant.toNbt());
        nbt.method_10544("witching_table.fluid_amount", fluidStorage.amount);
    }

    @Override
    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        class_1262.method_5429(nbt, inventory);
        progress = nbt.method_10550("witching_table.progress");
        fluidStorage.variant = FluidVariant.fromNbt((class_2487) nbt.method_10580("witching_table.fluid"));
        fluidStorage.amount = nbt.method_10537("witching_table.fluid_amount");
    }

    @Override
    public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
        sendFluidPacket();
        return new WitchingTableGUIHandler(syncId, playerInventory, this, this.propertyDelegate);
    }

    public void tick(class_1937 world, class_2338 pos, class_2680 state) {
        if (world.method_8608()) {
            return;
        }

        if (isOutputSlotEmptyOrReceivable()) {
            if (hasRecipe() && (!ModConfigs.WITCHING_TABLE_NEEDS_BLOOD || hasEnoughFluid()) && (!ModConfigs.WITCHING_TABLE_NEEDS_SOULS || (state.method_11654(SOUL_CHARGES)+state.method_11654(CURSED_SOUL_CHARGES)+state.method_11654(ABYSSAL_SOUL_CHARGES)) > 0)) {
                increaseCraftProgress();
                method_31663(world, pos, state);
                if (hasCraftingFinished()) {
                    craftItem();
                    if (ModConfigs.WITCHING_TABLE_NEEDS_BLOOD) {
                        extractFluid();
                    }
                    if (ModConfigs.WITCHING_TABLE_NEEDS_SOULS) {
                        consumeSoul(world,pos,state);
                    }
                    if (witchingTableBase()){
                        world.method_8501(pos.method_10069(-1,-1,-1), ModBlocks.RITUALISTIC_FANCY_CHARRED_PLANKS.method_9564().method_11657(STATE,0));
                        world.method_8501(pos.method_10069(0,-1,-1), ModBlocks.RITUALISTIC_FANCY_CHARRED_PLANKS.method_9564().method_11657(STATE,1));
                        world.method_8501(pos.method_10069(1,-1,-1), ModBlocks.RITUALISTIC_FANCY_CHARRED_PLANKS.method_9564().method_11657(STATE,2));
                        world.method_8501(pos.method_10069(-1,-1,0), ModBlocks.RITUALISTIC_FANCY_CHARRED_PLANKS.method_9564().method_11657(STATE,3));
                        world.method_8501(pos.method_10069(0,-1,0), ModBlocks.RITUALISTIC_FANCY_CHARRED_PLANKS.method_9564().method_11657(STATE,4));
                        world.method_8501(pos.method_10069(1,-1,0), ModBlocks.RITUALISTIC_FANCY_CHARRED_PLANKS.method_9564().method_11657(STATE,5));
                        world.method_8501(pos.method_10069(-1,-1,1), ModBlocks.RITUALISTIC_FANCY_CHARRED_PLANKS.method_9564().method_11657(STATE,6));
                        world.method_8501(pos.method_10069(0,-1,1), ModBlocks.RITUALISTIC_FANCY_CHARRED_PLANKS.method_9564().method_11657(STATE,7));
                        world.method_8501(pos.method_10069(1,-1,1), ModBlocks.RITUALISTIC_FANCY_CHARRED_PLANKS.method_9564().method_11657(STATE,8));
                    }
                    for (int x = -5; x <= 5; x++) {
                        for (int y = -5; y <= 5; y++) {
                            for (int z = -5; z <= 5; z++) {
                                if (world.method_8320(pos.method_10069(x,y,z)).method_26164(class_3481.field_26983)) {
                                    world.method_8501(pos.method_10069(x,y,z), world.method_8320(pos.method_10069(x,y,z)).method_11657(field_27175, false));
                                    world.method_8466(class_2398.field_23114, true, pos.method_10263()+x+0.5d, pos.method_10264()+y+0.5d, pos.method_10260()+z+0.5d,0,0.15d,0);
                                }
                                if (world.method_8320(pos.method_10069(x,y,z)).method_27852(ModBlocks.STICK_CROSS)) {
                                    world.method_8501(pos.method_10069(x,y,z), world.method_8320(pos.method_10069(x,y,z)).method_11657(FLIPPED, true));
                                    world.method_8466(class_2398.field_23114, true, pos.method_10263()+x+0.5d, pos.method_10264()+y+0.5d, pos.method_10260()+z+0.5d,0,0.15d,0);
                                }
                            }
                        }
                    }
                    resetProgress();
                    sendFluidPacket();
                }
            } else {
                resetProgress();
            }
        } else {
            resetProgress();
            method_31663(world, pos, state);
        }

        if(spaceForFluid()) {
            if(hasFluidBottleInSlot()) {
                transferFluidBottleToStorage();
                sendFluidPacket();
            } else if(hasFluidBucketInSlot()) {
                transferFluidBucketToStorage();
                sendFluidPacket();
            }
        }

        if(canBottleOrBucketBeFilled()) {
            if(canBucketBeFilled()) {
                fillBucket();
                sendFluidPacket();
            } else if (canBottleBeFilled()) {
                fillBottle();
                sendFluidPacket();
            }
        }
    }

    private void consumeSoul(class_1937 world, class_2338 pos, class_2680 state) {
        if (state.method_11654(SOUL_CHARGES) > 0) { world.method_8501(pos,state.method_11657(SOUL_CHARGES, state.method_11654(SOUL_CHARGES)-1));}
        else if (state.method_11654(CURSED_SOUL_CHARGES) > 0) { world.method_8501(pos,state.method_11657(CURSED_SOUL_CHARGES, state.method_11654(CURSED_SOUL_CHARGES)-1));}
        else { world.method_8501(pos,state.method_11657(ABYSSAL_SOUL_CHARGES, state.method_11654(ABYSSAL_SOUL_CHARGES)-1));}
    }

    private boolean witchingTableBase() {
        return (field_11863.method_8320(field_11867.method_10069(-1,-1,-1)).method_26164(ModTags.Blocks.WITCHING_TABLE_BASE_BLOCKS) && field_11863.method_8320(field_11867.method_10069(0,-1,-1)).method_26164(ModTags.Blocks.WITCHING_TABLE_BASE_BLOCKS) && field_11863.method_8320(field_11867.method_10069(1,-1,-1)).method_26164(ModTags.Blocks.WITCHING_TABLE_BASE_BLOCKS)
                && field_11863.method_8320(field_11867.method_10069(-1,-1,0)).method_26164(ModTags.Blocks.WITCHING_TABLE_BASE_BLOCKS) && field_11863.method_8320(field_11867.method_10069(0,-1,0)).method_26164(ModTags.Blocks.WITCHING_TABLE_BASE_BLOCKS) && field_11863.method_8320(field_11867.method_10069(1,-1,0)).method_26164(ModTags.Blocks.WITCHING_TABLE_BASE_BLOCKS)
                && field_11863.method_8320(field_11867.method_10069(-1,-1,1)).method_26164(ModTags.Blocks.WITCHING_TABLE_BASE_BLOCKS) && field_11863.method_8320(field_11867.method_10069(0,-1,1)).method_26164(ModTags.Blocks.WITCHING_TABLE_BASE_BLOCKS) && field_11863.method_8320(field_11867.method_10069(1,-1,1)).method_26164(ModTags.Blocks.WITCHING_TABLE_BASE_BLOCKS));
    }

    private boolean spaceForFluid() {
        return this.fluidStorage.amount <= FluidConstants.BUCKET * 7;
    }

    private boolean canBottleOrBucketBeFilled() {
        return (this.fluidStorage.amount >= FluidConstants.BOTTLE && this.method_5438(10).method_7947() == 1 &&
                (this.method_5438(10).method_31574(class_1802.field_8469) || this.method_5438(10).method_31574(class_1802.field_8550)));
    }

    private boolean canBucketBeFilled() {
        return (this.fluidStorage.amount >= FluidConstants.BUCKET &&
                this.method_5438(10).method_31574(class_1802.field_8550) &&
                this.method_5438(10).method_7947() == 1);
    }

    private boolean canBottleBeFilled() {
        return (this.fluidStorage.amount >= FluidConstants.BOTTLE &&
                this.method_5438(10).method_31574(class_1802.field_8469) &&
                this.method_5438(10).method_7947() == 1);
    }

    private void fillBucket() {
        try(Transaction transaction = Transaction.openOuter()) {
            this.fluidStorage.extract(FluidVariant.of(ModFluids.STILL_BLOOD),
                    FluidConstants.BUCKET, transaction);
            transaction.commit();
            this.method_5447(10, new class_1799(ModFluids.BLOOD_BUCKET));
        }
    }

    private void fillBottle() {
        try(Transaction transaction = Transaction.openOuter()) {
            this.fluidStorage.extract(FluidVariant.of(ModFluids.STILL_BLOOD),
                    FluidConstants.BOTTLE, transaction);
            transaction.commit();
            this.method_5447(10, new class_1799(ModItems.BLOOD_BOTTLE));
        }
    }

    private void resetProgress() {
        this.progress = 0;
    }

    private void craftItem() {
        Optional<WitchingRecipe> recipe = getCurrentRecipe();

        this.method_5434(0, 1);
        this.method_5434(1, 1);
        this.method_5434(2, 1);
        this.method_5434(3, 1);
        this.method_5434(4, 1);
        this.method_5434(5, 1);
        this.method_5434(6, 1);
        this.method_5434(7, 1);
        this.method_5434(8, 1);

        this.method_5447(OUTPUT_SLOT, new class_1799(recipe.get().method_8110(null).method_7909(), method_5438(OUTPUT_SLOT).method_7947() + recipe.get().method_8110(null).method_7947()));

        field_11863.method_8396(null, method_11016(), class_3417.field_23060, class_3419.field_15245, 1.0f, 1.0f);
    }

    private void extractFluid() {
        try(Transaction transaction = Transaction.openOuter()) {
            this.fluidStorage.extract(FluidVariant.of(ModFluids.STILL_BLOOD),
                    FluidConstants.BOTTLE, transaction);
            transaction.commit();
        }
    }

    private boolean hasCraftingFinished() {
        return progress >= maxProgress;
    }

    private void increaseCraftProgress() {
        progress++;
    }

    private boolean hasFluidBottleInSlot() {
        return this.method_5438(9).method_31573(ModTags.Items.BLOOD_BOTTLES);
    }

    private boolean hasFluidBucketInSlot() {
        return this.method_5438(9).method_31573(ModTags.Items.BLOOD_BUCKETS);
    }

    private void transferFluidBottleToStorage() {
        try(Transaction transaction = Transaction.openOuter()) {
            this.fluidStorage.insert(FluidVariant.of(ModFluids.STILL_BLOOD),
                    FluidConstants.BOTTLE, transaction);
            transaction.commit();
            this.method_5447(9, new class_1799(class_1802.field_8469));
        }
    }

    private void transferFluidBucketToStorage() {
        try(Transaction transaction = Transaction.openOuter()) {
            this.fluidStorage.insert(FluidVariant.of(ModFluids.STILL_BLOOD),
                    FluidConstants.BUCKET, transaction);
            transaction.commit();
            this.method_5447(9, new class_1799(class_1802.field_8550));
        }
    }

    private boolean hasEnoughFluid() {
        return this.fluidStorage.amount >= FluidConstants.BOTTLE;
    };

    private boolean hasRecipe() {
        Optional<WitchingRecipe> recipe = getCurrentRecipe();

        return recipe.isPresent() && canInsertAmountIntoOutputSlot(recipe.get().method_8110(null)) && canInsertItemIntoOutputSlot(recipe.get().method_8110(null).method_7909());
    }

    private Optional<WitchingRecipe> getCurrentRecipe() {
        class_1277 inv = new class_1277(this.method_5439());
        for(int i = 0; i < this.method_5439(); i++) {
            inv.method_5447(i, this.method_5438(i));
        }

        return method_10997().method_8433().method_8132(WitchingRecipe.Type.INSTANCE, inv, method_10997());
    }

    private boolean canInsertItemIntoOutputSlot(class_1792 item) {
        return this.method_5438(OUTPUT_SLOT).method_31574(item) || this.method_5438(OUTPUT_SLOT).method_7960();
    }

    private boolean canInsertAmountIntoOutputSlot(class_1799 result) {
        return this.method_5438(OUTPUT_SLOT).method_7947() + result.method_7947() <= method_5438(OUTPUT_SLOT).method_7914();
    }

    private boolean isOutputSlotEmptyOrReceivable() {
        return this.method_5438(OUTPUT_SLOT).method_7960() || this.method_5438(OUTPUT_SLOT).method_7947() < this.method_5438(OUTPUT_SLOT).method_7914();
    }

    @Override
    public @Nullable class_2596<class_2602> method_38235() {
        return class_2622.method_38585(this);
    }

    @Override
    public class_2487 method_16887() {
        return method_38244();
    }
}