package net.tlotd.datagen;

import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricTagProvider;
import net.minecraft.class_1802;
import net.minecraft.class_2246;
import net.minecraft.class_2960;
import net.minecraft.class_3489;
import net.minecraft.class_6862;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import net.tlotd.block.ModBlocks;
import net.tlotd.fluid.ModFluids;
import net.tlotd.item.ModItems;
import net.tlotd.util.ModTags;

import java.util.concurrent.CompletableFuture;

public class ModItemTagProvider extends FabricTagProvider.ItemTagProvider {
    public ModItemTagProvider(FabricDataOutput output, CompletableFuture<class_7225.class_7874> completableFuture) {
        super(output, completableFuture);
    }

    @Override
    protected void method_10514(class_7225.class_7874 wrapperLookup) {

        method_10512(ModTags.Items.DIVINE_ITEMS)
                .add(ModBlocks.STICK_CROSS.method_8389())
                .add(ModItems.DIVINE_PICKAXE)
        ;

        method_10512(ModTags.Items.OCCULT_ITEMS)
                .add(ModItems.PLANCHETTE)
                .add(ModBlocks.OUIJA_BOARD.method_8389())
                .add(ModItems.CURSED_SOUL_FLASK)
                .add(ModBlocks.GOAT_HEAD.method_8389())
                .add(ModBlocks.EFFIGIES.method_8389())
                .add(ModBlocks.WITCHING_TABLE.method_8389())
        ;

        method_10512(ModTags.Items.ELDRITCH_ITEMS)
                .add(ModItems.SOUL_FLASK_OF_THE_ABYSS)
        ;

        method_10512(ModTags.Items.BLOOD_BOTTLES)
                .add(ModItems.BLOOD_BOTTLE)
                .method_35922(class_2960.method_12829("twilightforest:fiery_blood"))
                .method_35922(class_2960.method_12829("iceandfire:fire_dragon_blood"))
                .method_35922(class_2960.method_12829("iceandfire:ice_dragon_blood"))
                .method_35922(class_2960.method_12829("iceandfire:lightning_dragon_blood"))
        ;

        method_10512(ModTags.Items.BLOOD_BUCKETS)
                .add(ModFluids.BLOOD_BUCKET)
                .method_35922(class_2960.method_12829("biomesoplenty:blood_bucket"))
                .method_35922(class_2960.method_12829("neepmeat:blood_bucket"))
        ;

        method_10512(ModTags.Items.BULLET_PROOF_ARMOR)
                .method_26792(ModTags.Items.BULLET_PROOF_ARMOR_II)
                .add(ModItems.JURASSOLINE_HELMET)
                .add(ModItems.JURASSOLINE_CHESTPLATE)
                .add(ModItems.JURASSOLINE_LEGGINGS)
                .add(ModItems.JURASSOLINE_BOOTS)
                .add(ModItems.PALLADIUM_HELMET)
                .add(ModItems.PALLADIUM_CHESTPLATE)
                .add(ModItems.PALLADIUM_LEGGINGS)
                .add(ModItems.PALLADIUM_BOOTS)
        ;

        method_10512(ModTags.Items.BULLET_PROOF_ARMOR_II)
                .method_26792(ModTags.Items.BULLET_PROOF_ARMOR_III)
                .add(ModItems.NEBULAR_HELMET)
                .add(ModItems.NEBULAR_CHESTPLATE)
                .add(ModItems.NEBULAR_LEGGINGS)
                .add(ModItems.NEBULAR_BOOTS)
                .add(ModItems.CINNABAR_HELMET)
                .add(ModItems.CINNABAR_CHESTPLATE)
                .add(ModItems.CINNABAR_LEGGINGS)
                .add(ModItems.CINNABAR_BOOTS)
        ;

        method_10512(ModTags.Items.BULLET_PROOF_ARMOR_III)
                .add(ModItems.MITHRIL_HELMET)
                .add(ModItems.MITHRIL_CHESTPLATE)
                .add(ModItems.MITHRIL_LEGGINGS)
                .add(ModItems.MITHRIL_BOOTS)
        ;

        method_10512(ModTags.Items.EGGS)
                .method_35923(class_2960.method_12829("c:eggs"))
        ;

        method_10512(ModTags.Items.HATCHABLE_EGGS)
                .add(class_1802.field_8618)
                .add(class_1802.field_8840)
                .add(class_1802.field_43193)
                .add(ModBlocks.TREX_EGG.method_8389())
                .add(ModBlocks.INFECTED_TREX_EGG.method_8389())
        ;

        method_10512(ModTags.Items.FORGING_HAMMERS)
                .method_26792(ModTags.Items.FORGING_HAMMERS_TIER1)
        ;

        method_10512(ModTags.Items.FORGING_HAMMERS_TIER1)
                .method_26792(ModTags.Items.FORGING_HAMMERS_TIER2)
        ;

        method_10512(ModTags.Items.FORGING_HAMMERS_TIER2)
                .method_26792(ModTags.Items.FORGING_HAMMERS_TIER3)
        ;

        method_10512(ModTags.Items.FORGING_HAMMERS_TIER3)
                .method_26792(ModTags.Items.FORGING_HAMMERS_TIER4)
        ;

        method_10512(ModTags.Items.FORGING_HAMMERS_TIER4)
                .add(ModItems.NETHERITE_FORGING_HAMMER)
                .method_26792(ModTags.Items.FORGING_HAMMERS_TIER5)
        ;

        method_10512(ModTags.Items.FORGING_HAMMERS_TIER5)
                .add(ModItems.HELIORITE_FORGING_HAMMER)
                .add(ModItems.ENDURIUM_FORGING_HAMMER)
                .method_26792(ModTags.Items.FORGING_HAMMERS_TIER6)
        ;

        method_10512(ModTags.Items.FORGING_HAMMERS_TIER6)
                .add(ModItems.PALLADIUM_FORGING_HAMMER)
                .add(ModItems.JURASSOLINE_FORGING_HAMMER)
                .method_26792(ModTags.Items.FORGING_HAMMERS_TIER7)
        ;

        method_10512(ModTags.Items.FORGING_HAMMERS_TIER7)
                .add(ModItems.CINNABAR_FORGING_HAMMER)
                .add(ModItems.NEBULAR_FORGING_HAMMER)
                .method_26792(ModTags.Items.FORGING_HAMMERS_TIER8)
        ;

        method_10512(ModTags.Items.FORGING_HAMMERS_TIER8)
                .add(ModItems.MITHRIL_FORGING_HAMMER)
                .method_26792(ModTags.Items.FORGING_HAMMERS_TIER9)
        ;

        method_10512(ModTags.Items.FORGING_HAMMERS_TIER9)
                .add(ModItems.ASTRAL_FORGING_HAMMER)
        ;

        method_10512(ModTags.Items.WOODEN_BARK)
                .add(ModItems.OAK_BARK)
                .add(ModItems.SPRUCE_BARK)
                .add(ModItems.BIRCH_BARK)
                .add(ModItems.JUNGLE_BARK)
                .add(ModItems.ACACIA_BARK)
                .add(ModItems.DARK_OAK_BARK)
                .add(ModItems.MANGROVE_BARK)
                .add(ModItems.CHERRY_BARK)
                .add(ModItems.GINKGO_BARK)

                .add(ModItems.SKYROOT_BARK)

                .add(ModItems.PEWEN_BARK)
                .add(ModItems.THORNWOOD_BARK)

                .add(ModItems.FIR_BARK)
                .add(ModItems.PINE_BARK)
                .add(ModItems.MAPLE_BARK)
                .add(ModItems.REDWOOD_BARK)
                .add(ModItems.MAHOGANY_BARK)
                .add(ModItems.JACARANCA_BARK)
                .add(ModItems.PALM_BARK)
                .add(ModItems.WILLOW_BARK)
                .add(ModItems.DEAD_BARK)
                .add(ModItems.MAGIC_BARK)
                .add(ModItems.UMBRAN_BARK)
                .add(ModItems.HELLBARK_BARK)
                .add(ModItems.EMPYREAL_BARK)

                .add(ModItems.ASHEN_BARK)
                .add(ModItems.AZALEA_BARK)
                .add(ModItems.TRUMPET_BARK)

                .add(ModItems.RUBBERWOOD_BARK)

                .add(ModItems.TWILIGHT_OAK_BARK)
                .add(ModItems.CANOPY_TREE_BARK)
                .add(ModItems.TWILIGHT_MANGROVE_BARK)
                .add(ModItems.DARKWOOD_BARK)
                .add(ModItems.TIMEWOOD_BARK)
                .add(ModItems.TRANSWOOD_BARK)
                .add(ModItems.MINEWOOD_BARK)
                .add(ModItems.SORTINGWOOD_BARK)

                .add(ModItems.YELLOW_WALLPAPER)
        ;

        method_10512(class_3489.field_23212)
                .method_26792(ModTags.Items.GINKGO_LOGS)
        ;

        method_10512(ModTags.Items.GINKGO_LOGS)
                .add(ModBlocks.GINKGO_LOG.method_8389())
                .add(ModBlocks.GINKGO_WOOD.method_8389())
                .add(ModBlocks.STRIPPED_GINKGO_LOG.method_8389())
                .add(ModBlocks.STRIPPED_GINKGO_WOOD.method_8389())
        ;

        method_10512(class_3489.field_15558)
                .add(ModBlocks.GINKGO_LEAVES.method_8389())
        ;

        method_10512(class_3489.field_15528)
                .add(ModBlocks.GINKGO_SAPLING.method_8389())
        ;

        method_10512(class_3489.field_15537)
                .add(ModBlocks.GINKGO_PLANKS.method_8389())
                .method_35923(class_2960.method_12829("c:fancy_planks"))
        ;

        method_10512(class_3489.field_15557)
                .add(ModBlocks.GINKGO_STAIRS.method_8389())
                .add(ModBlocks.FANCY_OAK_STAIRS.method_8389())
                .add(ModBlocks.FANCY_SPRUCE_STAIRS.method_8389())
                .add(ModBlocks.FANCY_BIRCH_STAIRS.method_8389())
                .add(ModBlocks.FANCY_JUNGLE_STAIRS.method_8389())
                .add(ModBlocks.FANCY_ACACIA_STAIRS.method_8389())
                .add(ModBlocks.FANCY_DARK_OAK_STAIRS.method_8389())
                .add(ModBlocks.FANCY_MANGROVE_STAIRS.method_8389())
                .add(ModBlocks.FANCY_CHERRY_STAIRS.method_8389())
                .add(ModBlocks.FANCY_PALE_OAK_STAIRS.method_8389())
                .add(ModBlocks.FANCY_BAMBOO_STAIRS.method_8389())
                .add(ModBlocks.FANCY_CRIMSON_STAIRS.method_8389())
                .add(ModBlocks.FANCY_WARPED_STAIRS.method_8389())
                .add(ModBlocks.FANCY_GINKGO_STAIRS.method_8389())
                .add(ModBlocks.FANCY_CHARRED_STAIRS.method_8389())
        ;

        method_10512(class_3489.field_15534)
                .add(ModBlocks.GINKGO_SLAB.method_8389())
                .add(ModBlocks.FANCY_OAK_SLAB.method_8389())
                .add(ModBlocks.FANCY_SPRUCE_SLAB.method_8389())
                .add(ModBlocks.FANCY_BIRCH_SLAB.method_8389())
                .add(ModBlocks.FANCY_JUNGLE_SLAB.method_8389())
                .add(ModBlocks.FANCY_ACACIA_SLAB.method_8389())
                .add(ModBlocks.FANCY_DARK_OAK_SLAB.method_8389())
                .add(ModBlocks.FANCY_MANGROVE_SLAB.method_8389())
                .add(ModBlocks.FANCY_CHERRY_SLAB.method_8389())
                .add(ModBlocks.FANCY_PALE_OAK_SLAB.method_8389())
                .add(ModBlocks.FANCY_BAMBOO_SLAB.method_8389())
                .add(ModBlocks.FANCY_CRIMSON_SLAB.method_8389())
                .add(ModBlocks.FANCY_WARPED_SLAB.method_8389())
                .add(ModBlocks.FANCY_GINKGO_SLAB.method_8389())
                .add(ModBlocks.FANCY_CHARRED_SLAB.method_8389())
        ;

        method_10512(class_3489.field_17620)
                .add(ModBlocks.GINKGO_FENCE.method_8389())
        ;

        method_10512(class_3489.field_40858)
                .add(ModBlocks.GINKGO_FENCE_GATE.method_8389())
        ;

        method_10512(class_3489.field_15552)
                .add(ModBlocks.GINKGO_DOOR.method_8389())
        ;

        method_10512(class_3489.field_15550)
                .add(ModBlocks.GINKGO_TRAPDOOR.method_8389())
                .add(ModBlocks.FANCY_OAK_TRAPDOOR.method_8389())
                .add(ModBlocks.FANCY_SPRUCE_TRAPDOOR.method_8389())
                .add(ModBlocks.FANCY_BIRCH_TRAPDOOR.method_8389())
                .add(ModBlocks.FANCY_JUNGLE_TRAPDOOR.method_8389())
                .add(ModBlocks.FANCY_ACACIA_TRAPDOOR.method_8389())
                .add(ModBlocks.FANCY_DARK_OAK_TRAPDOOR.method_8389())
                .add(ModBlocks.FANCY_MANGROVE_TRAPDOOR.method_8389())
                .add(ModBlocks.FANCY_CHERRY_TRAPDOOR.method_8389())
                .add(ModBlocks.FANCY_PALE_OAK_TRAPDOOR.method_8389())
                .add(ModBlocks.FANCY_BAMBOO_TRAPDOOR.method_8389())
                .add(ModBlocks.FANCY_CRIMSON_TRAPDOOR.method_8389())
                .add(ModBlocks.FANCY_WARPED_TRAPDOOR.method_8389())
                .add(ModBlocks.FANCY_GINKGO_TRAPDOOR.method_8389())
                .add(ModBlocks.FANCY_CHARRED_TRAPDOOR.method_8389())
        ;

        method_10512(class_3489.field_15540)
                .add(ModBlocks.GINKGO_PRESSURE_PLATE.method_8389())
        ;

        method_10512(class_3489.field_15555)
                .add(ModBlocks.GINKGO_BUTTON.method_8389())
        ;

        method_10512(class_3489.field_15533)
                .add(ModItems.GINKGO_SIGN)
        ;

        method_10512(class_3489.field_40108)
                .add(ModItems.HANGING_GINKGO_SIGN)
        ;

        method_10512(class_3489.field_41890)
                .add(ModItems.HELIORITE_HELMET, ModItems.HELIORITE_CHESTPLATE, ModItems.HELIORITE_LEGGINGS, ModItems.HELIORITE_BOOTS)
                .add(ModItems.ENDURIUM_HELMET, ModItems.ENDURIUM_CHESTPLATE, ModItems.ENDURIUM_LEGGINGS, ModItems.ENDURIUM_BOOTS)
                .add(ModItems.PALLADIUM_HELMET, ModItems.PALLADIUM_CHESTPLATE, ModItems.PALLADIUM_LEGGINGS, ModItems.PALLADIUM_BOOTS)
                .add(ModItems.JURASSOLINE_HELMET, ModItems.JURASSOLINE_CHESTPLATE, ModItems.JURASSOLINE_LEGGINGS, ModItems.JURASSOLINE_BOOTS)
                .add(ModItems.CINNABAR_HELMET, ModItems.CINNABAR_CHESTPLATE, ModItems.CINNABAR_LEGGINGS, ModItems.CINNABAR_BOOTS)
                .add(ModItems.NEBULAR_HELMET, ModItems.NEBULAR_CHESTPLATE, ModItems.NEBULAR_LEGGINGS, ModItems.NEBULAR_BOOTS)
                .add(ModItems.MITHRIL_HELMET, ModItems.MITHRIL_CHESTPLATE, ModItems.MITHRIL_LEGGINGS, ModItems.MITHRIL_BOOTS)
        ;

        method_10512(class_3489.field_40109)
                .add(ModItems.SPELL_BOOK)
                .add(ModItems.FORBIDDEN_SPELL_BOOK)
        ;

        method_10512(class_3489.field_15543)
                .add(ModBlocks.ROSE.method_8389())
                .add(ModBlocks.IRIS.method_8389())
                .add(ModBlocks.EDELWEISS.method_8389())
                .add(ModBlocks.ATHELAS.method_8389())
        ;

        method_10512(class_3489.field_15536)
                .add(ModItems.GINKGO_BOAT)
        ;

        method_10512(class_3489.field_38080)
                .add(ModItems.GINKGO_CHEST_BOAT)
        ;

        method_10512(class_3489.field_44592)
                .add(ModBlocks.MARBLE_BUTTON.method_8389())
                .add(ModBlocks.LIMESTONE_BUTTON.method_8389())
                .add(ModBlocks.RED_DEEPSLATE_BUTTON.method_8389())
        ;

        method_10512(class_3489.field_25808)
                .add(ModBlocks.MARBLE.method_8389())
                .add(ModBlocks.LIMESTONE.method_8389())
                .add(ModBlocks.RED_DEEPSLATE.method_8389())
                .add(ModBlocks.COBBLED_RED_DEEPSLATE.method_8389())
                .add(ModBlocks.MEGAREGOLITH.method_8389())
        ;

        method_10512(class_3489.field_23802)
                .add(ModBlocks.MARBLE.method_8389())
                .add(ModBlocks.LIMESTONE.method_8389())
                .add(ModBlocks.RED_DEEPSLATE.method_8389())
                .add(ModBlocks.COBBLED_RED_DEEPSLATE.method_8389())
                .add(ModBlocks.MEGAREGOLITH.method_8389())
        ;

        method_10512(class_3489.field_22277)
                .add(ModItems.ALUMINIUM_INGOT)
                .add(ModItems.HELIORITE_INGOT)
                .add(ModItems.ENDURIUM_INGOT)
                .add(ModItems.PALLADIUM_INGOT)
                .add(ModItems.JURASSOLINE_INGOT)
                .add(ModItems.CINNABAR_INGOT)
                .add(ModItems.NEBULAR_INGOT)
                .add(ModItems.MITHRIL_INGOT)
                .add(ModItems.ASTRAL_INGOT)
        ;

        method_10512(class_3489.field_15544)
                .add(ModBlocks.CURSED_WOOL.method_8389())
        ;

        method_10512(class_3489.field_15542)
                .add(ModBlocks.CURSED_CARPET.method_8389())
        ;

        method_10512(class_3489.field_24481)
                .add(ModBlocks.GLOBUS_CRUCIGER.method_8389())
                .add(ModItems.EMPERORS_CROWN)
        ;

        method_10512(class_3489.field_28624)
                .add(ModItems.STRAWBERRY)
        ;

        method_10512(class_3489.field_15532)
                .add(ModBlocks.LUNAR_REGOLITH.method_8389())
                .add(ModBlocks.SUSPICIOUS_LUNAR_REGOLITH.method_8389())
        ;

        method_10512(class_3489.field_42972)
                .add(ModBlocks.LUNAR_REGOLITH.method_8389())
        ;

        method_10512(class_3489.field_15543)
                .add(ModBlocks.ROSE.method_8389())
                .add(ModBlocks.IRIS.method_8389())
                .add(ModBlocks.ROSE.method_8389())
                .add(ModBlocks.ATHELAS.method_8389())
        ;

        method_10512(class_3489.field_23969)
                .add(ModItems.MUSIC_DISC_1)
                .add(ModItems.MUSIC_DISC_2)
                .add(ModItems.MUSIC_DISC_3)
                .add(ModItems.MUSIC_DISC_4)
                .add(ModItems.VHS_CASSETTE)
        ;

        method_10512(class_3489.field_15541)
                .add(ModItems.MUSIC_DISC_1)
                .add(ModItems.MUSIC_DISC_2)
                .add(ModItems.MUSIC_DISC_3)
                .add(ModItems.MUSIC_DISC_4)
        ;

        method_10512(ModTags.Items.MUSIC_DISCS)
                .add(ModItems.MUSIC_DISC_1)
                .add(ModItems.MUSIC_DISC_2)
                .add(ModItems.MUSIC_DISC_3)
                .add(ModItems.MUSIC_DISC_4)
        ;

        method_10512(ModTags.Items.TRANSMITTABLE_SIGNALS)
                .method_26792(ModTags.Items.MUSIC_DISCS)
                .method_26792(ModTags.Items.VHS_CASSETTES)
                .method_26792(ModTags.Items.GAME_CARTRIDGES)
        ;

        method_10512(ModTags.Items.STICK_EFFIGIES)
                .add(ModBlocks.STICK_CROSS.method_8389())
                .add(ModItems.STICK_EFFIGY)
                .add(ModItems.STICK_FIGURE)
        ;

        method_10512(ModTags.Items.BEER_CONTAINER)
                .add(ModItems.BEER_GOAT_HORN)
                .add(ModFluids.BEER_BUCKET)
                .add(ModBlocks.WOODEN_BEER_STEIN.method_8389())
        ;

        method_10512(ModTags.Items.MEAD_CONTAINER)
                .add(ModItems.MEAD_GOAT_HORN)
                .add(ModFluids.MEAD_BUCKET)
                .add(ModBlocks.WOODEN_MEAD_STEIN.method_8389())
        ;

        method_10512(ModTags.Items.HOT_MILK_CONTAINER)
                .add(ModFluids.HOT_MILK_BUCKET)
                .add(ModBlocks.HOT_WOODEN_MILK_STEIN.method_8389())
        ;

        method_10512(ModTags.Items.EXTRACTION_PICKAXES)
                .add(ModItems.CINNABAR_PICKAXE)
                .add(ModItems.CINNABAR_PAXEL)
                .add(ModItems.NEBULAR_PICKAXE)
                .add(ModItems.NEBULAR_PAXEL)
                .add(ModItems.MITHRIL_PICKAXE)
                .add(ModItems.MITHRIL_PAXEL)
                .add(ModItems.ASTRAL_PICKAXE)
                .add(ModItems.DIVINE_PICKAXE)
                .add(ModItems.CATACLYSMIC_PICKAXE)
        ;

        method_10512(ModTags.Items.EXTRACTION_II_PICKAXES)
                .add(ModItems.MITHRIL_PICKAXE)
                .add(ModItems.MITHRIL_PAXEL)
                .add(ModItems.ASTRAL_PICKAXE)
                .add(ModItems.DIVINE_PICKAXE)
                .add(ModItems.CATACLYSMIC_PICKAXE)
                .add(ModItems.MITHRIL_COMMAND_BLOCK_PICKAXE)
        ;

        method_10512(ModTags.Items.EXTRACTION_III_PICKAXES)
                .add(ModItems.ASTRAL_PICKAXE)
                .add(ModItems.DIVINE_PICKAXE)
                .add(ModItems.CATACLYSMIC_PICKAXE)
        ;

        method_10512(ModTags.Items.MOUTH_OF_THE_ABYSS)
                .add(ModItems.ELDRITCH_PICKAXE)
        ;

        method_10512(ModTags.Items.WOODEN_LIQUID_STEINS)
                .add(ModBlocks.WOODEN_WATER_STEIN.method_8389())
                .add(ModBlocks.WOODEN_BEER_STEIN.method_8389())
                .add(ModBlocks.WOODEN_MEAD_STEIN.method_8389())
                .add(ModBlocks.WOODEN_APPLE_JUICE_STEIN.method_8389())
                .add(ModBlocks.WOODEN_ORANGE_JUICE_STEIN.method_8389())
                .add(ModBlocks.WOODEN_MILK_STEIN.method_8389())
                .add(ModBlocks.WOODEN_CHOCOLATE_MILKSHAKE_STEIN.method_8389())
                .add(ModBlocks.WOODEN_CARAMEL_MILKSHAKE_STEIN.method_8389())
                .add(ModBlocks.WOODEN_STRAWBERRY_MILKSHAKE_STEIN.method_8389())
                .add(ModBlocks.WOODEN_ORANGE_MILKSHAKE_STEIN.method_8389())
                .add(ModBlocks.WOODEN_BLUE_BERRY_MILKSHAKE_STEIN.method_8389())
                .add(ModBlocks.WOODEN_TORCHBERRY_MILKSHAKE_STEIN.method_8389())
                .add(ModBlocks.HOT_WOODEN_MILK_STEIN.method_8389())
                .add(ModBlocks.WOODEN_HOT_CHOCOLATE_STEIN.method_8389())
        ;

        method_10512(ModTags.Items.VHS_CASSETTES)
                .add(ModItems.VHS_CASSETTE)
                .add(ModItems.VHS_CASSETTE_1)
                .add(ModItems.VHS_CASSETTE_2)
                .add(ModItems.VHS_CASSETTE_3)
                .add(ModItems.VHS_CASSETTE_4)
                .add(ModItems.VHS_CASSETTE_5)
                .add(ModItems.VHS_CASSETTE_6)
                .add(ModItems.VHS_CASSETTE_7)
                .add(ModItems.VHS_CASSETTE_8)
                .add(ModItems.VHS_CASSETTE_9)
                .add(ModItems.VHS_CASSETTE_PROJECT_KV31)
                .add(ModItems.VHS_CASSETTE_BROKEN)
        ;

        method_10512(ModTags.Items.GAME_CARTRIDGES)
                .add(ModItems.GAME_CARTRIDGE)
                .add(ModItems.GAME_CARTRIDGE_1)
                .add(ModItems.GAME_CARTRIDGE_2)
                .add(ModItems.GAME_CARTRIDGE_3)
        ;

        method_10512(ModTags.Items.HEV_CHARGER_CHARGABLE)
                .add(ModItems.HEV_SUIT_CHESTPLATE)
                .add(ModItems.HEV_SUIT_LEGGINGS)
                .add(ModItems.HEV_SUIT_BOOTS)
        ;

        method_10512(ModTags.Items.RADIATION_PROTECTION_WITHOUT_HELMET)
                .add(ModItems.HEV_SUIT_CHESTPLATE)
                .add(ModItems.HEV_SUIT_LEGGINGS)
                .add(ModItems.HEV_SUIT_BOOTS)
        ;

        method_10512(ModTags.Items.RADIATION_PROTECTION)
                .add(ModItems.HEV_SUIT_CHESTPLATE)
                .add(ModItems.HEV_SUIT_LEGGINGS)
                .add(ModItems.HEV_SUIT_BOOTS)
                .method_35922(class_2960.method_12829("alexscaves:hazmat_mask"))
                .method_35922(class_2960.method_12829("alexscaves:hazmat_chestplate"))
                .method_35922(class_2960.method_12829("alexscaves:hazmat_leggings"))
                .method_35922(class_2960.method_12829("alexscaves:hazmat_boots"))
                .method_35922(class_2960.method_12829("mekanism:hazmat_mask"))
                .method_35922(class_2960.method_12829("mekanism:hazmat_gown"))
                .method_35922(class_2960.method_12829("mekanism:hazmat_pants"))
                .method_35922(class_2960.method_12829("mekanism:hazmat_boots"))
        ;

        method_10512(ModTags.Items.OXYGEN_STORING)
                .method_26792(ModTags.Items.OXYGEN_STORING_1K)
                .method_26792(ModTags.Items.OXYGEN_STORING_2K)
                .method_26792(ModTags.Items.OXYGEN_STORING_4K)
        ;

        method_10512(ModTags.Items.OXYGEN_STORING_1K)
                .add(ModItems.OXYGEN_TANK)
                .add(ModItems.SPACE_SUIT_CHESTPLATE)
                .method_35922(class_2960.method_12829("ad_astra:space_suit"))
        ;

        method_10512(ModTags.Items.OXYGEN_STORING_2K)
                .method_35922(class_2960.method_12829("ad_astra:netherite_space_suit"))
        ;

        method_10512(ModTags.Items.OXYGEN_STORING_4K)
                .method_35922(class_2960.method_12829("ad_astra:jet_suit"))
        ;

        method_10512(ModTags.Items.HYPOXIA_PROTECTION)
                .add(ModItems.ASTRONAUT_HELMET)
                .add(ModItems.SPACE_SUIT_CHESTPLATE)
                .add(ModItems.SPACE_SUIT_LEGGINGS)
                .add(ModItems.SPACE_SUIT_BOOTS)
                .method_35923(class_2960.method_12829("ad_astra:space_suit_items"))
        ;

        method_10512(ModTags.Items.IRON_OR_STEEL)
                .method_35923(class_2960.method_12829("c:iron_ingots"))
                .method_35923(class_2960.method_12829("c:steel_ingots"))
        ;

        method_10512(ModTags.Items.CINNABAR_OR_NEBULAR)
                .add(ModItems.CINNABAR_CRYSTAL)
                .add(ModItems.NEBULAR_CRYSTAL)
        ;

        method_10512(ModTags.Items.WIRES)
                .add(ModItems.ALUMINIUM_WIRE)
                .add(ModItems.COPPER_WIRE)
                .method_26792(ModTags.Items.WIRES_2)
        ;

        method_10512(ModTags.Items.WIRES_2)
                .add(ModItems.GOLD_WIRE)
                .method_26792(ModTags.Items.WIRES_3)
        ;

        method_10512(ModTags.Items.WIRES_3)
                .add(ModItems.MITHRIL_WIRE)
        ;

        method_10512(ModTags.Items.CIRCUIT_BOARDS)
                .add(ModItems.CIRCUIT_BOARD)
                .method_26792(ModTags.Items.ADVANCED_CIRCUIT_BOARDS)
        ;

        method_10512(ModTags.Items.ADVANCED_CIRCUIT_BOARDS)
                .add(ModItems.ADVANCED_CIRCUIT_BOARD)
                .method_26792(ModTags.Items.TRANSCENDENT_CIRCUIT_BOARDS)
        ;

        method_10512(ModTags.Items.TRANSCENDENT_CIRCUIT_BOARDS)
                .add(ModItems.TRANSCENDENT_CIRCUIT_BOARD)
                .add(ModItems.FUTURISTIC_CIRCUIT_BOARD)
                .add(ModItems.ARCANE_CIRCUIT_BOARD)
                .add(ModItems.BIOLOGICAL_CIRCUIT_BOARD)
        ;

        method_10512(ModTags.Items.KEYCARDS)
                .add(ModItems.KEYCARD)
        ;

        method_10512(ModTags.Items.TREX_HEADS)
                .add(ModBlocks.TREX_HEAD.method_8389())
                .add(ModBlocks.GREEN_TREX_HEAD.method_8389())
                .add(ModBlocks.GRAY_TREX_HEAD.method_8389())

                .add(ModBlocks.INFECTED_TREX_HEAD.method_8389())
                .add(ModBlocks.SCULK_TREX_HEAD.method_8389())
                .add(ModBlocks.SICKENED_TREX_HEAD.method_8389())
        ;

        method_10512(class_6862.method_40092(class_7924.field_41197, new class_2960("c", "stripped_woods")))
                .add(class_1802.field_8248)
                .add(class_1802.field_8362)
                .add(class_1802.field_8472)
                .add(class_1802.field_8785)
                .add(class_1802.field_8284)
                .add(class_1802.field_8219)
                .add(class_1802.field_37509)
                .add(class_1802.field_42690)
                .add(class_1802.field_22487)
                .add(class_1802.field_22488)
                .add(ModBlocks.STRIPPED_GINKGO_WOOD.method_8389())
        ;

        method_10512(ModTags.Items.SICKLES)
                .add(ModItems.COPPER_SICKLE)
                .add(ModItems.GOLDEN_SICKLE)
                .add(ModItems.STEEL_SICKLE)
                .add(ModItems.NETHERITE_SICKLE)
                .add(ModItems.HELIORITE_SICKLE)
                .add(ModItems.ENDURIUM_SICKLE)
                .add(ModItems.PALLADIUM_SICKLE)
                .add(ModItems.JURASSOLINE_SICKLE)
                .add(ModItems.CINNABAR_SICKLE)
                .add(ModItems.NEBULAR_SICKLE)
                .add(ModItems.MITHRIL_SICKLE)
                .add(ModItems.ASTRAL_SICKLE)
        ;

        method_10512(class_6862.method_40092(class_7924.field_41197, new class_2960("c", "swords")))
                .add(ModItems.BAMBOO_SWORD)
                .add(ModItems.HELIORITE_SWORD)
                .add(ModItems.ENDURIUM_SWORD)
                .add(ModItems.PALLADIUM_SWORD)
                .add(ModItems.JURASSOLINE_SWORD)
                .add(ModItems.CINNABAR_SWORD)
                .add(ModItems.NEBULAR_SWORD)
                .add(ModItems.MITHRIL_SWORD)
                .add(ModItems.MITHRIL_COMMAND_BLOCK_SWORD)
                .add(ModItems.ASTRAL_SWORD)
                .add(ModItems.NARSIL_HANDLE)
                .add(ModItems.ANDURIL)
        ;

        method_10512(class_6862.method_40092(class_7924.field_41197, new class_2960("c", "pickaxes")))
                .add(ModItems.BAMBOO_PICKAXE)
                .add(ModItems.HELIORITE_PICKAXE)
                .add(ModItems.ENDURIUM_PICKAXE)
                .add(ModItems.PALLADIUM_PICKAXE)
                .add(ModItems.JURASSOLINE_PICKAXE)
                .add(ModItems.CINNABAR_PICKAXE)
                .add(ModItems.NEBULAR_PICKAXE)
                .add(ModItems.MITHRIL_PICKAXE)
                .add(ModItems.MITHRIL_COMMAND_BLOCK_PICKAXE)
                .add(ModItems.ASTRAL_PICKAXE)
                .add(ModItems.DIVINE_PICKAXE)
                .add(ModItems.CATACLYSMIC_PICKAXE)
                .add(ModItems.ELDRITCH_PICKAXE)
        ;

        method_10512(class_3489.field_18317)
                .add(ModItems.SILVERTHORN_ARROW)
        ;

        method_10512(class_6862.method_40092(class_7924.field_41197, new class_2960("c", "axes")))
                .add(ModItems.BAMBOO_AXE)
                .add(ModItems.HELIORITE_AXE)
                .add(ModItems.ENDURIUM_AXE)
                .add(ModItems.PALLADIUM_AXE)
                .add(ModItems.JURASSOLINE_AXE)
                .add(ModItems.CINNABAR_AXE)
                .add(ModItems.NEBULAR_AXE)
                .add(ModItems.MITHRIL_AXE)
                .add(ModItems.MITHRIL_COMMAND_BLOCK_AXE)
                .add(ModItems.ASTRAL_AXE)
        ;

        method_10512(class_6862.method_40092(class_7924.field_41197, new class_2960("c", "shovels")))
                .add(ModItems.BAMBOO_SHOVEL)
                .add(ModItems.HELIORITE_SHOVEL)
                .add(ModItems.ENDURIUM_SHOVEL)
                .add(ModItems.JURASSOLINE_SHOVEL)
                .add(ModItems.PALLADIUM_SHOVEL)
                .add(ModItems.CINNABAR_SHOVEL)
                .add(ModItems.NEBULAR_SHOVEL)
                .add(ModItems.MITHRIL_SHOVEL)
                .add(ModItems.MITHRIL_COMMAND_BLOCK_SHOVEL)
                .add(ModItems.ASTRAL_SHOVEL)
        ;

        method_10512(class_6862.method_40092(class_7924.field_41197, new class_2960("c", "hoes")))
                .add(ModItems.BAMBOO_HOE)
                .add(ModItems.HELIORITE_HOE)
                .add(ModItems.ENDURIUM_HOE)
                .add(ModItems.PALLADIUM_HOE)
                .add(ModItems.JURASSOLINE_HOE)
                .add(ModItems.CINNABAR_HOE)
                .add(ModItems.NEBULAR_HOE)
                .add(ModItems.MITHRIL_HOE)
                .add(ModItems.MITHRIL_COMMAND_BLOCK_HOE)
                .add(ModItems.ASTRAL_HOE)
        ;

        method_10512(ModTags.Items.PAXELS)
                .add(ModItems.HELIORITE_PAXEL)
                .add(ModItems.ENDURIUM_PAXEL)
                .add(ModItems.PALLADIUM_PAXEL)
                .add(ModItems.JURASSOLINE_PAXEL)
                .add(ModItems.CINNABAR_PAXEL)
                .add(ModItems.NEBULAR_PAXEL)
                .add(ModItems.MITHRIL_PAXEL)
        ;

        method_10512(class_6862.method_40092(class_7924.field_41197, new class_2960("c", "quartz_blocks")))
                .add(class_1802.field_20402)
                .add(class_1802.field_20386)
        ;

        method_10512(class_6862.method_40092(class_7924.field_41197, new class_2960("c", "colorless_glass")))
                .add(class_1802.field_8280)
        ;

        method_10512(class_6862.method_40092(class_7924.field_41197, new class_2960("c", "colorless_glass_panes")))
                .add(class_1802.field_8141)
        ;

        method_10512(class_6862.method_40092(class_7924.field_41197, new class_2960("c", "framed_colorless_glass")))
                .add(ModBlocks.FRAMED_GLASS.method_8389())
                .add(ModBlocks.FRAMED_GLASS_BOTTOM.method_8389())
                .add(ModBlocks.FRAMED_GLASS_MIDDLE.method_8389())
                .add(ModBlocks.FRAMED_GLASS_TOP.method_8389())
                .add(ModBlocks.FRAMED_GLASS_ROUND.method_8389())
                .add(ModBlocks.FRAMED_GLASS_SPLIT.method_8389())
                .add(ModBlocks.FRAMED_GLASS_TILED.method_8389())
        ;

        method_10512(class_6862.method_40092(class_7924.field_41197, new class_2960("c", "framed_colorless_glass_panes")))
                .add(ModBlocks.FRAMED_GLASS_PANE.method_8389())
                .add(ModBlocks.FRAMED_GLASS_BOTTOM_PANE.method_8389())
                .add(ModBlocks.FRAMED_GLASS_MIDDLE_PANE.method_8389())
                .add(ModBlocks.FRAMED_GLASS_TOP_PANE.method_8389())
                .add(ModBlocks.FRAMED_GLASS_ROUND_PANE.method_8389())
                .add(ModBlocks.FRAMED_GLASS_SPLIT_PANE.method_8389())
                .add(ModBlocks.FRAMED_GLASS_TILED_PANE.method_8389())
        ;

        method_10512(class_6862.method_40092(class_7924.field_41197, new class_2960("c", "bones")))
                .add(ModItems.FOSSILIZED_BONE)
        ;

        method_10512(class_6862.method_40092(class_7924.field_41197, new class_2960("c", "seeds")))
                .add(ModItems.STRAWBERRY_SEEDS)
                .add(ModItems.ORANGE_SEEDS)
                .add(ModItems.PIPE_WEED_SEEDS)
        ;

        method_10512(class_3489.field_41891)
                .add(ModItems.HELIORITE_INGOT)
                .add(ModItems.ENDURIUM_INGOT)
                .add(ModItems.PALLADIUM_INGOT)
                .add(ModItems.JURASSOLINE_INGOT)
                .add(ModItems.CINNABAR_INGOT)
                .add(ModItems.NEBULAR_INGOT)
                .add(ModItems.MITHRIL_INGOT)
        ;

        method_10512(class_3489.field_44591)
                .add(ModItems.STRAWBERRY_SEEDS)
                .add(ModItems.ORANGE_SEEDS)
                .add(ModItems.PIPE_WEED_SEEDS)
        ;

        method_10512(class_6862.method_40092(class_7924.field_41197, new class_2960("c", "flour")))
                .add(ModItems.FLOUR)
        ;

        method_10512(class_6862.method_40092(class_7924.field_41197, new class_2960("c", "eggs")))
                .add(class_1802.field_8803)
        ;

        method_10512(class_6862.method_40092(class_7924.field_41197, new class_2960("c", "sugar")))
                .add(class_1802.field_8479)
        ;

        method_10512(class_6862.method_40092(class_7924.field_41197, new class_2960("c", "milk")))
                .add(class_1802.field_8103)
                .add(ModBlocks.WOODEN_MILK_STEIN.method_8389())
        ;

        method_10512(class_6862.method_40092(class_7924.field_41197, new class_2960("c", "sulfur_ores")))
                .add(ModBlocks.RED_DEEPSLATE_SULFUR_ORE.method_8389())
                .add(ModBlocks.NETHER_SULFUR_ORE.method_8389())
        ;

        method_10512(class_6862.method_40092(class_7924.field_41197, new class_2960("c", "quartz_ores")))
                .add(ModBlocks.RED_DEEPSLATE_QUARTZ_ORE.method_8389())
                .add(class_2246.field_10213.method_8389())
        ;

        method_10512(class_6862.method_40092(class_7924.field_41197, new class_2960("c", "coal_ores")))
                .add(ModBlocks.MEGAREGOLITH_COAL_ORE.method_8389())
        ;

        method_10512(class_6862.method_40092(class_7924.field_41197, new class_2960("c", "copper_ores")))
                .add(ModBlocks.RED_DEEPSLATE_COPPER_ORE.method_8389())
        ;

        method_10512(class_6862.method_40092(class_7924.field_41197, new class_2960("c", "iron_ores")))
                .add(ModBlocks.RED_DEEPSLATE_IRON_ORE.method_8389())
                .add(ModBlocks.MEGAREGOLITH_IRON_ORE.method_8389())
        ;

        method_10512(class_6862.method_40092(class_7924.field_41197, new class_2960("c", "gold_ores")))
                .add(ModBlocks.RED_DEEPSLATE_GOLD_ORE.method_8389())
        ;

        method_10512(class_6862.method_40092(class_7924.field_41197, new class_2960("c", "lapis_ores")))
                .add(ModBlocks.RED_DEEPSLATE_LAPIS_ORE.method_8389())
        ;

        method_10512(class_6862.method_40092(class_7924.field_41197, new class_2960("c", "redstone_ores")))
                .add(ModBlocks.RED_DEEPSLATE_REDSTONE_ORE.method_8389())
        ;

        method_10512(class_6862.method_40092(class_7924.field_41197, new class_2960("c", "diamond_ores")))
                .add(ModBlocks.RED_DEEPSLATE_DIAMOND_ORE.method_8389())
        ;

        method_10512(class_6862.method_40092(class_7924.field_41197, new class_2960("c", "emerald_ores")))
                .add(ModBlocks.RED_DEEPSLATE_EMERALD_ORE.method_8389())
        ;

        method_10512(class_6862.method_40092(class_7924.field_41197, new class_2960("c", "uranium_ores")))
                .add(ModBlocks.URANIUM_ORE.method_8389())
                .add(ModBlocks.DEEPSLATE_URANIUM_ORE.method_8389())
                .add(ModBlocks.RED_DEEPSLATE_URANIUM_ORE.method_8389())
        ;

        method_10512(class_6862.method_40092(class_7924.field_41197, new class_2960("c", "palladium_ores")))
                .add(ModBlocks.PALLADIUM_ORE.method_8389())
                .add(ModBlocks.DEEPSLATE_PALLADIUM_ORE.method_8389())
                .add(ModBlocks.RED_DEEPSLATE_PALLADIUM_ORE.method_8389())
        ;

        method_10512(class_6862.method_40092(class_7924.field_41197, new class_2960("c", "cinnabar_ores")))
                .add(ModBlocks.CINNABAR_ORE.method_8389())
                .add(ModBlocks.DEEPSLATE_CINNABAR_ORE.method_8389())
                .add(ModBlocks.RED_DEEPSLATE_CINNABAR_ORE.method_8389())
        ;

        method_10512(class_6862.method_40092(class_7924.field_41197, new class_2960("c", "zinc_ores")))
                .add(ModBlocks.RED_DEEPSLATE_ZINC_ORE.method_8389())
        ;

        method_10512(class_6862.method_40092(class_7924.field_41197, new class_2960("c", "copper_nuggets")))
                .add(ModItems.COPPER_NUGGET)
        ;

        method_10512(class_6862.method_40092(class_7924.field_41197, new class_2960("c", "aluminium_raw_materials"))).method_35923(class_2960.method_12829("c:aluminum_raw_materials"));
        method_10512(class_6862.method_40092(class_7924.field_41197, new class_2960("c", "aluminum_raw_materials"))).add(ModItems.RAW_ALUMINIUM);
        method_10512(class_6862.method_40092(class_7924.field_41197, new class_2960("c", "aluminium_nuggets"))).method_35923(class_2960.method_12829("c:aluminum_nuggets"));
        method_10512(class_6862.method_40092(class_7924.field_41197, new class_2960("c", "aluminum_nuggets"))).add(ModItems.ALUMINIUM_NUGGET);
        method_10512(class_6862.method_40092(class_7924.field_41197, new class_2960("c", "aluminium_ingots"))).method_35923(class_2960.method_12829("c:aluminum_ingots"));
        method_10512(class_6862.method_40092(class_7924.field_41197, new class_2960("c", "aluminum_ingots"))).add(ModItems.ALUMINIUM_INGOT);
        method_10512(class_6862.method_40092(class_7924.field_41197, new class_2960("c", "aluminium_plates"))).method_35923(class_2960.method_12829("c:aluminum_plates"));
        method_10512(class_6862.method_40092(class_7924.field_41197, new class_2960("c", "aluminum_plates"))).add(ModItems.ALUMINIUM_SHEET);
        method_10512(class_6862.method_40092(class_7924.field_41197, new class_2960("c", "raw_aluminium_blocks"))).method_35923(class_2960.method_12829("c:raw_aluminum_blocks"));
        method_10512(class_6862.method_40092(class_7924.field_41197, new class_2960("c", "raw_aluminum_blocks"))).add(ModBlocks.RAW_ALUMINIUM_BLOCK.method_8389());
        method_10512(class_6862.method_40092(class_7924.field_41197, new class_2960("c", "aluminium_blocks"))).method_35923(class_2960.method_12829("c:aluminum_blocks"));
        method_10512(class_6862.method_40092(class_7924.field_41197, new class_2960("c", "aluminum_blocks"))).add(ModBlocks.ALUMINIUM_BLOCK.method_8389());
        method_10512(class_6862.method_40092(class_7924.field_41197, new class_2960("c", "aluminium_ores"))).method_35923(class_2960.method_12829("c:aluminum_ores"));
        method_10512(class_6862.method_40092(class_7924.field_41197, new class_2960("c", "aluminum_ores")))
                .add(ModBlocks.ALUMINIUM_ORE.method_8389())
                .add(ModBlocks.DEEPSLATE_ALUMINIUM_ORE.method_8389())
                .add(ModBlocks.RED_DEEPSLATE_ALUMINIUM_ORE.method_8389())
        ;

        method_10512(class_6862.method_40092(class_7924.field_41197, new class_2960("c", "lead_raw_materials")))
                .add(ModItems.RAW_LEAD)
        ;

        method_10512(class_6862.method_40092(class_7924.field_41197, new class_2960("c", "lead_nuggets")))
                .add(ModItems.LEAD_NUGGET)
        ;

        method_10512(class_6862.method_40092(class_7924.field_41197, new class_2960("c", "lead_ingots")))
                .add(ModItems.LEAD_INGOT)
        ;

        method_10512(class_6862.method_40092(class_7924.field_41197, new class_2960("c", "raw_lead_blocks")))
                .add(ModBlocks.RAW_LEAD_BLOCK.method_8389())
        ;

        method_10512(class_6862.method_40092(class_7924.field_41197, new class_2960("c", "lead_blocks")))
                .add(ModBlocks.LEAD_BLOCK.method_8389())
        ;

        method_10512(class_6862.method_40092(class_7924.field_41197, new class_2960("c", "lead_ores")))
                .add(ModBlocks.LEAD_ORE.method_8389())
                .add(ModBlocks.DEEPSLATE_LEAD_ORE.method_8389())
                .add(ModBlocks.RED_DEEPSLATE_LEAD_ORE.method_8389())
        ;

        method_10512(class_6862.method_40092(class_7924.field_41197, new class_2960("c", "sulfur_dusts")))
                .add(ModItems.SULFUR)
        ;

        method_10512(class_6862.method_40092(class_7924.field_41197, new class_2960("c", "raw_uranium")))
                .add(ModItems.URANIUM)
        ;

        method_10512(class_6862.method_40092(class_7924.field_41197, new class_2960("forge", "raw_materials/uranium")))
                .add(ModItems.URANIUM)
        ;

        method_10512(class_6862.method_40092(class_7924.field_41197, new class_2960("c", "uranium_nuggets")))
                .add(ModItems.URANIUM_NUGGET)
        ;

        method_10512(class_6862.method_40092(class_7924.field_41197, new class_2960("c", "uranium_ingots")))
                .add(ModItems.URANIUM_INGOT)
        ;

        method_10512(class_6862.method_40092(class_7924.field_41197, new class_2960("c", "raw_uranium_blocks")))
                .add(ModBlocks.RAW_URANIUM_BLOCK.method_8389())
        ;

        method_10512(class_6862.method_40092(class_7924.field_41197, new class_2960("c", "uranium_blocks")))
                .add(ModBlocks.URANIUM_BLOCK.method_8389())
        ;

        method_10512(class_6862.method_40092(class_7924.field_41197, new class_2960("c", "wooden_rods")))
                .add(class_1802.field_8600)
        ;

        method_10512(class_6862.method_40092(class_7924.field_41197, new class_2960("c", "copper_ingots")))
                .add(class_1802.field_27022)
        ;

        method_10512(class_6862.method_40092(class_7924.field_41197, new class_2960("c", "iron_nuggets")))
                .add(class_1802.field_8675)
        ;

        method_10512(class_6862.method_40092(class_7924.field_41197, new class_2960("c", "iron_ingots")))
                .add(class_1802.field_8620)
        ;

        method_10512(class_6862.method_40092(class_7924.field_41197, new class_2960("c", "gold_nuggets")))
                .add(class_1802.field_8397)
        ;

        method_10512(class_6862.method_40092(class_7924.field_41197, new class_2960("c", "gold_ingots")))
                .add(class_1802.field_8695)
        ;

        method_10512(class_6862.method_40092(class_7924.field_41197, new class_2960("c", "steel_raw_materials")))
                .add(ModItems.STEEL_INGREDIENTS)
        ;

        method_10512(class_6862.method_40092(class_7924.field_41197, new class_2960("c", "steel_nuggets")))
                .add(ModItems.STEEL_NUGGET)
        ;

        method_10512(class_6862.method_40092(class_7924.field_41197, new class_2960("c", "steel_ingots")))
                .add(ModItems.STEEL_INGOT)
        ;

        method_10512(class_6862.method_40092(class_7924.field_41197, new class_2960("c", "steel_rods")))
                .add(ModItems.STEEL_ROD)
        ;

        method_10512(class_6862.method_40092(class_7924.field_41197, new class_2960("c", "steel_blocks")))
                .add(ModBlocks.STEEL_BLOCK.method_8389())
        ;

        method_10512(class_6862.method_40092(class_7924.field_41197, new class_2960("c", "mithril_raw_materials")))
                .add(ModItems.RAW_MITHRIL)
        ;

        method_10512(class_6862.method_40092(class_7924.field_41197, new class_2960("c", "mithril_nuggets")))
                .add(ModItems.MITHRIL_NUGGET)
        ;

        method_10512(class_6862.method_40092(class_7924.field_41197, new class_2960("c", "mithril_ingots")))
                .add(ModItems.MITHRIL_INGOT)
        ;

        method_10512(class_6862.method_40092(class_7924.field_41197, new class_2960("c", "raw_mithril_blocks")))
                .add(ModBlocks.RAW_MITHRIL_BLOCK.method_8389())
        ;

        method_10512(class_6862.method_40092(class_7924.field_41197, new class_2960("c", "mithril_blocks")))
                .add(ModBlocks.MITHRIL_BLOCK.method_8389())
        ;

        method_10512(class_6862.method_40092(class_7924.field_41197, new class_2960("c", "oil_buckets")))
                .add(ModFluids.OIL_BUCKET)
        ;

        method_10512(class_6862.method_40092(class_7924.field_41197, new class_2960("c", "fossils")))
                .add(ModItems.FOSSILIZED_BONE)
                .add(ModItems.PLANT_FOSSIL)
        ;

        method_10512(class_6862.method_40092(class_7924.field_41197, new class_2960("c", "shears")))
                .add(ModItems.COPPER_SICKLE)
                .add(ModItems.GOLDEN_SICKLE)
                .add(ModItems.STEEL_SICKLE)
                .add(ModItems.NETHERITE_SICKLE)
                .add(ModItems.HELIORITE_SICKLE)
                .add(ModItems.ENDURIUM_SICKLE)
                .add(ModItems.PALLADIUM_SICKLE)
                .add(ModItems.JURASSOLINE_SICKLE)
                .add(ModItems.CINNABAR_SICKLE)
                .add(ModItems.NEBULAR_SICKLE)
                .add(ModItems.MITHRIL_SICKLE)
                .add(ModItems.ASTRAL_SICKLE)
        ;

        method_10512(class_6862.method_40092(class_7924.field_41197, new class_2960("c", "foods")))
                .add(ModBlocks.WOODEN_WATER_STEIN.method_8389())
                .add(ModBlocks.WOODEN_MILK_STEIN.method_8389())
                .add(ModBlocks.WOODEN_BEER_STEIN.method_8389())
                .add(ModBlocks.WOODEN_MEAD_STEIN.method_8389())
                .add(ModBlocks.WOODEN_APPLE_JUICE_STEIN.method_8389())
                .add(ModBlocks.WOODEN_ORANGE_JUICE_STEIN.method_8389())
                .add(ModBlocks.WOODEN_STRAWBERRY_MILKSHAKE_STEIN.method_8389())
                .add(ModBlocks.WOODEN_ORANGE_MILKSHAKE_STEIN.method_8389())
                .add(ModBlocks.WOODEN_BLUE_BERRY_MILKSHAKE_STEIN.method_8389())
                .add(ModBlocks.WOODEN_TORCHBERRY_MILKSHAKE_STEIN.method_8389())
                .add(ModBlocks.WOODEN_CHOCOLATE_MILKSHAKE_STEIN.method_8389())
                .add(ModBlocks.WOODEN_CARAMEL_MILKSHAKE_STEIN.method_8389())
                .add(ModBlocks.HOT_WOODEN_MILK_STEIN.method_8389())
                .add(ModBlocks.WOODEN_HOT_CHOCOLATE_STEIN.method_8389())
                .add(ModItems.CARAMEL)
                .add(ModItems.STRAWBERRY)
                .add(ModItems.CHOCOLATE_STRAWBERRY)
                .add(ModItems.ORANGE)
                .add(ModItems.HEMP_COOKIE)
                .add(ModItems.TOAST)
                .add(ModItems.STRAWBERRY_JAM_TOAST)
                .add(ModItems.ORANGE_MARMELADE_TOAST)
                .add(ModItems.SWEET_BERRY_JAM_TOAST)
                .add(ModItems.GLOW_BERRY_JAM_TOAST)
                .add(ModItems.BLUE_BERRY_JAM_TOAST)
                .add(ModItems.DROOPFRUIT_JAM_TOAST)
                .add(ModItems.ANCIENT_SOULBERRY_JAM_TOAST)
                .add(ModItems.MAULTASCHE)
                .add(ModItems.MAULTASCHEN_BROTH)
                .add(ModItems.RAW_SCHNITZEL)
                .add(ModItems.SCHNITZEL)
                .add(ModItems.CALAMARI)
                .add(ModItems.FRIED_CALAMARI)
                .add(ModItems.DINOSAUR_MEAT)
                .add(ModItems.COOKED_DINOSAUR_MEAT)
                .add(ModItems.CURED_MEAT)
                .add(ModItems.COOKED_MEAT)
                .add(ModItems.PORRIDGE)
        ;

        method_10512(class_6862.method_40092(class_7924.field_41197, new class_2960("c", "caramel")))
                .add(ModItems.CARAMEL)
                .method_35922(class_2960.method_12829("alexscaves:caramel"))
        ;
    }
}
