package net.tlotd.datagen;

import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricRecipeProvider;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2444;
import net.minecraft.class_2447;
import net.minecraft.class_2450;
import net.minecraft.class_2960;
import net.minecraft.class_3489;
import net.minecraft.class_6862;
import net.minecraft.class_7800;
import net.minecraft.class_7924;
import net.tlotd.block.ModBlocks;
import net.tlotd.fluid.ModFluids;
import net.tlotd.item.ModItems;
import net.tlotd.util.ModTags;

import java.util.List;
import java.util.function.Consumer;

public class ModRecipeProvider extends FabricRecipeProvider {

    private static final List<class_1935> ALUMINIUM_BLASTABLES = List.of(ModItems.RAW_ALUMINIUM, ModBlocks.ALUMINIUM_ORE, ModBlocks.DEEPSLATE_ALUMINIUM_ORE, ModBlocks.RED_DEEPSLATE_ALUMINIUM_ORE);
    private static final List<class_1935> LEAD_BLASTABLES = List.of(ModItems.RAW_LEAD, ModBlocks.LEAD_ORE, ModBlocks.DEEPSLATE_LEAD_ORE, ModBlocks.RED_DEEPSLATE_LEAD_ORE);

    private static final List<class_1935> URANIUM_BLASTABLES = List.of(ModItems.URANIUM, ModBlocks.URANIUM_ORE, ModBlocks.DEEPSLATE_URANIUM_ORE, ModBlocks.RED_DEEPSLATE_URANIUM_ORE);

    private static final List<class_1935> ENDURIUM_BLASTABLES = List.of(ModItems.ENDURIUM_CRYSTAL, ModBlocks.END_ENDURIUM_ORE);
    private static final List<class_1935> PALLADIUM_BLASTABLES = List.of(ModItems.RAW_PALLADIUM, ModBlocks.PALLADIUM_ORE, ModBlocks.DEEPSLATE_PALLADIUM_ORE, ModBlocks.RED_DEEPSLATE_PALLADIUM_ORE);
    private static final List<class_1935> JURASSOLINE_BLASTABLES = List.of(ModItems.JURASSOLINE_CRYSTAL, ModBlocks.JURASSOLINE_ORE, ModBlocks.DEEPSLATE_JURASSOLINE_ORE, ModBlocks.RED_DEEPSLATE_JURASSOLINE_ORE);
    private static final List<class_1935> CINNABAR_BLASTABLES = List.of(ModItems.CINNABAR_CRYSTAL, ModBlocks.CINNABAR_ORE, ModBlocks.DEEPSLATE_CINNABAR_ORE, ModBlocks. RED_DEEPSLATE_CINNABAR_ORE);
    private static final List<class_1935> NEBULAR_BLASTABLES = List.of(ModItems.NEBULAR_CRYSTAL, ModBlocks.NEBULAR_ORE, ModBlocks.DEEPSLATE_NEBULAR_ORE, ModBlocks. RED_DEEPSLATE_NEBULAR_ORE);
    private static final List<class_1935> MITHRIL_BLASTABLES = List.of(ModItems.RAW_MITHRIL, ModBlocks.BEDROCK_MITHRIL_ORE);

    public ModRecipeProvider(FabricDataOutput output) {
        super(output);
    }

    public static void offerReversibleNuggetCompactingRecipes(Consumer<class_2444> exporter, class_7800 reverseCategory, class_1935 baseItem, class_7800 compactingCategory, class_1935 compactItem) {
        method_36447(exporter, reverseCategory, baseItem, compactingCategory, compactItem, method_36450(compactItem) + "_from_nugget", (String)null, method_36450(baseItem), (String)null);
    }

    @Override
    public void method_10419(Consumer<class_2444> exporter) {

        method_36233(exporter, List.of(ModBlocks.MEGAREGOLITH_IRON_ORE), class_7800.field_40642, class_1802.field_8620, 0.25f,200, "iron_ingot");

        class_2447.method_10436(class_7800.field_40642, ModItems.SULFUR_TORCH,4)
                .method_10439("#")
                .method_10439("I")
                .method_10433('#', class_6862.method_40092(class_7924.field_41197, new class_2960("c", "sulfur_dusts")))
                .method_10433('I', class_6862.method_40092(class_7924.field_41197, new class_2960("c", "wooden_rods")))
                .method_10429(method_32807(ModItems.SULFUR), method_10426(ModItems.SULFUR))
                .method_10429(method_32807(class_1802.field_8600), method_10426(class_1802.field_8600))
                .method_17972(exporter, new class_2960(method_36450(ModItems.SULFUR_TORCH)));

        class_2447.method_10437(class_7800.field_40642, ModBlocks.SULFUR_LANTERN)
                .method_10439("###")
                .method_10439("#I#")
                .method_10439("###")
                .method_10433('#', class_6862.method_40092(class_7924.field_41197, new class_2960("c", "iron_nuggets")))
                .method_10434('I', ModItems.SULFUR_TORCH)
                .method_10429(method_32807(class_1802.field_8675), method_10426(class_1802.field_8675))
                .method_10429(method_32807(ModItems.SULFUR_TORCH), method_10426(ModItems.SULFUR_TORCH))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.SULFUR_LANTERN)));

        class_2447.method_10437(class_7800.field_40642, ModBlocks.SULFUR_CAMPFIRE)
                .method_10439(" I ")
                .method_10439("ISI")
                .method_10439("###")
                .method_10433('I', class_6862.method_40092(class_7924.field_41197, new class_2960("c", "wooden_rods")))
                .method_10433('S', class_6862.method_40092(class_7924.field_41197, new class_2960("c", "sulfur_dusts")))
                .method_10433('#', class_3489.field_23212)
                .method_10429(method_32807(class_1802.field_8583), method_10426(class_1802.field_8583))
                .method_10429(method_32807(ModItems.SULFUR), method_10426(ModItems.SULFUR))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.SULFUR_CAMPFIRE)));

        class_2447.method_10437(class_7800.field_40642, ModBlocks.WHITE_PUMPKIN)
                .method_10439(" W ")
                .method_10439("W#W")
                .method_10439(" W ")
                .method_10434('#', class_1802.field_17518)
                .method_10434('W', class_1802.field_8446)
                .method_10429(method_32807(class_1802.field_17518), method_10426(class_1802.field_17518))
                .method_10429(method_32807(class_1802.field_8446), method_10426(class_1802.field_8446))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.WHITE_PUMPKIN)));

        class_2450.method_10448(class_7800.field_40642, class_1802.field_8706, 4)
                .method_10454(ModBlocks.WHITE_PUMPKIN)
                .method_10442(method_32807(ModBlocks.WHITE_PUMPKIN), method_10426(ModBlocks.WHITE_PUMPKIN))
                .method_17972(exporter, new class_2960(method_36450(class_1802.field_8706)));

        class_2447.method_10437(class_7800.field_40642, ModBlocks.WHITE_JACK_O_LANTERN)
                .method_10439("#")
                .method_10439("I")
                .method_10434('#', ModBlocks.CARVED_WHITE_PUMPKIN)
                .method_10434('I', ModItems.SULFUR_TORCH)
                .method_10429(method_32807(ModBlocks.CARVED_WHITE_PUMPKIN), method_10426(ModBlocks.CARVED_WHITE_PUMPKIN))
                .method_10429(method_32807(ModItems.SULFUR_TORCH), method_10426(ModItems.SULFUR_TORCH))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.WHITE_JACK_O_LANTERN)));

        method_24885(exporter, ModBlocks.CURSED_CARPET, ModBlocks.CURSED_WOOL);

        class_2447.method_10436(class_7800.field_40642, class_1802.field_8407,3)
                .method_10439("###")
                .method_10433('#', ModTags.Items.WOODEN_BARK)
                .method_10429(method_32807(class_1802.field_8407), method_10426(class_1802.field_8407))
                .method_17972(exporter, new class_2960(method_36450(class_1802.field_8407)));

        class_2450.method_10447(class_7800.field_40642, class_1802.field_8583)
                .method_10454(class_1802.field_8415)
                .method_10454(ModItems.OAK_BARK)
                .method_10442(method_32807(class_1802.field_8415), method_10426(class_1802.field_8415))
                .method_10442(method_32807(ModItems.OAK_BARK), method_10426(ModItems.OAK_BARK))
                .method_17972(exporter, new class_2960(method_36450(class_1802.field_8583)));

        class_2450.method_10447(class_7800.field_40642, class_1802.field_8888)
                .method_10454(class_1802.field_8248)
                .method_10454(ModItems.OAK_BARK)
                .method_10442(method_32807(class_1802.field_8248), method_10426(class_1802.field_8248))
                .method_10442(method_32807(ModItems.OAK_BARK), method_10426(ModItems.OAK_BARK))
                .method_17972(exporter, new class_2960(method_36450(class_1802.field_8888)));

        class_2450.method_10447(class_7800.field_40642, class_1802.field_8684)
                .method_10454(class_1802.field_8624)
                .method_10454(ModItems.SPRUCE_BARK)
                .method_10442(method_32807(class_1802.field_8624), method_10426(class_1802.field_8624))
                .method_10442(method_32807(ModItems.SPRUCE_BARK), method_10426(ModItems.SPRUCE_BARK))
                .method_17972(exporter, new class_2960(method_36450(class_1802.field_8684)));

        class_2450.method_10447(class_7800.field_40642, class_1802.field_8210)
                .method_10454(class_1802.field_8362)
                .method_10454(ModItems.SPRUCE_BARK)
                .method_10442(method_32807(class_1802.field_8362), method_10426(class_1802.field_8362))
                .method_10442(method_32807(ModItems.SPRUCE_BARK), method_10426(ModItems.SPRUCE_BARK))
                .method_17972(exporter, new class_2960(method_36450(class_1802.field_8210)));

        class_2450.method_10447(class_7800.field_40642, class_1802.field_8170)
                .method_10454(class_1802.field_8767)
                .method_10454(ModItems.BIRCH_BARK)
                .method_10442(method_32807(class_1802.field_8767), method_10426(class_1802.field_8767))
                .method_10442(method_32807(ModItems.BIRCH_BARK), method_10426(ModItems.BIRCH_BARK))
                .method_17972(exporter, new class_2960(method_36450(class_1802.field_8170)));

        class_2450.method_10447(class_7800.field_40642, class_1802.field_8201)
                .method_10454(class_1802.field_8472)
                .method_10454(ModItems.BIRCH_BARK)
                .method_10442(method_32807(class_1802.field_8472), method_10426(class_1802.field_8472))
                .method_10442(method_32807(ModItems.BIRCH_BARK), method_10426(ModItems.BIRCH_BARK))
                .method_17972(exporter, new class_2960(method_36450(class_1802.field_8201)));

        class_2450.method_10447(class_7800.field_40642, class_1802.field_8125)
                .method_10454(class_1802.field_8334)
                .method_10454(ModItems.JUNGLE_BARK)
                .method_10442(method_32807(class_1802.field_8334), method_10426(class_1802.field_8334))
                .method_10442(method_32807(ModItems.JUNGLE_BARK), method_10426(ModItems.JUNGLE_BARK))
                .method_17972(exporter, new class_2960(method_36450(class_1802.field_8125)));

        class_2450.method_10447(class_7800.field_40642, class_1802.field_8439)
                .method_10454(class_1802.field_8785)
                .method_10454(ModItems.JUNGLE_BARK)
                .method_10442(method_32807(class_1802.field_8785), method_10426(class_1802.field_8785))
                .method_10442(method_32807(ModItems.JUNGLE_BARK), method_10426(ModItems.JUNGLE_BARK))
                .method_17972(exporter, new class_2960(method_36450(class_1802.field_8439)));

        class_2450.method_10447(class_7800.field_40642, class_1802.field_8820)
                .method_10454(class_1802.field_8072)
                .method_10454(ModItems.ACACIA_BARK)
                .method_10442(method_32807(class_1802.field_8072), method_10426(class_1802.field_8072))
                .method_10442(method_32807(ModItems.ACACIA_BARK), method_10426(ModItems.ACACIA_BARK))
                .method_17972(exporter, new class_2960(method_36450(class_1802.field_8820)));

        class_2450.method_10447(class_7800.field_40642, class_1802.field_8587)
                .method_10454(class_1802.field_8284)
                .method_10454(ModItems.ACACIA_BARK)
                .method_10442(method_32807(class_1802.field_8284), method_10426(class_1802.field_8284))
                .method_10442(method_32807(ModItems.ACACIA_BARK), method_10426(ModItems.ACACIA_BARK))
                .method_17972(exporter, new class_2960(method_36450(class_1802.field_8587)));

        class_2450.method_10447(class_7800.field_40642, class_1802.field_8652)
                .method_10454(class_1802.field_8808)
                .method_10454(ModItems.DARK_OAK_BARK)
                .method_10442(method_32807(class_1802.field_8808), method_10426(class_1802.field_8808))
                .method_10442(method_32807(ModItems.DARK_OAK_BARK), method_10426(ModItems.DARK_OAK_BARK))
                .method_17972(exporter, new class_2960(method_36450(class_1802.field_8652)));

        class_2450.method_10447(class_7800.field_40642, class_1802.field_8458)
                .method_10454(class_1802.field_8219)
                .method_10454(ModItems.DARK_OAK_BARK)
                .method_10442(method_32807(class_1802.field_8219), method_10426(class_1802.field_8219))
                .method_10442(method_32807(ModItems.DARK_OAK_BARK), method_10426(ModItems.DARK_OAK_BARK))
                .method_17972(exporter, new class_2960(method_36450(class_1802.field_8458)));

        class_2450.method_10447(class_7800.field_40642, class_1802.field_37512)
                .method_10454(class_1802.field_37515)
                .method_10454(ModItems.MANGROVE_BARK)
                .method_10442(method_32807(class_1802.field_37515), method_10426(class_1802.field_37515))
                .method_10442(method_32807(ModItems.MANGROVE_BARK), method_10426(ModItems.MANGROVE_BARK))
                .method_17972(exporter, new class_2960(method_36450(class_1802.field_37512)));

        class_2450.method_10447(class_7800.field_40642, class_1802.field_37510)
                .method_10454(class_1802.field_37509)
                .method_10454(ModItems.MANGROVE_BARK)
                .method_10442(method_32807(class_1802.field_37509), method_10426(class_1802.field_37509))
                .method_10442(method_32807(ModItems.MANGROVE_BARK), method_10426(ModItems.MANGROVE_BARK))
                .method_17972(exporter, new class_2960(method_36450(class_1802.field_37510)));

        class_2450.method_10447(class_7800.field_40642, class_1802.field_42692)
                .method_10454(class_1802.field_42693)
                .method_10454(ModItems.CHERRY_BARK)
                .method_10442(method_32807(class_1802.field_42693), method_10426(class_1802.field_42693))
                .method_10442(method_32807(ModItems.CHERRY_BARK), method_10426(ModItems.CHERRY_BARK))
                .method_17972(exporter, new class_2960(method_36450(class_1802.field_42692)));

        class_2450.method_10447(class_7800.field_40642, class_1802.field_42691)
                .method_10454(class_1802.field_42690)
                .method_10454(ModItems.CHERRY_BARK)
                .method_10442(method_32807(class_1802.field_42690), method_10426(class_1802.field_42690))
                .method_10442(method_32807(ModItems.CHERRY_BARK), method_10426(ModItems.CHERRY_BARK))
                .method_17972(exporter, new class_2960(method_36450(class_1802.field_42691)));

        class_2450.method_10447(class_7800.field_40642, ModBlocks.GINKGO_LOG)
                .method_10454(ModBlocks.STRIPPED_GINKGO_LOG)
                .method_10454(ModItems.GINKGO_BARK)
                .method_10442(method_32807(ModBlocks.STRIPPED_GINKGO_LOG), method_10426(ModBlocks.STRIPPED_GINKGO_LOG))
                .method_10442(method_32807(ModItems.GINKGO_BARK), method_10426(ModItems.GINKGO_BARK))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.GINKGO_LOG)));

        class_2450.method_10447(class_7800.field_40642, ModBlocks.GINKGO_WOOD)
                .method_10454(ModBlocks.STRIPPED_GINKGO_WOOD)
                .method_10454(ModItems.GINKGO_BARK)
                .method_10442(method_32807(ModBlocks.STRIPPED_GINKGO_WOOD), method_10426(ModBlocks.STRIPPED_GINKGO_WOOD))
                .method_10442(method_32807(ModItems.GINKGO_BARK), method_10426(ModItems.GINKGO_BARK))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.GINKGO_WOOD)));

        class_2450.method_10447(class_7800.field_40642, ModBlocks.YELLOW_WALLPAPERED_WOOD)
                .method_10446(class_6862.method_40092(class_7924.field_41197, new class_2960("c", "stripped_woods")))
                .method_10454(ModItems.YELLOW_WALLPAPER)
                .method_10442(method_32807(class_1802.field_8248), method_10426(class_1802.field_8248))
                .method_10442(method_32807(ModItems.YELLOW_WALLPAPER), method_10426(ModItems.YELLOW_WALLPAPER))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.YELLOW_WALLPAPERED_WOOD)));

        class_2450.method_10447(class_7800.field_40642, ModItems.DRAGON_BANNER_PATTERN)
                .method_10454(class_1802.field_8407)
                .method_10454(class_1802.field_8712)
                .method_10442(method_32807(class_1802.field_8407), method_10426(class_1802.field_8407))
                .method_10442(method_32807(class_1802.field_8712), method_10426(class_1802.field_8712))
                .method_17972(exporter, new class_2960(method_36450(ModItems.DRAGON_BANNER_PATTERN)));

        class_2450.method_10447(class_7800.field_40642, ModItems.LOTR_BANNER_PATTERN)
                .method_10454(class_1802.field_8407)
                .method_10454(class_1802.field_8397)
                .method_10442(method_32807(class_1802.field_8407), method_10426(class_1802.field_8407))
                .method_10442(method_32807(class_1802.field_8397), method_10426(class_1802.field_8397))
                .method_17972(exporter, new class_2960(method_36450(ModItems.LOTR_BANNER_PATTERN)));

        class_2450.method_10447(class_7800.field_40642, ModBlocks.APPARATUS)
                .method_10454(ModItems.URANIUM)
                .method_10454(class_1802.field_8801)
                .method_10446(class_6862.method_40092(class_7924.field_41197, new class_2960("c", "steel_ingots")))
                .method_10442(method_32807(ModItems.URANIUM), method_10426(ModItems.URANIUM))
                .method_10442(method_32807(class_1802.field_8801), method_10426(class_1802.field_8801))
                .method_10442(method_32807(ModItems.STEEL_INGOT), method_10426(ModItems.STEEL_INGOT))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.APPARATUS)));

        class_2447.method_10437(class_7800.field_40642, ModBlocks.GARBAGE_CAN)
                .method_10439("# #")
                .method_10439("# #")
                .method_10439("###")
                .method_10434('#', class_1802.field_8076)
                .method_10429(method_32807(class_1802.field_8076), method_10426(class_1802.field_8076))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.GARBAGE_CAN)));

        class_2447.method_10437(class_7800.field_40642, ModBlocks.BENCH)
                .method_10439("I-I")
                .method_10439("---")
                .method_10439("I-I")
                .method_10433('I', class_6862.method_40092(class_7924.field_41197, new class_2960("c", "steel_rods")))
                .method_10433('-', class_3489.field_15534)
                .method_10429(method_32807(ModItems.STEEL_ROD), method_10426(ModItems.STEEL_ROD))
                .method_10429(method_32807(class_1802.field_8320), method_10426(class_1802.field_8320))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.BENCH)));

        class_2447.method_10437(class_7800.field_40642, ModItems.PIPE)
                .method_10439("#-")
                .method_10433('#', class_3489.field_15537)
                .method_10433('-', class_6862.method_40092(class_7924.field_41197, new class_2960("c", "wooden_rods")))
                .method_10429(method_32807(class_1802.field_8118), method_10426(class_1802.field_8118))
                .method_10429(method_32807(class_1802.field_8600), method_10426(class_1802.field_8600))
                .method_17972(exporter, new class_2960(method_36450(ModItems.PIPE)));

        class_2447.method_10436(class_7800.field_40642, ModItems.HEMP_COOKIE, 8)
                .method_10439("#C#")
                .method_10434('#', class_1802.field_8861)
                .method_10434('C', ModItems.PIPE_WEED)
                .method_10429(method_32807(class_1802.field_8861), method_10426(class_1802.field_8861))
                .method_10429(method_32807(ModItems.PIPE_WEED), method_10426(ModItems.PIPE_WEED))
                .method_17972(exporter, new class_2960(method_36450(ModItems.HEMP_COOKIE)));

        class_2447.method_10436(class_7800.field_40642, ModBlocks.PRESERVES_JAR, 3)
                .method_10439("# #")
                .method_10439("###")
                .method_10433('#', class_6862.method_40092(class_7924.field_41197, new class_2960("c", "colorless_glass")))
                .method_10429(method_32807(class_1802.field_8280), method_10426(class_1802.field_8280))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.PRESERVES_JAR)));

        class_2450.method_10448(class_7800.field_40642, ModItems.TOAST, 3)
                .method_10454(class_1802.field_8229)
                .method_10442(method_32807(class_1802.field_8229), method_10426(class_1802.field_8229))
                .method_17972(exporter, new class_2960(method_36450(ModItems.TOAST)));

        class_2450.method_10448(class_7800.field_40642, ModItems.SWEET_BERRY_JAM_TOAST, 3)
                .method_10452("toasts")
                .method_10454(ModBlocks.SWEET_BERRY_JAM_JAR)
                .method_10454(ModItems.TOAST)
                .method_10454(ModItems.TOAST)
                .method_10454(ModItems.TOAST)
                .method_10442(method_32807(ModBlocks.SWEET_BERRY_JAM_JAR), method_10426(ModBlocks.SWEET_BERRY_JAM_JAR))
                .method_10442(method_32807(ModItems.TOAST), method_10426(ModItems.TOAST))
                .method_17972(exporter, new class_2960(method_36450(ModItems.SWEET_BERRY_JAM_TOAST)));

        class_2450.method_10448(class_7800.field_40642, ModItems.GLOW_BERRY_JAM_TOAST, 3)
                .method_10452("toasts")
                .method_10454(ModBlocks.GLOW_BERRY_JAM_JAR)
                .method_10454(ModItems.TOAST)
                .method_10454(ModItems.TOAST)
                .method_10454(ModItems.TOAST)
                .method_10442(method_32807(ModBlocks.GLOW_BERRY_JAM_JAR), method_10426(ModBlocks.GLOW_BERRY_JAM_JAR))
                .method_10442(method_32807(ModItems.TOAST), method_10426(ModItems.TOAST))
                .method_17972(exporter, new class_2960(method_36450(ModItems.GLOW_BERRY_JAM_TOAST)));

        class_2450.method_10448(class_7800.field_40642, ModItems.STRAWBERRY_JAM_TOAST, 3)
                .method_10452("toasts")
                .method_10454(ModBlocks.STRAWBERRY_JAM_JAR)
                .method_10454(ModItems.TOAST)
                .method_10454(ModItems.TOAST)
                .method_10454(ModItems.TOAST)
                .method_10442(method_32807(ModBlocks.STRAWBERRY_JAM_JAR), method_10426(ModBlocks.STRAWBERRY_JAM_JAR))
                .method_10442(method_32807(ModItems.TOAST), method_10426(ModItems.TOAST))
                .method_17972(exporter, new class_2960(method_36450(ModItems.STRAWBERRY_JAM_TOAST)));

        class_2450.method_10448(class_7800.field_40642, ModItems.ORANGE_MARMELADE_TOAST, 3)
                .method_10452("toasts")
                .method_10454(ModBlocks.ORANGE_MARMELADE_JAR)
                .method_10454(ModItems.TOAST)
                .method_10454(ModItems.TOAST)
                .method_10454(ModItems.TOAST)
                .method_10442(method_32807(ModBlocks.ORANGE_MARMELADE_JAR), method_10426(ModBlocks.ORANGE_MARMELADE_JAR))
                .method_10442(method_32807(ModItems.TOAST), method_10426(ModItems.TOAST))
                .method_17972(exporter, new class_2960(method_36450(ModItems.ORANGE_MARMELADE_TOAST)));

        class_2450.method_10448(class_7800.field_40642, ModItems.BLUE_BERRY_JAM_TOAST, 3)
                .method_10452("toasts")
                .method_10454(ModBlocks.BLUE_BERRY_JAM_JAR)
                .method_10454(ModItems.TOAST)
                .method_10454(ModItems.TOAST)
                .method_10454(ModItems.TOAST)
                .method_10442(method_32807(ModBlocks.BLUE_BERRY_JAM_JAR), method_10426(ModBlocks.BLUE_BERRY_JAM_JAR))
                .method_10442(method_32807(ModItems.TOAST), method_10426(ModItems.TOAST))
                .method_17972(exporter, new class_2960(method_36450(ModItems.BLUE_BERRY_JAM_TOAST)));

        class_2450.method_10448(class_7800.field_40642, ModItems.DROOPFRUIT_JAM_TOAST, 3)
                .method_10452("toasts")
                .method_10454(ModBlocks.DROOPFRUIT_JAM_JAR)
                .method_10454(ModItems.TOAST)
                .method_10454(ModItems.TOAST)
                .method_10454(ModItems.TOAST)
                .method_10442(method_32807(ModBlocks.DROOPFRUIT_JAM_JAR), method_10426(ModBlocks.DROOPFRUIT_JAM_JAR))
                .method_10442(method_32807(ModItems.TOAST), method_10426(ModItems.TOAST))
                .method_17972(exporter, new class_2960(method_36450(ModItems.DROOPFRUIT_JAM_TOAST)));

        class_2450.method_10448(class_7800.field_40642, ModItems.ANCIENT_SOULBERRY_JAM_TOAST, 3)
                .method_10452("toasts")
                .method_10454(ModBlocks.ANCIENT_SOULBERRY_JAM_JAR)
                .method_10454(ModItems.TOAST)
                .method_10454(ModItems.TOAST)
                .method_10454(ModItems.TOAST)
                .method_10442(method_32807(ModBlocks.ANCIENT_SOULBERRY_JAM_JAR), method_10426(ModBlocks.ANCIENT_SOULBERRY_JAM_JAR))
                .method_10442(method_32807(ModItems.TOAST), method_10426(ModItems.TOAST))
                .method_17972(exporter, new class_2960(method_36450(ModItems.ANCIENT_SOULBERRY_JAM_TOAST)));

        class_2450.method_10447(class_7800.field_40642, ModItems.STRAWBERRY_SEEDS)
                .method_10454(ModItems.STRAWBERRY)
                .method_10442(method_32807(ModItems.STRAWBERRY), method_10426(ModItems.STRAWBERRY))
                .method_17972(exporter, new class_2960(method_36450(ModItems.STRAWBERRY_SEEDS)));

        class_2450.method_10447(class_7800.field_40642, ModItems.CHOCOLATE_STRAWBERRY)
                .method_10446(class_6862.method_40092(class_7924.field_41197, new class_2960("c", "strawberries")))
                .method_10454(class_1802.field_8116)
                .method_10442(method_32807(ModItems.STRAWBERRY), method_10426(ModItems.STRAWBERRY))
                .method_10442(method_32807(class_1802.field_8116), method_10426(class_1802.field_8116))
                .method_17972(exporter, new class_2960(method_36450(ModItems.CHOCOLATE_STRAWBERRY)));

        class_2447.method_10437(class_7800.field_40642, ModBlocks.STRAWBERRY_CAKE)
                .method_10439("BMB")
                .method_10439("SWE")
                .method_10433('B', class_6862.method_40092(class_7924.field_41197, new class_2960("c", "strawberries")))
                .method_10433('M', class_6862.method_40092(class_7924.field_41197, new class_2960("c", "milk")))
                .method_10434('S', class_1802.field_8479)
                .method_10434('W', class_1802.field_8861)
                .method_10434('E', class_1802.field_8803)
                .method_10429(method_32807(ModItems.STRAWBERRY), method_10426(ModItems.STRAWBERRY))
                .method_10429(method_32807(class_1802.field_8103), method_10426(class_1802.field_8103))
                .method_10429(method_32807(class_1802.field_8479), method_10426(class_1802.field_8479))
                .method_10429(method_32807(class_1802.field_8861), method_10426(class_1802.field_8861))
                .method_10429(method_32807(class_1802.field_8803), method_10426(class_1802.field_8803))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.STRAWBERRY_CAKE)));

        class_2450.method_10447(class_7800.field_40642, ModItems.ORANGE_SEEDS)
                .method_10454(ModItems.ORANGE)
                .method_10442(method_32807(ModItems.ORANGE), method_10426(ModItems.ORANGE))
                .method_17972(exporter, new class_2960(method_36450(ModItems.ORANGE_SEEDS)));

        class_2447.method_10437(class_7800.field_40642, ModBlocks.ORANGE_CAKE)
                .method_10439("OMO")
                .method_10439("SWE")
                .method_10433('O', class_6862.method_40092(class_7924.field_41197, new class_2960("c", "oranges")))
                .method_10433('M', class_6862.method_40092(class_7924.field_41197, new class_2960("c", "milk")))
                .method_10434('S', class_1802.field_8479)
                .method_10434('W', class_1802.field_8861)
                .method_10434('E', class_1802.field_8803)
                .method_10429(method_32807(ModItems.ORANGE), method_10426(ModItems.ORANGE))
                .method_10429(method_32807(class_1802.field_8103), method_10426(class_1802.field_8103))
                .method_10429(method_32807(class_1802.field_8479), method_10426(class_1802.field_8479))
                .method_10429(method_32807(class_1802.field_8861), method_10426(class_1802.field_8861))
                .method_10429(method_32807(class_1802.field_8803), method_10426(class_1802.field_8803))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.ORANGE_CAKE)));

        class_2450.method_10447(class_7800.field_40642, ModItems.PIPE_WEED_SEEDS)
                .method_10454(ModItems.PIPE_WEED)
                .method_10442(method_32807(ModItems.PIPE_WEED), method_10426(ModItems.PIPE_WEED))
                .method_17972(exporter, new class_2960(method_36450(ModItems.PIPE_WEED_SEEDS)));

        class_2450.method_10447(class_7800.field_40642, ModBlocks.BW_STICKER)
                .method_10454(class_1802.field_8407)
                .method_10454(class_1802.field_8777)
                .method_10454(class_1802.field_8397)
                .method_10442(method_32807(class_1802.field_8407), method_10426(class_1802.field_8407))
                .method_10442(method_32807(class_1802.field_8777), method_10426(class_1802.field_8777))
                .method_10442(method_32807(class_1802.field_8397), method_10426(class_1802.field_8397))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.BW_STICKER)));

        class_2450.method_10447(class_7800.field_40642, ModBlocks.TLOTD_STICKER)
                .method_10454(class_1802.field_8407)
                .method_10454(class_1802.field_8777)
                .method_10454(ModItems.MITHRIL_NUGGET)
                .method_10442(method_32807(class_1802.field_8407), method_10426(class_1802.field_8407))
                .method_10442(method_32807(class_1802.field_8777), method_10426(class_1802.field_8777))
                .method_10442(method_32807(ModItems.MITHRIL_NUGGET), method_10426(ModItems.MITHRIL_NUGGET))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.TLOTD_STICKER)));

        class_2447.method_10436(class_7800.field_40642, ModBlocks.FESTIVE_LIGHTS, 8)
                .method_10439("WWW")
                .method_10439("#R#")
                .method_10439("###")
                .method_10433('W', ModTags.Items.WIRES)
                .method_10434('R', class_1802.field_8230)
                .method_10433('#', class_6862.method_40092(class_7924.field_41197, new class_2960("c", "glass_blocks")))
                .method_10429(method_32807(ModItems.COPPER_WIRE), method_10426(ModItems.COPPER_WIRE))
                .method_10429(method_32807(class_1802.field_8230), method_10426(class_1802.field_8230))
                .method_10429(method_32807(class_1802.field_8280), method_10426(class_1802.field_8280))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.FESTIVE_LIGHTS)));

        class_2447.method_10437(class_7800.field_40642, ModBlocks.PRESENT)
                .method_10439("PYP")
                .method_10439("RER")
                .method_10439("PYP")
                .method_10434('P', class_1802.field_8407)
                .method_10434('Y', class_1802.field_8192)
                .method_10434('R', class_1802.field_8264)
                .method_10434('E', class_1802.field_38746)
                .method_10429(method_32807(class_1802.field_8407), method_10426(class_1802.field_8407))
                .method_10429(method_32807(class_1802.field_8192), method_10426(class_1802.field_8192))
                .method_10429(method_32807(class_1802.field_8264), method_10426(class_1802.field_8264))
                .method_10429(method_32807(class_1802.field_38746), method_10426(class_1802.field_38746))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.PRESENT)));

        method_33717(exporter, class_7800.field_40634, ModBlocks.GRAVESTONE, class_2246.field_10445);
        method_33717(exporter, class_7800.field_40634, ModBlocks.MOSSY_GRAVESTONE, class_2246.field_9989);
        method_33717(exporter, class_7800.field_40634, ModBlocks.GRAVESTONE_CROSS, class_2246.field_10445);
        method_33717(exporter, class_7800.field_40634, ModBlocks.MOSSY_GRAVESTONE_CROSS, class_2246.field_9989);

        method_33717(exporter, class_7800.field_40634, ModBlocks.SMALL_GRAVESTONE, class_2246.field_10445);

        class_2450.method_10447(class_7800.field_40642, ModBlocks.SKELETON)
                .method_10454(class_1802.field_8606).method_10454(class_1802.field_8398).method_10454(class_1802.field_8606)
                .method_10454(class_1802.field_8606).method_10454(class_1802.field_8606).method_10454(class_1802.field_8606)
                .method_10454(class_1802.field_8606).method_10454(class_1802.field_8606).method_10454(class_1802.field_8606)
                .method_10442(method_32807(class_1802.field_8606), method_10426(class_1802.field_8606))
                .method_10442(method_32807(class_1802.field_8398), method_10426(class_1802.field_8398))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.SKELETON)));

        class_2450.method_10447(class_7800.field_40642, ModBlocks.SKELETON)
                .method_10454(ModBlocks.EMERGING_SKELETON)
                .method_10442(method_32807(ModBlocks.EMERGING_SKELETON), method_10426(ModBlocks.EMERGING_SKELETON))
                .method_17972(exporter, new class_2960("skeleton_from_emerging_skeleton"));

        class_2450.method_10447(class_7800.field_40642, ModBlocks.EMERGING_SKELETON)
                .method_10454(ModBlocks.SKELETON)
                .method_10442(method_32807(ModBlocks.SKELETON), method_10426(ModBlocks.SKELETON))
                .method_17972(exporter, new class_2960("skeleton_to_emerging_skeleton"));

        class_2447.method_10437(class_7800.field_40642, ModBlocks.EFFIGIES)
                .method_10439("SSS")
                .method_10439("III")
                .method_10439("III")
                .method_10434('S', class_1802.field_8276)
                .method_10433('I', ModTags.Items.STICK_EFFIGIES)
                .method_10429(method_32807(class_1802.field_8276), method_10426(class_1802.field_8276))
                .method_10429(method_32807(class_1802.field_8600), method_10426(class_1802.field_8600))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.EFFIGIES)));

        class_2447.method_10437(class_7800.field_40642, ModBlocks.STICK_CROSS)
                .method_10439(" I ")
                .method_10439("III")
                .method_10439(" I ")
                .method_10433('I', class_6862.method_40092(class_7924.field_41197, new class_2960("c", "wooden_rods")))
                .method_10429(method_32807(class_1802.field_8600), method_10426(class_1802.field_8600))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.STICK_CROSS)));

        class_2447.method_10437(class_7800.field_40642, ModItems.STICK_EFFIGY)
                .method_10439("III")
                .method_10439("III")
                .method_10439("I I")
                .method_10433('I', class_6862.method_40092(class_7924.field_41197, new class_2960("c", "wooden_rods")))
                .method_10429(method_32807(class_1802.field_8600), method_10426(class_1802.field_8600))
                .method_17972(exporter, new class_2960(method_36450(ModItems.STICK_EFFIGY)));

        class_2447.method_10437(class_7800.field_40642, ModItems.STICK_FIGURE)
                .method_10439("III")
                .method_10439(" I ")
                .method_10439("I I")
                .method_10433('I', class_6862.method_40092(class_7924.field_41197, new class_2960("c", "wooden_rods")))
                .method_10429(method_32807(class_1802.field_8600), method_10426(class_1802.field_8600))
                .method_17972(exporter, new class_2960(method_36450(ModItems.STICK_FIGURE)));

        class_2447.method_10437(class_7800.field_40642, ModItems.PLANCHETTE)
                .method_10439(" ##")
                .method_10439("#G#")
                .method_10439(" # ")
                .method_10433('#', class_3489.field_15537)
                .method_10433('G', class_6862.method_40092(class_7924.field_41197, new class_2960("c", "glass_panes")))
                .method_10429(method_32807(class_1802.field_8118), method_10426(class_1802.field_8118))
                .method_10429(method_32807(class_1802.field_8141), method_10426(class_1802.field_8141))
                .method_17972(exporter, new class_2960(method_36450(ModItems.PLANCHETTE)));

        class_2447.method_10437(class_7800.field_40642, ModItems.FLASH_DRIVE)
                .method_10439(" CB")
                .method_10439("WB ")
                .method_10439("I  ")
                .method_10433('I', class_6862.method_40092(class_7924.field_41197, new class_2960("c", "iron_ingots")))
                .method_10433('W', ModTags.Items.WIRES)
                .method_10434('C', ModItems.INTEGRATED_CIRCUIT)
                .method_10433('B', ModTags.Items.CIRCUIT_BOARDS)
                .method_10429(method_32807(class_1802.field_8620), method_10426(class_1802.field_8620))
                .method_10429(method_32807(ModItems.COPPER_WIRE), method_10426(ModItems.COPPER_WIRE))
                .method_10429(method_32807(ModItems.INTEGRATED_CIRCUIT), method_10426(ModItems.INTEGRATED_CIRCUIT))
                .method_10429(method_32807(ModItems.CIRCUIT_BOARD), method_10426(ModItems.CIRCUIT_BOARD))
                .method_17972(exporter, new class_2960(method_36450(ModItems.FLASH_DRIVE)));

        class_2447.method_10437(class_7800.field_40634, ModBlocks.CREEPER_PLUSHIE)
                .method_10439("I")
                .method_10439("#")
                .method_10434('I', class_1802.field_8054)
                .method_10433('#', class_3489.field_15544)
                .method_10429(method_32807(class_1802.field_8054), method_10426(class_1802.field_8054))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.CREEPER_PLUSHIE)));

        class_2447.method_10437(class_7800.field_40634, ModBlocks.ZOMBIE_PLUSHIE)
                .method_10439("I")
                .method_10439("#")
                .method_10434('I', class_1802.field_8511)
                .method_10433('#', class_3489.field_15544)
                .method_10429(method_32807(class_1802.field_8511), method_10426(class_1802.field_8511))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.ZOMBIE_PLUSHIE)));

        class_2447.method_10437(class_7800.field_40634, ModBlocks.PLAYER_PLUSHIE)
                .method_10439("I")
                .method_10439("#")
                .method_10434('I', class_1802.field_8465)
                .method_10433('#', class_3489.field_15544)
                .method_10429(method_32807(class_1802.field_8465), method_10426(class_1802.field_8465))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.PLAYER_PLUSHIE)));

        class_2447.method_10437(class_7800.field_40642, ModItems.COPPER_SICKLE)
                .method_10439(" #")
                .method_10439("I ")
                .method_10433('#', class_6862.method_40092(class_7924.field_41197, new class_2960("c", "copper_ingots")))
                .method_10433('I', class_6862.method_40092(class_7924.field_41197, new class_2960("c", "wooden_rods")))
                .method_10429(method_32807(class_1802.field_27022), method_10426(class_1802.field_27022))
                .method_10429(method_32807(class_1802.field_8600), method_10426(class_1802.field_8600))
                .method_17972(exporter, new class_2960(method_36450(ModItems.COPPER_SICKLE)));

        class_2447.method_10437(class_7800.field_40642, ModItems.GOLDEN_SICKLE)
                .method_10439(" #")
                .method_10439("I ")
                .method_10433('#', class_6862.method_40092(class_7924.field_41197, new class_2960("c", "gold_ingots")))
                .method_10433('I', class_6862.method_40092(class_7924.field_41197, new class_2960("c", "wooden_rods")))
                .method_10429(method_32807(class_1802.field_8695), method_10426(class_1802.field_8695))
                .method_10429(method_32807(class_1802.field_8600), method_10426(class_1802.field_8600))
                .method_17972(exporter, new class_2960(method_36450(ModItems.GOLDEN_SICKLE)));

        class_2447.method_10437(class_7800.field_40642, ModItems.NETHERITE_SICKLE)
                .method_10439(" #")
                .method_10439("I ")
                .method_10434('#', class_1802.field_22020)
                .method_10433('I', class_6862.method_40092(class_7924.field_41197, new class_2960("c", "wooden_rods")))
                .method_10429(method_32807(class_1802.field_22020), method_10426(class_1802.field_22020))
                .method_10429(method_32807(class_1802.field_8600), method_10426(class_1802.field_8600))
                .method_17972(exporter, new class_2960(method_36450(ModItems.NETHERITE_SICKLE)));

        class_2447.method_10437(class_7800.field_40642, ModItems.NETHERITE_FORGING_HAMMER)
                .method_10439("#")
                .method_10439("I")
                .method_10434('#', class_1802.field_22020)
                .method_10433('I', class_6862.method_40092(class_7924.field_41197, new class_2960("c", "wooden_rods")))
                .method_10429(method_32807(class_1802.field_22020), method_10426(class_1802.field_22020))
                .method_10429(method_32807(class_1802.field_8600), method_10426(class_1802.field_8600))
                .method_17972(exporter, new class_2960(method_36450(ModItems.NETHERITE_FORGING_HAMMER)));

        method_36448(exporter, "campfire", class_1865.field_17347, 600, ModItems.CURED_MEAT, ModItems.COOKED_MEAT, 0.5f);
        method_36448(exporter, "smoker", class_1865.field_17085, 100, ModItems.CURED_MEAT, ModItems.COOKED_MEAT, 0.5f);
        method_36448(exporter, "furnace", class_1865.field_9042, 200, ModItems.CURED_MEAT, ModItems.COOKED_MEAT, 0.5f);

        method_36448(exporter, "campfire", class_1865.field_17347, 600, ModItems.DINOSAUR_MEAT, ModItems.COOKED_DINOSAUR_MEAT, 0.5f);
        method_36448(exporter, "smoker", class_1865.field_17085, 100, ModItems.DINOSAUR_MEAT, ModItems.COOKED_DINOSAUR_MEAT, 0.5f);
        method_36448(exporter, "furnace", class_1865.field_9042, 200, ModItems.DINOSAUR_MEAT, ModItems.COOKED_DINOSAUR_MEAT, 0.5f);

        class_2450.method_10448(class_7800.field_40642, class_1802.field_8745, 4)
                .method_10454(ModItems.DINOSAUR_HIDE)
                .method_10442(method_32807(ModItems.DINOSAUR_HIDE), method_10426(ModItems.DINOSAUR_HIDE))
                .method_17972(exporter, new class_2960(method_36450(ModItems.DINOSAUR_HIDE)));

        class_2450.method_10448(class_7800.field_40642, ModItems.FLOUR,3)
                .method_10454(class_1802.field_8861)
                .method_10442(method_32807(class_1802.field_8861), method_10426(class_1802.field_8861))
                .method_17972(exporter, new class_2960(method_36450(ModItems.FLOUR)));

        class_2450.method_10448(class_7800.field_40642, ModItems.BREADCRUMBS,3)
                .method_10454(ModItems.TOAST)
                .method_10442(method_32807(ModItems.TOAST), method_10426(ModItems.TOAST))
                .method_17972(exporter, new class_2960(method_36450(ModItems.BREADCRUMBS)));

        class_2450.method_10448(class_7800.field_40642, ModItems.RAW_SCHNITZEL,1)
                .method_10446(ModTags.Items.RAW_MEAT)
                .method_10454(ModItems.BREADCRUMBS)
                .method_10446(class_6862.method_40092(class_7924.field_41197, new class_2960("c", "flour")))
                .method_10446(class_6862.method_40092(class_7924.field_41197, new class_2960("c", "eggs")))
                .method_10442(method_32807(ModItems.BREADCRUMBS), method_10426(ModItems.BREADCRUMBS))
                .method_10442(method_32807(ModItems.FLOUR), method_10426(ModItems.FLOUR))
                .method_10442(method_32807(class_1802.field_8803), method_10426(class_1802.field_8803))
                .method_17972(exporter, new class_2960(method_36450(ModItems.RAW_SCHNITZEL)));

        method_36448(exporter, "campfire", class_1865.field_17347, 600, ModItems.RAW_SCHNITZEL, ModItems.SCHNITZEL, 0.5f);
        method_36448(exporter, "smoker", class_1865.field_17085, 100, ModItems.RAW_SCHNITZEL, ModItems.SCHNITZEL, 0.5f);
        method_36448(exporter, "furnace", class_1865.field_9042, 200, ModItems.RAW_SCHNITZEL, ModItems.SCHNITZEL, 0.5f);

        class_2450.method_10448(class_7800.field_40642, ModItems.CALAMARI,3)
                .method_10454(ModItems.SQUID)
                .method_10446(class_6862.method_40092(class_7924.field_41197, new class_2960("c", "flour")))
                .method_10446(class_6862.method_40092(class_7924.field_41197, new class_2960("c", "eggs")))
                .method_10442(method_32807(ModItems.SQUID), method_10426(ModItems.SQUID))
                .method_10442(method_32807(ModItems.FLOUR), method_10426(ModItems.FLOUR))
                .method_10442(method_32807(class_1802.field_8803), method_10426(class_1802.field_8803))
                .method_17972(exporter, new class_2960(method_36450(ModItems.CALAMARI)));

        method_36448(exporter, "campfire", class_1865.field_17347, 600, ModItems.CALAMARI, ModItems.FRIED_CALAMARI, 0.5f);
        method_36448(exporter, "smoker", class_1865.field_17085, 100, ModItems.CALAMARI, ModItems.FRIED_CALAMARI, 0.5f);
        method_36448(exporter, "furnace", class_1865.field_9042, 200, ModItems.CALAMARI, ModItems.FRIED_CALAMARI, 0.5f);

        class_2450.method_10448(class_7800.field_40642, ModItems.MAULTASCHE,2)
                .method_10446(ModTags.Items.RAW_MEAT)
                .method_10454(class_1802.field_8861)
                .method_10442(method_32807(class_1802.field_8861), method_10426(class_1802.field_8861))
                .method_17972(exporter, new class_2960(method_36450(ModItems.MAULTASCHE)));

        class_2447.method_10437(class_7800.field_40642, ModItems.TINTED_GLASS_FLASK)
                .method_10439("# #")
                .method_10439(" # ")
                .method_10434('#', class_1802.field_27019)
                .method_10429(method_32807(class_1802.field_27019), method_10426(class_1802.field_27019))
                .method_17972(exporter, new class_2960(method_36450(ModItems.TINTED_GLASS_FLASK)));

        class_2450.method_10447(class_7800.field_40642, ModItems.SOUL_FLASK)
                .method_10454(ModItems.TINTED_GLASS_FLASK)
                .method_10446(class_3489.field_23801)
                .method_10442(method_32807(ModItems.TINTED_GLASS_FLASK), method_10426(ModItems.TINTED_GLASS_FLASK))
                .method_10442(method_32807(class_1802.field_8067), method_10426(class_1802.field_8067))
                .method_17972(exporter, new class_2960(method_36450(ModItems.SOUL_FLASK)));

        class_2447.method_10437(class_7800.field_40642, ModBlocks.WITCHING_TABLE)
                .method_10439("C#C")
                .method_10439("GGG")
                .method_10439("###")
                .method_10433('C', ModTags.Items.CINNABAR_OR_NEBULAR)
                .method_10434('G', class_1802.field_8469)
                .method_10434('#', ModBlocks.FANCY_CHARRED_PLANKS)
                .method_10429(method_32807(ModItems.CINNABAR_CRYSTAL), method_10426(ModItems.CINNABAR_CRYSTAL))
                .method_10429(method_32807(class_1802.field_8469), method_10426(class_1802.field_8469))
                .method_10429(method_32807(ModBlocks.FANCY_CHARRED_PLANKS), method_10426(ModBlocks.FANCY_CHARRED_PLANKS))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.WITCHING_TABLE)));

        class_2447.method_10437(class_7800.field_40642, ModItems.CATHODE_RAY_TUBE)
                .method_10439("IGI")
                .method_10439("GCR")
                .method_10439("IGI")
                .method_10433('I', class_6862.method_40092(class_7924.field_41197, new class_2960("c", "iron_ingots")))
                .method_10433('G', class_6862.method_40092(class_7924.field_41197, new class_2960("c", "colorless_glass_panes")))
                .method_10433('C', class_6862.method_40092(class_7924.field_41197, new class_2960("c", "copper_ingots")))
                .method_10434('R', class_1802.field_8230)
                .method_10429(method_32807(class_1802.field_8620), method_10426(class_1802.field_8620))
                .method_10429(method_32807(class_1802.field_8141), method_10426(class_1802.field_8141))
                .method_10429(method_32807(class_1802.field_27022), method_10426(class_1802.field_27022))
                .method_10429(method_32807(class_1802.field_8230), method_10426(class_1802.field_8230))
                .method_17972(exporter, new class_2960(method_36450(ModItems.CATHODE_RAY_TUBE)));

        class_2447.method_10437(class_7800.field_40642, ModItems.LIQUID_CRYSTAL_DISPLAY_PANEL)
                .method_10439("GGG")
                .method_10439("GAR")
                .method_10439("CCC")
                .method_10433('G', class_6862.method_40092(class_7924.field_41197, new class_2960("c", "colorless_glass_panes")))
                .method_10434('A', class_1802.field_27063)
                .method_10434('R', class_1802.field_8230)
                .method_10433('C', ModTags.Items.CIRCUIT_BOARDS)
                .method_10429(method_32807(class_1802.field_8141), method_10426(class_1802.field_8141))
                .method_10429(method_32807(class_1802.field_27063), method_10426(class_1802.field_27063))
                .method_10429(method_32807(class_1802.field_8230), method_10426(class_1802.field_8230))
                .method_10429(method_32807(ModItems.CIRCUIT_BOARD), method_10426(ModItems.CIRCUIT_BOARD))
                .method_17972(exporter, new class_2960(method_36450(ModItems.LIQUID_CRYSTAL_DISPLAY_PANEL)));

        class_2450.method_10447(class_7800.field_40642, ModItems.VHS_CASSETTE)
                .method_10446(ModTags.Items.VHS_CASSETTES)
                .method_10442(method_32807(ModItems.VHS_CASSETTE), method_10426(ModItems.VHS_CASSETTE))
                .method_17972(exporter, new class_2960(method_36450(ModItems.VHS_CASSETTE)));

        class_2447.method_10437(class_7800.field_40634, ModBlocks.INTERDIMENSIONAL_RECEIVER)
                .method_10439("W W")
                .method_10439("IRI")
                .method_10439("TXT")
                .method_10433('W', ModTags.Items.WIRES_3)
                .method_10433('I', class_6862.method_40092(class_7924.field_41197, new class_2960("c", "iron_ingots")))
                .method_10433('T', ModTags.Items.TRANSCENDENT_CIRCUIT_BOARDS)
                .method_10434('X', ModItems.XEN_CRYSTAL)
                .method_10434('R', class_1802.field_8230)
                .method_10429(method_32807(ModItems.MITHRIL_WIRE), method_10426(ModItems.MITHRIL_WIRE))
                .method_10429(method_32807(class_1802.field_8620), method_10426(class_1802.field_8620))
                .method_10429(method_32807(ModItems.TRANSCENDENT_CIRCUIT_BOARD), method_10426(ModItems.TRANSCENDENT_CIRCUIT_BOARD))
                .method_10429(method_32807(ModItems.XEN_CRYSTAL), method_10426(ModItems.XEN_CRYSTAL))
                .method_10429(method_32807(class_1802.field_8230), method_10426(class_1802.field_8230))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.INTERDIMENSIONAL_RECEIVER)));

        class_2447.method_10437(class_7800.field_40634, ModItems.HOLOGRAPHIC_PROJECTOR)
                .method_10439(" B ")
                .method_10439("SFS")
                .method_10434('B', class_1802.field_8668)
                .method_10434('S', ModItems.SUPERCONDUCTING_WIRE)
                .method_10434('F', ModItems.FUTURISTIC_CIRCUIT_BOARD)
                .method_10429(method_32807(class_1802.field_8668), method_10426(class_1802.field_8668))
                .method_10429(method_32807(ModItems.SUPERCONDUCTING_WIRE), method_10426(ModItems.SUPERCONDUCTING_WIRE))
                .method_10429(method_32807(ModItems.FUTURISTIC_CIRCUIT_BOARD), method_10426(ModItems.FUTURISTIC_CIRCUIT_BOARD))
                .method_17972(exporter, new class_2960(method_36450(ModItems.HOLOGRAPHIC_PROJECTOR)));

        class_2447.method_10437(class_7800.field_40634, ModBlocks.TELEPORTER)
                .method_10439("HHH")
                .method_10439("AXA")
                .method_10439("SFS")
                .method_10434('H', ModItems.HOLOGRAPHIC_PROJECTOR)
                .method_10434('A', ModItems.ALIEN_METAL)
                .method_10434('X', ModItems.XEN_CRYSTAL)
                .method_10434('S', ModItems.SUPERCONDUCTING_WIRE)
                .method_10434('F', ModItems.FUTURISTIC_CIRCUIT_BOARD)
                .method_10429(method_32807(ModItems.HOLOGRAPHIC_PROJECTOR), method_10426(ModItems.HOLOGRAPHIC_PROJECTOR))
                .method_10429(method_32807(ModItems.ALIEN_METAL), method_10426(ModItems.ALIEN_METAL))
                .method_10429(method_32807(ModItems.XEN_CRYSTAL), method_10426(ModItems.XEN_CRYSTAL))
                .method_10429(method_32807(ModItems.SUPERCONDUCTING_WIRE), method_10426(ModItems.SUPERCONDUCTING_WIRE))
                .method_10429(method_32807(ModItems.FUTURISTIC_CIRCUIT_BOARD), method_10426(ModItems.FUTURISTIC_CIRCUIT_BOARD))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.TELEPORTER)));

        class_2447.method_10437(class_7800.field_40634, ModBlocks.SIGNAL_TRANSMITTER_ANTENNA)
                .method_10439(" C ")
                .method_10439("CWC")
                .method_10439("CWC")
                .method_10433('C', class_6862.method_40092(class_7924.field_41197, new class_2960("c", "copper_ingots")))
                .method_10433('W', ModTags.Items.WIRES)
                .method_10429(method_32807(class_1802.field_27022), method_10426(class_1802.field_27022))
                .method_10429(method_32807(ModItems.COPPER_WIRE), method_10426(ModItems.COPPER_WIRE))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.SIGNAL_TRANSMITTER_ANTENNA)));

        class_2450.method_10448(class_7800.field_40642, ModItems.SUPERCONDUCTING_WIRE, 3)
                .method_10454(ModItems.FRAGMENTED_FUTURISTIC_CIRCUIT_BOARD)
                .method_10442(method_32807(ModItems.FRAGMENTED_FUTURISTIC_CIRCUIT_BOARD), method_10426(ModItems.FRAGMENTED_FUTURISTIC_CIRCUIT_BOARD))
                .method_17972(exporter, new class_2960(method_36450(ModItems.SUPERCONDUCTING_WIRE)));

        class_2447.method_10437(class_7800.field_40634, ModBlocks.HEV_CHARGER)
                .method_10439("SXS")
                .method_10439("AAD")
                .method_10439("SXS")
                .method_10434('X', ModItems.XEN_CRYSTAL)
                .method_10434('D', ModItems.LIQUID_CRYSTAL_DISPLAY_PANEL)
                .method_10433('A', ModTags.Items.ADVANCED_CIRCUIT_BOARDS)
                .method_10433('S', class_6862.method_40092(class_7924.field_41197, new class_2960("c", "steel_ingots")))
                .method_10429(method_32807(ModItems.XEN_CRYSTAL), method_10426(ModItems.XEN_CRYSTAL))
                .method_10429(method_32807(ModItems.LIQUID_CRYSTAL_DISPLAY_PANEL), method_10426(ModItems.LIQUID_CRYSTAL_DISPLAY_PANEL))
                .method_10429(method_32807(ModItems.ADVANCED_CIRCUIT_BOARD), method_10426(ModItems.ADVANCED_CIRCUIT_BOARD))
                .method_10429(method_32807(ModItems.STEEL_INGOT), method_10426(ModItems.STEEL_INGOT))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.HEV_CHARGER)));

        class_2447.method_10437(class_7800.field_40634, ModBlocks.INCUBATOR)
                .method_10439("IRI")
                .method_10439("IHI")
                .method_10439("SSS")
                .method_10434('R', class_1802.field_8230)
                .method_10434('H', class_1802.field_17528)
                .method_10433('I', class_6862.method_40092(class_7924.field_41197, new class_2960("c", "steel_rods")))
                .method_10433('S', class_6862.method_40092(class_7924.field_41197, new class_2960("c", "steel_ingots")))
                .method_10429(method_32807(class_1802.field_8230), method_10426(class_1802.field_8230))
                .method_10429(method_32807(class_1802.field_17528), method_10426(class_1802.field_17528))
                .method_10429(method_32807(ModItems.STEEL_ROD), method_10426(ModItems.STEEL_ROD))
                .method_10429(method_32807(ModItems.STEEL_INGOT), method_10426(ModItems.STEEL_INGOT))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.INCUBATOR)));

        method_36234(exporter, List.of(ModItems.SUPERCONDUCTING_WIRE), class_7800.field_40642, ModItems.ALIEN_METAL, 0.7f, 400, "alien_metal");

        class_2447.method_10437(class_7800.field_40634, ModBlocks.MINING_ELEVATOR_CONTROLLER)
                .method_10435("elevator_controller")
                .method_10439("###")
                .method_10439("I I")
                .method_10439("IBC")
                .method_10433('#', class_6862.method_40092(class_7924.field_41197, new class_2960("c", "steel_ingots")))
                .method_10434('I', class_1802.field_8076)
                .method_10433('B', class_3489.field_15551)
                .method_10433('C', ModTags.Items.CIRCUIT_BOARDS)
                .method_10429(method_32807(ModItems.STEEL_INGOT), method_10426(ModItems.STEEL_INGOT))
                .method_10429(method_32807(class_1802.field_8076), method_10426(class_1802.field_8076))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.MINING_ELEVATOR_CONTROLLER)));

        class_2447.method_10437(class_7800.field_40634, ModBlocks.MINING_ELEVATOR_BASE)
                .method_10435("elevator_base")
                .method_10439("I I")
                .method_10439("IEI")
                .method_10439("###")
                .method_10434('I', class_1802.field_8076)
                .method_10433('#', class_3489.field_15537)
                .method_10434('E', class_1802.field_8634)
                .method_10429(method_32807(class_1802.field_8076), method_10426(class_1802.field_8076))
                .method_10429(method_32807(class_1802.field_8634), method_10426(class_1802.field_8634))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.MINING_ELEVATOR_BASE)));

        class_2447.method_10437(class_7800.field_40634, ModBlocks.WOODEN_ELEVATOR_CONTROLLER)
                .method_10435("elevator_controller")
                .method_10439("###")
                .method_10439("#P#")
                .method_10439("#BC")
                .method_10433('#', class_3489.field_15537)
                .method_10434('P', class_1802.field_8892)
                .method_10433('B', class_3489.field_15551)
                .method_10433('C', ModTags.Items.CIRCUIT_BOARDS)
                .method_10429(method_32807(class_1802.field_8892), method_10426(class_1802.field_8892))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.WOODEN_ELEVATOR_CONTROLLER)));

        class_2447.method_10437(class_7800.field_40634, ModBlocks.WOODEN_ELEVATOR_BASE)
                .method_10435("elevator_base")
                .method_10439("# #")
                .method_10439("#E#")
                .method_10439("###")
                .method_10433('#', class_3489.field_15537)
                .method_10434('E', class_1802.field_8634)
                .method_10429(method_32807(class_1802.field_8634), method_10426(class_1802.field_8634))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.WOODEN_ELEVATOR_BASE)));

        class_2447.method_10437(class_7800.field_40634, ModBlocks.QUARTZ_ELEVATOR_CONTROLLER)
                .method_10435("elevator_controller")
                .method_10439("###")
                .method_10439("QPQ")
                .method_10439("QBC")
                .method_10433('#', class_3489.field_15537)
                .method_10433('Q', class_6862.method_40092(class_7924.field_41197, new class_2960("c", "quartz_blocks")))
                .method_10434('P', class_1802.field_8892)
                .method_10433('B', class_3489.field_15551)
                .method_10433('C', ModTags.Items.CIRCUIT_BOARDS)
                .method_10429(method_32807(class_1802.field_20386), method_10426(class_1802.field_20386))
                .method_10429(method_32807(class_1802.field_8892), method_10426(class_1802.field_8892))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.QUARTZ_ELEVATOR_CONTROLLER)));

        class_2447.method_10437(class_7800.field_40634, ModBlocks.QUARTZ_ELEVATOR_BASE)
                .method_10435("elevator_base")
                .method_10439("Q Q")
                .method_10439("QEQ")
                .method_10439("###")
                .method_10433('Q', class_6862.method_40092(class_7924.field_41197, new class_2960("c", "quartz_blocks")))
                .method_10433('#', class_3489.field_15537)
                .method_10434('E', class_1802.field_8634)
                .method_10429(method_32807(class_1802.field_20386), method_10426(class_1802.field_20386))
                .method_10429(method_32807(class_1802.field_8634), method_10426(class_1802.field_8634))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.QUARTZ_ELEVATOR_BASE)));

        class_2447.method_10437(class_7800.field_40634, ModBlocks.GLASS_ELEVATOR_CONTROLLER)
                .method_10435("elevator_controller")
                .method_10439("###")
                .method_10439("G G")
                .method_10439("GBC")
                .method_10433('#', class_3489.field_15537)
                .method_10433('G', class_6862.method_40092(class_7924.field_41197, new class_2960("c", "colorless_glass")))
                .method_10433('B', class_3489.field_15551)
                .method_10433('C', ModTags.Items.CIRCUIT_BOARDS)
                .method_10429(method_32807(class_1802.field_8280), method_10426(class_1802.field_8280))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.GLASS_ELEVATOR_CONTROLLER)));

        class_2447.method_10437(class_7800.field_40634, ModBlocks.GLASS_ELEVATOR_BASE)
                .method_10435("elevator_base")
                .method_10439("G G")
                .method_10439("GEG")
                .method_10439("###")
                .method_10433('G', class_6862.method_40092(class_7924.field_41197, new class_2960("c", "colorless_glass")))
                .method_10433('#', class_3489.field_15537)
                .method_10434('E', class_1802.field_8634)
                .method_10429(method_32807(class_1802.field_8280), method_10426(class_1802.field_8280))
                .method_10429(method_32807(class_1802.field_8634), method_10426(class_1802.field_8634))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.GLASS_ELEVATOR_BASE)));

        class_2447.method_10437(class_7800.field_40642, ModItems.NARSIL_HANDLE)
                .method_10439("#")
                .method_10439("I")
                .method_10434('#', class_1802.field_22021)
                .method_10434('I', ModItems.REINFORCED_TOOL_ROD)
                .method_10429(method_32807(class_1802.field_22021), method_10426(class_1802.field_22021))
                .method_10429(method_32807(ModItems.REINFORCED_TOOL_ROD), method_10426(ModItems.REINFORCED_TOOL_ROD))
                .method_17972(exporter, new class_2960(method_36450(ModItems.NARSIL_HANDLE)));

        class_2450.method_10447(class_7800.field_40642, ModItems.GONDORIAN_SHIELD)
                .method_10454(class_1802.field_8255)
                .method_10454(class_1802.field_8226)
                .method_10446(class_3489.field_15528)
                .method_10454(ModItems.MITHRIL_NUGGET)
                .method_10442(method_32807(class_1802.field_8255), method_10426(class_1802.field_8255))
                .method_10442(method_32807(class_1802.field_8226), method_10426(class_1802.field_8226))
                .method_10442(method_32807(ModItems.MITHRIL_NUGGET), method_10426(ModItems.MITHRIL_NUGGET))
                .method_36443(exporter, new class_2960(method_36450(ModItems.GONDORIAN_SHIELD))+"_from_shield");

        class_2450.method_10447(class_7800.field_40642, ModItems.GONDORIAN_SHIELD)
                .method_10454(ModItems.GONDORIAN_KINGS_GUARD_TOWER_SHIELD)
                .method_10442(method_32807(ModItems.GONDORIAN_KINGS_GUARD_TOWER_SHIELD), method_10426(ModItems.GONDORIAN_KINGS_GUARD_TOWER_SHIELD))
                .method_17972(exporter, new class_2960(method_36450(ModItems.GONDORIAN_SHIELD)));

        class_2450.method_10447(class_7800.field_40642, ModItems.GONDORIAN_TOWER_SHIELD)
                .method_10454(ModItems.GONDORIAN_SHIELD)
                .method_10442(method_32807(ModItems.GONDORIAN_SHIELD), method_10426(ModItems.GONDORIAN_SHIELD))
                .method_17972(exporter, new class_2960(method_36450(ModItems.GONDORIAN_TOWER_SHIELD)));

        class_2450.method_10447(class_7800.field_40642, ModItems.GONDORIAN_KINGS_GUARD_TOWER_SHIELD)
                .method_10454(ModItems.GONDORIAN_TOWER_SHIELD)
                .method_10442(method_32807(ModItems.GONDORIAN_TOWER_SHIELD), method_10426(ModItems.GONDORIAN_TOWER_SHIELD))
                .method_17972(exporter, new class_2960(method_36450(ModItems.GONDORIAN_KINGS_GUARD_TOWER_SHIELD)));

        class_2447.method_10437(class_7800.field_40634, ModItems.GONDORIAN_KNIGHT_SHIELD)
                .method_10439("GGG")
                .method_10439("G#G")
                .method_10439("GGG")
                .method_10434('#', ModItems.GONDORIAN_TOWER_SHIELD)
                .method_10434('G', class_1802.field_8397)
                .method_10429(method_32807(ModItems.GONDORIAN_TOWER_SHIELD), method_10426(ModItems.GONDORIAN_TOWER_SHIELD))
                .method_10429(method_32807(class_1802.field_8397), method_10426(class_1802.field_8397))
                .method_17972(exporter, new class_2960(method_36450(ModItems.GONDORIAN_KNIGHT_SHIELD)));

        class_2447.method_10437(class_7800.field_40634, ModItems.GONDORIAN_ORNAMENTED_KNIGHT_SHIELD)
                .method_10439("MGM")
                .method_10439("G#G")
                .method_10439("MGM")
                .method_10434('#', ModItems.GONDORIAN_KNIGHT_SHIELD)
                .method_10434('G', class_1802.field_8408)
                .method_10434('M', ModItems.MITHRIL_NUGGET)
                .method_10429(method_32807(ModItems.GONDORIAN_KNIGHT_SHIELD), method_10426(ModItems.GONDORIAN_KNIGHT_SHIELD))
                .method_10429(method_32807(class_1802.field_8408), method_10426(class_1802.field_8408))
                .method_10429(method_32807(ModItems.MITHRIL_NUGGET), method_10426(ModItems.MITHRIL_NUGGET))
                .method_17972(exporter, new class_2960(method_36450(ModItems.GONDORIAN_ORNAMENTED_KNIGHT_SHIELD)));

        class_2447.method_10437(class_7800.field_40634, ModBlocks.ARCHAEOLOGY_TABLE)
                .method_10439("II")
                .method_10439("##")
                .method_10439("##")
                .method_10433('I', class_6862.method_40092(class_7924.field_41197, new class_2960("c", "fossils")))
                .method_10433('#', class_3489.field_15537)
                .method_10429(method_32807(ModItems.FOSSILIZED_BONE), method_10426(ModItems.FOSSILIZED_BONE))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.ARCHAEOLOGY_TABLE)));

        class_2450.method_10447(class_7800.field_40642, class_1802.field_8264)
                .method_10454(ModBlocks.ROSE)
                .method_10452("red_dye")
                .method_10442(method_32807(ModBlocks.ROSE), method_10426(ModBlocks.ROSE))
                .method_17972(exporter, new class_2960("red_dye_from_rose"));

        class_2450.method_10447(class_7800.field_40642, class_1802.field_8296)
                .method_10454(ModBlocks.IRIS)
                .method_10452("purple_dye")
                .method_10442(method_32807(ModBlocks.IRIS), method_10426(ModBlocks.IRIS))
                .method_17972(exporter, new class_2960("purple_dye_from_iris"));

        class_2450.method_10447(class_7800.field_40642, ModItems.EDELWEISS_PETALS)
                .method_10454(ModBlocks.EDELWEISS)
                .method_10442(method_32807(ModBlocks.EDELWEISS), method_10426(ModBlocks.EDELWEISS))
                .method_17972(exporter, new class_2960(method_36450(ModItems.EDELWEISS_PETALS)));

        class_2450.method_10447(class_7800.field_40642, class_1802.field_8446)
                .method_10454(ModItems.EDELWEISS_PETALS)
                .method_10442(method_32807(ModItems.EDELWEISS_PETALS), method_10426(ModItems.EDELWEISS_PETALS))
                .method_17972(exporter, new class_2960(method_36450(ModItems.EDELWEISS_PETALS) + "_to_dye"));

        class_2450.method_10447(class_7800.field_40642, class_1802.field_8446)
                .method_10454(ModBlocks.ATHELAS)
                .method_10452("white_dye")
                .method_10442(method_32807(ModBlocks.ATHELAS), method_10426(ModBlocks.ATHELAS))
                .method_17972(exporter, new class_2960("white_dye_from_athelas"));

        method_32808(ModBlocks.MARBLE_STAIRS, class_1856.method_8091(ModBlocks.MARBLE))
                .method_33530(method_32807(ModBlocks.MARBLE), method_10426(ModBlocks.MARBLE))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.MARBLE_STAIRS)));
        method_32804(class_7800.field_40634, ModBlocks.MARBLE_SLAB, class_1856.method_8091(ModBlocks.MARBLE))
                .method_33530(method_32807(ModBlocks.MARBLE), method_10426(ModBlocks.MARBLE))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.MARBLE_SLAB)));
        class_2447.method_10436(class_7800.field_40634, ModBlocks.MARBLE_WALL, 6)
                .method_10439("###")
                .method_10439("###")
                .method_10434('#', ModBlocks.MARBLE)
                .method_10429(method_32807(ModBlocks.MARBLE), method_10426(ModBlocks.MARBLE))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.MARBLE_WALL)));
        method_33717(exporter, class_7800.field_40634, ModBlocks.MARBLE_STAIRS, ModBlocks.MARBLE);
        method_33715(exporter, class_7800.field_40634, ModBlocks.MARBLE_SLAB, ModBlocks.MARBLE,2);
        method_33717(exporter, class_7800.field_40634, ModBlocks.MARBLE_WALL, ModBlocks.MARBLE);
        class_2450.method_10447(class_7800.field_40634, ModBlocks.MARBLE_BUTTON)
                .method_10454(ModBlocks.MARBLE)
                .method_10442(method_32807(ModBlocks.MARBLE), method_10426(ModBlocks.MARBLE))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.MARBLE_BUTTON)));
        method_32806(class_7800.field_40634, ModBlocks.MARBLE_PRESSURE_PLATE, class_1856.method_8091(ModBlocks.MARBLE))
                .method_33530(method_32807(ModBlocks.MARBLE), method_10426(ModBlocks.MARBLE))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.MARBLE_PRESSURE_PLATE)));

        method_32808(ModBlocks.LIMESTONE_STAIRS, class_1856.method_8091(ModBlocks.LIMESTONE))
                .method_33530(method_32807(ModBlocks.LIMESTONE), method_10426(ModBlocks.LIMESTONE))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.LIMESTONE_STAIRS)));
        method_32804(class_7800.field_40634, ModBlocks.LIMESTONE_SLAB, class_1856.method_8091(ModBlocks.LIMESTONE))
                .method_33530(method_32807(ModBlocks.LIMESTONE), method_10426(ModBlocks.LIMESTONE))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.LIMESTONE_SLAB)));
        class_2447.method_10436(class_7800.field_40634, ModBlocks.LIMESTONE_WALL, 6)
                .method_10439("###")
                .method_10439("###")
                .method_10434('#', ModBlocks.LIMESTONE)
                .method_10429(method_32807(ModBlocks.LIMESTONE), method_10426(ModBlocks.LIMESTONE))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.LIMESTONE_WALL)));
        method_33717(exporter, class_7800.field_40634, ModBlocks.LIMESTONE_STAIRS, ModBlocks.LIMESTONE);
        method_33715(exporter, class_7800.field_40634, ModBlocks.LIMESTONE_SLAB, ModBlocks.LIMESTONE,2);
        method_33717(exporter, class_7800.field_40634, ModBlocks.LIMESTONE_WALL, ModBlocks.LIMESTONE);
        class_2450.method_10447(class_7800.field_40634, ModBlocks.LIMESTONE_BUTTON)
                .method_10454(ModBlocks.LIMESTONE)
                .method_10442(method_32807(ModBlocks.LIMESTONE), method_10426(ModBlocks.LIMESTONE))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.LIMESTONE_BUTTON)));
        method_32806(class_7800.field_40634, ModBlocks.LIMESTONE_PRESSURE_PLATE, class_1856.method_8091(ModBlocks.LIMESTONE))
                .method_33530(method_32807(ModBlocks.LIMESTONE), method_10426(ModBlocks.LIMESTONE))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.LIMESTONE_PRESSURE_PLATE)));

        class_2447.method_10436(class_7800.field_40634, ModBlocks.RED_DEEPSLATE, 2)
                .method_10439("#C")
                .method_10439("C#")
                .method_10434('#', class_1802.field_28866)
                .method_10434('C', class_1802.field_33401)
                .method_10429(method_32807(class_1802.field_28866), method_10426(class_1802.field_28866))
                .method_10429(method_32807(class_1802.field_33401), method_10426(class_1802.field_33401))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.RED_DEEPSLATE)));
        class_2447.method_10436(class_7800.field_40634, ModBlocks.COBBLED_RED_DEEPSLATE, 2)
                .method_10439("#C")
                .method_10439("C#")
                .method_10434('#', class_1802.field_29025)
                .method_10434('C', class_1802.field_33401)
                .method_10429(method_32807(class_1802.field_29025), method_10426(class_1802.field_29025))
                .method_10429(method_32807(class_1802.field_33401), method_10426(class_1802.field_33401))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.COBBLED_RED_DEEPSLATE)));

        class_2447.method_10436(class_7800.field_40634, ModBlocks.RED_SANDY_DEEPSLATE, 2)
                .method_10439("#R")
                .method_10439("R#")
                .method_10434('#', ModBlocks.RED_DEEPSLATE)
                .method_10434('R', class_1802.field_8200)
                .method_10429(method_32807(ModBlocks.RED_DEEPSLATE), method_10426(ModBlocks.RED_DEEPSLATE))
                .method_10429(method_32807(class_1802.field_8200), method_10426(class_1802.field_8200))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.RED_SANDY_DEEPSLATE)));

        class_2447.method_10436(class_7800.field_40634, ModBlocks.RED_GRAVEL, 2)
                .method_10439("#C")
                .method_10439("C#")
                .method_10434('#', class_1802.field_8110)
                .method_10434('C', class_1802.field_33401)
                .method_10429(method_32807(class_1802.field_8110), method_10426(class_1802.field_8110))
                .method_10429(method_32807(class_1802.field_33401), method_10426(class_1802.field_33401))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.RED_GRAVEL)));

        method_32808(ModBlocks.COBBLED_RED_DEEPSLATE_STAIRS, class_1856.method_8091(ModBlocks.COBBLED_RED_DEEPSLATE))
                .method_33530(method_32807(ModBlocks.COBBLED_RED_DEEPSLATE), method_10426(ModBlocks.COBBLED_RED_DEEPSLATE))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.COBBLED_RED_DEEPSLATE_STAIRS)));
        method_32804(class_7800.field_40634, ModBlocks.COBBLED_RED_DEEPSLATE_SLAB, class_1856.method_8091(ModBlocks.COBBLED_RED_DEEPSLATE))
                .method_33530(method_32807(ModBlocks.COBBLED_RED_DEEPSLATE), method_10426(ModBlocks.COBBLED_RED_DEEPSLATE))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.COBBLED_RED_DEEPSLATE_SLAB)));
        class_2447.method_10436(class_7800.field_40634, ModBlocks.COBBLED_RED_DEEPSLATE_WALL, 6)
                .method_10439("###")
                .method_10439("###")
                .method_10434('#', ModBlocks.COBBLED_RED_DEEPSLATE)
                .method_10429(method_32807(ModBlocks.COBBLED_RED_DEEPSLATE), method_10426(ModBlocks.COBBLED_RED_DEEPSLATE))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.COBBLED_RED_DEEPSLATE_WALL)));
        method_33717(exporter, class_7800.field_40634, ModBlocks.COBBLED_RED_DEEPSLATE_STAIRS, ModBlocks.COBBLED_RED_DEEPSLATE);
        method_33715(exporter, class_7800.field_40634, ModBlocks.COBBLED_RED_DEEPSLATE_SLAB, ModBlocks.COBBLED_RED_DEEPSLATE,2);
        method_33717(exporter, class_7800.field_40634, ModBlocks.COBBLED_RED_DEEPSLATE_WALL, ModBlocks.COBBLED_RED_DEEPSLATE);
        class_2450.method_10447(class_7800.field_40634, ModBlocks.RED_DEEPSLATE_BUTTON)
                .method_10454(ModBlocks.RED_DEEPSLATE)
                .method_10442(method_32807(ModBlocks.RED_DEEPSLATE), method_10426(ModBlocks.RED_DEEPSLATE))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.RED_DEEPSLATE_BUTTON)));
        method_32806(class_7800.field_40634, ModBlocks.RED_DEEPSLATE_PRESSURE_PLATE, class_1856.method_8091(ModBlocks.RED_DEEPSLATE))
                .method_33530(method_32807(ModBlocks.RED_DEEPSLATE), method_10426(ModBlocks.RED_DEEPSLATE))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.RED_DEEPSLATE_PRESSURE_PLATE)));

        method_36233(exporter, List.of(ModBlocks.COBBLED_RED_DEEPSLATE), class_7800.field_40642, ModBlocks.RED_DEEPSLATE, 0.1f, 200, "red_deepslate");

        method_32808(ModBlocks.RED_DEEPSLATE_STAIRS, class_1856.method_8091(ModBlocks.RED_DEEPSLATE))
                .method_33530(method_32807(ModBlocks.RED_DEEPSLATE), method_10426(ModBlocks.RED_DEEPSLATE))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.RED_DEEPSLATE_STAIRS)));
        method_32804(class_7800.field_40634, ModBlocks.RED_DEEPSLATE_SLAB, class_1856.method_8091(ModBlocks.RED_DEEPSLATE))
                .method_33530(method_32807(ModBlocks.RED_DEEPSLATE), method_10426(ModBlocks.RED_DEEPSLATE))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.RED_DEEPSLATE_SLAB)));
        class_2447.method_10436(class_7800.field_40634, ModBlocks.RED_DEEPSLATE_WALL, 6)
                .method_10439("###")
                .method_10439("###")
                .method_10434('#', ModBlocks.RED_DEEPSLATE)
                .method_10429(method_32807(ModBlocks.RED_DEEPSLATE), method_10426(ModBlocks.RED_DEEPSLATE))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.RED_DEEPSLATE_WALL)));
        method_33717(exporter, class_7800.field_40634, ModBlocks.RED_DEEPSLATE_STAIRS, ModBlocks.RED_DEEPSLATE);
        method_33715(exporter, class_7800.field_40634, ModBlocks.RED_DEEPSLATE_SLAB, ModBlocks.RED_DEEPSLATE,2);
        method_33717(exporter, class_7800.field_40634, ModBlocks.RED_DEEPSLATE_WALL, ModBlocks.RED_DEEPSLATE);

        class_2447.method_10436(class_7800.field_40634, ModBlocks.POLISHED_RED_DEEPSLATE, 4)
                .method_10439("##")
                .method_10439("##")
                .method_10434('#', ModBlocks.RED_DEEPSLATE)
                .method_10429(method_32807(ModBlocks.RED_DEEPSLATE), method_10426(ModBlocks.RED_DEEPSLATE))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.POLISHED_RED_DEEPSLATE)));

        class_2447.method_10436(class_7800.field_40634, ModBlocks.RED_DEEPSLATE_BRICKS, 4)
                .method_10439("##")
                .method_10439("##")
                .method_10434('#', ModBlocks.POLISHED_RED_DEEPSLATE)
                .method_10429(method_32807(ModBlocks.POLISHED_RED_DEEPSLATE), method_10426(ModBlocks.POLISHED_RED_DEEPSLATE))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.RED_DEEPSLATE_BRICKS)));

        method_32808(ModBlocks.RED_DEEPSLATE_BRICK_STAIRS, class_1856.method_8091(ModBlocks.RED_DEEPSLATE_BRICKS))
                .method_33530(method_32807(ModBlocks.RED_DEEPSLATE_BRICKS), method_10426(ModBlocks.RED_DEEPSLATE_BRICKS))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.RED_DEEPSLATE_BRICK_STAIRS)));
        method_32804(class_7800.field_40634, ModBlocks.RED_DEEPSLATE_BRICK_SLAB, class_1856.method_8091(ModBlocks.RED_DEEPSLATE_BRICKS))
                .method_33530(method_32807(ModBlocks.RED_DEEPSLATE_BRICKS), method_10426(ModBlocks.RED_DEEPSLATE_BRICKS))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.RED_DEEPSLATE_BRICK_SLAB)));
        class_2447.method_10436(class_7800.field_40634, ModBlocks.RED_DEEPSLATE_BRICK_WALL, 6)
                .method_10439("###")
                .method_10439("###")
                .method_10434('#', ModBlocks.RED_DEEPSLATE_BRICKS)
                .method_10429(method_32807(ModBlocks.RED_DEEPSLATE_BRICKS), method_10426(ModBlocks.RED_DEEPSLATE_BRICKS))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.RED_DEEPSLATE_BRICK_WALL)));
        method_33717(exporter, class_7800.field_40634, ModBlocks.RED_DEEPSLATE_BRICK_STAIRS, ModBlocks.RED_DEEPSLATE_BRICKS);
        method_33715(exporter, class_7800.field_40634, ModBlocks.RED_DEEPSLATE_BRICK_SLAB, ModBlocks.RED_DEEPSLATE_BRICKS,2);
        method_33717(exporter, class_7800.field_40634, ModBlocks.RED_DEEPSLATE_BRICK_WALL, ModBlocks.RED_DEEPSLATE_BRICKS);

        class_2450.method_10447(class_7800.field_40634, ModBlocks.MOSSY_RED_DEEPSLATE_BRICKS)
                .method_10454(ModBlocks.RED_DEEPSLATE_BRICKS)
                .method_10454(class_1802.field_17523)
                .method_10452(ModBlocks.MOSSY_RED_DEEPSLATE_BRICKS.toString())
                .method_10442(method_32807(ModBlocks.RED_DEEPSLATE_BRICKS), method_10426(ModBlocks.RED_DEEPSLATE_BRICKS))
                .method_10442(method_32807(class_1802.field_17523), method_10426(class_1802.field_17523))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.MOSSY_RED_DEEPSLATE_BRICKS)));

        class_2450.method_10447(class_7800.field_40634, ModBlocks.MOSSY_RED_DEEPSLATE_BRICKS)
                .method_10454(ModBlocks.RED_DEEPSLATE_BRICKS)
                .method_10454(class_1802.field_28654)
                .method_10452(ModBlocks.MOSSY_RED_DEEPSLATE_BRICKS.toString())
                .method_10442(method_32807(ModBlocks.RED_DEEPSLATE_BRICKS), method_10426(ModBlocks.RED_DEEPSLATE_BRICKS))
                .method_10442(method_32807(class_1802.field_28654), method_10426(class_1802.field_28654))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.MOSSY_RED_DEEPSLATE_BRICKS) + "2"));

        method_36233(exporter, List.of(ModBlocks.RED_DEEPSLATE_BRICKS), class_7800.field_40642, ModBlocks.CRACKED_RED_DEEPSLATE_BRICKS, 0.1f, 200, "cracked_red_deepslate_bricks");

        class_2447.method_10436(class_7800.field_40634, ModBlocks.POLISHED_COBBLED_RED_DEEPSLATE, 4)
                .method_10439("##")
                .method_10439("##")
                .method_10434('#', ModBlocks.COBBLED_RED_DEEPSLATE)
                .method_10429(method_32807(ModBlocks.COBBLED_RED_DEEPSLATE), method_10426(ModBlocks.COBBLED_RED_DEEPSLATE))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.POLISHED_COBBLED_RED_DEEPSLATE)));

        class_2447.method_10436(class_7800.field_40634, ModBlocks.COBBLED_RED_DEEPSLATE_BRICKS, 4)
                .method_10439("##")
                .method_10439("##")
                .method_10434('#', ModBlocks.POLISHED_COBBLED_RED_DEEPSLATE)
                .method_10429(method_32807(ModBlocks.POLISHED_COBBLED_RED_DEEPSLATE), method_10426(ModBlocks.POLISHED_COBBLED_RED_DEEPSLATE))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.COBBLED_RED_DEEPSLATE_BRICKS)));

        method_32808(ModBlocks.COBBLED_RED_DEEPSLATE_BRICK_STAIRS, class_1856.method_8091(ModBlocks.COBBLED_RED_DEEPSLATE_BRICKS))
                .method_33530(method_32807(ModBlocks.COBBLED_RED_DEEPSLATE_BRICKS), method_10426(ModBlocks.COBBLED_RED_DEEPSLATE_BRICKS))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.COBBLED_RED_DEEPSLATE_BRICK_STAIRS)));
        method_32804(class_7800.field_40634, ModBlocks.COBBLED_RED_DEEPSLATE_BRICK_SLAB, class_1856.method_8091(ModBlocks.COBBLED_RED_DEEPSLATE_BRICKS))
                .method_33530(method_32807(ModBlocks.COBBLED_RED_DEEPSLATE_BRICKS), method_10426(ModBlocks.COBBLED_RED_DEEPSLATE_BRICKS))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.COBBLED_RED_DEEPSLATE_BRICK_SLAB)));
        class_2447.method_10436(class_7800.field_40634, ModBlocks.COBBLED_RED_DEEPSLATE_BRICK_WALL, 6)
                .method_10439("###")
                .method_10439("###")
                .method_10434('#', ModBlocks.COBBLED_RED_DEEPSLATE_BRICKS)
                .method_10429(method_32807(ModBlocks.COBBLED_RED_DEEPSLATE_BRICKS), method_10426(ModBlocks.COBBLED_RED_DEEPSLATE_BRICKS))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.COBBLED_RED_DEEPSLATE_BRICK_WALL)));
        method_33717(exporter, class_7800.field_40634, ModBlocks.COBBLED_RED_DEEPSLATE_BRICK_STAIRS, ModBlocks.COBBLED_RED_DEEPSLATE_BRICKS);
        method_33715(exporter, class_7800.field_40634, ModBlocks.COBBLED_RED_DEEPSLATE_BRICK_SLAB, ModBlocks.COBBLED_RED_DEEPSLATE_BRICKS,2);
        method_33717(exporter, class_7800.field_40634, ModBlocks.COBBLED_RED_DEEPSLATE_BRICK_WALL, ModBlocks.COBBLED_RED_DEEPSLATE_BRICKS);

        class_2450.method_10447(class_7800.field_40634, ModBlocks.MOSSY_COBBLED_RED_DEEPSLATE_BRICKS)
                .method_10454(ModBlocks.COBBLED_RED_DEEPSLATE_BRICKS)
                .method_10454(class_1802.field_17523)
                .method_10452(ModBlocks.MOSSY_COBBLED_RED_DEEPSLATE_BRICKS.toString())
                .method_10442(method_32807(ModBlocks.COBBLED_RED_DEEPSLATE_BRICKS), method_10426(ModBlocks.COBBLED_RED_DEEPSLATE_BRICKS))
                .method_10442(method_32807(class_1802.field_17523), method_10426(class_1802.field_17523))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.MOSSY_COBBLED_RED_DEEPSLATE_BRICKS)));

        class_2450.method_10447(class_7800.field_40634, ModBlocks.MOSSY_COBBLED_RED_DEEPSLATE_BRICKS)
                .method_10454(ModBlocks.COBBLED_RED_DEEPSLATE_BRICKS)
                .method_10454(class_1802.field_28654)
                .method_10452(ModBlocks.MOSSY_COBBLED_RED_DEEPSLATE_BRICKS.toString())
                .method_10442(method_32807(ModBlocks.COBBLED_RED_DEEPSLATE_BRICKS), method_10426(ModBlocks.COBBLED_RED_DEEPSLATE_BRICKS))
                .method_10442(method_32807(class_1802.field_28654), method_10426(class_1802.field_28654))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.MOSSY_COBBLED_RED_DEEPSLATE_BRICKS) + "2"));

        method_36233(exporter, List.of(ModBlocks.COBBLED_RED_DEEPSLATE_BRICKS), class_7800.field_40642, ModBlocks.CRACKED_COBBLED_RED_DEEPSLATE_BRICKS, 0.0f, 200, "cracked_cobbled_red_deepslate_bricks");

        class_2450.method_10447(class_7800.field_40634, ModBlocks.REINFORCED_RED_DEEPSLATE)
                .method_10454(ModBlocks.RED_DEEPSLATE)
                .method_10446(class_6862.method_40092(class_7924.field_41197, new class_2960("c", "fossils")))
                .method_10442(method_32807(ModBlocks.RED_DEEPSLATE), method_10426(ModBlocks.RED_DEEPSLATE))
                .method_10442(method_32807(ModItems.FOSSILIZED_BONE), method_10426(ModItems.FOSSILIZED_BONE))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.REINFORCED_RED_DEEPSLATE)));

        class_2450.method_10447(class_7800.field_40634, ModBlocks.TREX_HEAD)
                .method_10446(ModTags.Items.TREX_HEADS)
                .method_10454(class_1802.field_8099)
                .method_10442(method_32807(ModBlocks.TREX_HEAD), method_10426(ModBlocks.TREX_HEAD))
                .method_10442(method_32807(class_1802.field_8099), method_10426(class_1802.field_8099))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.TREX_HEAD)));

        class_2450.method_10447(class_7800.field_40634, ModBlocks.GREEN_TREX_HEAD)
                .method_10446(ModTags.Items.TREX_HEADS)
                .method_10454(class_1802.field_8408)
                .method_10442(method_32807(ModBlocks.TREX_HEAD), method_10426(ModBlocks.TREX_HEAD))
                .method_10442(method_32807(class_1802.field_8408), method_10426(class_1802.field_8408))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.GREEN_TREX_HEAD)));

        class_2450.method_10447(class_7800.field_40634, ModBlocks.GRAY_TREX_HEAD)
                .method_10446(ModTags.Items.TREX_HEADS)
                .method_10454(class_1802.field_8298)
                .method_10442(method_32807(ModBlocks.TREX_HEAD), method_10426(ModBlocks.TREX_HEAD))
                .method_10442(method_32807(class_1802.field_8298), method_10426(class_1802.field_8298))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.GRAY_TREX_HEAD)));
        
        method_33544(ModBlocks.GLASS_DOOR, class_1856.method_8091(class_2246.field_10033))
                .method_33530(method_32807(class_2246.field_10033), method_10426(class_2246.field_10033))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.GLASS_DOOR)));

        method_33553(ModBlocks.GLASS_TRAPDOOR, class_1856.method_8091(class_2246.field_10033))
                .method_33530(method_32807(class_2246.field_10033), method_10426(class_2246.field_10033))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.GLASS_TRAPDOOR)));

        class_2450.method_10448(class_7800.field_40634, ModBlocks.GINKGO_PLANKS, 4)
                .method_10446(ModTags.Items.GINKGO_LOGS)
                .method_10442(method_32807(ModBlocks.GINKGO_LOG), method_10426(ModBlocks.GINKGO_LOG))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.GINKGO_PLANKS)));

        method_32808(ModBlocks.GINKGO_STAIRS, class_1856.method_8091(ModBlocks.GINKGO_PLANKS))
                .method_33530(method_32807(ModBlocks.GINKGO_PLANKS), method_10426(ModBlocks.GINKGO_PLANKS))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.GINKGO_STAIRS)));

        method_32804(class_7800.field_40634, ModBlocks.GINKGO_SLAB, class_1856.method_8091(ModBlocks.GINKGO_PLANKS))
                .method_33530(method_32807(ModBlocks.GINKGO_PLANKS), method_10426(ModBlocks.GINKGO_PLANKS))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.GINKGO_SLAB)));

        class_2450.method_10447(class_7800.field_40634, ModBlocks.GINKGO_BUTTON)
                .method_10454(ModBlocks.GINKGO_PLANKS)
                .method_10442(method_32807(ModBlocks.GINKGO_PLANKS), method_10426(ModBlocks.GINKGO_PLANKS))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.GINKGO_BUTTON)));

        method_32806(class_7800.field_40634, ModBlocks.GINKGO_PRESSURE_PLATE, class_1856.method_8091(ModBlocks.GINKGO_PLANKS))
                .method_33530(method_32807(ModBlocks.GINKGO_PLANKS), method_10426(ModBlocks.GINKGO_PLANKS))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.GINKGO_PRESSURE_PLATE)));

        method_33546(ModBlocks.GINKGO_FENCE, class_1856.method_8091(ModBlocks.GINKGO_PLANKS))
                .method_33530(method_32807(ModBlocks.GINKGO_PLANKS), method_10426(ModBlocks.GINKGO_PLANKS))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.GINKGO_FENCE)));

        method_33548(ModBlocks.GINKGO_FENCE_GATE, class_1856.method_8091(ModBlocks.GINKGO_PLANKS))
                .method_33530(method_32807(ModBlocks.GINKGO_PLANKS), method_10426(ModBlocks.GINKGO_PLANKS))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.GINKGO_FENCE_GATE)));

        method_33544(ModBlocks.GINKGO_DOOR, class_1856.method_8091(ModBlocks.GINKGO_PLANKS))
                .method_33530(method_32807(ModBlocks.GINKGO_PLANKS), method_10426(ModBlocks.GINKGO_PLANKS))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.GINKGO_DOOR)));

        method_33553(ModBlocks.GINKGO_TRAPDOOR, class_1856.method_8091(ModBlocks.GINKGO_PLANKS))
                .method_33530(method_32807(ModBlocks.GINKGO_PLANKS), method_10426(ModBlocks.GINKGO_PLANKS))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.GINKGO_TRAPDOOR)));

        class_2447.method_10436(class_7800.field_40634, ModBlocks.GINKGO_WOOD, 3)
                .method_10439("##")
                .method_10439("##")
                .method_10434('#', ModBlocks.GINKGO_LOG)
                .method_10429(method_32807(ModBlocks.GINKGO_LOG), method_10426(ModBlocks.GINKGO_LOG))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.GINKGO_WOOD)+"_from_logs"));

        class_2447.method_10436(class_7800.field_40634, ModBlocks.STRIPPED_GINKGO_WOOD, 3)
                .method_10439("##")
                .method_10439("##")
                .method_10434('#', ModBlocks.STRIPPED_GINKGO_LOG)
                .method_10429(method_32807(ModBlocks.STRIPPED_GINKGO_LOG), method_10426(ModBlocks.STRIPPED_GINKGO_LOG))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.STRIPPED_GINKGO_WOOD)));

        class_2447.method_10436(class_7800.field_40642, ModItems.GINKGO_SIGN, 3)
                .method_10439("###")
                .method_10439("###")
                .method_10439(" I ")
                .method_10434('#', ModBlocks.GINKGO_PLANKS)
                .method_10433('I', class_6862.method_40092(class_7924.field_41197, new class_2960("c", "wooden_rods")))
                .method_10435("wooden_sign")
                .method_10429(method_32807(ModBlocks.GINKGO_PLANKS), method_10426(ModBlocks.GINKGO_PLANKS))
                .method_10429(method_32807(class_1802.field_8600), method_10426(class_1802.field_8600))
                .method_17972(exporter, new class_2960(method_36450(ModItems.GINKGO_SIGN)));

        class_2447.method_10436(class_7800.field_40642, ModItems.HANGING_GINKGO_SIGN, 3)
                .method_10439("I I")
                .method_10439("###")
                .method_10439("###")
                .method_10434('I', class_1802.field_23983)
                .method_10434('#', ModBlocks.STRIPPED_GINKGO_LOG)
                .method_10435("hanging_sign")
                .method_10429(method_32807(ModBlocks.STRIPPED_GINKGO_LOG), method_10426(ModBlocks.STRIPPED_GINKGO_LOG))
                .method_10429(method_32807(class_1802.field_23983), method_10426(class_1802.field_23983))
                .method_17972(exporter, new class_2960(method_36450(ModItems.HANGING_GINKGO_SIGN)));

        class_2447.method_10437(class_7800.field_40642, ModItems.GINKGO_BOAT)
                .method_10439("# #")
                .method_10439("###")
                .method_10434('#', ModBlocks.GINKGO_PLANKS)
                .method_10435("boat")
                .method_10429(method_32807(ModBlocks.GINKGO_PLANKS), method_10426(ModBlocks.GINKGO_PLANKS))
                .method_17972(exporter, new class_2960(method_36450(ModItems.GINKGO_BOAT)));

        class_2450.method_10447(class_7800.field_40642, ModItems.GINKGO_CHEST_BOAT)
                .method_10454(class_1802.field_8106)
                .method_10454(ModItems.GINKGO_BOAT)
                .method_10452("chest_boat")
                .method_10442(method_32807(class_1802.field_8106), method_10426(class_1802.field_8106))
                .method_10442(method_32807(ModItems.GINKGO_BOAT), method_10426(ModItems.GINKGO_BOAT))
                .method_17972(exporter, new class_2960(method_36450(ModItems.GINKGO_CHEST_BOAT)));

        class_2447.method_10436(class_7800.field_40642, ModBlocks.FRAMED_GLASS, 8)
                .method_10439("###")
                .method_10439("#I#")
                .method_10439("###")
                .method_10433('#', class_6862.method_40092(class_7924.field_41197, new class_2960("c", "colorless_glass")))
                .method_10433('I', class_6862.method_40092(class_7924.field_41197, new class_2960("c", "steel_rods")))
                .method_10429(method_32807(class_1802.field_8280), method_10426(class_1802.field_8280))
                .method_10429(method_32807(ModItems.STEEL_ROD), method_10426(ModItems.STEEL_ROD))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.FRAMED_GLASS)));

        class_2447.method_10436(class_7800.field_40642, ModBlocks.FRAMED_GLASS_PANE, 8)
                .method_10439("###")
                .method_10439("#I#")
                .method_10439("###")
                .method_10433('#', class_6862.method_40092(class_7924.field_41197, new class_2960("c", "colorless_glass_panes")))
                .method_10433('I', class_6862.method_40092(class_7924.field_41197, new class_2960("c", "steel_rods")))
                .method_10429(method_32807(class_1802.field_8141), method_10426(class_1802.field_8141))
                .method_10429(method_32807(ModItems.STEEL_ROD), method_10426(ModItems.STEEL_ROD))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.FRAMED_GLASS_PANE)));

        class_2447.method_10437(class_7800.field_40642, ModBlocks.LIGHT_SWITCH)
                .method_10439(" # ")
                .method_10439("#L#")
                .method_10439(" # ")
                .method_10434('L', class_1802.field_8865)
                .method_10434('#', class_1802.field_8155)
                .method_10429(method_32807(class_1802.field_8865), method_10426(class_1802.field_8865))
                .method_10429(method_32807(class_1802.field_8155), method_10426(class_1802.field_8155))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.LIGHT_SWITCH)));

        class_2447.method_10437(class_7800.field_40642, ModBlocks.ELEVATOR_DIAL)
                .method_10439(" G ")
                .method_10439("G#G")
                .method_10439("GGG")
                .method_10434('G', class_1802.field_8397)
                .method_10434('#', class_1802.field_8141)
                .method_10429(method_32807(class_1802.field_8397), method_10426(class_1802.field_8397))
                .method_10429(method_32807(class_1802.field_8141), method_10426(class_1802.field_8141))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.ELEVATOR_DIAL)));

        class_2447.method_10437(class_7800.field_40642, ModBlocks.EXIT_SIGN)
                .method_10439("I I")
                .method_10439("IRI")
                .method_10439("III")
                .method_10434('I', class_1802.field_8675)
                .method_10434('R', class_1802.field_8230)
                .method_10429(method_32807(class_1802.field_8675), method_10426(class_1802.field_8675))
                .method_10429(method_32807(class_1802.field_8230), method_10426(class_1802.field_8230))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.EXIT_SIGN)));

        method_33717(exporter, class_7800.field_40634, ModBlocks.FANCY_OAK_PLANKS, class_2246.field_10161);
        method_33717(exporter, class_7800.field_40634, ModBlocks.FANCY_SPRUCE_PLANKS, class_2246.field_9975);
        method_33717(exporter, class_7800.field_40634, ModBlocks.FANCY_BIRCH_PLANKS, class_2246.field_10148);
        method_33717(exporter, class_7800.field_40634, ModBlocks.FANCY_JUNGLE_PLANKS, class_2246.field_10334);
        method_33717(exporter, class_7800.field_40634, ModBlocks.FANCY_ACACIA_PLANKS, class_2246.field_10218);
        method_33717(exporter, class_7800.field_40634, ModBlocks.FANCY_DARK_OAK_PLANKS, class_2246.field_10075);
        method_33717(exporter, class_7800.field_40634, ModBlocks.FANCY_MANGROVE_PLANKS, class_2246.field_37577);
        method_33717(exporter, class_7800.field_40634, ModBlocks.FANCY_CHERRY_PLANKS, class_2246.field_42751);
        method_33717(exporter, class_7800.field_40634, ModBlocks.FANCY_BAMBOO_PLANKS, class_2246.field_40294);
        method_33717(exporter, class_7800.field_40634, ModBlocks.FANCY_CRIMSON_PLANKS, class_2246.field_22126);
        method_33717(exporter, class_7800.field_40634, ModBlocks.FANCY_WARPED_PLANKS, class_2246.field_22127);
        method_33717(exporter, class_7800.field_40634, ModBlocks.FANCY_GINKGO_PLANKS, ModBlocks.GINKGO_PLANKS);

        method_33717(exporter, class_7800.field_40634, class_2246.field_10161, ModBlocks.FANCY_OAK_PLANKS);
        method_33717(exporter, class_7800.field_40634, class_2246.field_9975, ModBlocks.FANCY_SPRUCE_PLANKS);
        method_33717(exporter, class_7800.field_40634, class_2246.field_10148, ModBlocks.FANCY_BIRCH_PLANKS);
        method_33717(exporter, class_7800.field_40634, class_2246.field_10334, ModBlocks.FANCY_JUNGLE_PLANKS);
        method_33717(exporter, class_7800.field_40634, class_2246.field_10218, ModBlocks.FANCY_ACACIA_PLANKS);
        method_33717(exporter, class_7800.field_40634, class_2246.field_10075, ModBlocks.FANCY_DARK_OAK_PLANKS);
        method_33717(exporter, class_7800.field_40634, class_2246.field_37577, ModBlocks.FANCY_MANGROVE_PLANKS);
        method_33717(exporter, class_7800.field_40634, class_2246.field_42751, ModBlocks.FANCY_CHERRY_PLANKS);
        method_33717(exporter, class_7800.field_40634, class_2246.field_40294, ModBlocks.FANCY_BAMBOO_PLANKS);
        method_33717(exporter, class_7800.field_40634, class_2246.field_22126, ModBlocks.FANCY_CRIMSON_PLANKS);
        method_33717(exporter, class_7800.field_40634, class_2246.field_22127, ModBlocks.FANCY_WARPED_PLANKS);
        method_33717(exporter, class_7800.field_40634, ModBlocks.GINKGO_PLANKS, ModBlocks.FANCY_GINKGO_PLANKS);

        method_32808(ModBlocks.FANCY_OAK_STAIRS, class_1856.method_8091(ModBlocks.FANCY_OAK_PLANKS))
                .method_33530(method_32807(ModBlocks.FANCY_OAK_PLANKS), method_10426(ModBlocks.FANCY_OAK_PLANKS))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.FANCY_OAK_STAIRS)));
        method_32804(class_7800.field_40634, ModBlocks.FANCY_OAK_SLAB, class_1856.method_8091(ModBlocks.FANCY_OAK_PLANKS))
                .method_33530(method_32807(ModBlocks.FANCY_OAK_PLANKS), method_10426(ModBlocks.FANCY_OAK_PLANKS))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.FANCY_OAK_SLAB)));
        method_33553(ModBlocks.FANCY_OAK_TRAPDOOR, class_1856.method_8091(ModBlocks.FANCY_OAK_PLANKS))
                .method_33530(method_32807(ModBlocks.FANCY_OAK_PLANKS), method_10426(ModBlocks.FANCY_OAK_PLANKS))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.FANCY_OAK_TRAPDOOR)));

        method_32808(ModBlocks.FANCY_SPRUCE_STAIRS, class_1856.method_8091(ModBlocks.FANCY_SPRUCE_PLANKS))
                .method_33530(method_32807(ModBlocks.FANCY_SPRUCE_PLANKS), method_10426(ModBlocks.FANCY_SPRUCE_PLANKS))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.FANCY_SPRUCE_STAIRS)));
        method_32804(class_7800.field_40634, ModBlocks.FANCY_SPRUCE_SLAB, class_1856.method_8091(ModBlocks.FANCY_SPRUCE_PLANKS))
                .method_33530(method_32807(ModBlocks.FANCY_SPRUCE_PLANKS), method_10426(ModBlocks.FANCY_SPRUCE_PLANKS))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.FANCY_SPRUCE_SLAB)));
        method_33553(ModBlocks.FANCY_SPRUCE_TRAPDOOR, class_1856.method_8091(ModBlocks.FANCY_SPRUCE_PLANKS))
                .method_33530(method_32807(ModBlocks.FANCY_SPRUCE_PLANKS), method_10426(ModBlocks.FANCY_SPRUCE_PLANKS))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.FANCY_SPRUCE_TRAPDOOR)));

        method_32808(ModBlocks.FANCY_BIRCH_STAIRS, class_1856.method_8091(ModBlocks.FANCY_BIRCH_PLANKS))
                .method_33530(method_32807(ModBlocks.FANCY_BIRCH_PLANKS), method_10426(ModBlocks.FANCY_BIRCH_PLANKS))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.FANCY_BIRCH_STAIRS)));
        method_32804(class_7800.field_40634, ModBlocks.FANCY_BIRCH_SLAB, class_1856.method_8091(ModBlocks.FANCY_BIRCH_PLANKS))
                .method_33530(method_32807(ModBlocks.FANCY_BIRCH_PLANKS), method_10426(ModBlocks.FANCY_BIRCH_PLANKS))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.FANCY_BIRCH_SLAB)));
        method_33553(ModBlocks.FANCY_BIRCH_TRAPDOOR, class_1856.method_8091(ModBlocks.FANCY_BIRCH_PLANKS))
                .method_33530(method_32807(ModBlocks.FANCY_BIRCH_PLANKS), method_10426(ModBlocks.FANCY_BIRCH_PLANKS))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.FANCY_BIRCH_TRAPDOOR)));

        method_32808(ModBlocks.FANCY_JUNGLE_STAIRS, class_1856.method_8091(ModBlocks.FANCY_JUNGLE_PLANKS))
                .method_33530(method_32807(ModBlocks.FANCY_JUNGLE_PLANKS), method_10426(ModBlocks.FANCY_JUNGLE_PLANKS))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.FANCY_JUNGLE_STAIRS)));
        method_32804(class_7800.field_40634, ModBlocks.FANCY_JUNGLE_SLAB, class_1856.method_8091(ModBlocks.FANCY_JUNGLE_PLANKS))
                .method_33530(method_32807(ModBlocks.FANCY_JUNGLE_PLANKS), method_10426(ModBlocks.FANCY_JUNGLE_PLANKS))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.FANCY_JUNGLE_SLAB)));
        method_33553(ModBlocks.FANCY_JUNGLE_TRAPDOOR, class_1856.method_8091(ModBlocks.FANCY_JUNGLE_PLANKS))
                .method_33530(method_32807(ModBlocks.FANCY_JUNGLE_PLANKS), method_10426(ModBlocks.FANCY_JUNGLE_PLANKS))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.FANCY_JUNGLE_TRAPDOOR)));

        method_32808(ModBlocks.FANCY_ACACIA_STAIRS, class_1856.method_8091(ModBlocks.FANCY_ACACIA_PLANKS))
                .method_33530(method_32807(ModBlocks.FANCY_ACACIA_PLANKS), method_10426(ModBlocks.FANCY_ACACIA_PLANKS))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.FANCY_ACACIA_STAIRS)));
        method_32804(class_7800.field_40634, ModBlocks.FANCY_ACACIA_SLAB, class_1856.method_8091(ModBlocks.FANCY_ACACIA_PLANKS))
                .method_33530(method_32807(ModBlocks.FANCY_ACACIA_PLANKS), method_10426(ModBlocks.FANCY_ACACIA_PLANKS))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.FANCY_ACACIA_SLAB)));
        method_33553(ModBlocks.FANCY_ACACIA_TRAPDOOR, class_1856.method_8091(ModBlocks.FANCY_ACACIA_PLANKS))
                .method_33530(method_32807(ModBlocks.FANCY_ACACIA_PLANKS), method_10426(ModBlocks.FANCY_ACACIA_PLANKS))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.FANCY_ACACIA_TRAPDOOR)));

        method_32808(ModBlocks.FANCY_DARK_OAK_STAIRS, class_1856.method_8091(ModBlocks.FANCY_DARK_OAK_PLANKS))
                .method_33530(method_32807(ModBlocks.FANCY_DARK_OAK_PLANKS), method_10426(ModBlocks.FANCY_DARK_OAK_PLANKS))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.FANCY_DARK_OAK_STAIRS)));
        method_32804(class_7800.field_40634, ModBlocks.FANCY_DARK_OAK_SLAB, class_1856.method_8091(ModBlocks.FANCY_DARK_OAK_PLANKS))
                .method_33530(method_32807(ModBlocks.FANCY_DARK_OAK_PLANKS), method_10426(ModBlocks.FANCY_DARK_OAK_PLANKS))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.FANCY_DARK_OAK_SLAB)));
        method_33553(ModBlocks.FANCY_DARK_OAK_TRAPDOOR, class_1856.method_8091(ModBlocks.FANCY_DARK_OAK_PLANKS))
                .method_33530(method_32807(ModBlocks.FANCY_DARK_OAK_PLANKS), method_10426(ModBlocks.FANCY_DARK_OAK_PLANKS))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.FANCY_DARK_OAK_TRAPDOOR)));

        method_32808(ModBlocks.FANCY_MANGROVE_STAIRS, class_1856.method_8091(ModBlocks.FANCY_MANGROVE_PLANKS))
                .method_33530(method_32807(ModBlocks.FANCY_MANGROVE_PLANKS), method_10426(ModBlocks.FANCY_MANGROVE_PLANKS))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.FANCY_MANGROVE_STAIRS)));
        method_32804(class_7800.field_40634, ModBlocks.FANCY_MANGROVE_SLAB, class_1856.method_8091(ModBlocks.FANCY_MANGROVE_PLANKS))
                .method_33530(method_32807(ModBlocks.FANCY_MANGROVE_PLANKS), method_10426(ModBlocks.FANCY_MANGROVE_PLANKS))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.FANCY_MANGROVE_SLAB)));
        method_33553(ModBlocks.FANCY_MANGROVE_TRAPDOOR, class_1856.method_8091(ModBlocks.FANCY_MANGROVE_PLANKS))
                .method_33530(method_32807(ModBlocks.FANCY_MANGROVE_PLANKS), method_10426(ModBlocks.FANCY_MANGROVE_PLANKS))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.FANCY_MANGROVE_TRAPDOOR)));

        method_32808(ModBlocks.FANCY_CHERRY_STAIRS, class_1856.method_8091(ModBlocks.FANCY_CHERRY_PLANKS))
                .method_33530(method_32807(ModBlocks.FANCY_CHERRY_PLANKS), method_10426(ModBlocks.FANCY_CHERRY_PLANKS))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.FANCY_CHERRY_STAIRS)));
        method_32804(class_7800.field_40634, ModBlocks.FANCY_CHERRY_SLAB, class_1856.method_8091(ModBlocks.FANCY_CHERRY_PLANKS))
                .method_33530(method_32807(ModBlocks.FANCY_CHERRY_PLANKS), method_10426(ModBlocks.FANCY_CHERRY_PLANKS))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.FANCY_CHERRY_SLAB)));
        method_33553(ModBlocks.FANCY_CHERRY_TRAPDOOR, class_1856.method_8091(ModBlocks.FANCY_CHERRY_PLANKS))
                .method_33530(method_32807(ModBlocks.FANCY_CHERRY_PLANKS), method_10426(ModBlocks.FANCY_CHERRY_PLANKS))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.FANCY_CHERRY_TRAPDOOR)));

        method_32808(ModBlocks.FANCY_PALE_OAK_STAIRS, class_1856.method_8091(ModBlocks.FANCY_PALE_OAK_PLANKS))
                .method_33530(method_32807(ModBlocks.FANCY_PALE_OAK_PLANKS), method_10426(ModBlocks.FANCY_PALE_OAK_PLANKS))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.FANCY_PALE_OAK_STAIRS)));
        method_32804(class_7800.field_40634, ModBlocks.FANCY_PALE_OAK_SLAB, class_1856.method_8091(ModBlocks.FANCY_PALE_OAK_PLANKS))
                .method_33530(method_32807(ModBlocks.FANCY_PALE_OAK_PLANKS), method_10426(ModBlocks.FANCY_PALE_OAK_PLANKS))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.FANCY_PALE_OAK_SLAB)));
        method_33553(ModBlocks.FANCY_PALE_OAK_TRAPDOOR, class_1856.method_8091(ModBlocks.FANCY_PALE_OAK_PLANKS))
                .method_33530(method_32807(ModBlocks.FANCY_PALE_OAK_PLANKS), method_10426(ModBlocks.FANCY_PALE_OAK_PLANKS))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.FANCY_PALE_OAK_TRAPDOOR)));

        method_32808(ModBlocks.FANCY_BAMBOO_STAIRS, class_1856.method_8091(ModBlocks.FANCY_BAMBOO_PLANKS))
                .method_33530(method_32807(ModBlocks.FANCY_BAMBOO_PLANKS), method_10426(ModBlocks.FANCY_BAMBOO_PLANKS))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.FANCY_BAMBOO_STAIRS)));
        method_32804(class_7800.field_40634, ModBlocks.FANCY_BAMBOO_SLAB, class_1856.method_8091(ModBlocks.FANCY_BAMBOO_PLANKS))
                .method_33530(method_32807(ModBlocks.FANCY_BAMBOO_PLANKS), method_10426(ModBlocks.FANCY_BAMBOO_PLANKS))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.FANCY_BAMBOO_SLAB)));
        method_33553(ModBlocks.FANCY_BAMBOO_TRAPDOOR, class_1856.method_8091(ModBlocks.FANCY_BAMBOO_PLANKS))
                .method_33530(method_32807(ModBlocks.FANCY_BAMBOO_PLANKS), method_10426(ModBlocks.FANCY_BAMBOO_PLANKS))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.FANCY_BAMBOO_TRAPDOOR)));

        method_32808(ModBlocks.FANCY_CRIMSON_STAIRS, class_1856.method_8091(ModBlocks.FANCY_CRIMSON_PLANKS))
                .method_33530(method_32807(ModBlocks.FANCY_CRIMSON_PLANKS), method_10426(ModBlocks.FANCY_CRIMSON_PLANKS))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.FANCY_CRIMSON_STAIRS)));
        method_32804(class_7800.field_40634, ModBlocks.FANCY_CRIMSON_SLAB, class_1856.method_8091(ModBlocks.FANCY_CRIMSON_PLANKS))
                .method_33530(method_32807(ModBlocks.FANCY_CRIMSON_PLANKS), method_10426(ModBlocks.FANCY_CRIMSON_PLANKS))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.FANCY_CRIMSON_SLAB)));
        method_33553(ModBlocks.FANCY_CRIMSON_TRAPDOOR, class_1856.method_8091(ModBlocks.FANCY_CRIMSON_PLANKS))
                .method_33530(method_32807(ModBlocks.FANCY_CRIMSON_PLANKS), method_10426(ModBlocks.FANCY_CRIMSON_PLANKS))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.FANCY_CRIMSON_TRAPDOOR)));

        method_32808(ModBlocks.FANCY_WARPED_STAIRS, class_1856.method_8091(ModBlocks.FANCY_WARPED_PLANKS))
                .method_33530(method_32807(ModBlocks.FANCY_WARPED_PLANKS), method_10426(ModBlocks.FANCY_WARPED_PLANKS))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.FANCY_WARPED_STAIRS)));
        method_32804(class_7800.field_40634, ModBlocks.FANCY_WARPED_SLAB, class_1856.method_8091(ModBlocks.FANCY_WARPED_PLANKS))
                .method_33530(method_32807(ModBlocks.FANCY_WARPED_PLANKS), method_10426(ModBlocks.FANCY_WARPED_PLANKS))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.FANCY_WARPED_SLAB)));
        method_33553(ModBlocks.FANCY_WARPED_TRAPDOOR, class_1856.method_8091(ModBlocks.FANCY_WARPED_PLANKS))
                .method_33530(method_32807(ModBlocks.FANCY_WARPED_PLANKS), method_10426(ModBlocks.FANCY_WARPED_PLANKS))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.FANCY_WARPED_TRAPDOOR)));

        method_32808(ModBlocks.FANCY_GINKGO_STAIRS, class_1856.method_8091(ModBlocks.FANCY_GINKGO_PLANKS))
                .method_33530(method_32807(ModBlocks.FANCY_GINKGO_PLANKS), method_10426(ModBlocks.FANCY_GINKGO_PLANKS))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.FANCY_GINKGO_STAIRS)));
        method_32804(class_7800.field_40634, ModBlocks.FANCY_GINKGO_SLAB, class_1856.method_8091(ModBlocks.FANCY_GINKGO_PLANKS))
                .method_33530(method_32807(ModBlocks.FANCY_GINKGO_PLANKS), method_10426(ModBlocks.FANCY_GINKGO_PLANKS))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.FANCY_GINKGO_SLAB)));
        method_33553(ModBlocks.FANCY_GINKGO_TRAPDOOR, class_1856.method_8091(ModBlocks.FANCY_GINKGO_PLANKS))
                .method_33530(method_32807(ModBlocks.FANCY_GINKGO_PLANKS), method_10426(ModBlocks.FANCY_GINKGO_PLANKS))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.FANCY_GINKGO_TRAPDOOR)));

        method_32808(ModBlocks.FANCY_CHARRED_STAIRS, class_1856.method_8091(ModBlocks.FANCY_CHARRED_PLANKS))
                .method_33530(method_32807(ModBlocks.FANCY_CHARRED_PLANKS), method_10426(ModBlocks.FANCY_CHARRED_PLANKS))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.FANCY_CHARRED_STAIRS)));
        method_32804(class_7800.field_40634, ModBlocks.FANCY_CHARRED_SLAB, class_1856.method_8091(ModBlocks.FANCY_CHARRED_PLANKS))
                .method_33530(method_32807(ModBlocks.FANCY_CHARRED_PLANKS), method_10426(ModBlocks.FANCY_CHARRED_PLANKS))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.FANCY_CHARRED_SLAB)));
        method_33553(ModBlocks.FANCY_CHARRED_TRAPDOOR, class_1856.method_8091(ModBlocks.FANCY_CHARRED_PLANKS))
                .method_33530(method_32807(ModBlocks.FANCY_CHARRED_PLANKS), method_10426(ModBlocks.FANCY_CHARRED_PLANKS))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.FANCY_CHARRED_TRAPDOOR)));

        class_2447.method_10436(class_7800.field_40634, ModBlocks.MEGAREGOLITH, 4)
                .method_10439("##")
                .method_10439("##")
                .method_10434('#', ModBlocks.LUNAR_REGOLITH)
                .method_10429(method_32807(ModBlocks.LUNAR_REGOLITH), method_10426(ModBlocks.LUNAR_REGOLITH))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.MEGAREGOLITH)));

        class_2447.method_10436(class_7800.field_40634, ModBlocks.MEGAREGOLITH_BRICKS, 4)
                .method_10439("##")
                .method_10439("##")
                .method_10434('#', ModBlocks.MEGAREGOLITH)
                .method_10429(method_32807(ModBlocks.MEGAREGOLITH), method_10426(ModBlocks.MEGAREGOLITH))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.MEGAREGOLITH_BRICKS)));

        method_32808(ModBlocks.MEGAREGOLITH_BRICK_STAIRS, class_1856.method_8091(ModBlocks.MEGAREGOLITH_BRICKS))
                .method_33530(method_32807(ModBlocks.MEGAREGOLITH_BRICKS), method_10426(ModBlocks.MEGAREGOLITH_BRICKS))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.MEGAREGOLITH_BRICK_STAIRS)));
        method_32804(class_7800.field_40634, ModBlocks.MEGAREGOLITH_BRICK_SLAB, class_1856.method_8091(ModBlocks.MEGAREGOLITH_BRICKS))
                .method_33530(method_32807(ModBlocks.MEGAREGOLITH_BRICKS), method_10426(ModBlocks.MEGAREGOLITH_BRICKS))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.MEGAREGOLITH_BRICK_SLAB)));
        class_2447.method_10436(class_7800.field_40634, ModBlocks.MEGAREGOLITH_BRICK_WALL, 6)
                .method_10439("###")
                .method_10439("###")
                .method_10434('#', ModBlocks.MEGAREGOLITH_BRICKS)
                .method_10429(method_32807(ModBlocks.MEGAREGOLITH_BRICKS), method_10426(ModBlocks.MEGAREGOLITH_BRICKS))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.MEGAREGOLITH_BRICK_WALL)));

        method_36448(exporter, "campfire", class_1865.field_17347, 600, class_1802.field_8479, ModItems.CARAMEL, 0.5f);
        method_36448(exporter, "smoker", class_1865.field_17085, 100, class_1802.field_8479, ModItems.CARAMEL, 0.5f);
        method_36448(exporter, "furnace", class_1865.field_9042, 200, class_1802.field_8479, ModItems.CARAMEL, 0.5f);

        class_2450.method_10447(class_7800.field_40642, ModFluids.CHEMICAL_WASTE_BUCKET)
                .method_10454(class_1802.field_8187)
                .method_10454(ModItems.URANIUM)
                .method_10454(ModItems.ENDURIUM_CRYSTAL)
                .method_10454(class_1802.field_8550)
                .method_10452(ModFluids.CHEMICAL_WASTE_BUCKET.toString())
                .method_10442(method_32807(class_1802.field_8187), method_10426(class_1802.field_8187))
                .method_10442(method_32807(ModItems.URANIUM), method_10426(ModItems.URANIUM))
                .method_10442(method_32807(ModItems.ENDURIUM_CRYSTAL), method_10426(ModItems.ENDURIUM_CRYSTAL))
                .method_10442(method_32807(class_1802.field_8550), method_10426(class_1802.field_8550))
                .method_17972(exporter, new class_2960(method_36450(ModFluids.CHEMICAL_WASTE_BUCKET)));

        class_2450.method_10447(class_7800.field_40642, ModFluids.BEER_BUCKET)
                .method_10454(class_1802.field_8705)
                .method_10454(class_1802.field_8861)
                .method_10454(class_1802.field_8550)
                .method_10452(ModFluids.BEER_BUCKET.toString())
                .method_10442(method_32807(class_1802.field_8705), method_10426(class_1802.field_8705))
                .method_10442(method_32807(class_1802.field_8861), method_10426(class_1802.field_8861))
                .method_10442(method_32807(class_1802.field_8550), method_10426(class_1802.field_8550))
                .method_17972(exporter, new class_2960(method_36450(ModFluids.BEER_BUCKET)));

        class_2450.method_10447(class_7800.field_40642, ModFluids.BEER_BUCKET)
                .method_10454(class_1802.field_8550)
                .method_10446(ModTags.Items.BEER_CONTAINER)
                .method_10452(ModFluids.BEER_BUCKET.toString())
                .method_10442(method_32807(class_1802.field_8550), method_10426(class_1802.field_8550))
                .method_17972(exporter, new class_2960(method_36450(ModFluids.BEER_BUCKET)+"2"));

        class_2450.method_10447(class_7800.field_40642, ModFluids.BEER_BUCKET)
                .method_10454(class_1802.field_8574)
                .method_10454(class_1802.field_8574)
                .method_10454(class_1802.field_8574)
                .method_10454(class_1802.field_8861)
                .method_10454(class_1802.field_8550)
                .method_10452(ModFluids.BEER_BUCKET.toString())
                .method_10442(method_32807(class_1802.field_8550), method_10426(class_1802.field_8550))
                .method_10442(method_32807(class_1802.field_8861), method_10426(class_1802.field_8861))
                .method_10442(method_32807(class_1802.field_8574), method_10426(class_1802.field_8574))
                .method_17972(exporter, new class_2960(method_36450(ModFluids.BEER_BUCKET)+"3"));

        class_2450.method_10447(class_7800.field_40642, ModFluids.BEER_BUCKET)
                .method_10454(class_1802.field_8550)
                .method_10454(ModItems.BEER_BOTTLE)
                .method_10454(ModItems.BEER_BOTTLE)
                .method_10454(ModItems.BEER_BOTTLE)
                .method_10452(ModFluids.BEER_BUCKET.toString())
                .method_10442(method_32807(class_1802.field_8550), method_10426(class_1802.field_8550))
                .method_10442(method_32807(ModItems.BEER_BOTTLE), method_10426(ModItems.BEER_BOTTLE))
                .method_17972(exporter, new class_2960(method_36450(ModFluids.BEER_BUCKET)+"4"));

        class_2450.method_10447(class_7800.field_40642, ModFluids.MEAD_BUCKET)
                .method_10454(class_1802.field_8550)
                .method_10454(class_1802.field_20417)
                .method_10454(class_1802.field_20417)
                .method_10454(class_1802.field_8574)
                .method_10454(class_1802.field_8574)
                .method_10452(ModFluids.MEAD_BUCKET.toString())
                .method_10442(method_32807(class_1802.field_8550), method_10426(class_1802.field_8550))
                .method_10442(method_32807(class_1802.field_20417), method_10426(class_1802.field_20417))
                .method_10442(method_32807(class_1802.field_8574), method_10426(class_1802.field_8574))
                .method_17972(exporter, new class_2960(method_36450(ModFluids.MEAD_BUCKET)));

        class_2450.method_10448(class_7800.field_40642, ModFluids.MEAD_BUCKET, 2)
                .method_10454(class_1802.field_8705)
                .method_10454(class_1802.field_21086)
                .method_10454(class_1802.field_8550)
                .method_10454(class_1802.field_8550)
                .method_10452(ModFluids.MEAD_BUCKET.toString())
                .method_10442(method_32807(class_1802.field_8705), method_10426(class_1802.field_8705))
                .method_10442(method_32807(class_1802.field_21086), method_10426(class_1802.field_21086))
                .method_10442(method_32807(class_1802.field_8550), method_10426(class_1802.field_8550))
                .method_17972(exporter, new class_2960(method_36450(ModFluids.MEAD_BUCKET)+"2"));

        class_2450.method_10447(class_7800.field_40642, ModFluids.MEAD_BUCKET)
                .method_10454(class_1802.field_8550)
                .method_10446(ModTags.Items.MEAD_CONTAINER)
                .method_10452(ModFluids.MEAD_BUCKET.toString())
                .method_10442(method_32807(class_1802.field_8550), method_10426(class_1802.field_8550))
                .method_10442(method_32807(ModBlocks.WOODEN_MEAD_STEIN), method_10426(ModBlocks.WOODEN_MEAD_STEIN))
                .method_17972(exporter, new class_2960(method_36450(ModFluids.MEAD_BUCKET)+"3"));

        class_2450.method_10447(class_7800.field_40642, ModFluids.MEAD_BUCKET)
                .method_10454(class_1802.field_8550)
                .method_10454(ModItems.MEAD_BOTTLE)
                .method_10454(ModItems.MEAD_BOTTLE)
                .method_10454(ModItems.MEAD_BOTTLE)
                .method_10452(ModFluids.MEAD_BUCKET.toString())
                .method_10442(method_32807(class_1802.field_8550), method_10426(class_1802.field_8550))
                .method_10442(method_32807(ModItems.MEAD_BOTTLE), method_10426(ModItems.MEAD_BOTTLE))
                .method_17972(exporter, new class_2960(method_36450(ModFluids.MEAD_BUCKET)+"4"));

        class_2447.method_10436(class_7800.field_40642, ModBlocks.WOODEN_STEIN,4)
                .method_10439("# #")
                .method_10439("I I")
                .method_10439("###")
                .method_10433('#', class_3489.field_15539)
                .method_10433('I', class_6862.method_40092(class_7924.field_41197, new class_2960("c", "iron_ingots")))
                .method_10435(ModBlocks.WOODEN_STEIN.toString())
                .method_10429(method_32807(class_1802.field_8583), method_10426(class_1802.field_8583))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.WOODEN_STEIN)));

        class_2450.method_10447(class_7800.field_40642, ModBlocks.WOODEN_WATER_STEIN)
                .method_10454(ModBlocks.WOODEN_STEIN)
                .method_10454(class_1802.field_8705)
                .method_10452(ModBlocks.WOODEN_WATER_STEIN.toString())
                .method_10442(method_32807(ModBlocks.WOODEN_STEIN), method_10426(ModBlocks.WOODEN_STEIN))
                .method_10442(method_32807(class_1802.field_8705), method_10426(class_1802.field_8705))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.WOODEN_WATER_STEIN)));

        class_2450.method_10447(class_7800.field_40642, ModBlocks.WOODEN_APPLE_JUICE_STEIN)
                .method_10454(ModBlocks.WOODEN_STEIN)
                .method_10454(class_1802.field_8279)
                .method_10454(class_1802.field_8279)
                .method_10454(class_1802.field_8279)
                .method_10452(ModBlocks.WOODEN_APPLE_JUICE_STEIN.toString())
                .method_10442(method_32807(ModBlocks.WOODEN_STEIN), method_10426(ModBlocks.WOODEN_STEIN))
                .method_10442(method_32807(class_1802.field_8279), method_10426(class_1802.field_8279))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.WOODEN_APPLE_JUICE_STEIN)));

        class_2450.method_10447(class_7800.field_40642, ModBlocks.WOODEN_ORANGE_JUICE_STEIN)
                .method_10454(ModBlocks.WOODEN_STEIN)
                .method_10446(class_6862.method_40092(class_7924.field_41197, new class_2960("c", "oranges")))
                .method_10446(class_6862.method_40092(class_7924.field_41197, new class_2960("c", "oranges")))
                .method_10446(class_6862.method_40092(class_7924.field_41197, new class_2960("c", "oranges")))
                .method_10452(ModBlocks.WOODEN_ORANGE_JUICE_STEIN.toString())
                .method_10442(method_32807(ModBlocks.WOODEN_STEIN), method_10426(ModBlocks.WOODEN_STEIN))
                .method_10442(method_32807(ModItems.ORANGE), method_10426(ModItems.ORANGE))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.WOODEN_ORANGE_JUICE_STEIN)));

        class_2450.method_10447(class_7800.field_40642, ModBlocks.WOODEN_BEER_STEIN)
                .method_10454(ModBlocks.WOODEN_STEIN)
                .method_10446(ModTags.Items.BEER_CONTAINER)
                .method_10452(ModBlocks.WOODEN_BEER_STEIN.toString())
                .method_10442(method_32807(ModBlocks.WOODEN_STEIN), method_10426(ModBlocks.WOODEN_STEIN))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.WOODEN_BEER_STEIN)));

        class_2450.method_10447(class_7800.field_40642, ModBlocks.WOODEN_BEER_STEIN)
                .method_10454(ModBlocks.WOODEN_WATER_STEIN)
                .method_10454(class_1802.field_8861)
                .method_10452(ModBlocks.WOODEN_BEER_STEIN.toString())
                .method_10442(method_32807(ModBlocks.WOODEN_WATER_STEIN), method_10426(ModBlocks.WOODEN_WATER_STEIN))
                .method_10442(method_32807(class_1802.field_8861), method_10426(class_1802.field_8861))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.WOODEN_BEER_STEIN)+"2"));

        class_2450.method_10447(class_7800.field_40642, ModBlocks.WOODEN_BEER_STEIN)
                .method_10454(ModBlocks.WOODEN_STEIN)
                .method_10454(ModItems.BEER_BOTTLE)
                .method_10454(ModItems.BEER_BOTTLE)
                .method_10454(ModItems.BEER_BOTTLE)
                .method_10452(ModBlocks.WOODEN_BEER_STEIN.toString())
                .method_10442(method_32807(ModBlocks.WOODEN_STEIN), method_10426(ModBlocks.WOODEN_STEIN))
                .method_10442(method_32807(ModItems.BEER_BOTTLE), method_10426(ModItems.BEER_BOTTLE))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.WOODEN_BEER_STEIN)+"3"));

        class_2450.method_10447(class_7800.field_40642, ModBlocks.WOODEN_MEAD_STEIN)
                .method_10454(ModBlocks.WOODEN_STEIN)
                .method_10454(class_1802.field_20417)
                .method_10454(class_1802.field_20417)
                .method_10454(class_1802.field_8574)
                .method_10454(class_1802.field_8574)
                .method_10452(ModBlocks.WOODEN_MEAD_STEIN.toString())
                .method_10442(method_32807(ModBlocks.WOODEN_STEIN), method_10426(ModBlocks.WOODEN_STEIN))
                .method_10442(method_32807(class_1802.field_20417), method_10426(class_1802.field_20417))
                .method_10442(method_32807(class_1802.field_8574), method_10426(class_1802.field_8574))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.WOODEN_MEAD_STEIN)));

        class_2450.method_10448(class_7800.field_40642, ModBlocks.WOODEN_MEAD_STEIN, 2)
                .method_10454(ModBlocks.WOODEN_WATER_STEIN)
                .method_10454(ModBlocks.WOODEN_STEIN)
                .method_10454(class_1802.field_21086)
                .method_10452(ModBlocks.WOODEN_MEAD_STEIN.toString())
                .method_10442(method_32807(ModBlocks.WOODEN_WATER_STEIN), method_10426(ModBlocks.WOODEN_WATER_STEIN))
                .method_10442(method_32807(class_1802.field_21086), method_10426(class_1802.field_21086))
                .method_10442(method_32807(ModBlocks.WOODEN_STEIN), method_10426(ModBlocks.WOODEN_STEIN))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.WOODEN_MEAD_STEIN)+"2"));

        class_2450.method_10447(class_7800.field_40642, ModBlocks.WOODEN_MEAD_STEIN)
                .method_10454(ModBlocks.WOODEN_STEIN)
                .method_10446(ModTags.Items.MEAD_CONTAINER)
                .method_10452(ModBlocks.WOODEN_MEAD_STEIN.toString())
                .method_10442(method_32807(ModBlocks.WOODEN_STEIN), method_10426(ModBlocks.WOODEN_STEIN))
                .method_10442(method_32807(ModFluids.MEAD_BUCKET), method_10426(ModFluids.MEAD_BUCKET))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.WOODEN_MEAD_STEIN)+"3"));

        class_2450.method_10447(class_7800.field_40642, ModBlocks.WOODEN_MEAD_STEIN)
                .method_10454(ModBlocks.WOODEN_STEIN)
                .method_10454(ModItems.MEAD_BOTTLE)
                .method_10454(ModItems.BEER_BOTTLE)
                .method_10454(ModItems.BEER_BOTTLE)
                .method_10452(ModBlocks.WOODEN_BEER_STEIN.toString())
                .method_10442(method_32807(ModBlocks.WOODEN_STEIN), method_10426(ModBlocks.WOODEN_STEIN))
                .method_10442(method_32807(ModItems.MEAD_BOTTLE), method_10426(ModItems.MEAD_BOTTLE))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.WOODEN_MEAD_STEIN)+"4"));

        class_2450.method_10447(class_7800.field_40642, ModBlocks.WOODEN_MILK_STEIN)
                .method_10454(ModBlocks.WOODEN_STEIN)
                .method_10446(class_6862.method_40092(class_7924.field_41197, new class_2960("c", "milk")))
                .method_10442(method_32807(ModBlocks.WOODEN_STEIN), method_10426(ModBlocks.WOODEN_STEIN))
                .method_10442(method_32807(class_1802.field_8103), method_10426(class_1802.field_8103))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.WOODEN_MILK_STEIN)));

        class_2450.method_10447(class_7800.field_40642, ModBlocks.HOT_WOODEN_MILK_STEIN)
                .method_10454(ModBlocks.WOODEN_STEIN)
                .method_10454(ModFluids.HOT_MILK_BUCKET)
                .method_10442(method_32807(ModBlocks.WOODEN_STEIN), method_10426(ModBlocks.WOODEN_STEIN))
                .method_10442(method_32807(ModFluids.HOT_MILK_BUCKET), method_10426(ModFluids.HOT_MILK_BUCKET))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.HOT_WOODEN_MILK_STEIN)));

        class_2450.method_10447(class_7800.field_40642, ModBlocks.WOODEN_HOT_CHOCOLATE_STEIN)
                .method_10454(ModBlocks.WOODEN_STEIN)
                .method_10454(ModFluids.HOT_CHOCOLATE_BUCKET)
                .method_10442(method_32807(ModBlocks.WOODEN_STEIN), method_10426(ModBlocks.WOODEN_STEIN))
                .method_10442(method_32807(ModFluids.HOT_CHOCOLATE_BUCKET), method_10426(ModFluids.HOT_CHOCOLATE_BUCKET))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.WOODEN_HOT_CHOCOLATE_STEIN)));

        class_2450.method_10447(class_7800.field_40642, ModBlocks.WOODEN_STRAWBERRY_MILKSHAKE_STEIN)
                .method_10454(ModBlocks.WOODEN_MILK_STEIN)
                .method_10446(class_6862.method_40092(class_7924.field_41197, new class_2960("c", "strawberries")))
                .method_10454(class_1802.field_8543)
                .method_10452("wooden_milkshake_stein")
                .method_10442(method_32807(ModBlocks.WOODEN_MILK_STEIN), method_10426(ModBlocks.WOODEN_MILK_STEIN))
                .method_10442(method_32807(ModItems.STRAWBERRY), method_10426(ModItems.STRAWBERRY))
                .method_10442(method_32807(class_1802.field_8543), method_10426(class_1802.field_8543))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.WOODEN_STRAWBERRY_MILKSHAKE_STEIN)));

        class_2450.method_10447(class_7800.field_40642, ModBlocks.WOODEN_ORANGE_MILKSHAKE_STEIN)
                .method_10454(ModBlocks.WOODEN_MILK_STEIN)
                .method_10446(class_6862.method_40092(class_7924.field_41197, new class_2960("c", "oranges")))
                .method_10454(class_1802.field_8543)
                .method_10452("wooden_milkshake_stein")
                .method_10442(method_32807(ModBlocks.WOODEN_MILK_STEIN), method_10426(ModBlocks.WOODEN_MILK_STEIN))
                .method_10442(method_32807(ModItems.ORANGE), method_10426(ModItems.ORANGE))
                .method_10442(method_32807(class_1802.field_8543), method_10426(class_1802.field_8543))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.WOODEN_ORANGE_MILKSHAKE_STEIN)));

        class_2450.method_10447(class_7800.field_40642, ModBlocks.WOODEN_CHOCOLATE_MILKSHAKE_STEIN)
                .method_10454(ModBlocks.WOODEN_MILK_STEIN)
                .method_10454(class_1802.field_8116)
                .method_10454(class_1802.field_8543)
                .method_10452("wooden_milkshake_stein")
                .method_10442(method_32807(ModBlocks.WOODEN_MILK_STEIN), method_10426(ModBlocks.WOODEN_MILK_STEIN))
                .method_10442(method_32807(class_1802.field_8116), method_10426(class_1802.field_8116))
                .method_10442(method_32807(class_1802.field_8543), method_10426(class_1802.field_8543))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.WOODEN_CHOCOLATE_MILKSHAKE_STEIN)));

        class_2450.method_10447(class_7800.field_40642, ModBlocks.WOODEN_CARAMEL_MILKSHAKE_STEIN)
                .method_10454(ModBlocks.WOODEN_MILK_STEIN)
                .method_10446(class_6862.method_40092(class_7924.field_41197, new class_2960("c", "caramel")))
                .method_10454(class_1802.field_8543)
                .method_10452("wooden_milkshake_stein")
                .method_10442(method_32807(ModBlocks.WOODEN_MILK_STEIN), method_10426(ModBlocks.WOODEN_MILK_STEIN))
                .method_10442(method_32807(ModItems.CARAMEL), method_10426(ModItems.CARAMEL))
                .method_10442(method_32807(class_1802.field_8543), method_10426(class_1802.field_8543))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.WOODEN_CARAMEL_MILKSHAKE_STEIN)));

        method_36448(exporter, "campfire", class_1865.field_17347, 600, ModBlocks.WOODEN_MILK_STEIN, ModBlocks.HOT_WOODEN_MILK_STEIN, 0.5f);
        method_36448(exporter, "smoker", class_1865.field_17085, 100, ModBlocks.WOODEN_MILK_STEIN, ModBlocks.HOT_WOODEN_MILK_STEIN, 0.5f);
        method_36448(exporter, "furnace", class_1865.field_9042, 200, ModBlocks.WOODEN_MILK_STEIN, ModBlocks.HOT_WOODEN_MILK_STEIN, 0.5f);

        method_36448(exporter, "campfire", class_1865.field_17347, 600, class_1802.field_8103, ModFluids.HOT_MILK_BUCKET, 0.5f);
        method_36448(exporter, "smoker", class_1865.field_17085, 100, class_1802.field_8103, ModFluids.HOT_MILK_BUCKET, 0.5f);
        method_36448(exporter, "furnace", class_1865.field_9042, 200, class_1802.field_8103, ModFluids.HOT_MILK_BUCKET, 0.5f);

        class_2450.method_10447(class_7800.field_40642, ModBlocks.WOODEN_HOT_CHOCOLATE_STEIN)
                .method_10446(ModTags.Items.HOT_MILK_CONTAINER)
                .method_10454(class_1802.field_8116)
                .method_10454(ModBlocks.WOODEN_STEIN)
                .method_10442(method_32807(ModBlocks.HOT_WOODEN_MILK_STEIN), method_10426(ModBlocks.HOT_WOODEN_MILK_STEIN))
                .method_10442(method_32807(class_1802.field_8116), method_10426(class_1802.field_8116))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.WOODEN_HOT_CHOCOLATE_STEIN)+"2"));

        class_2450.method_10447(class_7800.field_40642, ModFluids.HOT_CHOCOLATE_BUCKET)
                .method_10446(ModTags.Items.HOT_MILK_CONTAINER)
                .method_10454(class_1802.field_8116)
                .method_10454(class_1802.field_8550)
                .method_10452(ModFluids.HOT_CHOCOLATE_BUCKET.toString())
                .method_10442(method_32807(ModBlocks.HOT_WOODEN_MILK_STEIN), method_10426(ModBlocks.HOT_WOODEN_MILK_STEIN))
                .method_10442(method_32807(class_1802.field_8116), method_10426(class_1802.field_8116))
                .method_10442(method_32807(class_1802.field_8550), method_10426(class_1802.field_8550))
                .method_17972(exporter, new class_2960(method_36450(ModFluids.HOT_CHOCOLATE_BUCKET)));

        class_2450.method_10447(class_7800.field_40642, ModFluids.HOT_CHOCOLATE_BUCKET)
                .method_10454(ModBlocks.WOODEN_HOT_CHOCOLATE_STEIN)
                .method_10454(class_1802.field_8550)
                .method_10452(ModFluids.HOT_CHOCOLATE_BUCKET.toString())
                .method_10442(method_32807(ModBlocks.WOODEN_HOT_CHOCOLATE_STEIN), method_10426(ModBlocks.WOODEN_HOT_CHOCOLATE_STEIN))
                .method_10442(method_32807(class_1802.field_8550), method_10426(class_1802.field_8550))
                .method_17972(exporter, new class_2960(method_36450(ModFluids.HOT_CHOCOLATE_BUCKET)+"2"));

        class_2447.method_10436(class_7800.field_40642, ModItems.DRINK_CAN, 3)
                .method_10439("# #")
                .method_10439(" # ")
                .method_10433('#', class_6862.method_40092(class_7924.field_41197, new class_2960("c", "aluminium_plates")))
                .method_10429(method_32807(ModItems.ALUMINIUM_SHEET), method_10426(ModItems.ALUMINIUM_SHEET))
                .method_17972(exporter, new class_2960(method_36450(ModItems.DRINK_CAN)));

        class_2450.method_10447(class_7800.field_40642, ModItems.BEER_GOAT_HORN)
                .method_10454(class_1802.field_39057)
                .method_10446(ModTags.Items.BEER_CONTAINER)
                .method_10452(ModItems.BEER_GOAT_HORN.toString())
                .method_10442(method_32807(class_1802.field_39057), method_10426(class_1802.field_39057))
                .method_17972(exporter, new class_2960(method_36450(ModItems.BEER_GOAT_HORN)));

        class_2450.method_10447(class_7800.field_40642, ModItems.BEER_GOAT_HORN)
                .method_10454(class_1802.field_39057)
                .method_10454(ModItems.BEER_BOTTLE)
                .method_10454(ModItems.BEER_BOTTLE)
                .method_10454(ModItems.BEER_BOTTLE)
                .method_10452(ModItems.BEER_GOAT_HORN.toString())
                .method_10442(method_32807(class_1802.field_39057), method_10426(class_1802.field_39057))
                .method_10442(method_32807(ModItems.BEER_BOTTLE), method_10426(ModItems.BEER_BOTTLE))
                .method_17972(exporter, new class_2960(method_36450(ModItems.BEER_GOAT_HORN)+"2"));

        class_2450.method_10447(class_7800.field_40642, ModItems.MEAD_GOAT_HORN)
                .method_10454(class_1802.field_39057)
                .method_10446(ModTags.Items.MEAD_CONTAINER)
                .method_10452(ModItems.MEAD_GOAT_HORN.toString())
                .method_10442(method_32807(class_1802.field_39057), method_10426(class_1802.field_39057))
                .method_17972(exporter, new class_2960(method_36450(ModItems.MEAD_GOAT_HORN)));

        class_2450.method_10447(class_7800.field_40642, ModItems.MEAD_GOAT_HORN)
                .method_10454(class_1802.field_39057)
                .method_10454(ModItems.MEAD_BOTTLE)
                .method_10454(ModItems.MEAD_BOTTLE)
                .method_10454(ModItems.MEAD_BOTTLE)
                .method_10452(ModItems.MEAD_GOAT_HORN.toString())
                .method_10442(method_32807(class_1802.field_39057), method_10426(class_1802.field_39057))
                .method_10442(method_32807(ModItems.MEAD_BOTTLE), method_10426(ModItems.MEAD_BOTTLE))
                .method_17972(exporter, new class_2960(method_36450(ModItems.MEAD_GOAT_HORN)+"2"));

        class_2450.method_10447(class_7800.field_40642, ModItems.APPLE_JUICE_BOTTLE)
                .method_10454(class_1802.field_8469)
                .method_10454(class_1802.field_8279)
                .method_10442(method_32807(class_1802.field_8469), method_10426(class_1802.field_8469))
                .method_10442(method_32807(class_1802.field_8279), method_10426(class_1802.field_8279))
                .method_17972(exporter, new class_2960(method_36450(ModItems.APPLE_JUICE_BOTTLE)));

        class_2450.method_10447(class_7800.field_40642, ModItems.ORANGE_JUICE_BOTTLE)
                .method_10454(class_1802.field_8469)
                .method_10446(class_6862.method_40092(class_7924.field_41197, new class_2960("c", "oranges")))
                .method_10442(method_32807(class_1802.field_8469), method_10426(class_1802.field_8469))
                .method_10442(method_32807(ModItems.ORANGE), method_10426(ModItems.ORANGE))
                .method_17972(exporter, new class_2960(method_36450(ModItems.ORANGE_JUICE_BOTTLE)));

        class_2450.method_10447(class_7800.field_40642, ModBlocks.GLOBUS_CRUCIGER)
                .method_10454(class_1802.field_8367)
                .method_10454(ModBlocks.STICK_CROSS)
                .method_10442(method_32807(class_1802.field_8367), method_10426(class_1802.field_8367))
                .method_10442(method_32807(ModBlocks.STICK_CROSS), method_10426(ModBlocks.STICK_CROSS))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.GLOBUS_CRUCIGER)));

        class_2450.method_10447(class_7800.field_40642, ModItems.EMPERORS_CROWN)
                .method_10454(class_1802.field_8862)
                .method_10454(ModBlocks.GLOBUS_CRUCIGER)
                .method_10442(method_32807(class_1802.field_8862), method_10426(class_1802.field_8862))
                .method_10442(method_32807(ModBlocks.GLOBUS_CRUCIGER), method_10426(ModBlocks.GLOBUS_CRUCIGER))
                .method_17972(exporter, new class_2960(method_36450(ModItems.EMPERORS_CROWN)));

        class_2450.method_10447(class_7800.field_40642, ModItems.KEYCARD)
                .method_10454(ModItems.KEYCARD)
                .method_10442(method_32807(ModItems.KEYCARD), method_10426(ModItems.KEYCARD))
                .method_17972(exporter, new class_2960(method_36450(ModItems.KEYCARD) + "_cleared"));

        class_2450.method_10447(class_7800.field_40642, class_1802.field_8884)
                .method_10446(ModTags.Items.IRON_OR_STEEL)
                .method_10454(class_1802.field_8145)
                .method_10442(method_32807(class_1802.field_8620), method_10426(class_1802.field_8620))
                .method_10442(method_32807(class_1802.field_8145), method_10426(class_1802.field_8145))
                .method_17972(exporter, new class_2960(method_36450(class_1802.field_8884)));

        class_2450.method_10447(class_7800.field_40642, ModItems.FOSSIL_AND_STEEL)
                .method_10446(ModTags.Items.IRON_OR_STEEL)
                .method_10446(class_6862.method_40092(class_7924.field_41197, new class_2960("c", "fossils")))
                .method_10442(method_32807(class_1802.field_8620), method_10426(class_1802.field_8620))
                .method_10442(method_32807(ModItems.FOSSILIZED_BONE), method_10426(ModItems.FOSSILIZED_BONE))
                .method_17972(exporter, new class_2960(method_36450(ModItems.FOSSIL_AND_STEEL)));

        offerReversibleNuggetCompactingRecipes(exporter, class_7800.field_40642, ModItems.COPPER_NUGGET, class_7800.field_40642, class_1802.field_27022);

        method_36325(exporter, class_7800.field_40642, ModItems.RAW_ALUMINIUM, class_7800.field_40634, ModBlocks.RAW_ALUMINIUM_BLOCK);
        method_36233(exporter, ALUMINIUM_BLASTABLES, class_7800.field_40642, ModItems.ALUMINIUM_INGOT, 0.25f,200, "aluminium_ingot");
        offerReversibleNuggetCompactingRecipes(exporter, class_7800.field_40642, ModItems.ALUMINIUM_NUGGET, class_7800.field_40642, ModItems.ALUMINIUM_INGOT);
        method_36325(exporter, class_7800.field_40642, ModItems.ALUMINIUM_INGOT, class_7800.field_40634, ModBlocks.ALUMINIUM_BLOCK);

        method_36325(exporter, class_7800.field_40642, ModItems.RAW_LEAD, class_7800.field_40634, ModBlocks.RAW_LEAD_BLOCK);
        method_36233(exporter, LEAD_BLASTABLES, class_7800.field_40642, ModItems.LEAD_INGOT, 0.25f,200, "lead_ingot");
        offerReversibleNuggetCompactingRecipes(exporter, class_7800.field_40642, ModItems.LEAD_NUGGET, class_7800.field_40642, ModItems.LEAD_INGOT);
        method_36325(exporter, class_7800.field_40642, ModItems.LEAD_INGOT, class_7800.field_40634, ModBlocks.LEAD_BLOCK);

        method_36325(exporter, class_7800.field_40642, ModItems.URANIUM, class_7800.field_40634, ModBlocks.RAW_URANIUM_BLOCK);
        method_36233(exporter, URANIUM_BLASTABLES, class_7800.field_40642, ModItems.URANIUM_INGOT, 1f,200, "uranium");
        offerReversibleNuggetCompactingRecipes(exporter, class_7800.field_40642, ModItems.URANIUM_NUGGET, class_7800.field_40642, ModItems.URANIUM_INGOT);
        method_36325(exporter, class_7800.field_40642, ModItems.URANIUM_INGOT, class_7800.field_40634, ModBlocks.URANIUM_BLOCK);

        class_2450.method_10447(class_7800.field_40642, ModItems.STEEL_INGREDIENTS)
                .method_10454(class_1802.field_8620)
                .method_10454(class_1802.field_8665)
                .method_10442(method_32807(class_1802.field_8620), method_10426(class_1802.field_8620))
                .method_10442(method_32807(class_1802.field_8665), method_10426(class_1802.field_8665))
                .method_17972(exporter, new class_2960(method_36450(ModItems.STEEL_INGREDIENTS)));

        method_36234(exporter, List.of(ModItems.STEEL_INGREDIENTS), class_7800.field_40642, ModItems.STEEL_INGOT, 0.7f, 400, "steel_ingot");

        offerReversibleNuggetCompactingRecipes(exporter, class_7800.field_40642, ModItems.STEEL_NUGGET, class_7800.field_40642, ModItems.STEEL_INGOT);
        method_36325(exporter, class_7800.field_40642, ModItems.STEEL_INGOT, class_7800.field_40634, ModBlocks.STEEL_BLOCK);

        class_2447.method_10436(class_7800.field_40642, ModItems.STEEL_ROD, 4)
                .method_10439("#")
                .method_10439("#")
                .method_10433('#', class_6862.method_40092(class_7924.field_41197, new class_2960("c", "steel_ingots")))
                .method_10429(method_32807(ModItems.STEEL_INGOT), method_10426(ModItems.STEEL_INGOT))
                .method_17972(exporter, new class_2960(method_36450(ModItems.STEEL_ROD)));

        class_2447.method_10437(class_7800.field_40642, ModItems.STEEL_SICKLE)
                .method_10439(" #")
                .method_10439("I ")
                .method_10433('#', class_6862.method_40092(class_7924.field_41197, new class_2960("c", "steel_ingots")))
                .method_10433('I', class_6862.method_40092(class_7924.field_41197, new class_2960("c", "wooden_rods")))
                .method_10429(method_32807(ModItems.STEEL_INGOT), method_10426(ModItems.STEEL_INGOT))
                .method_10429(method_32807(class_1802.field_8600), method_10426(class_1802.field_8600))
                .method_17972(exporter, new class_2960(method_36450(ModItems.STEEL_SICKLE)));

        method_36325(exporter, class_7800.field_40642, ModItems.SULFUR, class_7800.field_40634, ModBlocks.SULFUR_BLOCK);

        class_2450.method_10447(class_7800.field_40642, ModItems.MONOCLE)
                .method_10446(class_6862.method_40092(class_7924.field_41197, new class_2960("c", "colorless_glass_panes")))
                .method_10454(class_1802.field_8397)
                .method_10442(method_32807(class_1802.field_8141), method_10426(class_1802.field_8141))
                .method_10442(method_32807(class_1802.field_8397), method_10426(class_1802.field_8397))
                .method_17972(exporter, new class_2960(method_36450(ModItems.MONOCLE)));

        class_2447.method_10437(class_7800.field_40642, ModItems.VICTORIAN_SUIT)
                .method_10439("#B#")
                .method_10439("###")
                .method_10439("###")
                .method_10434('#', class_1802.field_8745)
                .method_10434('B', class_1802.field_8226)
                .method_10429(method_32807(class_1802.field_8745), method_10426(class_1802.field_8745))
                .method_10429(method_32807(class_1802.field_8226), method_10426(class_1802.field_8226))
                .method_17972(exporter, new class_2960(method_36450(ModItems.VICTORIAN_SUIT)));

        class_2447.method_10437(class_7800.field_40642, ModItems.VICTORIAN_PANTS)
                .method_10439("###")
                .method_10439("#L#")
                .method_10439("# #")
                .method_10434('#', class_1802.field_8745)
                .method_10434('L', class_1802.field_8851)
                .method_10429(method_32807(class_1802.field_8745), method_10426(class_1802.field_8745))
                .method_10429(method_32807(class_1802.field_8851), method_10426(class_1802.field_8851))
                .method_17972(exporter, new class_2960(method_36450(ModItems.VICTORIAN_PANTS)));

        class_2447.method_10437(class_7800.field_40642, ModItems.VICTORIAN_BOOTS)
                .method_10439("# #")
                .method_10439("#G#")
                .method_10434('#', class_1802.field_8745)
                .method_10434('G', class_1802.field_8298)
                .method_10429(method_32807(class_1802.field_8745), method_10426(class_1802.field_8745))
                .method_10429(method_32807(class_1802.field_8298), method_10426(class_1802.field_8298))
                .method_17972(exporter, new class_2960(method_36450(ModItems.VICTORIAN_BOOTS)));

        class_2447.method_10437(class_7800.field_40642, ModItems.PICKELHAUBE)
                .method_10439(" I ")
                .method_10439("###")
                .method_10439("# #")
                .method_10433('I', class_6862.method_40092(class_7924.field_41197, new class_2960("c", "gold_ingots")))
                .method_10433('#', class_6862.method_40092(class_7924.field_41197, new class_2960("c", "steel_ingots")))
                .method_10429(method_32807(class_1802.field_8695), method_10426(class_1802.field_8695))
                .method_10429(method_32807(ModItems.STEEL_INGOT), method_10426(ModItems.STEEL_INGOT))
                .method_17972(exporter, new class_2960(method_36450(ModItems.PICKELHAUBE)));

        class_2447.method_10437(class_7800.field_40642, ModItems.IMPERIAL_GERMAN_UNIFORM_MANTLE)
                .method_10439("#B#")
                .method_10439("###")
                .method_10439("###")
                .method_10434('#', class_1802.field_8745)
                .method_10434('B', class_1802.field_8345)
                .method_10429(method_32807(class_1802.field_8745), method_10426(class_1802.field_8745))
                .method_10429(method_32807(class_1802.field_8345), method_10426(class_1802.field_8345))
                .method_17972(exporter, new class_2960(method_36450(ModItems.IMPERIAL_GERMAN_UNIFORM_MANTLE)));

        class_2447.method_10437(class_7800.field_40642, ModItems.IMPERIAL_GERMAN_UNIFORM_PANTS)
                .method_10439("###")
                .method_10439("#G#")
                .method_10439("# #")
                .method_10434('#', class_1802.field_8745)
                .method_10434('G', class_1802.field_8298)
                .method_10429(method_32807(class_1802.field_8745), method_10426(class_1802.field_8745))
                .method_10429(method_32807(class_1802.field_8298), method_10426(class_1802.field_8298))
                .method_17972(exporter, new class_2960(method_36450(ModItems.IMPERIAL_GERMAN_UNIFORM_PANTS)));

        class_2447.method_10437(class_7800.field_40642, ModItems.IMPERIAL_GERMAN_UNIFORM_BOOTS)
                .method_10439("# #")
                .method_10439("#B#")
                .method_10434('#', class_1802.field_8745)
                .method_10434('B', class_1802.field_8226)
                .method_10429(method_32807(class_1802.field_8745), method_10426(class_1802.field_8745))
                .method_10429(method_32807(class_1802.field_8226), method_10426(class_1802.field_8226))
                .method_17972(exporter, new class_2960(method_36450(ModItems.IMPERIAL_GERMAN_UNIFORM_BOOTS)));

        class_2447.method_10437(class_7800.field_40642, ModItems.SCIENTIST_GLASSES)
                .method_10439("I I")
                .method_10439("#I#")
                .method_10433('I', class_6862.method_40092(class_7924.field_41197, new class_2960("c", "iron_nuggets")))
                .method_10433('#', class_6862.method_40092(class_7924.field_41197, new class_2960("c", "colorless_glass_panes")))
                .method_10429(method_32807(class_1802.field_8675), method_10426(class_1802.field_8675))
                .method_10429(method_32807(class_1802.field_8141), method_10426(class_1802.field_8141))
                .method_17972(exporter, new class_2960(method_36450(ModItems.SCIENTIST_GLASSES)));

        class_2447.method_10437(class_7800.field_40642, ModItems.CTHONAUT_HELMET)
                .method_10439("###")
                .method_10439("# #")
                .method_10439("SSS")
                .method_10434('#', class_1802.field_27019)
                .method_10433('S', class_6862.method_40092(class_7924.field_41197, new class_2960("c", "steel_ingots")))
                .method_10429(method_32807(class_1802.field_27019), method_10426(class_1802.field_27019))
                .method_10429(method_32807(ModItems.STEEL_INGOT), method_10426(ModItems.STEEL_INGOT))
                .method_17972(exporter, new class_2960(method_36450(ModItems.CTHONAUT_HELMET)));

        class_2447.method_10437(class_7800.field_40642, ModItems.DEPTH_SUIT_CHESTPLATE)
                .method_10439("# #")
                .method_10439("###")
                .method_10439("###")
                .method_10433('#', class_6862.method_40092(class_7924.field_41197, new class_2960("c", "steel_ingots")))
                .method_10429(method_32807(ModItems.STEEL_INGOT), method_10426(ModItems.STEEL_INGOT))
                .method_17972(exporter, new class_2960(method_36450(ModItems.DEPTH_SUIT_CHESTPLATE)));

        class_2447.method_10437(class_7800.field_40642, ModItems.DEPTH_SUIT_LEGGINGS)
                .method_10439("###")
                .method_10439("# #")
                .method_10439("# #")
                .method_10433('#', class_6862.method_40092(class_7924.field_41197, new class_2960("c", "steel_ingots")))
                .method_10429(method_32807(ModItems.STEEL_INGOT), method_10426(ModItems.STEEL_INGOT))
                .method_17972(exporter, new class_2960(method_36450(ModItems.DEPTH_SUIT_LEGGINGS)));

        class_2447.method_10437(class_7800.field_40642, ModItems.DEPTH_SUIT_BOOTS)
                .method_10439("# #")
                .method_10439("# #")
                .method_10433('#', class_6862.method_40092(class_7924.field_41197, new class_2960("c", "steel_ingots")))
                .method_10429(method_32807(ModItems.STEEL_INGOT), method_10426(ModItems.STEEL_INGOT))
                .method_17972(exporter, new class_2960(method_36450(ModItems.DEPTH_SUIT_BOOTS)));

        class_2447.method_10437(class_7800.field_40642, ModItems.OXYGEN_TANK)
                .method_10439(" A ")
                .method_10439("AGA")
                .method_10439(" A ")
                .method_10433('A', class_6862.method_40092(class_7924.field_41197, new class_2960("c", "aluminium_ingots")))
                .method_10433('G', class_6862.method_40092(class_7924.field_41197, new class_2960("c", "glass_panes")))
                .method_10429(method_32807(ModItems.ALUMINIUM_INGOT), method_10426(ModItems.ALUMINIUM_INGOT))
                .method_10429(method_32807(class_1802.field_8141), method_10426(class_1802.field_8141))
                .method_17972(exporter, new class_2960(method_36450(ModItems.OXYGEN_TANK)));

        class_2447.method_10437(class_7800.field_40642, ModItems.ASTRONAUT_HELMET)
                .method_10439("###")
                .method_10439("# #")
                .method_10439("LLL")
                .method_10434('#', class_1802.field_27019)
                .method_10434('L', class_1802.field_8745)
                .method_10429(method_32807(class_1802.field_27019), method_10426(class_1802.field_27019))
                .method_10429(method_32807(class_1802.field_8745), method_10426(class_1802.field_8745))
                .method_17972(exporter, new class_2960(method_36450(ModItems.ASTRONAUT_HELMET)));

        class_2447.method_10437(class_7800.field_40642, ModItems.SPACE_SUIT_CHESTPLATE)
                .method_10439("#W#")
                .method_10439("O#O")
                .method_10439("###")
                .method_10434('#', class_1802.field_8745)
                .method_10434('W', class_1802.field_8446)
                .method_10434('O', ModItems.OXYGEN_TANK)
                .method_10429(method_32807(class_1802.field_8745), method_10426(class_1802.field_8745))
                .method_10429(method_32807(class_1802.field_8446), method_10426(class_1802.field_8446))
                .method_10429(method_32807(ModItems.OXYGEN_TANK), method_10426(ModItems.OXYGEN_TANK))
                .method_17972(exporter, new class_2960(method_36450(ModItems.SPACE_SUIT_CHESTPLATE)));

        class_2447.method_10437(class_7800.field_40642, ModItems.SPACE_SUIT_LEGGINGS)
                .method_10439("###")
                .method_10439("#W#")
                .method_10439("# #")
                .method_10434('#', class_1802.field_8745)
                .method_10434('W', class_1802.field_8446)
                .method_10429(method_32807(class_1802.field_8745), method_10426(class_1802.field_8745))
                .method_10429(method_32807(class_1802.field_8446), method_10426(class_1802.field_8446))
                .method_17972(exporter, new class_2960(method_36450(ModItems.SPACE_SUIT_LEGGINGS)));

        class_2447.method_10437(class_7800.field_40642, ModItems.SPACE_SUIT_BOOTS)
                .method_10439("# #")
                .method_10439("#L#")
                .method_10434('#', class_1802.field_8745)
                .method_10434('L', class_1802.field_8851)
                .method_10429(method_32807(class_1802.field_8745), method_10426(class_1802.field_8745))
                .method_10429(method_32807(class_1802.field_8851), method_10426(class_1802.field_8851))
                .method_17972(exporter, new class_2960(method_36450(ModItems.SPACE_SUIT_BOOTS)));

        class_2447.method_10437(class_7800.field_40642, ModItems.HEV_SUIT_CHESTPLATE)
                .method_10439("# #")
                .method_10439("#X#")
                .method_10439("X#X")
                .method_10433('#', class_6862.method_40092(class_7924.field_41197, new class_2960("c", "lead_ingots")))
                .method_10434('X', ModItems.XEN_CRYSTAL)
                .method_10429(method_32807(ModItems.LEAD_INGOT), method_10426(ModItems.LEAD_INGOT))
                .method_10429(method_32807(ModItems.XEN_CRYSTAL), method_10426(ModItems.XEN_CRYSTAL))
                .method_17972(exporter, new class_2960(method_36450(ModItems.HEV_SUIT_CHESTPLATE)));

        class_2447.method_10437(class_7800.field_40642, ModItems.HEV_SUIT_LEGGINGS)
                .method_10439("###")
                .method_10439("X X")
                .method_10439("# #")
                .method_10433('#', class_6862.method_40092(class_7924.field_41197, new class_2960("c", "lead_ingots")))
                .method_10434('X', ModItems.XEN_CRYSTAL)
                .method_10429(method_32807(ModItems.LEAD_INGOT), method_10426(ModItems.LEAD_INGOT))
                .method_10429(method_32807(ModItems.XEN_CRYSTAL), method_10426(ModItems.XEN_CRYSTAL))
                .method_17972(exporter, new class_2960(method_36450(ModItems.HEV_SUIT_LEGGINGS)));

        class_2447.method_10437(class_7800.field_40642, ModItems.HEV_SUIT_BOOTS)
                .method_10439("X X")
                .method_10439("# #")
                .method_10433('#', class_6862.method_40092(class_7924.field_41197, new class_2960("c", "lead_ingots")))
                .method_10434('X', ModItems.XEN_CRYSTAL)
                .method_10429(method_32807(ModItems.LEAD_INGOT), method_10426(ModItems.LEAD_INGOT))
                .method_10429(method_32807(ModItems.XEN_CRYSTAL), method_10426(ModItems.XEN_CRYSTAL))
                .method_17972(exporter, new class_2960(method_36450(ModItems.HEV_SUIT_BOOTS)));

        class_2447.method_10437(class_7800.field_40642, ModItems.BAMBOO_SWORD)
                .method_10439("#")
                .method_10439("#")
                .method_10439("I")
                .method_10434('#', class_1802.field_8648)
                .method_10433('I', class_6862.method_40092(class_7924.field_41197, new class_2960("c", "wooden_rods")))
                .method_10429(method_32807(class_1802.field_8648), method_10426(class_1802.field_8648))
                .method_10429(method_32807(class_1802.field_8600), method_10426(class_1802.field_8600))
                .method_17972(exporter, new class_2960(method_36450(ModItems.BAMBOO_SWORD)));

        class_2447.method_10437(class_7800.field_40642, ModItems.BAMBOO_PICKAXE)
                .method_10439("###")
                .method_10439(" I ")
                .method_10439(" I ")
                .method_10434('#', class_1802.field_8648)
                .method_10433('I', class_6862.method_40092(class_7924.field_41197, new class_2960("c", "wooden_rods")))
                .method_10429(method_32807(class_1802.field_8648), method_10426(class_1802.field_8648))
                .method_10429(method_32807(class_1802.field_8600), method_10426(class_1802.field_8600))
                .method_17972(exporter, new class_2960(method_36450(ModItems.BAMBOO_PICKAXE)));

        class_2447.method_10437(class_7800.field_40642, ModItems.BAMBOO_SHOVEL)
                .method_10439("#")
                .method_10439("I")
                .method_10439("I")
                .method_10434('#', class_1802.field_8648)
                .method_10433('I', class_6862.method_40092(class_7924.field_41197, new class_2960("c", "wooden_rods")))
                .method_10429(method_32807(class_1802.field_8648), method_10426(class_1802.field_8648))
                .method_10429(method_32807(class_1802.field_8600), method_10426(class_1802.field_8600))
                .method_17972(exporter, new class_2960(method_36450(ModItems.BAMBOO_SHOVEL)));

        class_2447.method_10437(class_7800.field_40642, ModItems.BAMBOO_AXE)
                .method_10439("##")
                .method_10439("#I")
                .method_10439(" I")
                .method_10434('#', class_1802.field_8648)
                .method_10433('I', class_6862.method_40092(class_7924.field_41197, new class_2960("c", "wooden_rods")))
                .method_10429(method_32807(class_1802.field_8648), method_10426(class_1802.field_8648))
                .method_10429(method_32807(class_1802.field_8600), method_10426(class_1802.field_8600))
                .method_10435(ModItems.BAMBOO_AXE.toString())
                .method_17972(exporter, new class_2960(method_36450(ModItems.BAMBOO_AXE)));

        class_2447.method_10437(class_7800.field_40642, ModItems.BAMBOO_AXE)
                .method_10439("##")
                .method_10439("I#")
                .method_10439("I ")
                .method_10434('#', class_1802.field_8648)
                .method_10433('I', class_6862.method_40092(class_7924.field_41197, new class_2960("c", "wooden_rods")))
                .method_10429(method_32807(class_1802.field_8648), method_10426(class_1802.field_8648))
                .method_10429(method_32807(class_1802.field_8600), method_10426(class_1802.field_8600))
                .method_10435(ModItems.BAMBOO_AXE.toString())
                .method_17972(exporter, new class_2960(method_36450(ModItems.BAMBOO_AXE) + "2"));

        class_2447.method_10437(class_7800.field_40642, ModItems.BAMBOO_HOE)
                .method_10439("##")
                .method_10439(" I")
                .method_10439(" I")
                .method_10434('#', class_1802.field_8648)
                .method_10433('I', class_6862.method_40092(class_7924.field_41197, new class_2960("c", "wooden_rods")))
                .method_10429(method_32807(class_1802.field_8648), method_10426(class_1802.field_8648))
                .method_10429(method_32807(class_1802.field_8600), method_10426(class_1802.field_8600))
                .method_10435(ModItems.BAMBOO_HOE.toString())
                .method_17972(exporter, new class_2960(method_36450(ModItems.BAMBOO_HOE)));

        class_2447.method_10437(class_7800.field_40642, ModItems.BAMBOO_HOE)
                .method_10439("##")
                .method_10439("I ")
                .method_10439("I ")
                .method_10434('#', class_1802.field_8648)
                .method_10433('I', class_6862.method_40092(class_7924.field_41197, new class_2960("c", "wooden_rods")))
                .method_10429(method_32807(class_1802.field_8648), method_10426(class_1802.field_8648))
                .method_10429(method_32807(class_1802.field_8600), method_10426(class_1802.field_8600))
                .method_10435(ModItems.BAMBOO_HOE.toString())
                .method_17972(exporter, new class_2960(method_36450(ModItems.BAMBOO_HOE) + "2"));

        class_2450.method_10447(class_7800.field_40642, ModItems.HELIORITE_INGOT)
                .method_10454(ModItems.HELIORITE_COMB)
                .method_10454(class_1802.field_8281)
                .method_10442(method_32807(ModItems.HELIORITE_COMB), method_10426(ModItems.HELIORITE_COMB))
                .method_10442(method_32807(class_1802.field_8281), method_10426(class_1802.field_8281))
                .method_17972(exporter, new class_2960(method_36450(ModItems.HELIORITE_INGOT) + "s"));

        method_36325(exporter, class_7800.field_40642, ModItems.HELIORITE_COMB, class_7800.field_40634, ModBlocks.HELIORITE_COMB_BLOCK);
        offerReversibleNuggetCompactingRecipes(exporter, class_7800.field_40642, ModItems.HELIORITE_NUGGET, class_7800.field_40642, ModItems.HELIORITE_INGOT);
        method_36325(exporter, class_7800.field_40642, ModItems.HELIORITE_INGOT, class_7800.field_40634, ModBlocks.HELIORITE_BLOCK);

        method_36234(exporter, List.of(ModItems.HELIORITE_SWORD, ModItems.HELIORITE_PICKAXE, ModItems.HELIORITE_AXE, ModItems.HELIORITE_SHOVEL, ModItems.HELIORITE_HOE, ModItems.HELIORITE_SICKLE, ModItems.HELIORITE_FORGING_HAMMER, ModItems.HELIORITE_HELMET, ModItems.HELIORITE_CHESTPLATE, ModItems.HELIORITE_LEGGINGS, ModItems.HELIORITE_BOOTS), class_7800.field_40642, ModItems.HELIORITE_NUGGET, 0.7f, 400, "heliorite_nugget");

        class_2447.method_10437(class_7800.field_40642, ModItems.HELIORITE_UPGRADE_SMITHING_TEMPLATE)
                .method_10439("#S#")
                .method_10439("#R#")
                .method_10439("###")
                .method_10434('#', ModItems.HELIORITE_INGOT)
                .method_10433('S', class_6862.method_40092(class_7924.field_41197, new class_2960("c", "steel_ingots")))
                .method_10434('R', ModBlocks.COBBLED_RED_DEEPSLATE)
                .method_10429(method_32807(ModItems.HELIORITE_INGOT), method_10426(ModItems.HELIORITE_INGOT))
                .method_10429(method_32807(ModItems.STEEL_INGOT), method_10426(ModItems.STEEL_INGOT))
                .method_10429(method_32807(ModBlocks.COBBLED_RED_DEEPSLATE), method_10426(ModBlocks.COBBLED_RED_DEEPSLATE))
                .method_17972(exporter, new class_2960(method_36450(ModItems.HELIORITE_UPGRADE_SMITHING_TEMPLATE)));

        class_2447.method_10437(class_7800.field_40642, ModItems.HELIORITE_PICKAXE_HEAD)
                .method_10439("###")
                .method_10434('#', ModItems.HELIORITE_INGOT)
                .method_10429(method_32807(ModItems.HELIORITE_INGOT), method_10426(ModItems.HELIORITE_INGOT))
                .method_17972(exporter, new class_2960(method_36450(ModItems.HELIORITE_PICKAXE_HEAD)));

        class_2447.method_10437(class_7800.field_40642, ModItems.HELIORITE_SWORD)
                .method_10439("#")
                .method_10439("#")
                .method_10439("I")
                .method_10434('#', ModItems.HELIORITE_INGOT)
                .method_10433('I', class_6862.method_40092(class_7924.field_41197, new class_2960("c", "steel_rods")))
                .method_10429(method_32807(ModItems.HELIORITE_INGOT), method_10426(ModItems.HELIORITE_INGOT))
                .method_10429(method_32807(ModItems.STEEL_ROD), method_10426(ModItems.STEEL_ROD))
                .method_17972(exporter, new class_2960(method_36450(ModItems.HELIORITE_SWORD)));

        class_2447.method_10437(class_7800.field_40642, ModItems.HELIORITE_SHOVEL)
                .method_10439("#")
                .method_10439("I")
                .method_10439("I")
                .method_10434('#', ModItems.HELIORITE_INGOT)
                .method_10433('I', class_6862.method_40092(class_7924.field_41197, new class_2960("c", "steel_rods")))
                .method_10429(method_32807(ModItems.HELIORITE_INGOT), method_10426(ModItems.HELIORITE_INGOT))
                .method_10429(method_32807(ModItems.STEEL_ROD), method_10426(ModItems.STEEL_ROD))
                .method_17972(exporter, new class_2960(method_36450(ModItems.HELIORITE_SHOVEL)));

        class_2447.method_10437(class_7800.field_40642, ModItems.HELIORITE_AXE)
                .method_10439("##")
                .method_10439("#I")
                .method_10439(" I")
                .method_10434('#', ModItems.HELIORITE_INGOT)
                .method_10433('I', class_6862.method_40092(class_7924.field_41197, new class_2960("c", "steel_rods")))
                .method_10429(method_32807(ModItems.HELIORITE_INGOT), method_10426(ModItems.HELIORITE_INGOT))
                .method_10429(method_32807(ModItems.STEEL_ROD), method_10426(ModItems.STEEL_ROD))
                .method_10435(ModItems.HELIORITE_AXE.toString())
                .method_17972(exporter, new class_2960(method_36450(ModItems.HELIORITE_AXE)));

        class_2447.method_10437(class_7800.field_40642, ModItems.HELIORITE_AXE)
                .method_10439("##")
                .method_10439("I#")
                .method_10439("I ")
                .method_10434('#', ModItems.HELIORITE_INGOT)
                .method_10433('I', class_6862.method_40092(class_7924.field_41197, new class_2960("c", "steel_rods")))
                .method_10429(method_32807(ModItems.HELIORITE_INGOT), method_10426(ModItems.HELIORITE_INGOT))
                .method_10429(method_32807(ModItems.STEEL_ROD), method_10426(ModItems.STEEL_ROD))
                .method_10435(ModItems.HELIORITE_AXE.toString())
                .method_17972(exporter, new class_2960(method_36450(ModItems.HELIORITE_AXE) + "2"));

        class_2447.method_10437(class_7800.field_40642, ModItems.HELIORITE_HOE)
                .method_10439("##")
                .method_10439(" I")
                .method_10439(" I")
                .method_10434('#', ModItems.HELIORITE_INGOT)
                .method_10433('I', class_6862.method_40092(class_7924.field_41197, new class_2960("c", "steel_rods")))
                .method_10429(method_32807(ModItems.HELIORITE_INGOT), method_10426(ModItems.HELIORITE_INGOT))
                .method_10429(method_32807(ModItems.STEEL_ROD), method_10426(ModItems.STEEL_ROD))
                .method_10435(ModItems.HELIORITE_HOE.toString())
                .method_17972(exporter, new class_2960(method_36450(ModItems.HELIORITE_HOE)));

        class_2447.method_10437(class_7800.field_40642, ModItems.HELIORITE_HOE)
                .method_10439("##")
                .method_10439("I ")
                .method_10439("I ")
                .method_10434('#', ModItems.HELIORITE_INGOT)
                .method_10433('I', class_6862.method_40092(class_7924.field_41197, new class_2960("c", "steel_rods")))
                .method_10429(method_32807(ModItems.HELIORITE_INGOT), method_10426(ModItems.HELIORITE_INGOT))
                .method_10429(method_32807(ModItems.STEEL_ROD), method_10426(ModItems.STEEL_ROD))
                .method_10435(ModItems.HELIORITE_HOE.toString())
                .method_17972(exporter, new class_2960(method_36450(ModItems.HELIORITE_HOE) + "2"));

        class_2447.method_10437(class_7800.field_40642, ModItems.HELIORITE_SICKLE)
                .method_10439(" #")
                .method_10439("I ")
                .method_10434('#', ModItems.HELIORITE_INGOT)
                .method_10433('I', class_6862.method_40092(class_7924.field_41197, new class_2960("c", "steel_rods")))
                .method_10429(method_32807(ModItems.HELIORITE_INGOT), method_10426(ModItems.HELIORITE_INGOT))
                .method_10429(method_32807(ModItems.STEEL_ROD), method_10426(ModItems.STEEL_ROD))
                .method_17972(exporter, new class_2960(method_36450(ModItems.HELIORITE_SICKLE)));

        class_2447.method_10437(class_7800.field_40642, ModItems.HELIORITE_FORGING_HAMMER)
                .method_10439("#")
                .method_10439("I")
                .method_10434('#', ModItems.HELIORITE_INGOT)
                .method_10433('I', class_6862.method_40092(class_7924.field_41197, new class_2960("c", "steel_rods")))
                .method_10429(method_32807(ModItems.HELIORITE_INGOT), method_10426(ModItems.HELIORITE_INGOT))
                .method_10429(method_32807(ModItems.STEEL_ROD), method_10426(ModItems.STEEL_ROD))
                .method_17972(exporter, new class_2960(method_36450(ModItems.HELIORITE_FORGING_HAMMER)));


        class_2447.method_10437(class_7800.field_40642, ModItems.HELIORITE_HELMET)
                .method_10439("###")
                .method_10439("# #")
                .method_10434('#', ModItems.HELIORITE_INGOT)
                .method_10429(method_32807(ModItems.HELIORITE_INGOT), method_10426(ModItems.HELIORITE_INGOT))
                .method_17972(exporter, new class_2960(method_36450(ModItems.HELIORITE_HELMET)));

        class_2447.method_10437(class_7800.field_40642, ModItems.HELIORITE_CHESTPLATE)
                .method_10439("# #")
                .method_10439("###")
                .method_10439("###")
                .method_10434('#', ModItems.HELIORITE_INGOT)
                .method_10429(method_32807(ModItems.HELIORITE_INGOT), method_10426(ModItems.HELIORITE_INGOT))
                .method_17972(exporter, new class_2960(method_36450(ModItems.HELIORITE_CHESTPLATE)));

        class_2447.method_10437(class_7800.field_40642, ModItems.HELIORITE_LEGGINGS)
                .method_10439("###")
                .method_10439("# #")
                .method_10439("# #")
                .method_10434('#', ModItems.HELIORITE_INGOT)
                .method_10429(method_32807(ModItems.HELIORITE_INGOT), method_10426(ModItems.HELIORITE_INGOT))
                .method_17972(exporter, new class_2960(method_36450(ModItems.HELIORITE_LEGGINGS)));

        class_2447.method_10437(class_7800.field_40642, ModItems.HELIORITE_BOOTS)
                .method_10439("# #")
                .method_10439("# #")
                .method_10434('#', ModItems.HELIORITE_INGOT)
                .method_10429(method_32807(ModItems.HELIORITE_INGOT), method_10426(ModItems.HELIORITE_INGOT))
                .method_17972(exporter, new class_2960(method_36450(ModItems.HELIORITE_BOOTS)));

        method_36234(exporter, ENDURIUM_BLASTABLES, class_7800.field_40642, ModItems.ENDURIUM_INGOT, 0.7f, 200, "endurium_ingot");

        method_36325(exporter, class_7800.field_40642, ModItems.ENDURIUM_CRYSTAL, class_7800.field_40634, ModBlocks.RAW_ENDURIUM_BLOCK);
        offerReversibleNuggetCompactingRecipes(exporter, class_7800.field_40642, ModItems.ENDURIUM_NUGGET, class_7800.field_40642, ModItems.ENDURIUM_INGOT);
        method_36325(exporter, class_7800.field_40642, ModItems.ENDURIUM_INGOT, class_7800.field_40634, ModBlocks.ENDURIUM_BLOCK);

        method_36234(exporter, List.of(ModItems.ENDURIUM_SWORD, ModItems.ENDURIUM_PICKAXE, ModItems.ENDURIUM_AXE, ModItems.ENDURIUM_SHOVEL, ModItems.ENDURIUM_HOE, ModItems.ENDURIUM_SICKLE, ModItems.ENDURIUM_FORGING_HAMMER, ModItems.ENDURIUM_HELMET, ModItems.ENDURIUM_CHESTPLATE, ModItems.ENDURIUM_LEGGINGS, ModItems.ENDURIUM_BOOTS), class_7800.field_40642, ModItems.ENDURIUM_NUGGET, 0.7f, 400, "endurium_nugget");

        class_2447.method_10437(class_7800.field_40642, ModItems.ENDURIUM_UPGRADE_SMITHING_TEMPLATE)
                .method_10439("#S#")
                .method_10439("#R#")
                .method_10439("###")
                .method_10434('#', ModItems.ENDURIUM_INGOT)
                .method_10433('S', class_6862.method_40092(class_7924.field_41197, new class_2960("c", "steel_ingots")))
                .method_10434('R', ModBlocks.COBBLED_RED_DEEPSLATE)
                .method_10429(method_32807(ModItems.ENDURIUM_INGOT), method_10426(ModItems.ENDURIUM_INGOT))
                .method_10429(method_32807(ModItems.STEEL_INGOT), method_10426(ModItems.STEEL_INGOT))
                .method_10429(method_32807(ModBlocks.COBBLED_RED_DEEPSLATE), method_10426(ModBlocks.COBBLED_RED_DEEPSLATE))
                .method_17972(exporter, new class_2960(method_36450(ModItems.ENDURIUM_UPGRADE_SMITHING_TEMPLATE)));

        class_2447.method_10437(class_7800.field_40642, ModItems.ENDURIUM_PICKAXE_HEAD)
                .method_10439("###")
                .method_10434('#', ModItems.ENDURIUM_INGOT)
                .method_10429(method_32807(ModItems.ENDURIUM_INGOT), method_10426(ModItems.ENDURIUM_INGOT))
                .method_17972(exporter, new class_2960(method_36450(ModItems.ENDURIUM_PICKAXE_HEAD)));

        class_2447.method_10437(class_7800.field_40642, ModItems.ENDURIUM_SWORD)
                .method_10439("#")
                .method_10439("#")
                .method_10439("I")
                .method_10434('#', ModItems.ENDURIUM_INGOT)
                .method_10433('I', class_6862.method_40092(class_7924.field_41197, new class_2960("c", "steel_rods")))
                .method_10429(method_32807(ModItems.ENDURIUM_INGOT), method_10426(ModItems.ENDURIUM_INGOT))
                .method_10429(method_32807(ModItems.STEEL_ROD), method_10426(ModItems.STEEL_ROD))
                .method_17972(exporter, new class_2960(method_36450(ModItems.ENDURIUM_SWORD)));

        class_2447.method_10437(class_7800.field_40642, ModItems.ENDURIUM_SHOVEL)
                .method_10439("#")
                .method_10439("I")
                .method_10439("I")
                .method_10434('#', ModItems.ENDURIUM_INGOT)
                .method_10433('I', class_6862.method_40092(class_7924.field_41197, new class_2960("c", "steel_rods")))
                .method_10429(method_32807(ModItems.ENDURIUM_INGOT), method_10426(ModItems.ENDURIUM_INGOT))
                .method_10429(method_32807(ModItems.STEEL_ROD), method_10426(ModItems.STEEL_ROD))
                .method_17972(exporter, new class_2960(method_36450(ModItems.ENDURIUM_SHOVEL)));

        class_2447.method_10437(class_7800.field_40642, ModItems.ENDURIUM_AXE)
                .method_10439("##")
                .method_10439("#I")
                .method_10439(" I")
                .method_10434('#', ModItems.ENDURIUM_INGOT)
                .method_10433('I', class_6862.method_40092(class_7924.field_41197, new class_2960("c", "steel_rods")))
                .method_10429(method_32807(ModItems.ENDURIUM_INGOT), method_10426(ModItems.ENDURIUM_INGOT))
                .method_10429(method_32807(ModItems.STEEL_ROD), method_10426(ModItems.STEEL_ROD))
                .method_10435(ModItems.ENDURIUM_AXE.toString())
                .method_17972(exporter, new class_2960(method_36450(ModItems.ENDURIUM_AXE)));

        class_2447.method_10437(class_7800.field_40642, ModItems.ENDURIUM_AXE)
                .method_10439("##")
                .method_10439("I#")
                .method_10439("I ")
                .method_10434('#', ModItems.ENDURIUM_INGOT)
                .method_10433('I', class_6862.method_40092(class_7924.field_41197, new class_2960("c", "steel_rods")))
                .method_10429(method_32807(ModItems.ENDURIUM_INGOT), method_10426(ModItems.ENDURIUM_INGOT))
                .method_10429(method_32807(ModItems.STEEL_ROD), method_10426(ModItems.STEEL_ROD))
                .method_10435(ModItems.ENDURIUM_AXE.toString())
                .method_17972(exporter, new class_2960(method_36450(ModItems.ENDURIUM_AXE) + "2"));

        class_2447.method_10437(class_7800.field_40642, ModItems.ENDURIUM_HOE)
                .method_10439("##")
                .method_10439(" I")
                .method_10439(" I")
                .method_10434('#', ModItems.ENDURIUM_INGOT)
                .method_10433('I', class_6862.method_40092(class_7924.field_41197, new class_2960("c", "steel_rods")))
                .method_10429(method_32807(ModItems.ENDURIUM_INGOT), method_10426(ModItems.ENDURIUM_INGOT))
                .method_10429(method_32807(ModItems.STEEL_ROD), method_10426(ModItems.STEEL_ROD))
                .method_10435(ModItems.ENDURIUM_HOE.toString())
                .method_17972(exporter, new class_2960(method_36450(ModItems.ENDURIUM_HOE)));

        class_2447.method_10437(class_7800.field_40642, ModItems.ENDURIUM_HOE)
                .method_10439("##")
                .method_10439("I ")
                .method_10439("I ")
                .method_10434('#', ModItems.ENDURIUM_INGOT)
                .method_10433('I', class_6862.method_40092(class_7924.field_41197, new class_2960("c", "steel_rods")))
                .method_10429(method_32807(ModItems.ENDURIUM_INGOT), method_10426(ModItems.ENDURIUM_INGOT))
                .method_10429(method_32807(ModItems.STEEL_ROD), method_10426(ModItems.STEEL_ROD))
                .method_10435(ModItems.ENDURIUM_HOE.toString())
                .method_17972(exporter, new class_2960(method_36450(ModItems.ENDURIUM_HOE) + "2"));

        class_2447.method_10437(class_7800.field_40642, ModItems.ENDURIUM_SICKLE)
                .method_10439(" #")
                .method_10439("I ")
                .method_10434('#', ModItems.ENDURIUM_INGOT)
                .method_10433('I', class_6862.method_40092(class_7924.field_41197, new class_2960("c", "steel_rods")))
                .method_10429(method_32807(ModItems.ENDURIUM_INGOT), method_10426(ModItems.ENDURIUM_INGOT))
                .method_10429(method_32807(ModItems.STEEL_ROD), method_10426(ModItems.STEEL_ROD))
                .method_17972(exporter, new class_2960(method_36450(ModItems.ENDURIUM_SICKLE)));

        class_2447.method_10437(class_7800.field_40642, ModItems.ENDURIUM_FORGING_HAMMER)
                .method_10439("#")
                .method_10439("I")
                .method_10434('#', ModItems.ENDURIUM_INGOT)
                .method_10433('I', class_6862.method_40092(class_7924.field_41197, new class_2960("c", "steel_rods")))
                .method_10429(method_32807(ModItems.ENDURIUM_INGOT), method_10426(ModItems.ENDURIUM_INGOT))
                .method_10429(method_32807(ModItems.STEEL_ROD), method_10426(ModItems.STEEL_ROD))
                .method_17972(exporter, new class_2960(method_36450(ModItems.ENDURIUM_FORGING_HAMMER)));

        class_2447.method_10437(class_7800.field_40642, ModItems.ENDURIUM_HELMET)
                .method_10439("###")
                .method_10439("# #")
                .method_10434('#', ModItems.ENDURIUM_INGOT)
                .method_10429(method_32807(ModItems.ENDURIUM_INGOT), method_10426(ModItems.ENDURIUM_INGOT))
                .method_17972(exporter, new class_2960(method_36450(ModItems.ENDURIUM_HELMET)));

        class_2447.method_10437(class_7800.field_40642, ModItems.ENDURIUM_CHESTPLATE)
                .method_10439("# #")
                .method_10439("###")
                .method_10439("###")
                .method_10434('#', ModItems.ENDURIUM_INGOT)
                .method_10429(method_32807(ModItems.ENDURIUM_INGOT), method_10426(ModItems.ENDURIUM_INGOT))
                .method_17972(exporter, new class_2960(method_36450(ModItems.ENDURIUM_CHESTPLATE)));

        class_2447.method_10437(class_7800.field_40642, ModItems.ENDURIUM_LEGGINGS)
                .method_10439("###")
                .method_10439("# #")
                .method_10439("# #")
                .method_10434('#', ModItems.ENDURIUM_INGOT)
                .method_10429(method_32807(ModItems.ENDURIUM_INGOT), method_10426(ModItems.ENDURIUM_INGOT))
                .method_17972(exporter, new class_2960(method_36450(ModItems.ENDURIUM_LEGGINGS)));

        class_2447.method_10437(class_7800.field_40642, ModItems.ENDURIUM_BOOTS)
                .method_10439("# #")
                .method_10439("# #")
                .method_10434('#', ModItems.ENDURIUM_INGOT)
                .method_10429(method_32807(ModItems.ENDURIUM_INGOT), method_10426(ModItems.ENDURIUM_INGOT))
                .method_17972(exporter, new class_2960(method_36450(ModItems.ENDURIUM_BOOTS)));

        method_36234(exporter, PALLADIUM_BLASTABLES, class_7800.field_40642, ModItems.PALLADIUM_INGOT, 0.7f, 200, "palladium_ingot");

        method_36325(exporter, class_7800.field_40642, ModItems.RAW_PALLADIUM, class_7800.field_40634, ModBlocks.RAW_PALLADIUM_BLOCK);
        offerReversibleNuggetCompactingRecipes(exporter, class_7800.field_40642, ModItems.PALLADIUM_NUGGET, class_7800.field_40642, ModItems.PALLADIUM_INGOT);
        method_36325(exporter, class_7800.field_40642, ModItems.PALLADIUM_INGOT, class_7800.field_40634, ModBlocks.PALLADIUM_BLOCK);

        method_36234(exporter, List.of(ModItems.PALLADIUM_SWORD, ModItems.PALLADIUM_PICKAXE, ModItems.PALLADIUM_AXE, ModItems.PALLADIUM_SHOVEL, ModItems.PALLADIUM_HOE, ModItems.PALLADIUM_SICKLE, ModItems.PALLADIUM_FORGING_HAMMER, ModItems.PALLADIUM_HELMET, ModItems.PALLADIUM_CHESTPLATE, ModItems.PALLADIUM_LEGGINGS, ModItems.PALLADIUM_BOOTS), class_7800.field_40642, ModItems.PALLADIUM_NUGGET, 0.7f, 400, "palladium_nugget");

        class_2447.method_10437(class_7800.field_40642, ModItems.PALLADIUM_SWORD)
                .method_10439("#")
                .method_10439("#")
                .method_10439("I")
                .method_10434('#', ModItems.PALLADIUM_INGOT)
                .method_10434('I', ModItems.FOSSILIZED_BONE)
                .method_10429(method_32807(ModItems.PALLADIUM_INGOT), method_10426(ModItems.PALLADIUM_INGOT))
                .method_10429(method_32807(ModItems.FOSSILIZED_BONE), method_10426(ModItems.FOSSILIZED_BONE))
                .method_17972(exporter, new class_2960(method_36450(ModItems.PALLADIUM_SWORD)));

        class_2447.method_10437(class_7800.field_40642, ModItems.PALLADIUM_PICKAXE)
                .method_10439("###")
                .method_10439(" I ")
                .method_10439(" I ")
                .method_10434('#', ModItems.PALLADIUM_INGOT)
                .method_10434('I', ModItems.FOSSILIZED_BONE)
                .method_10429(method_32807(ModItems.PALLADIUM_INGOT), method_10426(ModItems.PALLADIUM_INGOT))
                .method_10429(method_32807(ModItems.FOSSILIZED_BONE), method_10426(ModItems.FOSSILIZED_BONE))
                .method_17972(exporter, new class_2960(method_36450(ModItems.PALLADIUM_PICKAXE)));

        class_2447.method_10437(class_7800.field_40642, ModItems.PALLADIUM_SHOVEL)
                .method_10439("#")
                .method_10439("I")
                .method_10439("I")
                .method_10434('#', ModItems.PALLADIUM_INGOT)
                .method_10434('I', ModItems.FOSSILIZED_BONE)
                .method_10429(method_32807(ModItems.PALLADIUM_INGOT), method_10426(ModItems.PALLADIUM_INGOT))
                .method_10429(method_32807(ModItems.FOSSILIZED_BONE), method_10426(ModItems.FOSSILIZED_BONE))
                .method_17972(exporter, new class_2960(method_36450(ModItems.PALLADIUM_SHOVEL)));

        class_2447.method_10437(class_7800.field_40642, ModItems.PALLADIUM_AXE)
                .method_10439("##")
                .method_10439("#I")
                .method_10439(" I")
                .method_10434('#', ModItems.PALLADIUM_INGOT)
                .method_10434('I', ModItems.FOSSILIZED_BONE)
                .method_10429(method_32807(ModItems.PALLADIUM_INGOT), method_10426(ModItems.PALLADIUM_INGOT))
                .method_10429(method_32807(ModItems.FOSSILIZED_BONE), method_10426(ModItems.FOSSILIZED_BONE))
                .method_10435(ModItems.PALLADIUM_AXE.toString())
                .method_17972(exporter, new class_2960(method_36450(ModItems.PALLADIUM_AXE)));

        class_2447.method_10437(class_7800.field_40642, ModItems.PALLADIUM_AXE)
                .method_10439("##")
                .method_10439("I#")
                .method_10439("I ")
                .method_10434('#', ModItems.PALLADIUM_INGOT)
                .method_10434('I', ModItems.FOSSILIZED_BONE)
                .method_10429(method_32807(ModItems.PALLADIUM_INGOT), method_10426(ModItems.PALLADIUM_INGOT))
                .method_10429(method_32807(ModItems.FOSSILIZED_BONE), method_10426(ModItems.FOSSILIZED_BONE))
                .method_10435(ModItems.PALLADIUM_AXE.toString())
                .method_17972(exporter, new class_2960(method_36450(ModItems.PALLADIUM_AXE) + "2"));

        class_2447.method_10437(class_7800.field_40642, ModItems.PALLADIUM_HOE)
                .method_10439("##")
                .method_10439(" I")
                .method_10439(" I")
                .method_10434('#', ModItems.PALLADIUM_INGOT)
                .method_10434('I', ModItems.FOSSILIZED_BONE)
                .method_10429(method_32807(ModItems.PALLADIUM_INGOT), method_10426(ModItems.PALLADIUM_INGOT))
                .method_10429(method_32807(ModItems.FOSSILIZED_BONE), method_10426(ModItems.FOSSILIZED_BONE))
                .method_10435(ModItems.PALLADIUM_HOE.toString())
                .method_17972(exporter, new class_2960(method_36450(ModItems.PALLADIUM_HOE)));

        class_2447.method_10437(class_7800.field_40642, ModItems.PALLADIUM_HOE)
                .method_10439("##")
                .method_10439("I ")
                .method_10439("I ")
                .method_10434('#', ModItems.PALLADIUM_INGOT)
                .method_10434('I', ModItems.FOSSILIZED_BONE)
                .method_10429(method_32807(ModItems.PALLADIUM_INGOT), method_10426(ModItems.PALLADIUM_INGOT))
                .method_10429(method_32807(ModItems.FOSSILIZED_BONE), method_10426(ModItems.FOSSILIZED_BONE))
                .method_10435(ModItems.PALLADIUM_HOE.toString())
                .method_17972(exporter, new class_2960(method_36450(ModItems.PALLADIUM_HOE) + "2"));

        class_2447.method_10437(class_7800.field_40642, ModItems.PALLADIUM_SICKLE)
                .method_10439(" #")
                .method_10439("I ")
                .method_10434('#', ModItems.PALLADIUM_INGOT)
                .method_10434('I', ModItems.FOSSILIZED_BONE)
                .method_10429(method_32807(ModItems.PALLADIUM_INGOT), method_10426(ModItems.PALLADIUM_INGOT))
                .method_10429(method_32807(ModItems.FOSSILIZED_BONE), method_10426(ModItems.FOSSILIZED_BONE))
                .method_17972(exporter, new class_2960(method_36450(ModItems.PALLADIUM_SICKLE)));

        class_2447.method_10437(class_7800.field_40642, ModItems.PALLADIUM_FORGING_HAMMER)
                .method_10439("#")
                .method_10439("I")
                .method_10434('#', ModItems.PALLADIUM_INGOT)
                .method_10434('I', ModItems.FOSSILIZED_BONE)
                .method_10429(method_32807(ModItems.PALLADIUM_INGOT), method_10426(ModItems.PALLADIUM_INGOT))
                .method_10429(method_32807(ModItems.FOSSILIZED_BONE), method_10426(ModItems.FOSSILIZED_BONE))
                .method_17972(exporter, new class_2960(method_36450(ModItems.PALLADIUM_FORGING_HAMMER)));

        class_2447.method_10437(class_7800.field_40642, ModItems.PALLADIUM_HELMET)
                .method_10439("###")
                .method_10439("# #")
                .method_10434('#', ModItems.PALLADIUM_INGOT)
                .method_10429(method_32807(ModItems.PALLADIUM_INGOT), method_10426(ModItems.PALLADIUM_INGOT))
                .method_17972(exporter, new class_2960(method_36450(ModItems.PALLADIUM_HELMET)));

        class_2447.method_10437(class_7800.field_40642, ModItems.PALLADIUM_CHESTPLATE)
                .method_10439("# #")
                .method_10439("###")
                .method_10439("###")
                .method_10434('#', ModItems.PALLADIUM_INGOT)
                .method_10429(method_32807(ModItems.PALLADIUM_INGOT), method_10426(ModItems.PALLADIUM_INGOT))
                .method_17972(exporter, new class_2960(method_36450(ModItems.PALLADIUM_CHESTPLATE)));

        class_2447.method_10437(class_7800.field_40642, ModItems.PALLADIUM_LEGGINGS)
                .method_10439("###")
                .method_10439("# #")
                .method_10439("# #")
                .method_10434('#', ModItems.PALLADIUM_INGOT)
                .method_10429(method_32807(ModItems.PALLADIUM_INGOT), method_10426(ModItems.PALLADIUM_INGOT))
                .method_17972(exporter, new class_2960(method_36450(ModItems.PALLADIUM_LEGGINGS)));

        class_2447.method_10437(class_7800.field_40642, ModItems.PALLADIUM_BOOTS)
                .method_10439("# #")
                .method_10439("# #")
                .method_10434('#', ModItems.PALLADIUM_INGOT)
                .method_10429(method_32807(ModItems.PALLADIUM_INGOT), method_10426(ModItems.PALLADIUM_INGOT))
                .method_17972(exporter, new class_2960(method_36450(ModItems.PALLADIUM_BOOTS)));

        method_36234(exporter, JURASSOLINE_BLASTABLES, class_7800.field_40642, ModItems.JURASSOLINE_INGOT, 0.7f, 200, "jurassoline_ingot");

        method_36325(exporter, class_7800.field_40642, ModItems.JURASSOLINE_CRYSTAL, class_7800.field_40634, ModBlocks.JURASSOLINE_CRYSTAL_BLOCK);
        offerReversibleNuggetCompactingRecipes(exporter, class_7800.field_40642, ModItems.JURASSOLINE_NUGGET, class_7800.field_40642, ModItems.JURASSOLINE_INGOT);
        method_36325(exporter, class_7800.field_40642, ModItems.JURASSOLINE_INGOT, class_7800.field_40634, ModBlocks.JURASSOLINE_BLOCK);

        method_36234(exporter, List.of(ModItems.JURASSOLINE_SWORD, ModItems.JURASSOLINE_PICKAXE, ModItems.JURASSOLINE_AXE, ModItems.JURASSOLINE_SHOVEL, ModItems.JURASSOLINE_HOE, ModItems.JURASSOLINE_SICKLE, ModItems.JURASSOLINE_FORGING_HAMMER, ModItems.JURASSOLINE_HELMET, ModItems.JURASSOLINE_CHESTPLATE, ModItems.JURASSOLINE_LEGGINGS, ModItems.JURASSOLINE_BOOTS), class_7800.field_40642, ModItems.JURASSOLINE_NUGGET, 0.7f, 400, "jurassoline_nugget");

        class_2447.method_10437(class_7800.field_40642, ModItems.JURASSOLINE_SWORD)
                .method_10439("#")
                .method_10439("#")
                .method_10439("I")
                .method_10434('#', ModItems.JURASSOLINE_INGOT)
                .method_10434('I', ModItems.FOSSILIZED_BONE)
                .method_10429(method_32807(ModItems.JURASSOLINE_INGOT), method_10426(ModItems.JURASSOLINE_INGOT))
                .method_10429(method_32807(ModItems.FOSSILIZED_BONE), method_10426(ModItems.FOSSILIZED_BONE))
                .method_17972(exporter, new class_2960(method_36450(ModItems.JURASSOLINE_SWORD)));

        class_2447.method_10437(class_7800.field_40642, ModItems.JURASSOLINE_PICKAXE)
                .method_10439("###")
                .method_10439(" I ")
                .method_10439(" I ")
                .method_10434('#', ModItems.JURASSOLINE_INGOT)
                .method_10434('I', ModItems.FOSSILIZED_BONE)
                .method_10429(method_32807(ModItems.JURASSOLINE_INGOT), method_10426(ModItems.JURASSOLINE_INGOT))
                .method_10429(method_32807(ModItems.FOSSILIZED_BONE), method_10426(ModItems.FOSSILIZED_BONE))
                .method_17972(exporter, new class_2960(method_36450(ModItems.JURASSOLINE_PICKAXE)));

        class_2447.method_10437(class_7800.field_40642, ModItems.JURASSOLINE_SHOVEL)
                .method_10439("#")
                .method_10439("I")
                .method_10439("I")
                .method_10434('#', ModItems.JURASSOLINE_INGOT)
                .method_10434('I', ModItems.FOSSILIZED_BONE)
                .method_10429(method_32807(ModItems.JURASSOLINE_INGOT), method_10426(ModItems.JURASSOLINE_INGOT))
                .method_10429(method_32807(ModItems.FOSSILIZED_BONE), method_10426(ModItems.FOSSILIZED_BONE))
                .method_17972(exporter, new class_2960(method_36450(ModItems.JURASSOLINE_SHOVEL)));

        class_2447.method_10437(class_7800.field_40642, ModItems.JURASSOLINE_AXE)
                .method_10439("##")
                .method_10439("#I")
                .method_10439(" I")
                .method_10434('#', ModItems.JURASSOLINE_INGOT)
                .method_10434('I', ModItems.FOSSILIZED_BONE)
                .method_10429(method_32807(ModItems.JURASSOLINE_INGOT), method_10426(ModItems.JURASSOLINE_INGOT))
                .method_10429(method_32807(ModItems.FOSSILIZED_BONE), method_10426(ModItems.FOSSILIZED_BONE))
                .method_10435(ModItems.JURASSOLINE_AXE.toString())
                .method_17972(exporter, new class_2960(method_36450(ModItems.JURASSOLINE_AXE)));

        class_2447.method_10437(class_7800.field_40642, ModItems.JURASSOLINE_AXE)
                .method_10439("##")
                .method_10439("I#")
                .method_10439("I ")
                .method_10434('#', ModItems.JURASSOLINE_INGOT)
                .method_10434('I', ModItems.FOSSILIZED_BONE)
                .method_10429(method_32807(ModItems.JURASSOLINE_INGOT), method_10426(ModItems.JURASSOLINE_INGOT))
                .method_10429(method_32807(ModItems.FOSSILIZED_BONE), method_10426(ModItems.FOSSILIZED_BONE))
                .method_10435(ModItems.JURASSOLINE_AXE.toString())
                .method_17972(exporter, new class_2960(method_36450(ModItems.JURASSOLINE_AXE) + "2"));

        class_2447.method_10437(class_7800.field_40642, ModItems.JURASSOLINE_HOE)
                .method_10439("##")
                .method_10439(" I")
                .method_10439(" I")
                .method_10434('#', ModItems.JURASSOLINE_INGOT)
                .method_10434('I', ModItems.FOSSILIZED_BONE)
                .method_10429(method_32807(ModItems.JURASSOLINE_INGOT), method_10426(ModItems.JURASSOLINE_INGOT))
                .method_10429(method_32807(ModItems.FOSSILIZED_BONE), method_10426(ModItems.FOSSILIZED_BONE))
                .method_10435(ModItems.JURASSOLINE_HOE.toString())
                .method_17972(exporter, new class_2960(method_36450(ModItems.JURASSOLINE_HOE)));

        class_2447.method_10437(class_7800.field_40642, ModItems.JURASSOLINE_HOE)
                .method_10439("##")
                .method_10439("I ")
                .method_10439("I ")
                .method_10434('#', ModItems.JURASSOLINE_INGOT)
                .method_10434('I', ModItems.FOSSILIZED_BONE)
                .method_10429(method_32807(ModItems.JURASSOLINE_INGOT), method_10426(ModItems.JURASSOLINE_INGOT))
                .method_10429(method_32807(ModItems.FOSSILIZED_BONE), method_10426(ModItems.FOSSILIZED_BONE))
                .method_10435(ModItems.JURASSOLINE_HOE.toString())
                .method_17972(exporter, new class_2960(method_36450(ModItems.JURASSOLINE_HOE) + "2"));

        class_2447.method_10437(class_7800.field_40642, ModItems.JURASSOLINE_SICKLE)
                .method_10439(" #")
                .method_10439("I ")
                .method_10434('#', ModItems.JURASSOLINE_INGOT)
                .method_10434('I', ModItems.FOSSILIZED_BONE)
                .method_10429(method_32807(ModItems.JURASSOLINE_INGOT), method_10426(ModItems.JURASSOLINE_INGOT))
                .method_10429(method_32807(ModItems.FOSSILIZED_BONE), method_10426(ModItems.FOSSILIZED_BONE))
                .method_17972(exporter, new class_2960(method_36450(ModItems.JURASSOLINE_SICKLE)));

        class_2447.method_10437(class_7800.field_40642, ModItems.JURASSOLINE_FORGING_HAMMER)
                .method_10439("#")
                .method_10439("I")
                .method_10434('#', ModItems.JURASSOLINE_INGOT)
                .method_10434('I', ModItems.FOSSILIZED_BONE)
                .method_10429(method_32807(ModItems.JURASSOLINE_INGOT), method_10426(ModItems.JURASSOLINE_INGOT))
                .method_10429(method_32807(ModItems.FOSSILIZED_BONE), method_10426(ModItems.FOSSILIZED_BONE))
                .method_17972(exporter, new class_2960(method_36450(ModItems.JURASSOLINE_FORGING_HAMMER)));

        class_2447.method_10437(class_7800.field_40642, ModItems.JURASSOLINE_HELMET)
                .method_10439("###")
                .method_10439("# #")
                .method_10434('#', ModItems.JURASSOLINE_INGOT)
                .method_10429(method_32807(ModItems.JURASSOLINE_INGOT), method_10426(ModItems.JURASSOLINE_INGOT))
                .method_17972(exporter, new class_2960(method_36450(ModItems.JURASSOLINE_HELMET)));

        class_2447.method_10437(class_7800.field_40642, ModItems.JURASSOLINE_CHESTPLATE)
                .method_10439("# #")
                .method_10439("###")
                .method_10439("###")
                .method_10434('#', ModItems.JURASSOLINE_INGOT)
                .method_10429(method_32807(ModItems.JURASSOLINE_INGOT), method_10426(ModItems.JURASSOLINE_INGOT))
                .method_17972(exporter, new class_2960(method_36450(ModItems.JURASSOLINE_CHESTPLATE)));

        class_2447.method_10437(class_7800.field_40642, ModItems.JURASSOLINE_LEGGINGS)
                .method_10439("###")
                .method_10439("# #")
                .method_10439("# #")
                .method_10434('#', ModItems.JURASSOLINE_INGOT)
                .method_10429(method_32807(ModItems.JURASSOLINE_INGOT), method_10426(ModItems.JURASSOLINE_INGOT))
                .method_17972(exporter, new class_2960(method_36450(ModItems.JURASSOLINE_LEGGINGS)));

        class_2447.method_10437(class_7800.field_40642, ModItems.JURASSOLINE_BOOTS)
                .method_10439("# #")
                .method_10439("# #")
                .method_10434('#', ModItems.JURASSOLINE_INGOT)
                .method_10429(method_32807(ModItems.JURASSOLINE_INGOT), method_10426(ModItems.JURASSOLINE_INGOT))
                .method_17972(exporter, new class_2960(method_36450(ModItems.JURASSOLINE_BOOTS)));

        method_36234(exporter, CINNABAR_BLASTABLES, class_7800.field_40642, ModItems.CINNABAR_INGOT, 0.7f, 200, "cinnabar_ingot");

        method_36325(exporter, class_7800.field_40642, ModItems.CINNABAR_CRYSTAL, class_7800.field_40634, ModBlocks.CINNABAR_CRYSTAL_BLOCK);
        offerReversibleNuggetCompactingRecipes(exporter, class_7800.field_40642, ModItems.CINNABAR_NUGGET, class_7800.field_40642, ModItems.CINNABAR_INGOT);
        method_36325(exporter, class_7800.field_40642, ModItems.CINNABAR_INGOT, class_7800.field_40634, ModBlocks.CINNABAR_BLOCK);

        method_36234(exporter, List.of(ModItems.CINNABAR_SWORD, ModItems.CINNABAR_PICKAXE, ModItems.CINNABAR_AXE, ModItems.CINNABAR_SHOVEL, ModItems.CINNABAR_HOE, ModItems.CINNABAR_SICKLE, ModItems.CINNABAR_FORGING_HAMMER, ModItems.CINNABAR_HELMET, ModItems.CINNABAR_CHESTPLATE, ModItems.CINNABAR_LEGGINGS, ModItems.CINNABAR_BOOTS), class_7800.field_40642, ModItems.CINNABAR_NUGGET, 0.7f, 400, "cinnabar_nugget");

        class_2447.method_10437(class_7800.field_40642, ModItems.CINNABAR_SWORD)
                .method_10439("#")
                .method_10439("#")
                .method_10439("I")
                .method_10434('#', ModItems.CINNABAR_INGOT)
                .method_10434('I', ModItems.REINFORCED_TOOL_ROD)
                .method_10429(method_32807(ModItems.CINNABAR_INGOT), method_10426(ModItems.CINNABAR_INGOT))
                .method_10429(method_32807(ModItems.REINFORCED_TOOL_ROD), method_10426(ModItems.REINFORCED_TOOL_ROD))
                .method_17972(exporter, new class_2960(method_36450(ModItems.CINNABAR_SWORD)));

        class_2447.method_10437(class_7800.field_40642, ModItems.CINNABAR_PICKAXE)
                .method_10439("###")
                .method_10439(" I ")
                .method_10439(" I ")
                .method_10434('#', ModItems.CINNABAR_INGOT)
                .method_10434('I', ModItems.REINFORCED_TOOL_ROD)
                .method_10429(method_32807(ModItems.CINNABAR_INGOT), method_10426(ModItems.CINNABAR_INGOT))
                .method_10429(method_32807(ModItems.REINFORCED_TOOL_ROD), method_10426(ModItems.REINFORCED_TOOL_ROD))
                .method_17972(exporter, new class_2960(method_36450(ModItems.CINNABAR_PICKAXE)));

        class_2447.method_10437(class_7800.field_40642, ModItems.CINNABAR_SHOVEL)
                .method_10439("#")
                .method_10439("I")
                .method_10439("I")
                .method_10434('#', ModItems.CINNABAR_INGOT)
                .method_10434('I', ModItems.REINFORCED_TOOL_ROD)
                .method_10429(method_32807(ModItems.CINNABAR_INGOT), method_10426(ModItems.CINNABAR_INGOT))
                .method_10429(method_32807(ModItems.REINFORCED_TOOL_ROD), method_10426(ModItems.REINFORCED_TOOL_ROD))
                .method_17972(exporter, new class_2960(method_36450(ModItems.CINNABAR_SHOVEL)));

        class_2447.method_10437(class_7800.field_40642, ModItems.CINNABAR_AXE)
                .method_10439("##")
                .method_10439("#I")
                .method_10439(" I")
                .method_10434('#', ModItems.CINNABAR_INGOT)
                .method_10434('I', ModItems.REINFORCED_TOOL_ROD)
                .method_10429(method_32807(ModItems.CINNABAR_INGOT), method_10426(ModItems.CINNABAR_INGOT))
                .method_10429(method_32807(ModItems.REINFORCED_TOOL_ROD), method_10426(ModItems.REINFORCED_TOOL_ROD))
                .method_10435(ModItems.CINNABAR_AXE.toString())
                .method_17972(exporter, new class_2960(method_36450(ModItems.CINNABAR_AXE)));

        class_2447.method_10437(class_7800.field_40642, ModItems.CINNABAR_AXE)
                .method_10439("##")
                .method_10439("I#")
                .method_10439("I ")
                .method_10434('#', ModItems.CINNABAR_INGOT)
                .method_10434('I', ModItems.REINFORCED_TOOL_ROD)
                .method_10429(method_32807(ModItems.CINNABAR_INGOT), method_10426(ModItems.CINNABAR_INGOT))
                .method_10429(method_32807(ModItems.REINFORCED_TOOL_ROD), method_10426(ModItems.REINFORCED_TOOL_ROD))
                .method_10435(ModItems.CINNABAR_AXE.toString())
                .method_17972(exporter, new class_2960(method_36450(ModItems.CINNABAR_AXE) + "2"));

        class_2447.method_10437(class_7800.field_40642, ModItems.CINNABAR_HOE)
                .method_10439("##")
                .method_10439(" I")
                .method_10439(" I")
                .method_10434('#', ModItems.CINNABAR_INGOT)
                .method_10434('I', ModItems.REINFORCED_TOOL_ROD)
                .method_10429(method_32807(ModItems.CINNABAR_INGOT), method_10426(ModItems.CINNABAR_INGOT))
                .method_10429(method_32807(ModItems.REINFORCED_TOOL_ROD), method_10426(ModItems.REINFORCED_TOOL_ROD))
                .method_10435(ModItems.CINNABAR_HOE.toString())
                .method_17972(exporter, new class_2960(method_36450(ModItems.CINNABAR_HOE)));

        class_2447.method_10437(class_7800.field_40642, ModItems.CINNABAR_HOE)
                .method_10439("##")
                .method_10439("I ")
                .method_10439("I ")
                .method_10434('#', ModItems.CINNABAR_INGOT)
                .method_10434('I', ModItems.REINFORCED_TOOL_ROD)
                .method_10429(method_32807(ModItems.CINNABAR_INGOT), method_10426(ModItems.CINNABAR_INGOT))
                .method_10429(method_32807(ModItems.REINFORCED_TOOL_ROD), method_10426(ModItems.REINFORCED_TOOL_ROD))
                .method_10435(ModItems.CINNABAR_HOE.toString())
                .method_17972(exporter, new class_2960(method_36450(ModItems.CINNABAR_HOE) + "2"));

        class_2447.method_10437(class_7800.field_40642, ModItems.CINNABAR_SICKLE)
                .method_10439(" #")
                .method_10439("I ")
                .method_10434('#', ModItems.CINNABAR_INGOT)
                .method_10434('I', ModItems.REINFORCED_TOOL_ROD)
                .method_10429(method_32807(ModItems.CINNABAR_INGOT), method_10426(ModItems.CINNABAR_INGOT))
                .method_10429(method_32807(ModItems.REINFORCED_TOOL_ROD), method_10426(ModItems.REINFORCED_TOOL_ROD))
                .method_17972(exporter, new class_2960(method_36450(ModItems.CINNABAR_SICKLE)));

        class_2447.method_10437(class_7800.field_40642, ModItems.CINNABAR_FORGING_HAMMER)
                .method_10439("#")
                .method_10439("I")
                .method_10434('#', ModItems.CINNABAR_INGOT)
                .method_10434('I', ModItems.REINFORCED_TOOL_ROD)
                .method_10429(method_32807(ModItems.CINNABAR_INGOT), method_10426(ModItems.CINNABAR_INGOT))
                .method_10429(method_32807(ModItems.REINFORCED_TOOL_ROD), method_10426(ModItems.REINFORCED_TOOL_ROD))
                .method_17972(exporter, new class_2960(method_36450(ModItems.CINNABAR_FORGING_HAMMER)));

        class_2447.method_10437(class_7800.field_40642, ModItems.CINNABAR_HELMET)
                .method_10439("###")
                .method_10439("# #")
                .method_10434('#', ModItems.CINNABAR_INGOT)
                .method_10429(method_32807(ModItems.CINNABAR_INGOT), method_10426(ModItems.CINNABAR_INGOT))
                .method_17972(exporter, new class_2960(method_36450(ModItems.CINNABAR_HELMET)));

        class_2447.method_10437(class_7800.field_40642, ModItems.CINNABAR_CHESTPLATE)
                .method_10439("# #")
                .method_10439("###")
                .method_10439("###")
                .method_10434('#', ModItems.CINNABAR_INGOT)
                .method_10429(method_32807(ModItems.CINNABAR_INGOT), method_10426(ModItems.CINNABAR_INGOT))
                .method_17972(exporter, new class_2960(method_36450(ModItems.CINNABAR_CHESTPLATE)));

        class_2447.method_10437(class_7800.field_40642, ModItems.CINNABAR_LEGGINGS)
                .method_10439("###")
                .method_10439("# #")
                .method_10439("# #")
                .method_10434('#', ModItems.CINNABAR_INGOT)
                .method_10429(method_32807(ModItems.CINNABAR_INGOT), method_10426(ModItems.CINNABAR_INGOT))
                .method_17972(exporter, new class_2960(method_36450(ModItems.CINNABAR_LEGGINGS)));

        class_2447.method_10437(class_7800.field_40642, ModItems.CINNABAR_BOOTS)
                .method_10439("# #")
                .method_10439("# #")
                .method_10434('#', ModItems.CINNABAR_INGOT)
                .method_10429(method_32807(ModItems.CINNABAR_INGOT), method_10426(ModItems.CINNABAR_INGOT))
                .method_17972(exporter, new class_2960(method_36450(ModItems.CINNABAR_BOOTS)));

        method_36234(exporter, NEBULAR_BLASTABLES, class_7800.field_40642, ModItems.NEBULAR_INGOT, 0.7f, 200, "nebular_ingot");

        method_36325(exporter, class_7800.field_40642, ModItems.NEBULAR_CRYSTAL, class_7800.field_40634, ModBlocks.RAW_NEBULAR_BLOCK);
        offerReversibleNuggetCompactingRecipes(exporter, class_7800.field_40642, ModItems.NEBULAR_NUGGET, class_7800.field_40642, ModItems.NEBULAR_INGOT);
        method_36325(exporter, class_7800.field_40642, ModItems.NEBULAR_INGOT, class_7800.field_40634, ModBlocks.NEBULAR_BLOCK);

        method_36234(exporter, List.of(ModItems.NEBULAR_SWORD, ModItems.NEBULAR_PICKAXE, ModItems.NEBULAR_AXE, ModItems.NEBULAR_SHOVEL, ModItems.NEBULAR_HOE, ModItems.NEBULAR_SICKLE, ModItems.NEBULAR_FORGING_HAMMER, ModItems.NEBULAR_HELMET, ModItems.NEBULAR_CHESTPLATE, ModItems.NEBULAR_LEGGINGS, ModItems.NEBULAR_BOOTS), class_7800.field_40642, ModItems.NEBULAR_NUGGET, 0.7f, 400, "nebular_nugget");

        class_2447.method_10437(class_7800.field_40642, ModItems.NEBULAR_SWORD)
                .method_10439("#")
                .method_10439("#")
                .method_10439("I")
                .method_10434('#', ModItems.NEBULAR_INGOT)
                .method_10434('I', ModItems.REINFORCED_TOOL_ROD)
                .method_10429(method_32807(ModItems.NEBULAR_INGOT), method_10426(ModItems.NEBULAR_INGOT))
                .method_10429(method_32807(ModItems.REINFORCED_TOOL_ROD), method_10426(ModItems.REINFORCED_TOOL_ROD))
                .method_17972(exporter, new class_2960(method_36450(ModItems.NEBULAR_SWORD)));

        class_2447.method_10437(class_7800.field_40642, ModItems.NEBULAR_PICKAXE)
                .method_10439("###")
                .method_10439(" I ")
                .method_10439(" I ")
                .method_10434('#', ModItems.NEBULAR_INGOT)
                .method_10434('I', ModItems.REINFORCED_TOOL_ROD)
                .method_10429(method_32807(ModItems.NEBULAR_INGOT), method_10426(ModItems.NEBULAR_INGOT))
                .method_10429(method_32807(ModItems.REINFORCED_TOOL_ROD), method_10426(ModItems.REINFORCED_TOOL_ROD))
                .method_17972(exporter, new class_2960(method_36450(ModItems.NEBULAR_PICKAXE)));

        class_2447.method_10437(class_7800.field_40642, ModItems.NEBULAR_SHOVEL)
                .method_10439("#")
                .method_10439("I")
                .method_10439("I")
                .method_10434('#', ModItems.NEBULAR_INGOT)
                .method_10434('I', ModItems.REINFORCED_TOOL_ROD)
                .method_10429(method_32807(ModItems.NEBULAR_INGOT), method_10426(ModItems.NEBULAR_INGOT))
                .method_10429(method_32807(ModItems.REINFORCED_TOOL_ROD), method_10426(ModItems.REINFORCED_TOOL_ROD))
                .method_17972(exporter, new class_2960(method_36450(ModItems.NEBULAR_SHOVEL)));

        class_2447.method_10437(class_7800.field_40642, ModItems.NEBULAR_AXE)
                .method_10439("##")
                .method_10439("#I")
                .method_10439(" I")
                .method_10434('#', ModItems.NEBULAR_INGOT)
                .method_10434('I', ModItems.REINFORCED_TOOL_ROD)
                .method_10429(method_32807(ModItems.NEBULAR_INGOT), method_10426(ModItems.NEBULAR_INGOT))
                .method_10429(method_32807(ModItems.REINFORCED_TOOL_ROD), method_10426(ModItems.REINFORCED_TOOL_ROD))
                .method_10435(ModItems.NEBULAR_AXE.toString())
                .method_17972(exporter, new class_2960(method_36450(ModItems.NEBULAR_AXE)));

        class_2447.method_10437(class_7800.field_40642, ModItems.NEBULAR_AXE)
                .method_10439("##")
                .method_10439("I#")
                .method_10439("I ")
                .method_10434('#', ModItems.NEBULAR_INGOT)
                .method_10434('I', ModItems.REINFORCED_TOOL_ROD)
                .method_10429(method_32807(ModItems.NEBULAR_INGOT), method_10426(ModItems.NEBULAR_INGOT))
                .method_10429(method_32807(ModItems.REINFORCED_TOOL_ROD), method_10426(ModItems.REINFORCED_TOOL_ROD))
                .method_10435(ModItems.NEBULAR_AXE.toString())
                .method_17972(exporter, new class_2960(method_36450(ModItems.NEBULAR_AXE) + "2"));

        class_2447.method_10437(class_7800.field_40642, ModItems.NEBULAR_HOE)
                .method_10439("##")
                .method_10439(" I")
                .method_10439(" I")
                .method_10434('#', ModItems.NEBULAR_INGOT)
                .method_10434('I', ModItems.REINFORCED_TOOL_ROD)
                .method_10429(method_32807(ModItems.NEBULAR_INGOT), method_10426(ModItems.NEBULAR_INGOT))
                .method_10429(method_32807(ModItems.REINFORCED_TOOL_ROD), method_10426(ModItems.REINFORCED_TOOL_ROD))
                .method_10435(ModItems.NEBULAR_HOE.toString())
                .method_17972(exporter, new class_2960(method_36450(ModItems.NEBULAR_HOE)));

        class_2447.method_10437(class_7800.field_40642, ModItems.NEBULAR_HOE)
                .method_10439("##")
                .method_10439("I ")
                .method_10439("I ")
                .method_10434('#', ModItems.NEBULAR_INGOT)
                .method_10434('I', ModItems.REINFORCED_TOOL_ROD)
                .method_10429(method_32807(ModItems.NEBULAR_INGOT), method_10426(ModItems.NEBULAR_INGOT))
                .method_10429(method_32807(ModItems.REINFORCED_TOOL_ROD), method_10426(ModItems.REINFORCED_TOOL_ROD))
                .method_10435(ModItems.NEBULAR_HOE.toString())
                .method_17972(exporter, new class_2960(method_36450(ModItems.NEBULAR_HOE) + "2"));

        class_2447.method_10437(class_7800.field_40642, ModItems.NEBULAR_SICKLE)
                .method_10439(" #")
                .method_10439("I ")
                .method_10434('#', ModItems.NEBULAR_INGOT)
                .method_10434('I', ModItems.REINFORCED_TOOL_ROD)
                .method_10429(method_32807(ModItems.NEBULAR_INGOT), method_10426(ModItems.NEBULAR_INGOT))
                .method_10429(method_32807(ModItems.REINFORCED_TOOL_ROD), method_10426(ModItems.REINFORCED_TOOL_ROD))
                .method_17972(exporter, new class_2960(method_36450(ModItems.NEBULAR_SICKLE)));

        class_2447.method_10437(class_7800.field_40642, ModItems.NEBULAR_FORGING_HAMMER)
                .method_10439("#")
                .method_10439("I")
                .method_10434('#', ModItems.NEBULAR_INGOT)
                .method_10434('I', ModItems.REINFORCED_TOOL_ROD)
                .method_10429(method_32807(ModItems.NEBULAR_INGOT), method_10426(ModItems.NEBULAR_INGOT))
                .method_10429(method_32807(ModItems.REINFORCED_TOOL_ROD), method_10426(ModItems.REINFORCED_TOOL_ROD))
                .method_17972(exporter, new class_2960(method_36450(ModItems.NEBULAR_FORGING_HAMMER)));

        class_2447.method_10437(class_7800.field_40642, ModItems.NEBULAR_HELMET)
                .method_10439("###")
                .method_10439("# #")
                .method_10434('#', ModItems.NEBULAR_INGOT)
                .method_10429(method_32807(ModItems.NEBULAR_INGOT), method_10426(ModItems.NEBULAR_INGOT))
                .method_17972(exporter, new class_2960(method_36450(ModItems.NEBULAR_HELMET)));

        class_2447.method_10437(class_7800.field_40642, ModItems.NEBULAR_CHESTPLATE)
                .method_10439("# #")
                .method_10439("###")
                .method_10439("###")
                .method_10434('#', ModItems.NEBULAR_INGOT)
                .method_10429(method_32807(ModItems.NEBULAR_INGOT), method_10426(ModItems.NEBULAR_INGOT))
                .method_17972(exporter, new class_2960(method_36450(ModItems.NEBULAR_CHESTPLATE)));

        class_2447.method_10437(class_7800.field_40642, ModItems.NEBULAR_LEGGINGS)
                .method_10439("###")
                .method_10439("# #")
                .method_10439("# #")
                .method_10434('#', ModItems.NEBULAR_INGOT)
                .method_10429(method_32807(ModItems.NEBULAR_INGOT), method_10426(ModItems.NEBULAR_INGOT))
                .method_17972(exporter, new class_2960(method_36450(ModItems.NEBULAR_LEGGINGS)));

        class_2447.method_10437(class_7800.field_40642, ModItems.NEBULAR_BOOTS)
                .method_10439("# #")
                .method_10439("# #")
                .method_10434('#', ModItems.NEBULAR_INGOT)
                .method_10429(method_32807(ModItems.NEBULAR_INGOT), method_10426(ModItems.NEBULAR_INGOT))
                .method_17972(exporter, new class_2960(method_36450(ModItems.NEBULAR_BOOTS)));

        class_2450.method_10447(class_7800.field_40642, ModItems.REINFORCED_TOOL_ROD)
                .method_10446(class_6862.method_40092(class_7924.field_41197, new class_2960("c", "steel_rods")))
                .method_10454(class_1802.field_22021)
                .method_10442(method_32807(ModItems.STEEL_ROD), method_10426(ModItems.STEEL_ROD))
                .method_10442(method_32807(class_1802.field_22021), method_10426(class_1802.field_22021))
                .method_17972(exporter, new class_2960(method_36450(ModItems.REINFORCED_TOOL_ROD)));

        class_2450.method_10447(class_7800.field_40642, ModItems.FANCY_TOOL_ROD)
                .method_10454(class_1802.field_8477)
                .method_10454(ModItems.REINFORCED_TOOL_ROD)
                .method_10454(class_1802.field_8695)
                .method_10442(method_32807(class_1802.field_8477), method_10426(class_1802.field_8477))
                .method_10442(method_32807(ModItems.REINFORCED_TOOL_ROD), method_10426(ModItems.REINFORCED_TOOL_ROD))
                .method_10442(method_32807(class_1802.field_8695), method_10426(class_1802.field_8695))
                .method_17972(exporter, new class_2960(method_36450(ModItems.FANCY_TOOL_ROD)));

        method_36234(exporter, MITHRIL_BLASTABLES, class_7800.field_40642, ModItems.MITHRIL_INGOT, 1.0f, 400, "mithril_ingot");
        method_36234(exporter, List.of(ModBlocks.RAW_MITHRIL_BLOCK), class_7800.field_40642, ModBlocks.MITHRIL_BLOCK, 1.0f, 400, "mithril_block");

        method_36325(exporter, class_7800.field_40642, ModItems.RAW_MITHRIL, class_7800.field_40634, ModBlocks.RAW_MITHRIL_BLOCK);
        offerReversibleNuggetCompactingRecipes(exporter, class_7800.field_40642, ModItems.MITHRIL_NUGGET, class_7800.field_40642, ModItems.MITHRIL_INGOT);
        method_36325(exporter, class_7800.field_40642, ModItems.MITHRIL_INGOT, class_7800.field_40634, ModBlocks.MITHRIL_BLOCK);

        method_36234(exporter, List.of(ModItems.MITHRIL_SWORD, ModItems.MITHRIL_PICKAXE, ModItems.MITHRIL_AXE, ModItems.MITHRIL_SHOVEL, ModItems.MITHRIL_HOE, ModItems.MITHRIL_SICKLE, ModItems.MITHRIL_FORGING_HAMMER, ModItems.MITHRIL_HELMET, ModItems.MITHRIL_CHESTPLATE, ModItems.MITHRIL_LEGGINGS, ModItems.MITHRIL_BOOTS), class_7800.field_40642, ModItems.MITHRIL_NUGGET, 0.7f, 400, "mithril_nugget");

        class_2447.method_10437(class_7800.field_40642, ModItems.MITHRIL_SWORD)
                .method_10439("#")
                .method_10439("#")
                .method_10439("I")
                .method_10434('#', ModItems.MITHRIL_INGOT)
                .method_10434('I', ModItems.FANCY_TOOL_ROD)
                .method_10429(method_32807(ModItems.MITHRIL_INGOT), method_10426(ModItems.MITHRIL_INGOT))
                .method_10429(method_32807(ModItems.FANCY_TOOL_ROD), method_10426(ModItems.FANCY_TOOL_ROD))
                .method_17972(exporter, new class_2960(method_36450(ModItems.MITHRIL_SWORD)));

        class_2447.method_10437(class_7800.field_40642, ModItems.MITHRIL_PICKAXE)
                .method_10439("###")
                .method_10439(" I ")
                .method_10439(" I ")
                .method_10434('#', ModItems.MITHRIL_INGOT)
                .method_10434('I', ModItems.FANCY_TOOL_ROD)
                .method_10429(method_32807(ModItems.MITHRIL_INGOT), method_10426(ModItems.MITHRIL_INGOT))
                .method_10429(method_32807(ModItems.FANCY_TOOL_ROD), method_10426(ModItems.FANCY_TOOL_ROD))
                .method_17972(exporter, new class_2960(method_36450(ModItems.MITHRIL_PICKAXE)));

        class_2447.method_10437(class_7800.field_40642, ModItems.MITHRIL_SHOVEL)
                .method_10439("#")
                .method_10439("I")
                .method_10439("I")
                .method_10434('#', ModItems.MITHRIL_INGOT)
                .method_10434('I', ModItems.FANCY_TOOL_ROD)
                .method_10429(method_32807(ModItems.MITHRIL_INGOT), method_10426(ModItems.MITHRIL_INGOT))
                .method_10429(method_32807(ModItems.FANCY_TOOL_ROD), method_10426(ModItems.FANCY_TOOL_ROD))
                .method_17972(exporter, new class_2960(method_36450(ModItems.MITHRIL_SHOVEL)));

        class_2447.method_10437(class_7800.field_40642, ModItems.MITHRIL_AXE)
                .method_10439("##")
                .method_10439("#I")
                .method_10439(" I")
                .method_10434('#', ModItems.MITHRIL_INGOT)
                .method_10434('I', ModItems.FANCY_TOOL_ROD)
                .method_10429(method_32807(ModItems.MITHRIL_INGOT), method_10426(ModItems.MITHRIL_INGOT))
                .method_10429(method_32807(ModItems.FANCY_TOOL_ROD), method_10426(ModItems.FANCY_TOOL_ROD))
                .method_10435(ModItems.MITHRIL_AXE.toString())
                .method_17972(exporter, new class_2960(method_36450(ModItems.MITHRIL_AXE)));

        class_2447.method_10437(class_7800.field_40642, ModItems.MITHRIL_AXE)
                .method_10439("##")
                .method_10439("I#")
                .method_10439("I ")
                .method_10434('#', ModItems.MITHRIL_INGOT)
                .method_10434('I', ModItems.FANCY_TOOL_ROD)
                .method_10429(method_32807(ModItems.MITHRIL_INGOT), method_10426(ModItems.MITHRIL_INGOT))
                .method_10429(method_32807(ModItems.FANCY_TOOL_ROD), method_10426(ModItems.FANCY_TOOL_ROD))
                .method_10435(ModItems.MITHRIL_AXE.toString())
                .method_17972(exporter, new class_2960(method_36450(ModItems.MITHRIL_AXE) + "2"));

        class_2447.method_10437(class_7800.field_40642, ModItems.MITHRIL_HOE)
                .method_10439("##")
                .method_10439(" I")
                .method_10439(" I")
                .method_10434('#', ModItems.MITHRIL_INGOT)
                .method_10434('I', ModItems.FANCY_TOOL_ROD)
                .method_10429(method_32807(ModItems.MITHRIL_INGOT), method_10426(ModItems.MITHRIL_INGOT))
                .method_10429(method_32807(ModItems.FANCY_TOOL_ROD), method_10426(ModItems.FANCY_TOOL_ROD))
                .method_10435(ModItems.MITHRIL_HOE.toString())
                .method_17972(exporter, new class_2960(method_36450(ModItems.MITHRIL_HOE)));

        class_2447.method_10437(class_7800.field_40642, ModItems.MITHRIL_HOE)
                .method_10439("##")
                .method_10439("I ")
                .method_10439("I ")
                .method_10434('#', ModItems.MITHRIL_INGOT)
                .method_10434('I', ModItems.FANCY_TOOL_ROD)
                .method_10429(method_32807(ModItems.MITHRIL_INGOT), method_10426(ModItems.MITHRIL_INGOT))
                .method_10429(method_32807(ModItems.FANCY_TOOL_ROD), method_10426(ModItems.FANCY_TOOL_ROD))
                .method_10435(ModItems.MITHRIL_HOE.toString())
                .method_17972(exporter, new class_2960(method_36450(ModItems.MITHRIL_HOE) + "2"));

        class_2447.method_10437(class_7800.field_40642, ModItems.MITHRIL_FORGING_HAMMER)
                .method_10439("#")
                .method_10439("I")
                .method_10434('#', ModItems.MITHRIL_INGOT)
                .method_10434('I', ModItems.FANCY_TOOL_ROD)
                .method_10429(method_32807(ModItems.MITHRIL_INGOT), method_10426(ModItems.MITHRIL_INGOT))
                .method_10429(method_32807(ModItems.FANCY_TOOL_ROD), method_10426(ModItems.FANCY_TOOL_ROD))
                .method_17972(exporter, new class_2960(method_36450(ModItems.MITHRIL_FORGING_HAMMER)));

        class_2447.method_10437(class_7800.field_40642, ModItems.MITHRIL_STAR_CATCHER)
                .method_10439("  #")
                .method_10439(" I ")
                .method_10439("I  ")
                .method_10434('#', ModItems.MITHRIL_INGOT)
                .method_10434('I', ModItems.FANCY_TOOL_ROD)
                .method_10429(method_32807(ModItems.MITHRIL_INGOT), method_10426(ModItems.MITHRIL_INGOT))
                .method_10429(method_32807(ModItems.FANCY_TOOL_ROD), method_10426(ModItems.FANCY_TOOL_ROD))
                .method_17972(exporter, new class_2960(method_36450(ModItems.MITHRIL_STAR_CATCHER)));

        class_2447.method_10437(class_7800.field_40642, ModItems.MITHRIL_SICKLE)
                .method_10439(" #")
                .method_10439("I ")
                .method_10434('#', ModItems.MITHRIL_INGOT)
                .method_10434('I', ModItems.FANCY_TOOL_ROD)
                .method_10429(method_32807(ModItems.MITHRIL_INGOT), method_10426(ModItems.MITHRIL_INGOT))
                .method_10429(method_32807(ModItems.FANCY_TOOL_ROD), method_10426(ModItems.FANCY_TOOL_ROD))
                .method_17972(exporter, new class_2960(method_36450(ModItems.MITHRIL_SICKLE)));

        class_2447.method_10437(class_7800.field_40642, ModItems.MITHRIL_HELMET)
                .method_10439("###")
                .method_10439("# #")
                .method_10434('#', ModItems.MITHRIL_INGOT)
                .method_10429(method_32807(ModItems.MITHRIL_INGOT), method_10426(ModItems.MITHRIL_INGOT))
                .method_17972(exporter, new class_2960(method_36450(ModItems.MITHRIL_HELMET)));

        class_2447.method_10437(class_7800.field_40642, ModItems.MITHRIL_CHESTPLATE)
                .method_10439("# #")
                .method_10439("###")
                .method_10439("###")
                .method_10434('#', ModItems.MITHRIL_INGOT)
                .method_10429(method_32807(ModItems.MITHRIL_INGOT), method_10426(ModItems.MITHRIL_INGOT))
                .method_17972(exporter, new class_2960(method_36450(ModItems.MITHRIL_CHESTPLATE)));

        class_2447.method_10437(class_7800.field_40642, ModItems.MITHRIL_LEGGINGS)
                .method_10439("###")
                .method_10439("# #")
                .method_10439("# #")
                .method_10434('#', ModItems.MITHRIL_INGOT)
                .method_10429(method_32807(ModItems.MITHRIL_INGOT), method_10426(ModItems.MITHRIL_INGOT))
                .method_17972(exporter, new class_2960(method_36450(ModItems.MITHRIL_LEGGINGS)));

        class_2447.method_10437(class_7800.field_40642, ModItems.MITHRIL_BOOTS)
                .method_10439("# #")
                .method_10439("# #")
                .method_10434('#', ModItems.MITHRIL_INGOT)
                .method_10429(method_32807(ModItems.MITHRIL_INGOT), method_10426(ModItems.MITHRIL_INGOT))
                .method_17972(exporter, new class_2960(method_36450(ModItems.MITHRIL_BOOTS)));

        class_2447.method_10437(class_7800.field_40642, ModItems.MITHRIL_HORSE_ARMOR)
                .method_10439("  #")
                .method_10439("#L#")
                .method_10439("###")
                .method_10434('#', ModItems.MITHRIL_INGOT)
                .method_10434('L', class_1802.field_8745)
                .method_10429(method_32807(ModItems.MITHRIL_INGOT), method_10426(ModItems.MITHRIL_INGOT))
                .method_10429(method_32807(class_1802.field_8745), method_10426(class_1802.field_8745))
                .method_17972(exporter, new class_2960(method_36450(ModItems.MITHRIL_HORSE_ARMOR)));

        class_2447.method_10436(class_7800.field_40642, ModItems.SILVERTHORN_ARROW,8)
                .method_10439("M")
                .method_10439("I")
                .method_10439("F")
                .method_10434('M', ModItems.MITHRIL_NUGGET)
                .method_10434('I', ModItems.FANCY_TOOL_ROD)
                .method_10434('F', class_1802.field_8153)
                .method_10429(method_32807(ModItems.MITHRIL_NUGGET), method_10426(ModItems.MITHRIL_NUGGET))
                .method_10429(method_32807(ModItems.FANCY_TOOL_ROD), method_10426(ModItems.FANCY_TOOL_ROD))
                .method_10429(method_32807(class_1802.field_8153), method_10426(class_1802.field_8153))
                .method_17972(exporter, new class_2960(method_36450(ModItems.SILVERTHORN_ARROW)));

        class_2447.method_10437(class_7800.field_40642, ModBlocks.MITHRIL_ANVIL)
                .method_10439("###")
                .method_10439(" I ")
                .method_10439("III")
                .method_10434('#', ModBlocks.MITHRIL_BLOCK)
                .method_10434('I', ModItems.MITHRIL_INGOT)
                .method_10429(method_32807(ModBlocks.MITHRIL_BLOCK), method_10426(ModBlocks.MITHRIL_BLOCK))
                .method_10429(method_32807(ModItems.MITHRIL_INGOT), method_10426(ModItems.MITHRIL_INGOT))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.MITHRIL_ANVIL)));

        class_2447.method_10436(class_7800.field_40642, ModBlocks.MITHRIL_BARS,16)
                .method_10439("###")
                .method_10439("###")
                .method_10434('#', ModItems.MITHRIL_INGOT)
                .method_10429(method_32807(ModBlocks.MITHRIL_BLOCK), method_10426(ModBlocks.MITHRIL_BLOCK))
                .method_17972(exporter, new class_2960(method_36450(ModBlocks.MITHRIL_BARS)));

        class_2447.method_10437(class_7800.field_40634, ModItems.GAME_CARTRIDGE_1)
                .method_10439("N")
                .method_10439("C")
                .method_10434('N', class_1802.field_8328)
                .method_10434('C', ModItems.GAME_CARTRIDGE)
                .method_10429(method_32807(class_1802.field_8328), method_10426(class_1802.field_8328))
                .method_10429(method_32807(ModItems.GAME_CARTRIDGE), method_10426(ModItems.GAME_CARTRIDGE))
                .method_17972(exporter, new class_2960(method_36450(ModItems.GAME_CARTRIDGE_1)));

        class_2447.method_10437(class_7800.field_40634, ModItems.GAME_CARTRIDGE_2)
                .method_10439("X")
                .method_10439("C")
                .method_10434('X', ModItems.XEN_CRYSTAL)
                .method_10434('C', ModItems.GAME_CARTRIDGE)
                .method_10429(method_32807(ModItems.XEN_CRYSTAL), method_10426(ModItems.XEN_CRYSTAL))
                .method_10429(method_32807(ModItems.GAME_CARTRIDGE), method_10426(ModItems.GAME_CARTRIDGE))
                .method_17972(exporter, new class_2960(method_36450(ModItems.GAME_CARTRIDGE_2)));

        class_2447.method_10437(class_7800.field_40634, ModItems.GAME_CARTRIDGE_3)
                .method_10439("S")
                .method_10439("C")
                .method_10433('S', class_3489.field_15528)
                .method_10434('C', ModItems.GAME_CARTRIDGE)
                .method_10429(method_32807(class_1802.field_17535), method_10426(class_1802.field_17535))
                .method_10429(method_32807(ModItems.GAME_CARTRIDGE), method_10426(ModItems.GAME_CARTRIDGE))
                .method_17972(exporter, new class_2960(method_36450(ModItems.GAME_CARTRIDGE_3)));

        offerReversibleNuggetCompactingRecipes(exporter, class_7800.field_40642, ModItems.ASTRAL_NUGGET, class_7800.field_40642, ModItems.ASTRAL_INGOT);

        method_36325(exporter, class_7800.field_40642, ModItems.XEN_CRYSTAL, class_7800.field_40634, ModBlocks.XEN_CRYSTAL_BLOCK);
    }
}
