package net.tlotd.gui.renderer;

import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import org.jetbrains.annotations.Nullable;

// CREDIT: https://github.com/mezz/JustEnoughItems by mezz
// Under MIT-License: https://github.com/mezz/JustEnoughItems/blob/1.18/LICENSE.txt
public interface IIngredientRenderer<T> {
    /**
     * Renders an ingredient at a specific location.
     *
     * @param stack  The current {@link class_4587} for rendering the ingredient.
     * @param ingredient the ingredient to render.
     *
     * @since 9.3.0
     */
    default void render(class_4587 stack, T ingredient) {
        // if not implemented, this calls the old render function for backward compatibility
        render(stack, 0, 0, ingredient);
    }

    /**
     * Get the tooltip text for this ingredient. JEI renders the tooltip based on this.
     *
     * @param ingredient  The ingredient to get the tooltip for.
     * @param tooltipFlag Whether to show advanced information on item tooltips, toggled by F3+H
     * @return The tooltip text for the ingredient.
     */
    class_2561 getTooltip(T ingredient, class_1836 tooltipFlag);

    /**
     * Get the tooltip font renderer for this ingredient. JEI renders the tooltip based on this.
     *
     * @param minecraft  The minecraft instance.
     * @param ingredient The ingredient to get the tooltip for.
     * @return The font renderer for the ingredient.
     */
    default class_327 getFontRenderer(class_310 minecraft, T ingredient) {
        return minecraft.field_1772;
    }

    /**
     * Get the width of the ingredient drawn on screen by this renderer.
     *
     * @since 9.3.0
     */
    default int getWidth() {
        return 16;
    }

    /**
     * Get the height of the ingredient drawn on screen by this renderer.
     *
     * @since 9.3.0
     */
    default int getHeight() {
        return 16;
    }

    /**
     * Renders an ingredient at a specific location.
     *
     * @param xPosition  The x position to render the ingredient.
     * @param yPosition  The y position to render the ingredient.
     * @param ingredient the ingredient to render.
     *                   May be null, some renderers (like fluid tanks) will render an empty background.
     *
     * @deprecated Use {@link #render(class_4587, Object)} instead.
     */
    @Deprecated(forRemoval = true, since = "9.3.0")
    default void render(class_4587 stack, int xPosition, int yPosition, @Nullable T ingredient) {

    }
}