package net.tlotd.item.custom;

import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1839;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_437;
import net.minecraft.class_5328;
import net.minecraft.util.*;
import net.tlotd.enchantments.ModEnchantments;
import net.tlotd.item.ModItems;
import net.tlotd.sound.ModSounds;
import net.tlotd.world.dimension.ModDimensions;
import org.jetbrains.annotations.Nullable;

import java.util.Map;
import java.util.Optional;

public class MithrilMirrorItem extends class_1792 {

    private static final int BASE_MAX_CHARGES = 5;
    private static final int CHARGES_PER_LEVEL = 1;
    private static final int USE_TIME = 30;
    public static final class_2960 TENGWAR_FONT_ID = new class_2960("tlotd", "tengwar");
    public static final class_2960 ILLAGER_FONT_ID = new class_2960("minecraft", "illageralt");
    public static final class_2960 SOUL_CHARGES_FONT_ID = new class_2960("tlotd", "soul_charges");

    public MithrilMirrorItem(class_1793 settings) {
        super(settings);
    }

    @Override
    public class_1839 method_7853(class_1799 stack) {
        return class_1839.field_8953;
    }

    public float getProgress(class_1799 stack) {
        if (!stack.method_7985()) return 1.0f;
        if (stack.method_31574(ModItems.FOGGY_MITHRIL_MIRROR)) return 0.0f;
        class_2487 tag = stack.method_7969();
        int used = tag.method_10550("ChargesUsed");
        int maxCharges = getMaxCharges(stack);
        return 1.0f - ((float) used / (float) maxCharges);
    }

    @Override
    public boolean method_31567(class_1799 stack) {
        if (!stack.method_7985()) return false;
        if (class_1890.method_8225(ModEnchantments.CURSED_REFLECTION, stack) > 0) return false;
        return stack.method_7969().method_10550("ChargesUsed") > 0;
    }

    @Override
    public int method_31569(class_1799 stack) {
        return Math.round(getProgress(stack) * 13);
    }

    @Override
    public int method_31571(class_1799 stack) {
        if (class_1890.method_8225(ModEnchantments.CURSED_REFLECTION, stack) > 0) {
            return 0xB00000;
        }
        return 0x3C009C;
    }

    @Override
    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        return class_5328.method_29282(world, user, hand);
    }

    public class_1799 method_7861(class_1799 stack, class_1937 world, class_1309 user) {
        if (!(user instanceof class_1657 player)) return stack;
        if (!world.method_8608()) {
            if (stack.method_31574(ModItems.FOGGY_MITHRIL_MIRROR)) {
                boolean restored = false;
                for (int i = 0; i < player.method_31548().method_5439(); i++) {
                    class_1799 invStack = player.method_31548().method_5438(i);
                    boolean isCursed = class_1890.method_8225(ModEnchantments.CURSED_REFLECTION, stack) > 0;
                    class_1792 requiredFuel = isCursed ? ModItems.CURSED_SOUL_FLASK : ModItems.SOUL_FLASK_OF_THE_ABYSS;
                    if (!invStack.method_7960() && invStack.method_31574(requiredFuel)) {
                        invStack.method_7934(1);
                        class_1799 emptyFlask = ModItems.TINTED_GLASS_FLASK.method_7854();
                        if (!player.method_31548().method_7394(emptyFlask)) {
                            player.method_7328(emptyFlask, false);
                        }
                        class_1799 restoredMirror = ModItems.MITHRIL_MIRROR.method_7854();
                        Map<class_1887, Integer> enchants = class_1890.method_8222(stack);
                        class_1890.method_8214(enchants, restoredMirror);
                        class_2487 newTag = stack.method_7948().method_10553();
                        newTag.method_10569("ChargesUsed", 0);
                        restoredMirror.method_7980(newTag);
                        player.method_31548().method_7378(stack);
                        if (!player.method_31548().method_7394(restoredMirror)) {
                            player.method_7328(restoredMirror, false);
                        }
                        world.method_8396(null, player.method_24515(), class_3417.field_15029, class_3419.field_15248, 0.8f, 1.2f);
                        restored = true;
                        break;
                    }
                }
                if (!restored) {
                    player.method_7353(class_2561.method_43471("item.tlotd.foggy_mithril_mirror.charge_item_missing").method_27692(class_124.field_1061),true);
                    world.method_8396(null, player.method_24515(), class_3417.field_14977, class_3419.field_15248, 1f, 1f);
                }
                player.method_7357().method_7906(ModItems.FOGGY_MITHRIL_MIRROR, 200);
                player.method_7357().method_7906(ModItems.MITHRIL_MIRROR, 200);
                player.method_7259(class_3468.field_15372.method_14956(this));
                return stack;
            }
            if (stack.method_31574(ModItems.MITHRIL_MIRROR)) {
                class_3222 serverPlayer = (class_3222) player;
                class_3218 targetWorld = serverPlayer.field_13995.method_3847(serverPlayer.method_26281());
                if (targetWorld != null) {
                    class_2338 spawnpoint = serverPlayer.method_26280();
                    boolean worldspawn = false;
                    int transLevel = class_1890.method_8225(ModEnchantments.TRANSDIMENSIONAL, stack);
                    class_2487 tag = stack.method_7948();
                    int used = tag.method_10550("ChargesUsed");
                    int maxCharges = getMaxCharges(stack);
                    int remaining = maxCharges - used;
                    boolean crossDim = !targetWorld.method_27983().equals(player.method_37908().method_27983());
                    int cost = 0;
                    if (player.method_37908().method_27983().equals(ModDimensions.BACKROOMS_LEVEL_KEY)) {
                        player.method_7353(class_2561.method_43469("item.tlotd.mithril_mirror.cannot_escape", cost).method_27692(class_124.field_1061),true);
                        world.method_8396(null, player.method_24515(), class_3417.field_14977, class_3419.field_15248, 1f, 1f);
                        player.method_7357().method_7906(ModItems.MITHRIL_MIRROR, 600);
                        return stack;
                    } else if (targetWorld.method_27983().equals(ModDimensions.BACKROOMS_LEVEL_KEY)) {
                        player.method_7353(class_2561.method_43469("item.tlotd.mithril_mirror.destination_unknown", cost).method_27692(class_124.field_1061),true);
                        world.method_8396(null, player.method_24515(), class_3417.field_14977, class_3419.field_15248, 1f, 1f);
                        player.method_7357().method_7906(ModItems.MITHRIL_MIRROR, 600);
                        return stack;
                    } else if (crossDim && transLevel > 0) {
                        cost = switch (transLevel) {
                            case 1 -> 5;
                            case 2 -> 3;
                            case 3 -> 1;
                            default -> 0;
                        };
                        if (remaining < cost) {
                            player.method_7353(class_2561.method_43469("item.tlotd.mithril_mirror.charges_requirement", cost).method_27692(class_124.field_1061),true);
                            world.method_8396(null, player.method_24515(), class_3417.field_14977, class_3419.field_15248, 1f, 1f);
                            player.method_7357().method_7906(ModItems.MITHRIL_MIRROR, 600);
                            return stack;
                        }
                    } else if (crossDim) {
                        player.method_7353(class_2561.method_43471("item.tlotd.mithril_mirror.transdimensional").method_27692(class_124.field_1061),true);
                        world.method_8396(null, player.method_24515(), class_3417.field_14977, class_3419.field_15248, 1f, 1f);
                        player.method_7357().method_7906(ModItems.MITHRIL_MIRROR, 600);
                        return stack;
                    }
                    Optional<class_243> optionalSpawnVec = Optional.empty();
                    if (spawnpoint != null)
                        optionalSpawnVec = class_1657.method_26091(targetWorld, spawnpoint, serverPlayer.method_30631(), false, false);
                    if (spawnpoint == null || optionalSpawnVec.isEmpty()) {
                        worldspawn = true;
                    } else {
                        class_243 spawnVec = optionalSpawnVec.get();
                        serverPlayer.method_14251(targetWorld, spawnVec.method_10216(), spawnVec.method_10214(), spawnVec.method_10215(),
                                serverPlayer.method_30631(), 0.5F);
                        targetWorld.method_8396(null, spawnpoint, ModSounds.ITEM_MITHRIL_MIRROR, class_3419.field_15248, 0.4f, 0.8f);
                    }
                    if (worldspawn) {
                        spawnpoint = serverPlayer.field_13995.method_30002().method_43126();
                        serverPlayer.method_14251(serverPlayer.field_13995.method_30002(),
                                spawnpoint.method_10263(), spawnpoint.method_10264(), spawnpoint.method_10260(),
                                serverPlayer.method_30631(), 0.5F);
                        while (!targetWorld.method_17892(serverPlayer)) {
                            serverPlayer.method_20620(serverPlayer.method_23317(), serverPlayer.method_23318() + 1.0D, serverPlayer.method_23321());
                        }
                        targetWorld.method_8396(null, spawnpoint, ModSounds.ITEM_MITHRIL_MIRROR, class_3419.field_15248, 0.4f, 0.8f);
                    }
                    player.method_6092(new class_1293(class_1294.field_5919, 20, 0, false, false));
                    player.method_6092(new class_1293(class_1294.field_5916, 20, 0, false, false));
                    player.method_6092(new class_1293(class_1294.field_5911, 20, 0, false, false));
                    player.method_6092(new class_1293(class_1294.field_5901, 20, 0, false, false));
                    if (class_1890.method_8225(ModEnchantments.CURSED_REFLECTION, stack) > 0) {
                        player.method_6033(1.0F);
                        world.method_8396(null, player.method_24515(), class_3417.field_14792, class_3419.field_15248, 0.8f, 0.6f);
                    }
                    int curseLevel = class_1890.method_8225(ModEnchantments.CURSED_REFLECTION, stack);
                    int restorativeLevel = class_1890.method_8225(ModEnchantments.REFILL_CHARGES, stack);
                    if (curseLevel == 0) {
                        used += crossDim ? cost : 1;
                        tag.method_10569("ChargesUsed", used);
                    }
                    if (used >= maxCharges) {
                        boolean refilled = false;
                        class_1792 rechargeItem = (curseLevel > 0) ? ModItems.CURSED_SOUL_FLASK : ModItems.SOUL_FLASK_OF_THE_ABYSS;
                        class_1792 emptyFlask = ModItems.TINTED_GLASS_FLASK;
                        if (restorativeLevel > 0) {
                            for (int i = 0; i < player.method_31548().method_5439(); i++) {
                                class_1799 invStack = player.method_31548().method_5438(i);
                                if (!invStack.method_7960() && invStack.method_31574(rechargeItem)) {
                                    invStack.method_7934(1);
                                    if (!player.method_31548().method_7394(emptyFlask.method_7854())) {
                                        player.method_7328(emptyFlask.method_7854(), false);
                                    }
                                    tag.method_10569("ChargesUsed", 0);
                                    refilled = true;
                                    class_3414 refillSound = (curseLevel > 0) ? class_3417.field_14688 : class_3417.field_15029;
                                    world.method_8396(null, player.method_24515(), refillSound, class_3419.field_15248, 1f, 1f);
                                    break;
                                }
                            }
                        }
                        if (!refilled) {
                            player.method_31548().method_7378(stack);
                            class_1799 depleted = ModItems.FOGGY_MITHRIL_MIRROR.method_7854();
                            depleted.method_7980(stack.method_7948().method_10553());
                            Map<class_1887, Integer> enchants = class_1890.method_8222(stack);
                            class_1890.method_8214(enchants, depleted);
                            if (!player.method_31548().method_7394(depleted)) {
                                player.method_7328(depleted, false);
                            }
                        }
                    }
                } else {
                    world.method_8396(null, player.method_24515(), class_3417.field_14977, class_3419.field_15245, 1f, 1f);
                }
            }
        }
        player.method_7357().method_7906(ModItems.FOGGY_MITHRIL_MIRROR, 600);
        player.method_7357().method_7906(ModItems.MITHRIL_MIRROR, 600);
        player.method_7259(class_3468.field_15372.method_14956(this));
        return stack;
    }

    @Override
    public int method_7881(class_1799 stack) {
        return USE_TIME;
    }

    private int getMaxCharges(class_1799 stack) {
        int abyssLevel = class_1890.method_8225(ModEnchantments.DEPTH_OF_THE_ABYSS, stack);
        return BASE_MAX_CHARGES + (abyssLevel * CHARGES_PER_LEVEL);
    }

    private static String getChargeGlyphs(int remaining, int max, boolean cursed, boolean foggy) {
        remaining = Math.max(0, Math.min(remaining, max));
        if (foggy) {
            remaining = 0;
        }
        String bottleEmpty = cursed ? "\uE008" : "\uE010";
        String bottleFull = cursed ? "\uE00B" : "\uE013";
        String empty = cursed ? "\uE009" : "\uE011";
        String full = cursed ? "\uE00C" : "\uE014";
        String tipEmpty = cursed ? "\uE00A" : "\uE012";
        String tipFull = cursed ? "\uE00D" : "\uE015";
        StringBuilder bar = new StringBuilder();
        bar.append(remaining == 0 ? bottleEmpty : bottleFull);
        for (int i = 0; i < max - 1; i++) {
            bar.append(i < remaining ? full : empty);
        }
        bar.append(remaining == max ? tipFull : tipEmpty);
        return bar.toString();
    }

    @Override
    public class_2561 method_7864(class_1799 stack) {
        class_2561 name = super.method_7864(stack);
        if (class_1890.method_8225(ModEnchantments.CURSED_REFLECTION, stack) > 0) return name.method_27661().method_27692(class_124.field_1061);
        else return name;
    }

    @Override
    public void method_7851(class_1799 stack, @Nullable class_1937 world, java.util.List<class_2561> tooltip, class_1836 context) {
        class_2583 style = method_7848().method_10866();
        class_2487 tag = stack.method_7948();
        int used = tag.method_10550("ChargesUsed");
        int max = getMaxCharges(stack);
        int remaining = Math.max(0, max - used);
        boolean cursed = class_1890.method_8225(ModEnchantments.CURSED_REFLECTION, stack) > 0;
        boolean foggy = stack.method_31574(ModItems.FOGGY_MITHRIL_MIRROR);
        String pictogram = getChargeGlyphs(remaining, max, cursed, foggy);
        tooltip.add(class_2561.method_43470(pictogram).method_10862(class_2583.field_24360.method_27704(SOUL_CHARGES_FONT_ID).method_10977(class_124.field_1068)));
        if (class_437.method_25442()) {
            tooltip.add(class_2561.method_43471("item.tlotd.mithril_mirror.tooltip").method_27692(class_124.field_1080));
        } else if (cursed) {
            tooltip.add(class_2561.method_43471("item.tlotd.mithril_mirror.tooltip").method_10862(style.method_27704(ILLAGER_FONT_ID)).method_27692(class_124.field_1080));
        } else {
            tooltip.add(class_2561.method_43471("item.tlotd.mithril_mirror.tooltip_quenya").method_10862(style.method_27704(TENGWAR_FONT_ID)).method_27692(class_124.field_1080));
        }
        if (cursed) {
            tooltip.add(class_2561.method_43471("item.tlotd.desc_occult").method_27692(class_124.field_1061));
        } else {
            tooltip.add(class_2561.method_43471("item.tlotd.desc_eldritch").method_10862(style.method_36139(0x3C009C)));
        }
        super.method_7851(stack, world, tooltip, context);
    }

    @Override
    public boolean method_7870(class_1799 stack) {
        return true;
    }

    @Override
    public int method_7837() {
        return 10;
    }
}