package net.tlotd.item.custom;

import net.minecraft.class_124;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_174;
import net.minecraft.class_1766;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1832;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_3481;
import net.minecraft.item.*;
import net.tlotd.block.ModBlocks;
import net.tlotd.item.ModItems;
import net.tlotd.sound.ModSounds;
import net.tlotd.util.ModTags;
import net.tlotd.world.ModGlobalState;
import org.jetbrains.annotations.Nullable;

import java.util.List;

import static net.tlotd.block.custom.AlienControlPanelBlock.HARVESTED;

public class PaxelItem extends class_1766 {
    public PaxelItem(class_1832 material, int attackDamage, float attackSpeed, class_1792.class_1793 settings) {
        super((float)attackDamage, attackSpeed, material, ModTags.Blocks.PAXEL_MINEABLE, settings);
    }

    @Override
    public class_1269 method_7884(class_1838 context) {
        if(!context.method_8045().method_8608()) {
            class_2338 positionClicked = context.method_8037();
            class_1657 player = context.method_8036();
            class_2680 state = context.method_8045().method_8320(positionClicked);
            if ((state.method_27852(class_2246.field_10566) || state.method_27852(class_2246.field_10219)) && context.method_8045().method_8320(positionClicked.method_10084()).method_27852(class_2246.field_10124)) {
                if (player.method_5715()) {
                    context.method_8045().method_8501(positionClicked, class_2246.field_10194.method_9564());
                    context.method_8045().method_8396(null, positionClicked, class_3417.field_14616, class_3419.field_15248, 1.0f, 1.0f);
                } else {
                    context.method_8045().method_8501(positionClicked, class_2246.field_10362.method_9564());
                    context.method_8045().method_8396(null, positionClicked, class_3417.field_14846, class_3419.field_15248, 1.0f, 1.0f);
                }
                context.method_8041().method_7956(1, player, playerEntity -> playerEntity.method_20236(playerEntity.method_6058()));
                if (player instanceof class_3222 serverPlayerEntity) {
                    class_174.field_1198.method_8821(serverPlayerEntity, context.method_8041());
                    serverPlayerEntity.method_7259(class_3468.field_15372.method_14956(this));
                }
                return class_1269.field_5812;
            } else if ((state.method_27852(ModBlocks.RICH_DIRT) || state.method_27852(ModBlocks.RICH_GRASS_BLOCK)) && context.method_8045().method_8320(positionClicked.method_10084()).method_27852(class_2246.field_10124)) {
                if (player.method_5715()) {
                    context.method_8045().method_8501(positionClicked, ModBlocks.RICH_DIRT_PATH.method_9564());
                    context.method_8045().method_8396(null, positionClicked, class_3417.field_14616, class_3419.field_15248, 1.0f, 1.0f);
                } else {
                    context.method_8045().method_8501(positionClicked, ModBlocks.RICH_FARMLAND.method_9564());
                    context.method_8045().method_8396(null, positionClicked, class_3417.field_14846, class_3419.field_15248, 1.0f, 1.0f);
                }
                context.method_8041().method_7956(1, player, playerEntity -> playerEntity.method_20236(playerEntity.method_6058()));
                if (player instanceof class_3222 serverPlayerEntity) {
                    class_174.field_1198.method_8821(serverPlayerEntity, context.method_8041());
                    serverPlayerEntity.method_7259(class_3468.field_15372.method_14956(this));
                }
                return class_1269.field_5812;
            } else if (context.method_8041().method_31573(ModTags.Items.EXTRACTION_PICKAXES)) {
                boolean compat = false;
                if (player != null && !context.method_8045().field_9236 && player.method_5682() != null) {
                    ModGlobalState globalState = ModGlobalState.get(player.method_5682());
                    compat = globalState.extractionOreCompat();
                }
                String name = state.method_26204().method_9539();
                int damage = 1;
                int miningLevel = this.method_8022().method_8024();
                int blockLevel = 0;
                if (state.method_26164(ModTags.Blocks.TOOL_LEVEL_10)) { blockLevel = 10; }
                else if (state.method_26164(ModTags.Blocks.TOOL_LEVEL_9)) { blockLevel = 9; }
                else if (state.method_26164(ModTags.Blocks.TOOL_LEVEL_8)) { blockLevel = 8; }
                else if (state.method_26164(ModTags.Blocks.TOOL_LEVEL_7)) { blockLevel = 7; }
                else if (state.method_26164(ModTags.Blocks.TOOL_LEVEL_6)) { blockLevel = 6; }
                else if (state.method_26164(ModTags.Blocks.TOOL_LEVEL_5)) { blockLevel = 5; }
                else if (state.method_26164(ModTags.Blocks.TOOL_LEVEL_4)) { blockLevel = 4; }
                else if (state.method_26164(class_3481.field_33717)) { blockLevel = 3; }
                else if (state.method_26164(class_3481.field_33718)) { blockLevel = 2; }
                else if (state.method_26164(class_3481.field_33719)) { blockLevel = 1; }

                if (miningLevel >= blockLevel && (state == ModBlocks.ALIEN_CONTROL_PANEL.method_34725(state).method_11657(HARVESTED,false) || state.method_26164(ModTags.Blocks.EXTRACTABLE_BLOCKS) || (compat && name.contains("_ore")))) {
                    context.method_8045().method_22352(positionClicked, true);
                    if (state.method_27852(ModBlocks.ALIEN_CONTROL_PANEL) && !state.method_11654(HARVESTED)) {
                        context.method_8045().method_8501(positionClicked, state.method_11657(HARVESTED, true));
                        class_1799 circuit = ModItems.FRAGMENTED_FUTURISTIC_CIRCUIT_BOARD.method_7854();
                        circuit.method_7939(3);
                        class_2248.method_9577(context.method_8045(), context.method_8037().method_10084(), circuit);
                    }
                    if (state.method_26164(ModTags.Blocks.STONE_EXTRACTABLE_BLOCKS)) {
                        context.method_8045().method_8501(positionClicked, class_2246.field_10340.method_9564());
                    } else if (state.method_26164(ModTags.Blocks.ANDESITE_EXTRACTABLE_BLOCKS) || (compat && name.contains("andesite") && name.contains("ore"))) {
                        context.method_8045().method_8501(positionClicked, class_2246.field_10115.method_9564());
                    } else if (state.method_26164(ModTags.Blocks.DIORITE_EXTRACTABLE_BLOCKS) || (compat && name.contains("diorite") && name.contains("ore"))) {
                        context.method_8045().method_8501(positionClicked, class_2246.field_10508.method_9564());
                    } else if (state.method_26164(ModTags.Blocks.GRANITE_EXTRACTABLE_BLOCKS) || (compat && name.contains("granite") && name.contains("ore"))) {
                        context.method_8045().method_8501(positionClicked, class_2246.field_10474.method_9564());
                    } else if (state.method_26164(ModTags.Blocks.TUFF_EXTRACTABLE_BLOCKS) || (compat && name.contains("tuff") && name.contains("ore"))) {
                        context.method_8045().method_8501(positionClicked, class_2246.field_27165.method_9564());
                    } else if (state.method_26164(ModTags.Blocks.CALCITE_EXTRACTABLE_BLOCKS) || (compat && name.contains("calcite") && name.contains("ore"))) {
                        context.method_8045().method_8501(positionClicked, class_2246.field_27114.method_9564());
                    } else if (state.method_26164(ModTags.Blocks.RED_DEEPSLATE_EXTRACTABLE_BLOCKS) || (compat && name.contains("red_deepslate") && name.contains("ore"))) {
                        context.method_8045().method_8501(positionClicked, ModBlocks.RED_DEEPSLATE.method_9564());
                        damage = 2;
                    } else if (state.method_26164(ModTags.Blocks.DEEPSLATE_EXTRACTABLE_BLOCKS) || (compat && name.contains("deepslate") && name.contains("ore"))) {
                        context.method_8045().method_8501(positionClicked, class_2246.field_28888.method_9564());
                        damage = 2;
                    } else if (state.method_26164(ModTags.Blocks.BEDROCK_EXTRACTABLE_BLOCKS) || (compat && name.contains("bedrock") && name.contains("ore"))) {
                        context.method_8045().method_8501(positionClicked, class_2246.field_9987.method_9564());
                        damage = 10;
                    } else if (state.method_26164(ModTags.Blocks.END_STONE_EXTRACTABLE_BLOCKS) || (compat && name.contains("end") && name.contains("ore"))) {
                        context.method_8045().method_8501(positionClicked, class_2246.field_10471.method_9564());
                        damage = 5;
                    } else if (state.method_26164(ModTags.Blocks.NETHERRACK_EXTRACTABLE_BLOCKS) || (compat && name.contains("nether") && name.contains("ore"))) {
                        context.method_8045().method_8501(positionClicked, class_2246.field_10515.method_9564());
                        damage = 3;
                    } else if (state.method_26164(ModTags.Blocks.BASALT_EXTRACTABLE_BLOCKS) || (compat && name.contains("basalt") && name.contains("ore"))) {
                        context.method_8045().method_8501(positionClicked, class_2246.field_22091.method_9564());
                        damage = 3;
                    } else if (state.method_26164(ModTags.Blocks.BLACKSTONE_EXTRACTABLE_BLOCKS) || (compat && name.contains("blackstone") && name.contains("ore"))) {
                        context.method_8045().method_8501(positionClicked, class_2246.field_23869.method_9564());
                        damage = 3;
                    } else if (state.method_26164(ModTags.Blocks.MOON_ROCK_EXTRACTABLE_BLOCKS)) {
                        context.method_8045().method_8501(positionClicked, ModBlocks.MEGAREGOLITH.method_9564());
                        damage = 5;
                    }
                    context.method_8045().method_8396(null, positionClicked, ModSounds.ITEM_PICKAXE_EXTRACT, class_3419.field_15245, 1.0f, 1.0f);
                    int extraction_damage = damage*20;
                    if (context.method_8041().method_31573(ModTags.Items.EXTRACTION_II_PICKAXES)) {
                        extraction_damage = damage*10;
                    }
                    if (context.method_8041().method_31573(ModTags.Items.EXTRACTION_III_PICKAXES)) {
                        extraction_damage = damage;
                    }
                    context.method_8041().method_7956(extraction_damage, player, playerEntity -> playerEntity.method_20236(playerEntity.method_6058()));
                    if (player instanceof class_3222 serverPlayerEntity) {
                        class_174.field_1198.method_8821(serverPlayerEntity, context.method_8041());
                        serverPlayerEntity.method_7259(class_3468.field_15372.method_14956(this));
                    }
                    return class_1269.field_5812;
                }
            }
        }
        return class_1269.field_5814;
    }

    @Override
    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        if (stack.method_31573(ModTags.Items.EXTRACTION_III_PICKAXES)) {
            tooltip.add(class_2561.method_43471("item.tlotd.extraction.tooltip").method_10852(class_2561.method_43470(" ").method_10852(class_2561.method_43471("enchantment.level.3"))).method_27692(class_124.field_1080));
        } else if (stack.method_31573(ModTags.Items.EXTRACTION_II_PICKAXES)) {
            tooltip.add(class_2561.method_43471("item.tlotd.extraction.tooltip").method_10852(class_2561.method_43470(" ").method_10852(class_2561.method_43471("enchantment.level.2"))).method_27692(class_124.field_1080));
        } else if (stack.method_31573(ModTags.Items.EXTRACTION_PICKAXES)) {
            tooltip.add(class_2561.method_43471("item.tlotd.extraction.tooltip").method_10852(class_2561.method_43470(" ").method_10852(class_2561.method_43471("enchantment.level.1"))).method_27692(class_124.field_1080));
        }
        super.method_7851(stack, world, tooltip, context);
    }

    @Override
    public boolean method_7886(class_1799 stack) {
        return stack.method_31573(ModTags.Items.EXTRACTION_PICKAXES);
    }
}