package net.tlotd.item.custom;

import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1293;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1839;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_5328;
import net.minecraft.util.*;
import net.tlotd.effect.ModEffects;
import net.tlotd.enchantments.ModEnchantments;
import net.tlotd.item.ModItems;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import java.util.Map;

public class PipeItem extends class_1792 {

    private static final int BASE_MAX_CHARGES = 3;
    private static final int CHARGES_PER_LEVEL = 1;
    private static final int USE_TIME = 20;
    public static final class_2960 SOUL_CHARGES_FONT_ID = new class_2960("tlotd", "soul_charges");

    public PipeItem(class_1793 settings) {
        super(settings);
    }

    public class_1839 method_7853(class_1799 stack) {
        return class_1839.field_39058;
    }

    public float getProgress(class_1799 stack) {
        if (stack.method_31574(ModItems.PIPE)) return 0.0f;
        if (!stack.method_7985()) return 1.0f;
        class_2487 tag = stack.method_7969();
        int used = tag.method_10550("ChargesUsed");
        int maxCharges = getMaxCharges(stack);
        return 1.0f - ((float) used / (float) maxCharges);
    }

    @Override
    public boolean method_31567(class_1799 stack) {
        if (stack.method_31574(ModItems.PIPE_WEED_PIPE)) return true;
        if (!stack.method_7985()) return false;
        return stack.method_7969().method_10550("ChargesUsed") > 0;
    }

    @Override
    public int method_31569(class_1799 stack) {
        return Math.round(getProgress(stack) * 13);
    }

    @Override
    public int method_31571(class_1799 stack) {
        return 0x486B3E;
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        return class_5328.method_29282(world, user, hand);
    }

    public int method_7881(class_1799 stack) {
        return USE_TIME;
    }

    private int getMaxCharges(class_1799 stack) {
        int abyssLevel = class_1890.method_8225(ModEnchantments.RESOURCEFUL_SMOKING, stack);
        return BASE_MAX_CHARGES + (abyssLevel * CHARGES_PER_LEVEL);
    }

    private static String getChargeGlyphs(int remaining, int max, boolean empty) {
        remaining = Math.max(0, Math.min(remaining, max));
        if (empty) {
            remaining = 0;
        }
        StringBuilder bar = new StringBuilder();
        bar.append(remaining == 0 ? "\uE038" : "\uE03B");
        for (int i = 0; i < max - 1; i++) {
            bar.append(i < remaining ? "\uE03C" : "\uE039");
        }
        bar.append(remaining == max ? "\uE03D" : "\uE03A");
        return bar.toString();
    }

    public class_1799 method_7861(class_1799 stack, class_1937 world, class_1309 user) {
        if (!(user instanceof class_1657 player)) return stack;
        if (!world.method_8608()) {
            if (stack.method_31574(ModItems.PIPE)) {
                boolean restored = false;
                for (int i = 0; i < player.method_31548().method_5439(); i++) {
                    class_1799 invStack = player.method_31548().method_5438(i);
                    if (!invStack.method_7960() && invStack.method_31574(ModItems.PIPE_WEED)) {
                        invStack.method_7934(1);
                        class_1799 filledPipe = ModItems.PIPE_WEED_PIPE.method_7854();
                        Map<class_1887, Integer> enchants = class_1890.method_8222(stack);
                        class_1890.method_8214(enchants, filledPipe);
                        class_2487 newTag = stack.method_7948().method_10553();
                        newTag.method_10569("ChargesUsed", 0);
                        filledPipe.method_7980(newTag);
                        player.method_31548().method_7378(stack);
                        if (!player.method_31548().method_7394(filledPipe)) {
                            player.method_7328(filledPipe, false);
                        }
                        world.method_8396(null, player.method_24515(), class_3417.field_14573, class_3419.field_15248, 0.8f, 1.2f);
                        restored = true;
                        break;
                    }
                }
                if (!restored) {
                    world.method_8396(null, player.method_24515(), class_3417.field_14977, class_3419.field_15248, 1f, 1f);
                }
                player.method_7357().method_7906(ModItems.PIPE, 20);
                player.method_7357().method_7906(ModItems.PIPE_WEED_PIPE, 20);
                player.method_7259(class_3468.field_15372.method_14956(this));
                return stack;
            }
        }
        if (stack.method_31574(ModItems.PIPE_WEED_PIPE)) {
            user.method_6092(new class_1293(ModEffects.STONED, 600));
            class_2487 tag = stack.method_7948();
            int used = tag.method_10550("ChargesUsed");
            int refillLevel = class_1890.method_8225(ModEnchantments.REFILL_CHARGES, stack);
            int maxCharges = getMaxCharges(stack);
            used++;
            tag.method_10569("ChargesUsed", used);
            if (used >= maxCharges) {
                boolean refilled = false;
                if (refillLevel > 0) {
                    for (int i = 0; i < player.method_31548().method_5439(); i++) {
                        class_1799 invStack = player.method_31548().method_5438(i);
                        if (!invStack.method_7960() && invStack.method_31574(ModItems.PIPE_WEED)) {
                            invStack.method_7934(1);
                            tag.method_10569("ChargesUsed", 0);
                            refilled = true;
                            world.method_8396(null, player.method_24515(), class_3417.field_14573, class_3419.field_15248, 1f, 1f);
                            break;
                        }
                    }
                }
                if (!refilled) {
                    player.method_31548().method_7378(stack);
                    class_1799 depleted = ModItems.PIPE.method_7854();
                    depleted.method_7980(stack.method_7948().method_10553());
                    Map<class_1887, Integer> enchants = class_1890.method_8222(stack);
                    class_1890.method_8214(enchants, depleted);
                    if (!player.method_31548().method_7394(depleted)) {
                        player.method_7328(depleted, false);
                    }
                }
            }
        }
        player.method_7357().method_7906(ModItems.PIPE, 20);
        player.method_7357().method_7906(ModItems.PIPE_WEED_PIPE, 20);
        player.method_7259(class_3468.field_15372.method_14956(this));
        return stack;
    }

    @Override
    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        class_2487 tag = stack.method_7948();
        int used = tag.method_10550("ChargesUsed");
        int max = getMaxCharges(stack);
        int remaining = Math.max(0, max - used);
        boolean empty = stack.method_31574(ModItems.PIPE);
        String pictogram = getChargeGlyphs(remaining, max, empty);
        tooltip.add(class_2561.method_43470(pictogram).method_10862(class_2583.field_24360.method_27704(SOUL_CHARGES_FONT_ID).method_10977(class_124.field_1068)));
        if (stack.method_31574(ModItems.PIPE_WEED_PIPE)) {
            tooltip.add(class_2561.method_43471("effect.tlotd.stoned").method_10852(class_2561.method_43470(" (00:30)")).method_27692(class_124.field_1061));
        }
        super.method_7851(stack, world, tooltip, context);
    }

    @Override
    public boolean method_7870(class_1799 stack) {
        return true;
    }

    @Override
    public int method_7837() {
        return 10;
    }
}