package net.tlotd.mixin;

import com.mojang.datafixers.util.Pair;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1743;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.tlotd.block.ModBlocks;
import net.tlotd.item.ModItems;
import net.tlotd.util.ModTags;
import net.tlotd.world.ModGlobalState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.*;
import java.util.function.Supplier;

@Mixin(class_1743.class)
public abstract class WoodStrippingItemDrop {

    private static Map<class_2248, Supplier<class_1799>> BARK_BY_BLOCK = null;
    private static List<Pair<String, Supplier<class_1799>>> MODDED_BARK_KEYWORDS = null;

    @Inject(method = "useOnBlock", at = @At("HEAD"))
    protected void injectOnUseMethod(class_1838 context, CallbackInfoReturnable<class_1269> cir) {
        class_1657 player = context.method_8036();
        class_1937 world = context.method_8045();
        if (player == null || world.field_9236) return;
        ModGlobalState globalState = ModGlobalState.get(player.method_5682());
        if (!globalState.strippingDropsBark()) return;
        class_2680 state = world.method_8320(context.method_8037());
        class_2248 block = state.method_26204();
        if (!state.method_26164(ModTags.Blocks.LOGS_WITH_BARK)) return;
        ensureMappingsInitialized();
        class_1799 bark = getBarkForBlock(block);
        if (bark == null) return;
        class_2248.method_9577(world, context.method_8037(), bark);
    }

    private static void ensureMappingsInitialized() {
        if (BARK_BY_BLOCK != null) return;

        BARK_BY_BLOCK = new HashMap<>();
        MODDED_BARK_KEYWORDS = new ArrayList<>();

        BARK_BY_BLOCK.put(class_2246.field_10431, ModItems.OAK_BARK::method_7854);
        BARK_BY_BLOCK.put(class_2246.field_10126, ModItems.OAK_BARK::method_7854);
        BARK_BY_BLOCK.put(class_2246.field_10037, ModItems.SPRUCE_BARK::method_7854);
        BARK_BY_BLOCK.put(class_2246.field_10155, ModItems.SPRUCE_BARK::method_7854);
        BARK_BY_BLOCK.put(class_2246.field_10511, ModItems.BIRCH_BARK::method_7854);
        BARK_BY_BLOCK.put(class_2246.field_10307, ModItems.BIRCH_BARK::method_7854);
        BARK_BY_BLOCK.put(class_2246.field_10306, ModItems.JUNGLE_BARK::method_7854);
        BARK_BY_BLOCK.put(class_2246.field_10303, ModItems.JUNGLE_BARK::method_7854);
        BARK_BY_BLOCK.put(class_2246.field_10533, ModItems.ACACIA_BARK::method_7854);
        BARK_BY_BLOCK.put(class_2246.field_9999, ModItems.ACACIA_BARK::method_7854);
        BARK_BY_BLOCK.put(class_2246.field_10010, ModItems.DARK_OAK_BARK::method_7854);
        BARK_BY_BLOCK.put(class_2246.field_10178, ModItems.DARK_OAK_BARK::method_7854);
        BARK_BY_BLOCK.put(class_2246.field_37545, ModItems.MANGROVE_BARK::method_7854);
        BARK_BY_BLOCK.put(class_2246.field_37549, ModItems.MANGROVE_BARK::method_7854);
        BARK_BY_BLOCK.put(class_2246.field_42729, ModItems.CHERRY_BARK::method_7854);
        BARK_BY_BLOCK.put(class_2246.field_42733, ModItems.CHERRY_BARK::method_7854);

        BARK_BY_BLOCK.put(ModBlocks.GINKGO_LOG, ModItems.GINKGO_BARK::method_7854);
        BARK_BY_BLOCK.put(ModBlocks.GINKGO_WOOD, ModItems.GINKGO_BARK::method_7854);
        BARK_BY_BLOCK.put(ModBlocks.YELLOW_WALLPAPERED_WALL, ModItems.YELLOW_WALLPAPER::method_7854);

        MODDED_BARK_KEYWORDS.add(Pair.of("aether:skyroot", ModItems.SKYROOT_BARK::method_7854));
        MODDED_BARK_KEYWORDS.add(Pair.of("aether:golden_oak", ModItems.SKYROOT_BARK::method_7854));
        MODDED_BARK_KEYWORDS.add(Pair.of("alexscaves:pewen", ModItems.PEWEN_BARK::method_7854));
        MODDED_BARK_KEYWORDS.add(Pair.of("alexscaves:thornwood", ModItems.THORNWOOD_BARK::method_7854));
        MODDED_BARK_KEYWORDS.add(Pair.of("biomesoplenty:fir", ModItems.FIR_BARK::method_7854));
        MODDED_BARK_KEYWORDS.add(Pair.of("biomesoplenty:pine", ModItems.PINE_BARK::method_7854));
        MODDED_BARK_KEYWORDS.add(Pair.of("biomesoplenty:maple", ModItems.MAPLE_BARK::method_7854));
        MODDED_BARK_KEYWORDS.add(Pair.of("biomesoplenty:redwood", ModItems.REDWOOD_BARK::method_7854));
        MODDED_BARK_KEYWORDS.add(Pair.of("biomesoplenty:mahogany", ModItems.MAHOGANY_BARK::method_7854));
        MODDED_BARK_KEYWORDS.add(Pair.of("biomesoplenty:jacaranda", ModItems.JACARANCA_BARK::method_7854));
        MODDED_BARK_KEYWORDS.add(Pair.of("biomesoplenty:palm", ModItems.PALM_BARK::method_7854));
        MODDED_BARK_KEYWORDS.add(Pair.of("biomesoplenty:willow", ModItems.WILLOW_BARK::method_7854));
        MODDED_BARK_KEYWORDS.add(Pair.of("biomesoplenty:dead", ModItems.DEAD_BARK::method_7854));
        MODDED_BARK_KEYWORDS.add(Pair.of("biomesoplenty:magic", ModItems.MAGIC_BARK::method_7854));
        MODDED_BARK_KEYWORDS.add(Pair.of("biomesoplenty:umbran", ModItems.UMBRAN_BARK::method_7854));
        MODDED_BARK_KEYWORDS.add(Pair.of("biomesoplenty:hellbark", ModItems.HELLBARK_BARK::method_7854));
        MODDED_BARK_KEYWORDS.add(Pair.of("biomesoplenty:empyreal", ModItems.EMPYREAL_BARK::method_7854));
        MODDED_BARK_KEYWORDS.add(Pair.of("quark:ancient", ModItems.ASHEN_BARK::method_7854));
        MODDED_BARK_KEYWORDS.add(Pair.of("quark:azalea", ModItems.AZALEA_BARK::method_7854));
        MODDED_BARK_KEYWORDS.add(Pair.of("quark:blossom", ModItems.TRUMPET_BARK::method_7854));
        MODDED_BARK_KEYWORDS.add(Pair.of("thermal:rubberwood", ModItems.RUBBERWOOD_BARK::method_7854));
        MODDED_BARK_KEYWORDS.add(Pair.of("twilightforest:twilight_oak", ModItems.TWILIGHT_OAK_BARK::method_7854));
        MODDED_BARK_KEYWORDS.add(Pair.of("twilightforest:canopy", ModItems.CANOPY_TREE_BARK::method_7854));
        MODDED_BARK_KEYWORDS.add(Pair.of("twilightforest:mangrove", ModItems.TWILIGHT_MANGROVE_BARK::method_7854));
        MODDED_BARK_KEYWORDS.add(Pair.of("twilightforest:dark", ModItems.DARKWOOD_BARK::method_7854));
        MODDED_BARK_KEYWORDS.add(Pair.of("twilightforest:time", ModItems.TIMEWOOD_BARK::method_7854));
        MODDED_BARK_KEYWORDS.add(Pair.of("twilightforest:transformation", ModItems.TRANSWOOD_BARK::method_7854));
        MODDED_BARK_KEYWORDS.add(Pair.of("twilightforest:mining", ModItems.MINEWOOD_BARK::method_7854));
        MODDED_BARK_KEYWORDS.add(Pair.of("twilightforest:sorting", ModItems.SORTINGWOOD_BARK::method_7854));
    }

    private static class_1799 getBarkForBlock(class_2248 block) {
        Supplier<class_1799> direct = BARK_BY_BLOCK.get(block);
        if (direct != null) return direct.get();
        String key = block.method_9539().toLowerCase(Locale.ROOT);
        for (Pair<String, Supplier<class_1799>> entry : MODDED_BARK_KEYWORDS) {
            if (key.contains(entry.getFirst())) return entry.getSecond().get();
        }
        return null;
    }
}