package net.tlotd.mixin.client;

import net.minecraft.class_2960;
import net.minecraft.class_742;
import net.tlotd.util.CapeManager;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_742.class)
public abstract class AbstractClientPlayerEntityMixin {
    @Inject(method = "getCapeTexture", at = @At("HEAD"), cancellable = true)
    private void overrideCapeTexture(CallbackInfoReturnable<class_2960> cir) {
        class_742 player = (class_742) (Object) this;
        class_2960 customCape = CapeManager.getCape(player.method_5845());
        if (customCape != null) {
            cir.setReturnValue(customCape);
        }
    }
}