package net.tlotd.mixin.client;

import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_757;
import net.tlotd.effect.ModEffects;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_757.class)
public abstract class GameRendererMixin {

    @Shadow
    abstract void loadPostProcessor(class_2960 id);
    @Shadow
    public abstract void disablePostProcessor();

    @Unique
    private static boolean hadDrunk = false;
    @Unique
    private static boolean hadStoned = false;

    @Inject(method = "render", at = @At("HEAD"))
    private void onRender(float tickDelta, long startTime, boolean tick, CallbackInfo ci) {
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null) return;

        boolean hasDrunk = client.field_1724.method_6059(ModEffects.DRUNK);
        boolean hasStoned = client.field_1724.method_6059(ModEffects.STONED);

        if (hasDrunk && !hadDrunk) {
            this.loadPostProcessor(new class_2960("minecraft", "shaders/post/phosphor.json"));
        } else if (!hasDrunk && hadDrunk) {
            this.disablePostProcessor();
        }

        if (hasStoned && !hadStoned) {
            this.loadPostProcessor(new class_2960("minecraft", "shaders/post/blobs2.json"));
        } else if (!hasStoned && hadStoned) {
            this.disablePostProcessor();
        }

        hadDrunk = hasDrunk;
        hadStoned = hasStoned;
    }
}