package net.tlotd.tick;

import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2358;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;
import net.tlotd.config.ModConfigs;
import net.tlotd.effect.ModEffects;
import net.tlotd.world.dimension.ModDimensions;

import static net.tlotd.world.dimension.ModDimensions.LUNA_LEVEL_KEY;

public class ModServerTickEvents {

    private static int tickCounter = 0;

    public static void registerServerTickEvents() {
        ServerTickEvents.END_SERVER_TICK.register(server -> {
            tickCounter++;
            for (class_3222 player : server.method_3760().method_14571()) {
                if (player.method_37908().method_27983().equals(LUNA_LEVEL_KEY)) {
                    if (player.method_5809()) {
                        player.method_5646();
                    }
                    class_1293 h = new class_1293(ModEffects.HYPOXIA, 220, 0, true, false, true);
                    class_1293 s = new class_1293(class_1294.field_5906, 220, 0, true, false, true);
                    class_1293 j = new class_1293(class_1294.field_5913, 220, 2, true, false, true);
                    player.method_6092(h);
                    player.method_6092(s);
                    player.method_6092(j);
                    if (tickCounter % 20 == 0) {
                        extinguishFireBlocksAroundPlayer(player.method_51469(), player);
                    }
                }
                if (tickCounter % 20 == 0) {
                    handleDimensionTransfer(player);
                }
            }
        });
    }

    private static void extinguishFireBlocksAroundPlayer(class_3218 world, class_3222 player) {
        class_2338 playerPos = player.method_24515();
        int radius = 8;
        class_2338.class_2339 mutablePos = new class_2338.class_2339();
        for (int dx = -radius; dx <= radius; dx++) {
            for (int dy = -2; dy <= 4; dy++) {
                for (int dz = -radius; dz <= radius; dz++) {
                    mutablePos.method_10103(playerPos.method_10263() + dx, playerPos.method_10264() + dy, playerPos.method_10260() + dz);
                    class_2680 state = world.method_8320(mutablePos);
                    if (state.method_26204() instanceof class_2358) {
                        world.method_8501(mutablePos, class_2246.field_10124.method_9564());
                    }
                }
            }
        }
    }

    private static void handleDimensionTransfer(class_3222 player) {
        class_3218 currentWorld = player.method_51469();
        class_5321<class_1937> currentKey = currentWorld.method_27983();
        MinecraftServer server = currentWorld.method_8503();
        class_5321<class_1937> lunaKey = ModDimensions.LUNA_LEVEL_KEY;
        class_5321<class_1937> overworldKey = class_1937.field_25179;
        class_2338 pos = player.method_24515();
        if (currentKey.equals(overworldKey) && pos.method_10264() > ModConfigs.TERRA_WARP_HEIGHT_THRESHOLD) {
            class_3218 luna = server.method_3847(lunaKey);
            if (luna != null) {
                teleportPlayer(player, luna, new class_2338(pos.method_10263(), ModConfigs.LUNAR_WARP_DESTINATION_HEIGHT, pos.method_10260()));
            }
        } else if (currentKey.equals(lunaKey) && pos.method_10264() > ModConfigs.LUNAR_WARP_HEIGHT_THRESHOLD) {
            class_3218 overworld = server.method_3847(overworldKey);
            if (overworld != null) {
                teleportPlayer(player, overworld, new class_2338(pos.method_10263(), ModConfigs.TERRA_WARP_DESTINATION_HEIGHT, pos.method_10260()));
                if (ModConfigs.TERRA_FALL_DISTANCE_RESISTANCE != 0) {
                    player.method_6092(new class_1293(class_1294.field_5907, ModConfigs.TERRA_FALL_DISTANCE_RESISTANCE, 4, false, false, true));
                }
            }
        }
    }

    private static void teleportPlayer(class_3222 player, class_3218 destination, class_2338 targetPos) {
        player.method_18800(0,0,0);
        player.method_14251(destination, targetPos.method_10263() + 0.5, targetPos.method_10264(), targetPos.method_10260() + 0.5,
                player.method_36454(), player.method_36455());
    }
}
