package net.tlotd.util;

import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;

public class AdAstraOxygenNbtHelper {
    public static final String FLUID_ID = "ad_astra:oxygen";
    public static final long MAX_AMOUNT = 81000L;

    public static long getMaxOxygenForChestplate(class_1799 stack) {
        if (stack.method_31573(ModTags.Items.OXYGEN_STORING_4K)) return MAX_AMOUNT*4;
        if (stack.method_31573(ModTags.Items.OXYGEN_STORING_2K)) return MAX_AMOUNT*2;
        if (stack.method_31573(ModTags.Items.OXYGEN_STORING_1K)) return MAX_AMOUNT;
        return 0;
    }

    public static long getOxygen(class_1799 stack) {
        if (!stack.method_7985()) return 0L;
        class_2487 root = stack.method_7969();
        if (!root.method_10545("BotariumData")) return 0L;
        class_2487 botarium = root.method_10562("BotariumData");
        if (!botarium.method_10545("StoredFluids")) return 0L;
        class_2499 fluids = botarium.method_10554("StoredFluids", class_2520.field_33260);
        if (fluids.isEmpty()) return 0L;
        class_2487 fluidEntry = fluids.method_10602(0);
        if (!FLUID_ID.equals(fluidEntry.method_10558("Fluid"))) return 0L;
        return fluidEntry.method_10537("Amount");
    }

    public static void setOxygen(class_1799 stack, long amount) {
        amount = Math.min(amount, getMaxOxygenForChestplate(stack));
        amount = Math.max(amount, 0);
        class_2487 root = stack.method_7948();
        class_2487 botarium = root.method_10562("BotariumData");
        class_2499 fluids = botarium.method_10554("StoredFluids", class_2520.field_33260);
        class_2487 fluidEntry;
        if (fluids.isEmpty()) {
            fluidEntry = new class_2487();
            fluidEntry.method_10582("Fluid", FLUID_ID);
            fluids.add(fluidEntry);
        } else {
            fluidEntry = fluids.method_10602(0);
        }
        fluidEntry.method_10544("Amount", amount);
        fluids.method_10606(0, fluidEntry);
        botarium.method_10566("StoredFluids", fluids);
        root.method_10566("BotariumData", botarium);
        stack.method_7980(root);
    }
}