package net.tlotd.util;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2191;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_6880;
import net.minecraft.class_7733;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import net.tlotd.world.CustomTextureManager;
import net.tlotd.world.ModGlobalState;
import net.tlotd.world.SignalTrackingArray;

import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;

public class ModCommands {
    public static void registerCommands() {
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> {
            dispatcher.register(class_2170.method_9247("tlotd")
                            .then(class_2170.method_9247("debug")
                                    .requires(source -> source.method_9259(2))
                                    .executes(context -> {
                                        TelevisionSignalRegistry.debugDump();
                                        VideoGameRegistry.debugDump();
                                        context.getSource().method_9226(() -> class_2561.method_43470("Dumped TV signal & Video Game registries to console."), false);
                                        return 1;
                                    })
                            )
                    .then(class_2170.method_9247("signal")
                            .requires(source -> source.method_9259(2))
                            .then(class_2170.method_9247("add")
                                    .then(class_2170.method_9244("signal", class_7733.method_45603(registryAccess, class_7924.field_41197))
                                            .executes(ctx -> {
                                                class_6880<class_1792> entry = class_7733.method_45602(ctx, "signal", class_7924.field_41197);
                                                class_1792 item = entry.comp_349();
                                                class_3218 world = ctx.getSource().method_9225();
                                                SignalTrackingArray tracker = SignalTrackingArray.get(world);
                                                tracker.addSignal(item);
                                                ctx.getSource().method_9226(() -> class_2561.method_43470("Added signal: " + item.method_7876()), false);
                                                return 1;
                                            })
                                    )
                            )
                            .then(class_2170.method_9247("remove")
                                    .then(class_2170.method_9244("signal", class_7733.method_45603(registryAccess, class_7924.field_41197))
                                            .executes(ctx -> {
                                                class_6880<class_1792> entry = class_7733.method_45602(ctx, "signal", class_7924.field_41197);
                                                class_1792 item = entry.comp_349();
                                                class_2960 id = class_7923.field_41178.method_10221(item);
                                                class_3218 world = ctx.getSource().method_9225();
                                                SignalTrackingArray tracker = SignalTrackingArray.get(world);
                                                if (!tracker.hasSignal(id)) {
                                                    ctx.getSource().method_9213(class_2561.method_43470("No such signal is currently active: " + id));
                                                    return 0;
                                                }
                                                tracker.removeSignal(id);
                                                ctx.getSource().method_9226(() ->
                                                        class_2561.method_43470("Removed signal: ").method_10852(class_2561.method_43471(item.method_7876())), false
                                                );
                                                return 1;
                                            })
                                    )
                            )
                            .then(class_2170.method_9247("list")
                                    .executes(ctx -> {
                                        class_3218 world = ctx.getSource().method_9225();
                                        SignalTrackingArray tracker = SignalTrackingArray.get(world);
                                        String list = tracker.getAllSignals().stream()
                                                .map(class_2960::toString)
                                                .collect(Collectors.joining(", "));
                                        ctx.getSource().method_9226(() -> class_2561.method_43470("The " + tracker.getSignalCount() + " current signals are: " + list), false);
                                        return 1;
                                    })
                            )
                            .then(class_2170.method_9247("clear")
                                    .executes(ctx -> {
                                        class_3218 world = ctx.getSource().method_9225();
                                        SignalTrackingArray tracker = SignalTrackingArray.get(world);
                                        tracker.clearSignals();
                                        ctx.getSource().method_9226(() -> class_2561.method_43470("Cleared all signals"), false);
                                        return 1;
                                    })
                            )
                    )
                    .then(class_2170.method_9247("strippingDropsBark")
                            .executes(ctx -> {
                                boolean dropsBark = ModGlobalState.get(ctx.getSource().method_9211()).strippingDropsBark();
                                ctx.getSource().method_9226(() ->
                                        class_2561.method_43470("Stripping wood with an axe " + (dropsBark ? "dropps" : "doesn't drop") + " bark."), false);
                                return 1;
                            })
                            .then(class_2170.method_9244("value", BoolArgumentType.bool())
                                    .requires(src -> src.method_9259(2))
                                    .executes(ctx -> {
                                        boolean value = BoolArgumentType.getBool(ctx, "value");
                                        ModGlobalState state = ModGlobalState.get(ctx.getSource().method_9211());
                                        state.setStrippingDropsBark(value);
                                        ctx.getSource().method_9226(() ->
                                                class_2561.method_43470("Stripping wood with an axe " + (value ? "will" : "won't") + " drop bark."), true);
                                        return 1;
                                    })
                            )
                    )
                    .then(class_2170.method_9247("extractionOreCompat")
                            .executes(ctx -> {
                                boolean extraction = ModGlobalState.get(ctx.getSource().method_9211()).extractionOreCompat();
                                ctx.getSource().method_9226(() ->
                                        class_2561.method_43470("Experimental extraction compat " + (extraction ? "is" : "isn't") + " enabled."), false);
                                return 1;
                            })
                            .then(class_2170.method_9244("value", BoolArgumentType.bool())
                                    .requires(src -> src.method_9259(2))
                                    .executes(ctx -> {
                                        boolean value = BoolArgumentType.getBool(ctx, "value");
                                        ModGlobalState state = ModGlobalState.get(ctx.getSource().method_9211());
                                        state.setExtractionOreCompat(value);
                                        ctx.getSource().method_9226(() ->
                                                class_2561.method_43470("Experimental extraction compat " + (value ? "will" : "won't") + " be enabled."), true);
                                        return 1;
                                    })
                            )
                    )
                    .then(class_2170.method_9247("elevatorMaxDistance")
                            .executes(ctx -> {
                                int distance = ModGlobalState.get(ctx.getSource().method_9211()).elevatorMaxDistance();
                                ctx.getSource().method_9226(() ->
                                        class_2561.method_43470("The elevator can raise players up to " + distance + " blocks."), false);
                                return 1;
                            })
                            .then(class_2170.method_9244("value", IntegerArgumentType.integer(0, 1000))
                                    .requires(src -> src.method_9259(2))
                                    .executes(ctx -> {
                                        int value = IntegerArgumentType.getInteger(ctx, "value");
                                        ModGlobalState state = ModGlobalState.get(ctx.getSource().method_9211());
                                        state.setElevatorMaxDistance(value);
                                        ctx.getSource().method_9226(() ->
                                                class_2561.method_43470("The elevator will raise players up to " + value + " blocks."), true);
                                        return 1;
                                    })
                            )
                    )
                    .then(class_2170.method_9247("vanishedRepresentativeRewards")
                            .executes(ctx -> {
                                boolean rewards = ModGlobalState.get(ctx.getSource().method_9211()).formerTlotdRewards();
                                ctx.getSource().method_9226(() ->
                                        class_2561.method_43470("Vanished representatives " + (rewards ? "are" : "aren't") + " rewarded."), false);
                                return 1;
                            })
                            .then(class_2170.method_9244("value", BoolArgumentType.bool())
                                    .requires(src -> src.method_9259(2))
                                    .executes(ctx -> {
                                          boolean value = BoolArgumentType.getBool(ctx, "value");
                                          ModGlobalState state = ModGlobalState.get(ctx.getSource().method_9211());
                                          state.setFormerTlotdRewards(value);
                                          ctx.getSource().method_9226(() ->
                                                  class_2561.method_43470("Vanished representatives " + (value ? "will" : "won't") + " be rewarded."), true);
                                          return 1;
                                    })
                            )
                    )
                    .then(class_2170.method_9247("textureID")
                        .then(class_2170.method_9247("get")
                                .executes(ctx -> {
                                    class_2168 source = ctx.getSource();
                                    class_3222 player = source.method_44023();
                                    if (player == null) {
                                        source.method_9213(class_2561.method_43470("You must be a player to use this without arguments."));
                                        return 0;
                                    }
                                    CustomTextureManager manager = CustomTextureManager.get(source.method_9211());
                                    int id = manager.getTexture(player.method_5667());
                                    if (id >= 0) {
                                        source.method_9226(() ->
                                                class_2561.method_43470("Your custom texture ID is ").method_10852(class_2561.method_43470(String.valueOf(id)).method_27692(class_124.field_1075)), false);
                                    } else {
                                        source.method_9226(() -> class_2561.method_43470("You don’t have a custom texture ID assigned."), false);
                                    }
                                    return 1;
                                })
                                .then(class_2170.method_9244("player", class_2191.method_9329())
                                        .executes(ctx -> {
                                            class_2168 source = ctx.getSource();
                                            Collection<GameProfile> profiles = class_2191.method_9330(ctx, "player");
                                            CustomTextureManager manager = CustomTextureManager.get(source.method_9211());
                                            for (GameProfile profile : profiles) {
                                                int id = manager.getTexture(profile.getId());
                                                if (id >= 0) {
                                                    source.method_9226(() ->
                                                            class_2561.method_43470("🎨 ").method_10852(class_2561.method_43470(profile.getName() + " → ID " + id)
                                                                    .method_27692(class_124.field_1075)), false);
                                                } else {
                                                    source.method_9226(() ->
                                                            class_2561.method_43470(profile.getName() + " has no assigned texture ID."), false);
                                                }
                                            }
                                            return 1;
                                        })
                                )
                        )
                        .then(class_2170.method_9247("set")
                                .requires(source -> source.method_9259(2))
                                .then(class_2170.method_9244("player", class_2191.method_9329())
                                        .then(class_2170.method_9244("id", IntegerArgumentType.integer(0, 127))
                                                .executes(ctx -> {
                                                    class_2168 source = ctx.getSource();
                                                    Collection<GameProfile> profiles = class_2191.method_9330(ctx, "player");
                                                    int id = IntegerArgumentType.getInteger(ctx, "id");
                                                    CustomTextureManager manager = CustomTextureManager.get(source.method_9211());
                                                    for (GameProfile profile : profiles) {
                                                        manager.setTexture(profile.getId(), id);
                                                    }
                                                    source.method_9226(() ->
                                                            class_2561.method_43470("Set custom texture ID to " + id + " for " + profiles.size() + " player(s)."), true);
                                                    return 1;
                                                })
                                        )
                                )
                        )
                        .then(class_2170.method_9247("list")
                                .requires(source -> source.method_9259(2))
                                .executes(ctx -> {
                                    class_2168 source = ctx.getSource();
                                    CustomTextureManager manager = CustomTextureManager.get(source.method_9211());
                                    Map<UUID, Integer> skins = manager.getAll();
                                    if (skins.isEmpty()) {
                                        source.method_9226(() -> class_2561.method_43470("No custom texture IDs have been assigned yet."), false);
                                        return 1;
                                    }
                                    source.method_9226(() -> class_2561.method_43470("Assigned custom texture IDs:").method_27692(class_124.field_1065), false);
                                    MinecraftServer server = source.method_9211();
                                    for (Map.Entry<UUID, Integer> entry : skins.entrySet()) {
                                        String name = server.method_3793().method_14512(entry.getKey())
                                                .map(GameProfile::getName)
                                                .orElse(entry.getKey().toString());
                                        source.method_9226(() ->
                                                        class_2561.method_43470("- " + name + ": ").method_10852(class_2561.method_43470(String.valueOf(entry.getValue())).method_27692(class_124.field_1075)),
                                                false);
                                    }
                                    return 1;
                                })
                        )
                        .then(class_2170.method_9247("remove")
                                .requires(source -> source.method_9259(2))
                                .then(class_2170.method_9244("player", class_2191.method_9329())
                                        .executes(ctx -> {
                                            class_2168 source = ctx.getSource();
                                            Collection<GameProfile> profiles = class_2191.method_9330(ctx, "player");
                                            CustomTextureManager manager = CustomTextureManager.get(source.method_9211());
                                            int[] removedCount = {0};
                                            for (GameProfile profile : profiles) {
                                                if (manager.removeTexture(profile.getId())) {
                                                    removedCount[0]++;
                                                    source.method_9226(
                                                            () -> class_2561.method_43470("Removed custom texture ID for " + profile.getName() + "."),
                                                            true
                                                    );
                                                } else {
                                                    source.method_9226(
                                                            () -> class_2561.method_43470(profile.getName() + " had no custom texture ID assigned."),
                                                            false
                                                    );
                                                }
                                            }
                                            if (removedCount[0] == 0) {
                                                source.method_9226(() -> class_2561.method_43470("No entries were removed."), false);
                                            } else if (removedCount[0] > 1) {
                                                int finalCount = removedCount[0];
                                                source.method_9226(
                                                        () -> class_2561.method_43470("Removed " + finalCount + " player entries."),
                                                        true
                                                );
                                            }
                                            return 1;
                                        })
                                )
                        )
                    )
            );
        });
    }
}