package net.tlotd.util;

import java.util.*;
import net.minecraft.class_2248;
import net.minecraft.class_2960;

public class TelevisionSignalRegistry {
    private static final Map<class_2960, SignalEntry> SIGNALS = new LinkedHashMap<>();

    public record SignalEntry(class_2960 signalItem, class_2248 offBlock, class_2248 onBlock, int channel) {}

    public static class_2960 normalize(class_2960 id) {
        if (id == null) return null;
        return new class_2960(id.method_12836().toLowerCase(Locale.ROOT), id.method_12832().toLowerCase(Locale.ROOT));
    }

    public static void register(SignalEntry entry) {
        class_2960 key = normalize(entry.signalItem());
        if (SIGNALS.containsKey(key)) {
            System.out.println("[TLOTD-TV] Warning: Duplicate registration for signal " + key);
            return;
        }
        SIGNALS.put(key, entry);
    }

    public static void registerBatch(class_2960[] itemIds, class_2248 offBlock, class_2248 onBlock, int startingChannel) {
        int channel = startingChannel;
        for (class_2960 id : itemIds) {
            register(new SignalEntry(normalize(id), offBlock, onBlock, channel++));
        }
    }

    public static Optional<SignalEntry> findBySignal(class_2960 id) {
        if (id == null) return Optional.empty();
        class_2960 normalized = normalize(id);
        return Optional.ofNullable(SIGNALS.get(normalized));
    }

    public static Collection<SignalEntry> getAll() {
        return SIGNALS.values();
    }

    public static void debugDump() {
        if (SIGNALS.isEmpty()) {
            System.out.println("[TelevisionSignalRegistry] No signals registered.");
            return;
        }
        System.out.println("[TelevisionSignalRegistry] Dumping all registered signals (" + SIGNALS.size() + "):\n");
        for (SignalEntry entry : SIGNALS.values()) {
            System.out.println("Signal: " + entry.signalItem()
                    + "\n  Off Block: " + entry.offBlock()
                    + "\n  On Block: " + entry.onBlock()
                    + "\n  Channel: " + entry.channel()
                    + "\n");
        }
        System.out.println("[TelevisionSignalRegistry] End of dump.\n");
    }
}