package net.tlotd.util;

import java.util.*;
import net.minecraft.class_2248;
import net.minecraft.class_2960;

public class VideoGameRegistry {
    private static final Map<class_2960, SignalEntry> SIGNALS = new LinkedHashMap<>();

    public record SignalEntry(class_2960 signalItem, class_2248 tvBlock, class_2248 computerBlock, int gameID) {}

    public static class_2960 normalize(class_2960 id) {
        if (id == null) return null;
        return new class_2960(id.method_12836().toLowerCase(Locale.ROOT), id.method_12832().toLowerCase(Locale.ROOT));
    }

    public static void register(SignalEntry entry) {
        class_2960 key = normalize(entry.signalItem());
        if (SIGNALS.containsKey(key)) {
            System.out.println("[TLOTD-Games] Warning: Duplicate registration for signal " + key);
            return;
        }
        SIGNALS.put(key, entry);
    }

    public static void registerBatch(class_2960[] itemIds, class_2248 tvBlock, class_2248 computerBlock,int startinggameID) {
        int gameID = startinggameID;
        for (class_2960 id : itemIds) {
            register(new SignalEntry(normalize(id), tvBlock, computerBlock, gameID++));
        }
    }

    public static Optional<SignalEntry> findBySignal(class_2960 id) {
        if (id == null) return Optional.empty();
        class_2960 normalized = normalize(id);
        return Optional.ofNullable(SIGNALS.get(normalized));
    }

    public static Collection<SignalEntry> getAll() {
        return SIGNALS.values();
    }

    public static void debugDump() {
        if (SIGNALS.isEmpty()) {
            System.out.println("[VideoGameRegistry] No signals registered.");
            return;
        }
        System.out.println("[VideoGameRegistry] Dumping all registered signals (" + SIGNALS.size() + "):\n");
        for (SignalEntry entry : SIGNALS.values()) {
            System.out.println("Signal: " + entry.signalItem()
                    + "\n  TV Block: " + entry.tvBlock()
                    + "\n  Computer Block: " + entry.computerBlock()
                    + "\n  GameID: " + entry.gameID()
                    + "\n");
        }
        System.out.println("[VideoGameRegistry] End of dump.\n");
    }
}