package net.tlotd.world;

import net.minecraft.class_18;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_3218;
import net.minecraft.server.MinecraftServer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class CustomTextureManager extends class_18 {
    private final Map<UUID, Integer> textureMap = new HashMap<>();

    public static CustomTextureManager get(MinecraftServer server) {
        class_3218 overworld = server.method_30002();
        return overworld.method_17983().method_17924(CustomTextureManager::fromNbt, CustomTextureManager::new, "TLOTD_Textures");
    }

    public static CustomTextureManager fromNbt(class_2487 tag) {
        CustomTextureManager manager = new CustomTextureManager();
        class_2499 list = tag.method_10554("Textures", class_2520.field_33260);
        for (class_2520 e : list) {
            class_2487 nbt = (class_2487) e;
            manager.textureMap.put(nbt.method_25926("Player"), nbt.method_10550("Texture"));
        }
        return manager;
    }

    @Override
    public class_2487 method_75(class_2487 nbt) {
        class_2499 list = new class_2499();
        for (Map.Entry<UUID, Integer> entry : textureMap.entrySet()) {
            class_2487 textureData = new class_2487();
            textureData.method_25927("Player", entry.getKey());
            textureData.method_10569("Texture", entry.getValue());
            list.add(textureData);
        }
        nbt.method_10566("Textures", list);
        return nbt;
    }

    public void setTexture(UUID player, int textureId) {
        textureMap.put(player, textureId);
        method_80();
    }

    public int getTexture(UUID player) {
        return textureMap.getOrDefault(player, -1);
    }

    public Map<UUID, Integer> getAll() {
        return Collections.unmodifiableMap(textureMap);
    }

    public boolean removeTexture(UUID player) {
        if (textureMap.remove(player) != null) {
            method_80();
            return true;
        }
        return false;
    }

    public boolean hasTexture(UUID player) {
        return textureMap.containsKey(player);
    }
}