package net.tlotd.world;

import net.fabricmc.fabric.api.event.lifecycle.v1.ServerChunkEvents;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2806;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3485;
import net.minecraft.class_3492;
import net.minecraft.class_3499;
import net.tlotd.TLOTD;
import net.tlotd.compat.CompatModsCheck;
import net.tlotd.world.dimension.ModDimensions;

import java.util.Optional;


public class ModChunkEvents {

    public static void generateModWorldGen() {
        ServerChunkEvents.CHUNK_LOAD.register((world, chunk) -> {
            class_1923 chunkPos = chunk.method_12004();

            if (world.method_27983().equals(ModDimensions.LUNA_LEVEL_KEY)) {
                if (chunkPos.field_9181 == -6 && chunkPos.field_9180 == -6) {
                    world.method_8503().execute(() -> {
                        StructurePlacedPersistentState state = StructurePlacedPersistentState.get(world);
                        if (!state.isPlaced()) {
                            placeStructure(world, new class_2960(TLOTD.MOD_ID, "alien_gate"), new class_2338(-6, -66, -6));
                            state.setPlaced(true);
                            state.method_80();
                        }
                    });
                }
            }
        });
    }

    public static void placeStructure(class_3218 world, class_2960 id, class_2338 origin) {
        class_3485 manager = world.method_14183();
        Optional<class_3499> opt = manager.method_15094(id);
        if (opt.isEmpty()) {
            System.out.println("[DEBUG] Structure " + id + " not found!");
            return;
        }
        class_3499 template = opt.get();
        class_2382 size = template.method_15160();
        System.out.println("[DEBUG] Placing structure " + id + " at " + origin + " size=" + size);
        class_3492 data = new class_3492()
                .method_15125(class_2415.field_11302)
                .method_15123(class_2470.field_11467)
                .method_15133(false);
        if (!world.method_8393(origin.method_10263() >> 4, origin.method_10260() >> 4)) {
            System.out.println("[WARN] Chunk not loaded for " + id + ", delaying placement");
            return;
        }
        template.method_15172(world, origin, origin, data, world.method_8409(), 2);
    }

    public static void spawnBackroomsStructures(class_3222 player) {
        class_3218 targetWorld = player.method_5682().method_3847(ModDimensions.BACKROOMS_LEVEL_KEY);
        if (targetWorld == null) return;
        StructurePlacedPersistentState state = StructurePlacedPersistentState.get(targetWorld);
        if (!state.isPlaced()) {
            player.method_14251(targetWorld, 0.5, 28.1, 0.5, 0.0F, 0.5F);
            for (int cx = -1; cx <= 0; cx++) {
                for (int cz = -1; cz <= 0; cz++) {
                    class_2338 lowerPos = new class_2338(cx * 16, 0, cz * 16);
                    class_2338 upperPos = new class_2338(cx * 16, 10, cz * 16);
                    targetWorld.method_8402(lowerPos.method_10263() >> 4, lowerPos.method_10260() >> 4, class_2806.field_12803, true);
                    targetWorld.method_8402(upperPos.method_10263() >> 4, upperPos.method_10260() >> 4, class_2806.field_12803, true);
                    String compat = "";
                    if (cx == -1 && CompatModsCheck.CREATE) {
                        compat = "_create";
                    }
                    class_2960 lowerId = new class_2960(TLOTD.MOD_ID, "backrooms_lower_" + cx + "_" + cz);
                    class_2960 upperId = new class_2960(TLOTD.MOD_ID, "backrooms_upper_" + cx + "_" + cz + compat);
                    placeStructure(targetWorld, lowerId, lowerPos);
                    placeStructure(targetWorld, upperId, upperPos);
                }
            }
            state.setPlaced(true);
            state.method_80();
        } else {
            player.method_14251(targetWorld, 0.5, 28.1, 0.5, 0.0F, 0.5F);
        }
    }
}