package net.tlotd.world;

import net.minecraft.class_18;
import net.minecraft.class_2487;
import net.minecraft.class_3218;
import net.minecraft.server.MinecraftServer;

public class ModGlobalState extends class_18 {
    private boolean axeStrippingBark = true;
    private boolean extractionOreCompat = true;
    private int elevatorMaxDistance = 100;
    private boolean formerTlotdRewards = false;

    public static ModGlobalState get(MinecraftServer server) {
        class_3218 overworld = server.method_30002();
        return overworld.method_17983().method_17924(ModGlobalState::fromNbt, ModGlobalState::new, "TLOTD_Data");
    }

    private static ModGlobalState fromNbt(class_2487 nbt) {
        ModGlobalState state = new ModGlobalState();
        state.axeStrippingBark = nbt.method_10577("AxeStrippingBark");
        state.extractionOreCompat = nbt.method_10577("ExtractionOreCompat");
        state.elevatorMaxDistance = nbt.method_10550("ElevatorMaxDistance");
        state.formerTlotdRewards = nbt.method_10577("FormerTLOTDRewards");
        return state;
    }

    @Override
    public class_2487 method_75(class_2487 nbt) {
        nbt.method_10556("AxeStrippingBark", axeStrippingBark);
        nbt.method_10556("ExtractionOreCompat", extractionOreCompat);
        nbt.method_10569("ElevatorMaxDistance", elevatorMaxDistance);
        nbt.method_10556("FormerTLOTDRewards", formerTlotdRewards);
        return nbt;
    }

    public boolean strippingDropsBark() {
        return axeStrippingBark;
    }

    public void setStrippingDropsBark(boolean value) {
        this.axeStrippingBark = value;
        method_80();
    }

    public boolean extractionOreCompat() {
        return extractionOreCompat;
    }

    public void setExtractionOreCompat(boolean value) {
        this.extractionOreCompat = value;
        method_80();
    }

    public int elevatorMaxDistance() {
        return elevatorMaxDistance;
    }

    public void setElevatorMaxDistance(int value) {
        this.elevatorMaxDistance = value;
        method_80();
    }

    public boolean formerTlotdRewards() {
        return formerTlotdRewards;
    }

    public void setFormerTlotdRewards(boolean value) {
        this.formerTlotdRewards = value;
        method_80();
    }
}