package net.tlotd.world;

import java.util.*;
import net.minecraft.class_1792;
import net.minecraft.class_18;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_7923;

public class SignalTrackingArray extends class_18 {
    private final Set<class_2960> signals = new HashSet<>();

    public static SignalTrackingArray get(class_3218 world) {
        return world.method_17983().method_17924(
                SignalTrackingArray::createFromNbt,
                SignalTrackingArray::new,
                "tlotd_signals"
        );
    }

    public static SignalTrackingArray createFromNbt(class_2487 nbt) {
        SignalTrackingArray state = new SignalTrackingArray();
        class_2499 list = nbt.method_10554("signals", class_2520.field_33258);

        for (class_2520 elem : list) {
            String idStr = elem.method_10714();
            class_2960 id = class_2960.method_12829(idStr);
            if (id != null) state.signals.add(id);
        }

        return state;
    }

    @Override
    public class_2487 method_75(class_2487 nbt) {
        class_2499 list = new class_2499();
        for (class_2960 id : signals) {
            list.add(class_2519.method_23256(id.toString()));
        }
        nbt.method_10566("signals", list);
        return nbt;
    }

    public boolean hasSignal(class_2960 id) {
        return signals.contains(id);
    }

    public boolean hasSignal(class_1792 item) {
        return hasSignal(class_7923.field_41178.method_10221(item));
    }

    public void addSignal(class_2960 id) {
        if (signals.add(id)) method_80();
    }

    public void addSignal(class_1792 item) {
        addSignal(class_7923.field_41178.method_10221(item));
    }

    public void removeSignal(class_2960 id) {
        if (signals.remove(id)) method_80();
    }

    public void removeSignal(class_1792 item) {
        removeSignal(class_7923.field_41178.method_10221(item));
    }

    public void clearSignals() {
        if (!signals.isEmpty()) {
            signals.clear();
            method_80();
        }
    }

    public Set<class_2960> getAllSignals() {
        return Collections.unmodifiableSet(signals);
    }

    public int getSignalCount() {
        return Collections.unmodifiableSet(signals).size();
    }

    public boolean hasAnySignals() {
        return !signals.isEmpty();
    }
}