package net.tlotd.block.custom;

import net.minecraft.block.*;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2318;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2464;
import net.minecraft.class_2470;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2753;
import net.minecraft.class_2758;
import net.minecraft.class_3419;
import net.minecraft.class_3610;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.tlotd.block.ModBlocks;
import net.tlotd.item.ModItems;
import net.tlotd.sound.ModSounds;
import net.tlotd.util.ModTags;

import static net.tlotd.block.custom.KeycardProgrammerBlock.ON;

public class ComputerBlock extends class_2248 {

    public static final class_2758 SCREEN = class_2758.method_11867("screen", 0, 7);

    public static final class_2746 WATERLOGGED = class_2741.field_12508;

    public static final class_2753 FACING = class_2318.field_10927;

    @Override
    public class_2680 method_9605(class_1750 ctx) {
        return this.method_9564()
                .method_11657(FACING, ctx.method_8042())
                .method_11657(WATERLOGGED, ctx.method_8045().method_8316(ctx.method_8037()).method_39360(class_3612.field_15910))
                .method_11657(SCREEN, 0);
    }

    @Override
    public class_3610 method_9545(class_2680 state) {
        return state.method_11654(WATERLOGGED) ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    @Override
    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        if (state.method_11654(WATERLOGGED)) {
            world.method_39281(pos, class_3612.field_15910, class_3612.field_15910.method_15789(world));
        }

        return super.method_9559(state, direction, neighborState, world, pos, neighborPos);
    }

    @Override
    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return state.method_11657(FACING, rotation.method_10503(state.method_11654(FACING)));
    }

    @Override
    public void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(FACING, WATERLOGGED, SCREEN);
    }

    public ComputerBlock(class_2251 settings) {
        super(settings);
        this.method_9590(this.field_10647.method_11664().method_11657(FACING, class_2350.field_11043).method_11657(WATERLOGGED, false).method_11657(SCREEN, 0));
    }

    public static final class_265 NORTH_SHAPE = class_259.method_1084(
            class_2248.method_9541(0, 0, 0, 16, 13, 12),
            class_2248.method_9541(0, 0, 12.5, 16, 1, 16));
    public static final class_265 WEST_SHAPE = class_259.method_1084(
            class_2248.method_9541(0, 0, 0, 12, 13, 16),
            class_2248.method_9541(12.5, 0, 0, 16, 1, 16));
    public static final class_265 SOUTH_SHAPE = class_259.method_1084(
            class_2248.method_9541(0, 0, 4, 16, 13, 16),
            class_2248.method_9541(0, 0, 0, 16, 1, 3.5));
    public static final class_265 EAST_SHAPE = class_259.method_1084(
            class_2248.method_9541(4, 0, 0, 16, 13, 16),
            class_2248.method_9541(0, 0, 0, 3.5, 1, 16));

    @Override
    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return switch (state.method_11654(FACING)) {
            case field_11034 -> EAST_SHAPE;
            case field_11035 -> SOUTH_SHAPE;
            case field_11039 -> WEST_SHAPE;
            default -> NORTH_SHAPE;
        };
    }

    @Override
    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    @Override
    public class_1799 method_9574(class_1922 world, class_2338 pos, class_2680 state) {
        return ModBlocks.COMPUTER.method_8389().method_7854();
    }

    private void TurnOffBlocks(class_1937 world, class_2338 pos) {
        if (world.method_8320(pos.method_10095()).method_26164(ModTags.Blocks.COMPUTER_ACCESSORIES)) {
            world.method_8501(pos.method_10095(), world.method_8320(pos.method_10095()).method_11657(ON, false));
        }
        if (world.method_8320(pos.method_10078()).method_26164(ModTags.Blocks.COMPUTER_ACCESSORIES)) {
            world.method_8501(pos.method_10078(), world.method_8320(pos.method_10078()).method_11657(ON, false));
        }
        if (world.method_8320(pos.method_10072()).method_26164(ModTags.Blocks.COMPUTER_ACCESSORIES)) {
            world.method_8501(pos.method_10072(), world.method_8320(pos.method_10072()).method_11657(ON, false));
        }
        if (world.method_8320(pos.method_10067()).method_26164(ModTags.Blocks.COMPUTER_ACCESSORIES)) {
            world.method_8501(pos.method_10067(), world.method_8320(pos.method_10067()).method_11657(ON, false));
        }
    }

    @Override
    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        if (player.method_5715()) {
            if (!world.field_9236) {
                if (state.method_26204().equals(ModBlocks.COMPUTER)) {
                    world.method_8501(pos, ModBlocks.COMPUTER_ON.method_34725(state));
                    if (world.method_8320(pos.method_10095()).method_26164(ModTags.Blocks.COMPUTER_ACCESSORIES)) {
                        world.method_8501(pos.method_10095(), world.method_8320(pos.method_10095()).method_11657(ON, true));
                    }
                    if (world.method_8320(pos.method_10078()).method_26164(ModTags.Blocks.COMPUTER_ACCESSORIES)) {
                        world.method_8501(pos.method_10078(), world.method_8320(pos.method_10078()).method_11657(ON, true));
                    }
                    if (world.method_8320(pos.method_10072()).method_26164(ModTags.Blocks.COMPUTER_ACCESSORIES)) {
                        world.method_8501(pos.method_10072(), world.method_8320(pos.method_10072()).method_11657(ON, true));
                    }
                    if (world.method_8320(pos.method_10067()).method_26164(ModTags.Blocks.COMPUTER_ACCESSORIES)) {
                        world.method_8501(pos.method_10067(), world.method_8320(pos.method_10067()).method_11657(ON, true));
                    }
                } else {
                    world.method_8501(pos, ModBlocks.COMPUTER.method_34725(state).method_11657(SCREEN, 0));
                    TurnOffBlocks(world, pos);
                }
                world.method_8396(null, pos, ModSounds.BLOCK_COMPUTER_INTERACT, class_3419.field_15245, 1.0f, 1.0f);
            }
            return class_1269.field_5812;
        } else if (state.method_26204().equals(ModBlocks.COMPUTER_ON)) {
            if (!world.field_9236) {
                class_1799 stack = player.method_5998(hand);
                int x = 0;
                if (stack.method_31573(ModTags.Items.GAME_CARTRIDGES)) {
                    if(stack.method_31574(ModItems.GAME_CARTRIDGE_1)) {x = 2;}
                    else if(stack.method_31574(ModItems.GAME_CARTRIDGE_2)) {x = 4;}
                    else if(stack.method_31574(ModItems.GAME_CARTRIDGE_3)) {x = 6;}
                } else if (state.method_11654(SCREEN) == 0 || state.method_11654(SCREEN) == 2 || state.method_11654(SCREEN) == 4 || state.method_11654(SCREEN) == 6) {
                    x = state.method_11654(SCREEN) + 1;
                } else {
                    x = state.method_11654(SCREEN) - 1;
                }
                world.method_8501(pos, ModBlocks.COMPUTER_ON.method_34725(state).method_11657(SCREEN, x));
                world.method_8396(null, pos, ModSounds.BLOCK_COMPUTER_INTERACT, class_3419.field_15245, 1.0f, 1.0f);
            }
            return class_1269.field_5812;
        }
        return class_1269.field_5814;
    }

    @Override
    public void method_9585(class_1936 world, class_2338 pos, class_2680 state) {
        super.method_9585(world, pos, state);
        TurnOffBlocks((class_1937) world, pos);
    }
}