package net.tlotd.block.custom;

import net.minecraft.block.*;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2318;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2464;
import net.minecraft.class_2470;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2753;
import net.minecraft.class_3419;
import net.minecraft.class_3610;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.tlotd.config.ModConfigs;
import net.tlotd.sound.ModSounds;
import net.tlotd.util.ModTags;

public class ElevatorControllerBlock extends class_2248 {

    public static final class_2746 WATERLOGGED = class_2741.field_12508;

    public static final class_2753 FACING = class_2318.field_10927;



    @Override
    public class_2680 method_9605(class_1750 ctx) {
        return this.method_9564()
                .method_11657(FACING, ctx.method_8042())
                .method_11657(WATERLOGGED, ctx.method_8045().method_8316(ctx.method_8037()).method_39360(class_3612.field_15910));
    }

    @Override
    public class_3610 method_9545(class_2680 state) {
        return state.method_11654(WATERLOGGED) ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    @Override
    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        if (state.method_11654(WATERLOGGED)) {
            world.method_39281(pos, class_3612.field_15910, class_3612.field_15910.method_15789(world));
        }

        return super.method_9559(state, direction, neighborState, world, pos, neighborPos);
    }

    @Override
    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return state.method_11657(FACING, rotation.method_10503(state.method_11654(FACING)));
    }

    @Override
    public void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(FACING, WATERLOGGED);
    }

    public ElevatorControllerBlock(class_2251 settings) {
        super(settings);
        this.method_9590(this.field_10647.method_11664().method_11657(FACING, class_2350.field_11043).method_11657(WATERLOGGED, false));
    }

    private static final class_265 BASE_SHAPE = class_2248.method_9541(0,15,0,16,16,16);

    public static final class_265 WEST_SHAPE = class_259.method_17786(
            class_2248.method_9541(0.0, 0.0, 0.0, 1.0, 15.0, 16.0),
            class_2248.method_9541(0.0, 0.0, 0.0, 16.0, 15.0, 1.0),
            class_2248.method_9541(0.0, 0.0, 15.0, 16.0, 15.0, 16.0),
            BASE_SHAPE
    );
    public static final class_265 NORTH_SHAPE = class_259.method_17786(
            class_2248.method_9541(0.0, 0.0, 0.0, 1.0, 15.0, 16.0),
            class_2248.method_9541(15.0, 0.0, 0.0, 16.0, 15.0, 16.0),
            class_2248.method_9541(0.0, 0.0, 0.0, 16.0, 15.0, 1.0),
            BASE_SHAPE
    );
    public static final class_265 EAST_SHAPE = class_259.method_17786(
            class_2248.method_9541(15.0, 0.0, 0.0, 16.0, 15.0, 16.0),
            class_2248.method_9541(0.0, 0.0, 0.0, 16.0, 15.0, 1.0),
            class_2248.method_9541(0.0, 0.0, 15.0, 16.0, 15.0, 16.0),
            BASE_SHAPE
    );
    public static final class_265 SOUTH_SHAPE = class_259.method_17786(
            class_2248.method_9541(0.0, 0.0, 0.0, 1.0, 15.0, 16.0),
            class_2248.method_9541(15.0, 0.0, 0.0, 16.0, 15.0, 16.0),
            class_2248.method_9541(0.0, 0.0, 15.0, 16.0, 15.0, 16.0),
            BASE_SHAPE
    );

    @Override
    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return switch (state.method_11654(FACING)) {
            case field_11043 -> NORTH_SHAPE;
            case field_11035 -> SOUTH_SHAPE;
            case field_11034 -> EAST_SHAPE;
            case field_11039 -> WEST_SHAPE;
            default -> BASE_SHAPE;
        };
    }

    @Override
    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    @Override
    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        if (!world.field_9236) {
            if (player.method_19538().method_1031(0,1,0).method_24802(pos.method_46558(), 0.5)) {
                int search_y;
                if (player.method_5715()) {
                    for(search_y = -2; search_y>= -ModConfigs.ELEVATOR_MAX_DISTANCE-1; search_y--){
                        if((world.method_8320(pos.method_10069(0, search_y,0)).method_26164(ModTags.Blocks.ELEVATOR_BASES)) && (world.method_8320(pos.method_10069(0,1+search_y,0)).method_26164(ModTags.Blocks.ELEVATOR_CONTROLLERS))) {
                            player.method_23327(player.method_19538().method_10216(), player.method_19538().method_10214()+search_y+1, player.method_19538().method_10215());
                            world.method_8396(null, pos.method_10069(0, search_y,0), ModSounds.BLOCK_ELEVATOR_PLING, class_3419.field_15245, 1.0f, 1.0f);
                        }
                    }
                } else {
                    for(search_y = 0; search_y<=ModConfigs.ELEVATOR_MAX_DISTANCE-1; search_y++){
                        if((world.method_8320(pos.method_10069(0, search_y,0)).method_26164(ModTags.Blocks.ELEVATOR_BASES)) && (world.method_8320(pos.method_10069(0,1+search_y,0)).method_26164(ModTags.Blocks.ELEVATOR_CONTROLLERS))) {
                            player.method_23327(player.method_19538().method_10216(), player.method_19538().method_10214()+search_y+1, player.method_19538().method_10215());
                            world.method_8396(null, pos.method_10069(0, search_y,0), ModSounds.BLOCK_ELEVATOR_PLING, class_3419.field_15245, 1.0f, 1.0f);
                        }
                    }
                }
            }
        }
        return class_1269.field_5812;
    }
}
