package net.tlotd.block.custom;

import net.minecraft.block.*;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2269;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_5712;
import net.minecraft.class_8177;
import net.tlotd.block.entity.KeycardReaderBlockEntity;
import net.tlotd.item.ModItems;
import net.tlotd.sound.ModSounds;
import org.jetbrains.annotations.Nullable;

public class KeycardReaderBlock extends class_2269 implements class_2343 {

    public static final class_265 SOUTH_SHAPE = class_2248.method_9541(4, 2, 0, 12, 14, 1);
    public static final class_265 WEST_SHAPE = class_2248.method_9541(15, 2, 4, 16, 14, 12);
    public static final class_265 NORTH_SHAPE = class_2248.method_9541(4, 2, 15, 12, 14, 16);
    public static final class_265 EAST_SHAPE = class_2248.method_9541(0, 2, 4, 1, 14, 12);
    public static final class_265 DOWN_SHAPE = class_2248.method_9541(2, 0, 4, 14, 1, 12);
    public static final class_265 DOWN_SHAPE_2 = class_2248.method_9541(4, 0, 2, 12, 1, 14);
    public static final class_265 UP_SHAPE = class_2248.method_9541(2, 15, 4, 14, 16, 12);
    public static final class_265 UP_SHAPE_2 = class_2248.method_9541(4, 15, 2, 12, 16, 14);

    public KeycardReaderBlock(class_2251 settings, class_8177 blockSetType, int pressTicks, boolean wooden) {
        super(settings, blockSetType, pressTicks, wooden);
    }

    @Override
    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        class_1799 stack = player.method_5998(hand);
        class_2586 blockEntity = world.method_8321(pos);
        if (!world.field_9236 && stack.method_31574(ModItems.KEYCARD) && blockEntity instanceof KeycardReaderBlockEntity keycardReaderBlockEntity) {
            if (!stack.method_7985()) {
                player.method_7353(class_2561.method_43471("block.tlotd.keycard_reader.no_password"), true);
                world.method_8396(null, pos, class_3417.field_15008, class_3419.field_15245, 1.0f, 1.0f);
            }
            else {
                if (keycardReaderBlockEntity.password.isEmpty()) {
                    keycardReaderBlockEntity.password = stack.method_7969().method_10558("password");
                    keycardReaderBlockEntity.method_5431();
                    world.method_8396(null, pos, ModSounds.BLOCK_KEYCARD_READER_PLING, class_3419.field_15245, 1.0f, 1.0f);
                    player.method_7353(class_2561.method_43471("block.tlotd.keycard_reader.password_set"), true);
                }
                else {
                    if (keycardReaderBlockEntity.password.equals(stack.method_7969().method_10558("password"))) {
                        if (state.method_11654(field_10729)) {
                            return class_1269.field_21466;
                        }
                        this.method_21845(state, world, pos);
                        this.method_9714(player, world, pos, true);
                        world.method_33596(player, class_5712.field_28174, pos);
                        world.method_8396(null, pos, ModSounds.BLOCK_KEYCARD_READER_PLING, class_3419.field_15245, 1.0f, 1.0f);
                    } else {
                        world.method_8396(null, pos, class_3417.field_15008, class_3419.field_15245, 1.0f, 1.0f);
                    }
                }
            }
            return class_1269.field_5812;
        }
        return class_1269.field_5814;
    }

    @Override
    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        switch (state.method_11654(field_11007)) {
            case field_12475: {
                switch (state.method_11654(field_11177).method_10166()) {
                    case field_11048: {
                        return DOWN_SHAPE;
                    }
                }
                return DOWN_SHAPE_2;
            }
            case field_12471: {
                switch (state.method_11654(field_11177)) {
                    case field_11034: {
                        return field_10720;
                    }
                    case field_11039: {
                        return field_10731;
                    }
                    case field_11035: {
                        return field_10715;
                    }
                }
                return field_10728;
            }
        }
        switch (state.method_11654(field_11177).method_10166()) {
            case field_11048: {
                return UP_SHAPE;
            }
        }
        return UP_SHAPE_2;
    }

    @Override
    public @Nullable class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new KeycardReaderBlockEntity(pos, state);
    }
}
