package net.tlotd.block.custom;

import net.minecraft.block.*;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2318;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2464;
import net.minecraft.class_2470;
import net.minecraft.class_2561;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2753;
import net.minecraft.class_2758;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3489;
import net.minecraft.class_3610;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_6862;
import net.tlotd.block.ModBlocks;
import net.tlotd.config.ModConfigs;
import net.tlotd.item.ModItems;
import net.tlotd.sound.ModSounds;
import net.tlotd.util.ModTags;
import net.tlotd.world.SignalTrackingArray;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import java.util.Map;

public class RadioBlock extends class_2248 {

    public static final class_2758 FREQUENCY = class_2758.method_11867("frequency", 0, 4);
    public static final class_2758 WOOD_TYPE = class_2758.method_11867("wood_type", 1, 28);
    public static final class_2746 MODDED = class_2746.method_11825("modded");
    public static final class_2746 WATERLOGGED = class_2741.field_12508;
    public static final class_2753 FACING = class_2318.field_10927;

    private static final class_265 Z_SHAPE = class_2248.method_9541(4.0, 0.0, 0.0, 12.0, 11.0, 16.0);
    private static final class_265 X_SHAPE = class_2248.method_9541(0.0, 0.0, 4.0, 16.0, 11.0, 12.0);

    private static final class_2561[] FREQUENCY_MESSAGES = new class_2561[]{
            class_2561.method_43471("messages.tlotd.radio.frequency.0"),
            class_2561.method_43471("messages.tlotd.radio.frequency.1"),
            class_2561.method_43471("messages.tlotd.radio.frequency.2"),
            class_2561.method_43471("messages.tlotd.radio.frequency.3"),
            class_2561.method_43471("messages.tlotd.radio.frequency.4")
    };
    private static final class_3414[] FREQUENCY_SOUNDS = new class_3414[]{
            null,
            ModSounds.RADIO_FREQUENCY_1,
            ModSounds.RADIO_FREQUENCY_2,
            ModSounds.RADIO_FREQUENCY_3,
            ModSounds.RADIO_FREQUENCY_4
    };

    private static final Map<class_6862<class_1792>, Integer> WOOD_TYPE_MAP = Map.ofEntries(
            Map.entry(class_3489.field_15545, 1),
            Map.entry(class_3489.field_15549, 2),
            Map.entry(class_3489.field_15554, 3),
            Map.entry(class_3489.field_15538, 4),
            Map.entry(class_3489.field_15525, 5),
            Map.entry(class_3489.field_15546, 6),
            Map.entry(class_3489.field_37403, 7),
            Map.entry(class_3489.field_42618, 8),
            Map.entry(ModTags.Items.GINKGO_LOGS, 10),
            Map.entry(class_3489.field_40987, 11),
            Map.entry(class_3489.field_21957, 12),
            Map.entry(class_3489.field_21958, 13)
    );

    private record ModdedWoodRule(String modId, String namePart, int type) {}
    private static final List<ModdedWoodRule> MODDED_WOOD_RULES = List.of(
            new ModdedWoodRule("aether", "skyroot", 1),
            new ModdedWoodRule("aether", "golden_oak", 1),
            new ModdedWoodRule("twilightforest", "twilight_oak", 2),
            new ModdedWoodRule("twilightforest", "canopy", 3),
            new ModdedWoodRule("twilightforest", "mangrove", 4),
            new ModdedWoodRule("twilightforest", "dark", 5),
            new ModdedWoodRule("twilightforest", "time", 6),
            new ModdedWoodRule("twilightforest", "transformation", 7),
            new ModdedWoodRule("twilightforest", "mining", 8),
            new ModdedWoodRule("twilightforest", "sorting", 9),
            new ModdedWoodRule("thermal", "rubberwood", 10),
            new ModdedWoodRule("quark", "ancient", 11),
            new ModdedWoodRule("quark", "azalea", 12),
            new ModdedWoodRule("quark", "blossom", 13),
            new ModdedWoodRule("alexscaves", "pewen", 14),
            new ModdedWoodRule("alexscaves", "thornwood", 15),
            new ModdedWoodRule("biomesoplenty", "fir", 16),
            new ModdedWoodRule("biomesoplenty", "pine", 17),
            new ModdedWoodRule("biomesoplenty", "maple", 18),
            new ModdedWoodRule("biomesoplenty", "redwood", 19),
            new ModdedWoodRule("biomesoplenty", "mahogany", 20),
            new ModdedWoodRule("biomesoplenty", "jacaranda", 21),
            new ModdedWoodRule("biomesoplenty", "palm", 22),
            new ModdedWoodRule("biomesoplenty", "willow", 23),
            new ModdedWoodRule("biomesoplenty", "dead", 24),
            new ModdedWoodRule("biomesoplenty", "magic", 25),
            new ModdedWoodRule("biomesoplenty", "umbran", 26),
            new ModdedWoodRule("biomesoplenty", "hellbark", 27),
            new ModdedWoodRule("biomesoplenty", "empyreal", 28)
    );

    private static String[] FREQUENCY_DISC_KEYS = null;

    private static String[] getFrequencyDiscKeys() {
        if (FREQUENCY_DISC_KEYS == null) {
            FREQUENCY_DISC_KEYS = new String[]{
                    ModItems.MUSIC_DISC_1.method_7876(),
                    ModItems.MUSIC_DISC_2.method_7876(),
                    ModItems.MUSIC_DISC_3.method_7876(),
                    ModItems.MUSIC_DISC_4.method_7876()
            };
        }
        return FREQUENCY_DISC_KEYS;
    }

    public RadioBlock(class_2251 settings) {
        super(settings);
        this.method_9590(this.field_10647.method_11664()
                .method_11657(FACING, class_2350.field_11043)
                .method_11657(WATERLOGGED, false)
                .method_11657(FREQUENCY, 0)
                .method_11657(WOOD_TYPE, 1)
                .method_11657(MODDED, false));
    }

    @Override
    public class_2680 method_9605(class_1750 ctx) {
        return this.method_9564()
                .method_11657(FACING, ctx.method_8042())
                .method_11657(WATERLOGGED, ctx.method_8045().method_8316(ctx.method_8037()).method_39360(class_3612.field_15910))
                .method_11657(FREQUENCY, 0)
                .method_11657(WOOD_TYPE, 1)
                .method_11657(MODDED, false);
    }

    @Override
    public class_3610 method_9545(class_2680 state) {
        return state.method_11654(WATERLOGGED) ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    @Override
    public class_2680 method_9559(class_2680 state, class_2350 dir, class_2680 neighbor, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        if (state.method_11654(WATERLOGGED)) {
            world.method_39281(pos, class_3612.field_15910, class_3612.field_15910.method_15789(world));
        }
        return super.method_9559(state, dir, neighbor, world, pos, neighborPos);
    }

    @Override
    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return state.method_11657(FACING, rotation.method_10503(state.method_11654(FACING)));
    }

    @Override
    public void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(FACING, WATERLOGGED, FREQUENCY, WOOD_TYPE, MODDED);
    }

    @Override
    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 ctx) {
        return switch (state.method_11654(FACING)) {
            case field_11034, field_11039 -> Z_SHAPE;
            default -> X_SHAPE;
        };
    }

    @Override
    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    @Override
    public void method_9568(class_1799 stack, @Nullable class_1922 world, List<class_2561> tooltip, class_1836 opts) {
        if (!ModConfigs.ALL_SIGNALS_UNLOCKED) {
            tooltip.add(class_2561.method_43470(""));
            tooltip.add(class_2561.method_43471("block.tlotd.radio.tooltip").method_27692(class_124.field_1080));
            tooltip.add(class_2561.method_43471("block.tlotd.radio.tooltip_2").method_27692(class_124.field_1080));
            tooltip.add(class_2561.method_43470(" ").method_10852(class_2561.method_43471("block.tlotd.signal_transmitter").method_27692(class_124.field_1078)));
        }
        super.method_9568(stack, world, tooltip, opts);
    }

    @Override
    public class_1799 method_9574(class_1922 world, class_2338 pos, class_2680 state) {
        return ModBlocks.RADIO.method_8389().method_7854();
    }

    private void sendFrequencyMessageAndSound(class_1657 player, class_1937 world, class_2338 pos, int freq) {
        player.method_7353(FREQUENCY_MESSAGES[freq], true);
        if (freq > 0) {
            world.method_8396(null, pos, FREQUENCY_SOUNDS[freq], class_3419.field_15247, 1.0f, 1.0f);
        }
    }

    private void tryUpdateWood(class_1937 world, class_2338 pos, class_1657 player) {
        class_1799 stack = player.method_6047();
        for (var entry : WOOD_TYPE_MAP.entrySet()) {
            if (stack.method_31573(entry.getKey())) {
                updateWood(world, pos, entry.getValue(), false);
                return;
            }
        }
        String name = stack.method_7922();
        for (ModdedWoodRule rule : MODDED_WOOD_RULES) {
            if (name.contains(rule.modId()) && name.contains(rule.namePart())) {
                updateWood(world, pos, rule.type(), true);
                return;
            }
        }
    }

    @Override
    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        int freq = state.method_11654(FREQUENCY);
        if (player.method_5715()) {
            class_310.method_1551().method_1483().method_4881();
            if (!world.field_9236) {
                class_3218 serverWorld = (class_3218) world;
                SignalTrackingArray tracker = SignalTrackingArray.get(serverWorld);
                boolean radioOff = state.method_26204().equals(ModBlocks.RADIO);
                if (radioOff) {
                    if (ModConfigs.ALL_SIGNALS_UNLOCKED) {
                        world.method_8501(pos, ModBlocks.RADIO_ON.method_34725(state));
                        sendFrequencyMessageAndSound(player, world, pos, freq);
                    } else if (tracker.hasAnySignals()) {
                        for (int i = 1; i <= 4; i++) {
                            if (tracker.hasSignal(getFrequencyDiscKeys()[i - 1]) && freq <= i) {
                                world.method_8501(pos, ModBlocks.RADIO_ON.method_34725(state).method_11657(FREQUENCY, i));
                                sendFrequencyMessageAndSound(player, world, pos, i);
                                return class_1269.field_5812;
                            }
                        }
                        world.method_8501(pos, ModBlocks.RADIO_ON.method_34725(state).method_11657(FREQUENCY, 0));
                        sendFrequencyMessageAndSound(player, world, pos, 0);
                    } else {
                        world.method_8501(pos, ModBlocks.RADIO_ON.method_34725(state).method_11657(FREQUENCY, 0));
                        sendFrequencyMessageAndSound(player, world, pos, 0);
                    }
                } else {
                    world.method_8501(pos, ModBlocks.RADIO.method_34725(state));
                }
            }
            world.method_8396(null, pos, ModSounds.BLOCK_RADIO_SWITCH_FREQUENCY, class_3419.field_15245, 1.0f, 1.0f);
            return class_1269.field_5812;
        }
        class_1799 held = player.method_6047();
        if (held.method_31573(class_3489.field_15539) || held.method_31573(class_3489.field_40987) || held.method_31573(ModTags.Items.GINKGO_LOGS)) {
            if (!world.field_9236) {
                tryUpdateWood(world, pos, player);
            }
            world.method_8396(null, pos, class_3417.field_14718, class_3419.field_15245, 1.0f, 1.0f);
            return class_1269.field_5812;
        }
        if (state.method_26204().equals(ModBlocks.RADIO_ON)) {
            class_310.method_1551().method_1483().method_4881();
            if (!world.field_9236) {
                class_3218 serverWorld = (class_3218) world;
                SignalTrackingArray tracker = SignalTrackingArray.get(serverWorld);
                if (ModConfigs.ALL_SIGNALS_UNLOCKED) {
                    int newFreq = freq < 4 ? freq + 1 : 1;
                    world.method_8501(pos, ModBlocks.RADIO_ON.method_34725(state.method_11657(FREQUENCY, newFreq)));
                    sendFrequencyMessageAndSound(player, world, pos, newFreq);
                } else if (tracker.hasAnySignals()) {
                    boolean updated = false;
                    for (int i = 1; i <= 4; i++) {
                        if (tracker.hasSignal(getFrequencyDiscKeys()[i - 1]) && freq < i) {
                            world.method_8501(pos, ModBlocks.RADIO_ON.method_34725(state).method_11657(FREQUENCY, i));
                            sendFrequencyMessageAndSound(player, world, pos, i);
                            updated = true;
                            break;
                        }
                    }
                    if (!updated) {
                        world.method_8501(pos, ModBlocks.RADIO_ON.method_34725(state).method_11657(FREQUENCY, 0));
                        sendFrequencyMessageAndSound(player, world, pos, 0);
                    }
                } else {
                    sendFrequencyMessageAndSound(player, world, pos, 0);
                }
            }
            world.method_8396(null, pos, ModSounds.BLOCK_RADIO_SWITCH_FREQUENCY, class_3419.field_15245, 1.0f, 1.0f);
            return class_1269.field_5812;
        }
        return class_1269.field_5814;
    }

    public void updateWood(class_1937 world, class_2338 pos, int type, boolean modded) {
        world.method_8501(pos, world.method_8320(pos).method_11657(WOOD_TYPE, type).method_11657(MODDED, modded));
    }

    @Override
    public void method_9576(class_1937 world, class_2338 pos, class_2680 state, class_1657 player) {
        class_310.method_1551().method_1483().method_4881();
        world.method_8396(null, pos, class_3417.field_15026, class_3419.field_15245, 1.0f, 1.0f);
        super.method_9576(world, pos, state, player);
    }
}