package net.tlotd.block.custom;

import net.minecraft.block.*;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2318;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2464;
import net.minecraft.class_2470;
import net.minecraft.class_2561;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2753;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3610;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.tlotd.block.ModBlocks;
import net.tlotd.sound.ModSounds;
import net.tlotd.util.ModTags;
import net.tlotd.world.SignalTrackingArray;
import org.jetbrains.annotations.Nullable;

import java.util.List;

public class SignalTransmitterBlock extends class_2248 {

    public static final class_2746 WATERLOGGED = class_2741.field_12508;
    public static final class_2753 FACING = class_2318.field_10927;

    @Override
    public class_2680 method_9605(class_1750 ctx) {
        return this.method_9564()
                .method_11657(FACING, ctx.method_8042())
                .method_11657(WATERLOGGED, ctx.method_8045().method_8316(ctx.method_8037()).method_39360(class_3612.field_15910));
    }

    @Override
    public class_3610 method_9545(class_2680 state) {
        return state.method_11654(WATERLOGGED) ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    @Override
    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        if (state.method_11654(WATERLOGGED)) {
            world.method_39281(pos, class_3612.field_15910, class_3612.field_15910.method_15789(world));
        }

        return super.method_9559(state, direction, neighborState, world, pos, neighborPos);
    }

    @Override
    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return state.method_11657(FACING, rotation.method_10503(state.method_11654(FACING)));
    }

    @Override
    public void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(FACING, WATERLOGGED);
    }

    public SignalTransmitterBlock(class_2251 settings) {
        super(settings);
        this.method_9590(this.field_10647.method_11664().method_11657(FACING, class_2350.field_11043).method_11657(WATERLOGGED, false));
    }

    public static final class_265 SHAPE = class_259.method_17786(
            class_2248.method_9541(1, 0, 1, 15, 11.5, 15),
            class_2248.method_9541(2, 11.5, 2, 14, 15, 14),
            class_2248.method_9541(3, 15, 3, 13, 16, 13)
    );

    @Override
    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return SHAPE;
    }

    @Override
    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    @Override
    public void method_9568(class_1799 stack, @Nullable class_1922 world, List<class_2561> tooltip, class_1836 options) {
        tooltip.add(class_2561.method_43470(""));
        tooltip.add(class_2561.method_43471("block.tlotd.signal_transmitter.tooltip").method_27692(class_124.field_1080));
        tooltip.add(class_2561.method_43470(" ").method_10852(class_2561.method_43471("block.tlotd.signal_transmitter.tooltip_2")).method_27692(class_124.field_1078));
        tooltip.add(class_2561.method_43470(" ").method_10852(class_2561.method_43471("block.tlotd.signal_transmitter.tooltip_3")).method_27692(class_124.field_1078));
        tooltip.add(class_2561.method_43471("block.tlotd.signal_transmitter.tooltip_4").method_27692(class_124.field_1080));
        tooltip.add(class_2561.method_43470(" 2x ").method_10852(class_2561.method_43471("block.tlotd.signal_transmitter_antenna")).method_27692(class_124.field_1078));
        tooltip.add(class_2561.method_43470(" ").method_10852(class_2561.method_43471("block.minecraft.lightning_rod.upside_down")).method_27692(class_124.field_1078));
        tooltip.add(class_2561.method_43470(" ").method_10852(class_2561.method_43471("block.minecraft.lightning_rod")).method_27692(class_124.field_1078));
        super.method_9568(stack, world, tooltip, options);
    }

    @Override
    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        if (!world.field_9236) {
            class_3218 serverWorld = (class_3218) world;
            SignalTrackingArray tracker = SignalTrackingArray.get(serverWorld);
            if (world.method_8320(pos.method_10084()) == ModBlocks.SIGNAL_TRANSMITTER_ANTENNA.method_9564() && world.method_8320(pos.method_10086(2)) == ModBlocks.SIGNAL_TRANSMITTER_ANTENNA.method_9564().method_11657(SignalTransmitterAntennaBlock.UPPER, true) && world.method_8320(pos.method_10086(3)) == class_2246.field_27171.method_9564().method_11657(FACING, class_2350.field_11033) && world.method_8320(pos.method_10086(4)) == class_2246.field_27171.method_9564()) {
                if (player.method_6047().method_31573(ModTags.Items.TRANSMITTABLE_SIGNALS)) {
                    if (tracker.hasSignal(player.method_6047().method_7922())) {
                        tracker.removeSignal(player.method_6047().method_7922());
                        player.method_7353(class_2561.method_43471("block.tlotd.signal_transmitter.removed"),true);
                    } else {
                        tracker.addSignal(player.method_6047().method_7922());
                        player.method_7353(class_2561.method_43471("block.tlotd.signal_transmitter.added"),true);
                    }
                    world.method_8396(null, pos, ModSounds.BLOCK_VIDEOCASSETTE_RECORDER, class_3419.field_15245, 1.0f, 1.0f);
                } else {
                    if (!tracker.hasAnySignals()) {
                        player.method_43496(class_2561.method_43471("block.tlotd.signal_transmitter.list_empty"));
                    } else {
                        player.method_43496(class_2561.method_43469("block.tlotd.signal_transmitter.list", tracker.getSignalCount()));
                        for (String signal : tracker.getAllSignals()) {
                            player.method_43496(class_2561.method_43470(" ").method_27692(class_124.field_1080).method_10852(class_2561.method_43471(signal).method_10852(class_2561.method_43470(": ")).method_10852(class_2561.method_43471(signal + ".desc"))));
                        }
                    }
                    world.method_8396(null, pos, class_3417.field_14791, class_3419.field_15245, 1.0f, 1.0f);
                }
            }
            else {
                player.method_43496(class_2561.method_43471("block.tlotd.signal_transmitter.incomplete"));
                world.method_8396(null, pos, class_3417.field_14791, class_3419.field_15245, 1.0f, 1.0f);
            }
        }
        return class_1269.field_5812;
    }
}
