package net.tlotd.block.custom;

import net.minecraft.block.*;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2318;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2464;
import net.minecraft.class_2470;
import net.minecraft.class_2561;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2753;
import net.minecraft.class_2758;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_3610;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.tlotd.block.ModBlocks;
import net.tlotd.config.ModConfigs;
import net.tlotd.item.ModItems;
import net.tlotd.sound.ModSounds;
import net.tlotd.world.SignalTrackingArray;
import org.jetbrains.annotations.Nullable;

import java.util.List;

public class TelevisionBlock extends class_2248 {

    public static final class_2758 CHANNEL = class_2758.method_11867("channel", 0, 9);
    public static final class_2746 WATERLOGGED = class_2741.field_12508;
    public static final class_2753 FACING = class_2318.field_10927;

    private static String[] VHS_DISC_KEYS = null;
    private static String[] getVHSDiscKeys() {
        if (VHS_DISC_KEYS == null) {
            VHS_DISC_KEYS = new String[]{
                    ModItems.VHS_CASSETTE_BROKEN.method_7876(), // channel 0
                    ModItems.VHS_CASSETTE_1.method_7876(),
                    ModItems.VHS_CASSETTE_2.method_7876(),
                    ModItems.VHS_CASSETTE_3.method_7876(),
                    ModItems.VHS_CASSETTE_4.method_7876(),
                    ModItems.VHS_CASSETTE_5.method_7876(),
                    ModItems.VHS_CASSETTE_6.method_7876(),
                    ModItems.VHS_CASSETTE_7.method_7876(),
                    ModItems.VHS_CASSETTE_8.method_7876(),
                    ModItems.VHS_CASSETTE_9.method_7876()
            };
        }
        return VHS_DISC_KEYS;
    }

    @Override
    public class_2680 method_9605(class_1750 ctx) {
        return this.method_9564()
                .method_11657(FACING, ctx.method_8042())
                .method_11657(WATERLOGGED, ctx.method_8045().method_8316(ctx.method_8037()).method_39360(class_3612.field_15910))
                .method_11657(CHANNEL,0);
    }

    @Override
    public class_3610 method_9545(class_2680 state) {
        return state.method_11654(WATERLOGGED) ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    @Override
    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        if (state.method_11654(WATERLOGGED)) {
            world.method_39281(pos, class_3612.field_15910, class_3612.field_15910.method_15789(world));
        }

        return super.method_9559(state, direction, neighborState, world, pos, neighborPos);
    }

    @Override
    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return state.method_11657(FACING, rotation.method_10503(state.method_11654(FACING)));
    }

    @Override
    public void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(FACING, WATERLOGGED, CHANNEL);
    }

    public TelevisionBlock(class_2251 settings) {
        super(settings);
        this.method_9590(this.field_10647.method_11664()
                .method_11657(FACING, class_2350.field_11043)
                .method_11657(WATERLOGGED, false)
                .method_11657(CHANNEL, 0));
    }

    public static final class_265 Z_SHAPE = class_2248.method_9541(3, 0, 0, 13, 12, 16);
    public static final class_265 X_SHAPE = class_2248.method_9541(0, 0, 3, 16, 12, 13);

    @Override
    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return switch (state.method_11654(FACING)) {
            case field_11034, field_11039 -> Z_SHAPE;
            default -> X_SHAPE;
        };
    }

    @Override
    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    @Override
    public class_1799 method_9574(class_1922 world, class_2338 pos, class_2680 state) {
        return ModBlocks.TELEVISION.method_8389().method_7854();
    }

    @Override
    public void method_9568(class_1799 stack, @Nullable class_1922 world, List<class_2561> tooltip, class_1836 options) {
        tooltip.add(class_2561.method_43470(""));
        if (!ModConfigs.ALL_SIGNALS_UNLOCKED) {
            tooltip.add(class_2561.method_43471("block.tlotd.television.tooltip").method_27692(class_124.field_1080));
            tooltip.add(class_2561.method_43470(" ").method_10852(class_2561.method_43471("block.tlotd.signal_transmitter").method_27692(class_124.field_1078)));
        }
        tooltip.add(class_2561.method_43471("block.tlotd.television.tooltip_2").method_27692(class_124.field_1080));
        tooltip.add(class_2561.method_43470(" ").method_10852(class_2561.method_43471("block.tlotd.videocassette_recorder").method_27692(class_124.field_1078)));
        super.method_9568(stack, world, tooltip, options);
    }

    @Override
    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        if (player.method_5715()) {
            if (!world.field_9236) {
                if (state.method_26204().equals(ModBlocks.TELEVISION)) {
                    class_3218 serverWorld = (class_3218) world;
                    SignalTrackingArray tracker = SignalTrackingArray.get(serverWorld);
                    int channel = 0;
                    if (ModConfigs.ALL_SIGNALS_UNLOCKED || world.method_8320(pos.method_10084()).method_27852(ModBlocks.INTERDIMENSIONAL_RECEIVER)) {
                        channel = state.method_11654(CHANNEL);
                    } else if (tracker.hasAnySignals()) {
                        for (int i = 0; i <= 9; i++) {
                            if (tracker.hasSignal(getVHSDiscKeys()[i]) && state.method_11654(CHANNEL) <= i) {
                                channel = i;
                                break;
                            }
                        }
                    }
                    class_2680 newState = ModBlocks.TELEVISION_ON.method_34725(state).method_11657(CHANNEL, channel);
                    world.method_8501(pos, newState);
                    world.method_8396(null, pos, ModSounds.BLOCK_TELEVISION_SWITCH_CHANNEL, class_3419.field_15245, 1f, 1f);
                } else if (state.method_26204().equals(ModBlocks.TELEVISION_ON)) {
                    world.method_8501(pos, ModBlocks.TELEVISION.method_34725(state));
                    world.method_8396(null, pos, ModSounds.BLOCK_TELEVISION_SWITCH_CHANNEL, class_3419.field_15245, 1f, 1f);
                }
            }
            return class_1269.field_5812;
        }
        else if (state.method_26204().equals(ModBlocks.TELEVISION_ON)) {
            if (!world.field_9236) {
                class_3218 serverWorld = (class_3218) world;
                SignalTrackingArray tracker = SignalTrackingArray.get(serverWorld);
                int currentChannel = state.method_11654(CHANNEL);
                int nextChannel = currentChannel;
                if (ModConfigs.ALL_SIGNALS_UNLOCKED || world.method_8320(pos.method_10084()).method_27852(ModBlocks.INTERDIMENSIONAL_RECEIVER)) {
                    nextChannel = (currentChannel + 1) % 10;
                } else if (tracker.hasAnySignals()) {
                    for (int i = currentChannel + 1; i <= 9; i++) {
                        if (tracker.hasSignal(getVHSDiscKeys()[i])) {
                            nextChannel = i;
                            break;
                        }
                    }
                    if (nextChannel == currentChannel) nextChannel = 0;
                }
                if (nextChannel != currentChannel) {
                    class_2680 newState = ModBlocks.TELEVISION_ON.method_34725(state).method_11657(CHANNEL, nextChannel);
                    world.method_8501(pos, newState);
                    world.method_8396(null, pos, ModSounds.BLOCK_TELEVISION_SWITCH_CHANNEL, class_3419.field_15245, 1f, 1f);
                }
            }
            return class_1269.field_5812;
        }
        return class_1269.field_5814;
    }
}