package net.tlotd.block.custom;

import net.minecraft.block.*;
import net.minecraft.class_10;
import net.minecraft.class_124;
import net.minecraft.class_1264;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2464;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2758;
import net.minecraft.class_2960;
import net.minecraft.class_3726;
import net.minecraft.class_3908;
import net.minecraft.class_3965;
import net.minecraft.class_437;
import net.minecraft.class_5558;
import net.minecraft.util.*;
import net.tlotd.block.entity.WitchingTableBlockEntity;
import net.tlotd.block.entity.ModBlockEntities;
import net.tlotd.config.ModConfigs;
import net.tlotd.item.ModItems;
import org.jetbrains.annotations.Nullable;

import java.util.List;

public class WitchingTableBlock extends class_2237 implements class_2343 {

    public static final class_2758 SOUL_CHARGES = class_2758.method_11867("soul_charges", 0, 3);
    public static final class_2758 CURSED_SOUL_CHARGES = class_2758.method_11867("cursed_soul_charges", 0, 3);
    public static final class_2758 ABYSSAL_SOUL_CHARGES = class_2758.method_11867("abyssal_soul_charges", 0, 3);

    public WitchingTableBlock(class_2251 settings) {
        super(settings);
    }

    @Override
    public boolean method_9516(class_2680 state, class_1922 world, class_2338 pos, class_10 type) {
        return false;
    }

    private static final class_265 SHAPE = class_2248.method_9541(0,0,0,16,12,16);

    @Override
    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return SHAPE;
    }

    @Override
    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    @Override
    public @Nullable class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new WitchingTableBlockEntity(pos, state);
    }

    @Override
    public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        if (state.method_26204() != newState.method_26204()) {
            class_2586 blockEntity = world.method_8321(pos);
            if (blockEntity instanceof WitchingTableBlockEntity) {
                class_1264.method_5451(world, pos, (WitchingTableBlockEntity)blockEntity);
                world.method_8455(pos, this);
            }
            super.method_9536(state, world, pos, newState, moved);
        }
    }

    @Override
    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        if (!world.field_9236) {
            if (player.method_5998(hand).method_31574(ModItems.SOUL_FLASK) || player.method_5998(hand).method_31574(ModItems.CURSED_SOUL_FLASK) || player.method_5998(hand).method_31574(ModItems.SOUL_FLASK_OF_THE_ABYSS)) {
                return class_1269.field_5814;
            }
            class_3908 screenHandlerFactory = ((WitchingTableBlockEntity) world.method_8321(pos));
            if (screenHandlerFactory != null) {
                player.method_17355(screenHandlerFactory);
            }
        }
        return class_1269.field_5812;
    }
    
    @Override
    public @Nullable <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        return method_31618(type, ModBlockEntities.WITCHING_TABLE_BLOCK_ENTITY,
                (world1, pos, state1, blockEntity) -> blockEntity.tick(world1, pos, state1));
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(SOUL_CHARGES, CURSED_SOUL_CHARGES, ABYSSAL_SOUL_CHARGES);
    }

    public static final class_2960 ILLAGER_FONT_ID = new class_2960("minecraft", "illageralt");
    public static final class_2960 RECIPIES_FONT_ID = new class_2960("tlotd", "recipies");

    @Override
    public void method_9568(class_1799 stack, @Nullable class_1922 world, List<class_2561> tooltip, class_1836 options) {
        class_2583 style = method_9518().method_10866();
        if (class_437.method_25442()) {
            if (ModConfigs.WITCHING_TABLE_NEEDS_BLOOD && ModConfigs.WITCHING_TABLE_NEEDS_SOULS) {
                tooltip.add(class_2561.method_43471("block.tlotd.witching_table.tooltip_bs").method_27692(class_124.field_1080));
                tooltip.add(class_2561.method_43471("block.tlotd.witching_table.tooltip_bs_2").method_27692(class_124.field_1080));
                tooltip.add(class_2561.method_43471("block.tlotd.witching_table.tooltip_bs_3").method_27692(class_124.field_1080));
            } else if (ModConfigs.WITCHING_TABLE_NEEDS_BLOOD) {
                tooltip.add(class_2561.method_43471("block.tlotd.witching_table.tooltip_b").method_27692(class_124.field_1080));
                tooltip.add(class_2561.method_43471("block.tlotd.witching_table.tooltip_b_2").method_27692(class_124.field_1080));
                tooltip.add(class_2561.method_43471("block.tlotd.witching_table.tooltip_b_3").method_27692(class_124.field_1080));
            } else if (ModConfigs.WITCHING_TABLE_NEEDS_SOULS) {
                tooltip.add(class_2561.method_43471("block.tlotd.witching_table.tooltip_s").method_27692(class_124.field_1080));
                tooltip.add(class_2561.method_43471("block.tlotd.witching_table.tooltip_s_2").method_27692(class_124.field_1080));
                tooltip.add(class_2561.method_43471("block.tlotd.witching_table.tooltip_s_3").method_27692(class_124.field_1080));
            } else {
                tooltip.add(class_2561.method_43471("block.tlotd.witching_table.tooltip").method_27692(class_124.field_1080));
                tooltip.add(class_2561.method_43471("block.tlotd.witching_table.tooltip_2").method_27692(class_124.field_1080));
            }
            tooltip.add(class_2561.method_43471("item.tlotd.desc_occult").method_27692(class_124.field_1061));
            tooltip.add(class_2561.method_43470(""));
            tooltip.add(class_2561.method_43470("\uE020\uE000\uE022\uE021\uE023").method_10862(style.method_27704(RECIPIES_FONT_ID)));
            tooltip.add(class_2561.method_43470("\uE020\uE000\uE026\uE024\uE025\uE027\uE021\uE028").method_10862(style.method_27704(RECIPIES_FONT_ID)));
            tooltip.add(class_2561.method_43470("\uE020\uE000\uE029\uE02A\uE023\uE02A\uE021\uE02B").method_10862(style.method_27704(RECIPIES_FONT_ID)));
        } else {
            if (ModConfigs.WITCHING_TABLE_NEEDS_BLOOD && ModConfigs.WITCHING_TABLE_NEEDS_SOULS) {
                tooltip.add(class_2561.method_43471("block.tlotd.witching_table.tooltip_bs").method_10862(style.method_27704(ILLAGER_FONT_ID)).method_27692(class_124.field_1080));
                tooltip.add(class_2561.method_43471("block.tlotd.witching_table.tooltip_bs_2").method_10862(style.method_27704(ILLAGER_FONT_ID)).method_27692(class_124.field_1080));
                tooltip.add(class_2561.method_43471("block.tlotd.witching_table.tooltip_bs_3").method_10862(style.method_27704(ILLAGER_FONT_ID)).method_27692(class_124.field_1080));
            } else if (ModConfigs.WITCHING_TABLE_NEEDS_BLOOD) {
                tooltip.add(class_2561.method_43471("block.tlotd.witching_table.tooltip_b").method_10862(style.method_27704(ILLAGER_FONT_ID)).method_27692(class_124.field_1080));
                tooltip.add(class_2561.method_43471("block.tlotd.witching_table.tooltip_b_2").method_10862(style.method_27704(ILLAGER_FONT_ID)).method_27692(class_124.field_1080));
                tooltip.add(class_2561.method_43471("block.tlotd.witching_table.tooltip_b_3").method_10862(style.method_27704(ILLAGER_FONT_ID)).method_27692(class_124.field_1080));
            } else if (ModConfigs.WITCHING_TABLE_NEEDS_SOULS) {
                tooltip.add(class_2561.method_43471("block.tlotd.witching_table.tooltip_s").method_10862(style.method_27704(ILLAGER_FONT_ID)).method_27692(class_124.field_1080));
                tooltip.add(class_2561.method_43471("block.tlotd.witching_table.tooltip_s_2").method_10862(style.method_27704(ILLAGER_FONT_ID)).method_27692(class_124.field_1080));
                tooltip.add(class_2561.method_43471("block.tlotd.witching_table.tooltip_s_3").method_10862(style.method_27704(ILLAGER_FONT_ID)).method_27692(class_124.field_1080));
            } else {
                tooltip.add(class_2561.method_43471("block.tlotd.witching_table.tooltip").method_10862(style.method_27704(ILLAGER_FONT_ID)).method_27692(class_124.field_1080));
                tooltip.add(class_2561.method_43471("block.tlotd.witching_table.tooltip_2").method_10862(style.method_27704(ILLAGER_FONT_ID)).method_27692(class_124.field_1080));
            }
            tooltip.add(class_2561.method_43471("item.tlotd.desc_occult").method_27692(class_124.field_1061));
            tooltip.add(class_2561.method_43470(""));
            tooltip.add(class_2561.method_43470("").method_10852(class_2561.method_43471("text.tlotd.recipe.tooltip").method_27692(class_124.field_1063)).method_10852(class_2561.method_43471("key.keyboard.left.shift").method_27692(class_124.field_1080)).method_10852(class_2561.method_43471("text.tlotd.recipe.tooltip_2").method_27692(class_124.field_1063)));
        }
        super.method_9568(stack, world, tooltip, options);
    }
}
