package net.tlotd.block.entity;

import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.minecraft.class_1262;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3913;
import net.tlotd.gui.OxygenCollectorGUIHandler;
import net.tlotd.util.AdAstraOxygenNbtHelper;
import net.tlotd.util.ModTags;
import org.jetbrains.annotations.Nullable;

public class OxygenCollectorBlockEntity extends class_2586 implements ExtendedScreenHandlerFactory, ImplementedInventory {

    private final class_2371<class_1799> inventory = class_2371.method_10213(1, class_1799.field_8037);

    protected final class_3913 propertyDelegate;
    private int quality = 1 ;

    public OxygenCollectorBlockEntity(class_2338 pos, class_2680 state) {
        super(ModBlockEntities.OXYGEN_COLLECTOR_BLOCK_ENTITY, pos, state);
        this.propertyDelegate = new class_3913() {
            @Override
            public int method_17390(int index) {
                return OxygenCollectorBlockEntity.this.quality;
            }

            @Override
            public void method_17391(int index, int value) {
                OxygenCollectorBlockEntity.this.quality = value;
            }

            @Override
            public int method_17389() {
                return 1;
            }
        };
    }

    @Override
    public void writeScreenOpeningData(class_3222 serverPlayerEntity, class_2540 packetByteBuf) {
        packetByteBuf.method_10807(this.field_11867);
    }

    @Override
    public class_2561 method_5476() {
        return class_2561.method_43471("block.tlotd.oxygen_collector");
    }

    @Override
    public class_2371<class_1799> getItems() {
        return inventory;
    }

    @Override
    protected void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        class_1262.method_5426(nbt, inventory);
        nbt.method_10569("quality", quality);
    }

    @Override
    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        class_1262.method_5429(nbt, inventory);
        quality = nbt.method_10550("quality");
    }

    @Override
    public @Nullable class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
        return new OxygenCollectorGUIHandler(syncId, playerInventory, this, this.propertyDelegate);
    }

    public void tick(class_1937 world, class_2338 pos, class_2680 state) {
        if(world.method_8608()) {
            return;
        }

        if(oxygenChargable()) {
            if(canBeFilled()) {
                this.fillOxygen();
            }
        }
    }

    private boolean oxygenChargable() {
        return this.method_5438(0).method_31573(ModTags.Items.OXYGEN_CHARGABLE);
    }

    private boolean canBeFilled() {
        return (this.method_5438(0).method_7985() && this.method_5438(0).method_7969().method_10550("tlotd:oxygen") < 1000 || !this.method_5438(0).method_7985());
    }

    private void fillOxygen() {
        class_1799 stack = this.method_5438(0);
        if (stack.method_7960()) return;
        long current = AdAstraOxygenNbtHelper.getOxygen(stack);
        long next = Math.min(current + (quality * 81L), AdAstraOxygenNbtHelper.MAX_AMOUNT);
        AdAstraOxygenNbtHelper.setOxygen(stack, next);
    }
}
