package net.tlotd.gui;

import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_3913;
import net.minecraft.class_3919;
import net.tlotd.block.entity.MithrilAnvilBlockEntity;
import net.tlotd.util.ModTags;

public class MithrilAnvilGUIHandler extends class_1703 {

    private final class_1263 inventory;
    private final class_3913 propertyDelegate;
    public final MithrilAnvilBlockEntity blockEntity;

    public MithrilAnvilGUIHandler(int syncId, class_1661 inventory, class_2540 buf) {
        this(syncId, inventory, inventory.field_7546.method_37908().method_8321(buf.method_10811()),
                new class_3919(2));
    }

    public MithrilAnvilGUIHandler(int syncId, class_1661 playerInventory, class_2586 blockEntity, class_3913 propertyDelegate) {
        super(ModGUIHandlers.MITHRIL_ANVIL_GUI_HANDLER, syncId);
        method_17359(((class_1263) blockEntity),7);
        this.inventory = ((class_1263) blockEntity);
        inventory.method_5435(playerInventory.field_7546);
        this.propertyDelegate = propertyDelegate;
        this.blockEntity = ((MithrilAnvilBlockEntity) blockEntity);

        this.method_7621(new RestrictedSlot(inventory, 0, 86, 18, ModTags.Items.FORGING_HAMMERS));
        this.method_7621(new class_1735(inventory, 1, 104, 27));

        this.method_7621(new class_1735(inventory, 2, 32, 27));
        this.method_7621(new class_1735(inventory, 3, 50, 18));
        this.method_7621(new class_1735(inventory, 4, 50, 36));
        this.method_7621(new class_1735(inventory, 5, 68, 27));

        this.method_7621(new class_1735(inventory, 6, 140, 27));

        addPlayerInventory(playerInventory);
        addPlayerHotbar(playerInventory);

        method_17360(propertyDelegate);
    }

    public boolean isCrafting() {
        return propertyDelegate.method_17390(0) > 0;
    }

    public int getScaledProgress() {
        int progress = this.propertyDelegate.method_17390(0);
        int maxProgress = this.propertyDelegate.method_17390(1);
        int progressArrowSize = 16;

        return maxProgress != 0 && progress != 0 ? progress * progressArrowSize / maxProgress : 0;
    }

    @Override
    public class_1799 method_7601(class_1657 player, int invSlot) {
        class_1799 newStack = class_1799.field_8037;
        class_1735 slot = this.field_7761.get(invSlot);
        if (slot != null && slot.method_7681()) {
            class_1799 originalStack = slot.method_7677();
            newStack = originalStack.method_7972();
            if (invSlot < this.inventory.method_5439()) {
                if (!this.method_7616(originalStack, this.inventory.method_5439(), this.field_7761.size(), true)) {
                    return class_1799.field_8037;
                }
            } else if (!this.method_7616(originalStack, 0, this.inventory.method_5439(), false)) {
                return class_1799.field_8037;
            }

            if (originalStack.method_7960()) {
                slot.method_48931(class_1799.field_8037);
            } else {
                slot.method_7668();
            }
        }

        return newStack;
    }

    @Override
    public boolean method_7597(class_1657 player) {
        return this.inventory.method_5443(player);
    }

    private void addPlayerInventory(class_1661 playerInventory) {
        for (int i = 0; i < 3; ++i) {
            for (int l = 0; l < 9; ++l) {
                this.method_7621(new class_1735(playerInventory, l + i * 9 + 9, 8 + l * 18, 67 + i * 18));
            }
        }
    }

    private void addPlayerHotbar(class_1661 playerInventory) {
        for (int i = 0; i < 9; ++i) {
            this.method_7621(new class_1735(playerInventory, i, 8 + i * 18, 125));
        }
    }
}
