package net.tlotd.item.custom;

import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_437;
import net.tlotd.sound.ModSounds;
import net.tlotd.util.AdAstraOxygenNbtHelper;
import net.tlotd.util.ModTags;
import org.jetbrains.annotations.Nullable;

import java.util.List;

public class OxygenTankItem extends class_1792 {
    public OxygenTankItem(class_1793 settings) {
        super(settings);
    }

    @Override
    public class_1799 method_7854() {
        class_1799 base = new class_1799(this);
        AdAstraOxygenNbtHelper.setOxygen(base, 0);
        return base;
    }

    @Override
    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        String oxygen = "0 \uD83E\uDEA3 / 1K \uD83E\uDEA3";
        if (class_437.method_25442()) {
            oxygen = "0 \uD83E\uDEA3 / 1,000 \uD83E\uDEA3";
            if (stack.method_7985()) {
                long oxygenAmount = AdAstraOxygenNbtHelper.getOxygen(stack);
                int displayAmount = (int) Math.round((double) oxygenAmount * 1000 / AdAstraOxygenNbtHelper.MAX_AMOUNT);
                String formattedOxygen = String.format("%,d", displayAmount);
                oxygen = formattedOxygen + " \uD83E\uDEA3 / 1,000 \uD83E\uDEA3";
            }
        } else {
            if (stack.method_7985()) {
                long oxygenAmount = AdAstraOxygenNbtHelper.getOxygen(stack);
                int displayAmount = (int) Math.round((double) oxygenAmount * 1000 / AdAstraOxygenNbtHelper.MAX_AMOUNT);
                String formattedOxygen;
                if (displayAmount == 1000) {
                    formattedOxygen = "1K";
                } else {
                    formattedOxygen = String.valueOf(displayAmount);
                }
                oxygen = formattedOxygen + " \uD83E\uDEA3 / 1K \uD83E\uDEA3";
            }
        }
        tooltip.add(class_2561.method_43469("item.tlotd.oxygen_level.tooltip", oxygen).method_27692(class_124.field_1065));
        super.method_7851(stack, world, tooltip, context);
    }

    public float getProgress(class_1799 stack) {
        return AdAstraOxygenNbtHelper.MAX_AMOUNT - AdAstraOxygenNbtHelper.getOxygen(stack);
    }

    @Override
    public boolean method_31567(class_1799 stack) {
        return true;
    }

    public int method_31569(class_1799 stack) {
        return Math.round(13.0f - getProgress(stack) * 13.0f / AdAstraOxygenNbtHelper.MAX_AMOUNT);
    }

    @Override
    public int method_31571(class_1799 stack) {
        return 0x9fc5e8;
    }

    @Override
    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        class_1799 itemStack = user.method_5998(hand);
        if (!world.method_8608()) {
            class_1799 chest = user.method_31548().method_7372(2);
            if (chest.method_31573(ModTags.Items.OXYGEN_CHARGABLE) && AdAstraOxygenNbtHelper.getOxygen(itemStack) > 0 && AdAstraOxygenNbtHelper.getOxygen(chest) < AdAstraOxygenNbtHelper.MAX_AMOUNT) {
                long chestOxygen = AdAstraOxygenNbtHelper.getOxygen(chest);
                long itemOxygen = AdAstraOxygenNbtHelper.getOxygen(itemStack);
                long transfer = Math.min(itemOxygen, AdAstraOxygenNbtHelper.MAX_AMOUNT - chestOxygen);
                AdAstraOxygenNbtHelper.setOxygen(chest, chestOxygen + transfer);
                AdAstraOxygenNbtHelper.setOxygen(itemStack, itemOxygen - transfer);
                world.method_8396(null, user.method_24515(), class_3417.field_14726, class_3419.field_15248, 1.0f, 1.0f);
                return class_1271.method_22427(itemStack);
            }
        }
        return class_1271.method_22430(itemStack);
    }
}