package net.tlotd.item.custom;

import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1738;
import net.minecraft.class_1741;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_437;
import net.tlotd.util.AdAstraOxygenNbtHelper;
import org.jetbrains.annotations.Nullable;

import java.util.List;

public class SpaceSuitArmorItem extends class_1738 {
    public SpaceSuitArmorItem(class_1741 material, class_8051 type, class_1793 settings) {
        super(material, type, settings);
    }

    @Override
    public class_1799 method_7854() {
        class_1799 base = new class_1799(this);
        AdAstraOxygenNbtHelper.setOxygen(base, 0);
        return base;
    }

    @Override
    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
        if (!world.method_8608() && entity.method_31747()) {
            if (stack == ((class_1657) entity).method_31548().method_7372(2)) {
                String oxygen = "0%";
                if (stack.method_7985()) {
                    long oxygenAmount = AdAstraOxygenNbtHelper.getOxygen(stack);
                    int displayAmount = (int) Math.round((double) oxygenAmount * 100 / AdAstraOxygenNbtHelper.MAX_AMOUNT);
                    oxygen = displayAmount + "%";
                }
                ((class_1657) entity).method_7353(class_2561.method_43469("item.tlotd.oxygen_level.tooltip", oxygen), true);
            }
        }
    }

    @Override
    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        String oxygen = "0 \uD83E\uDEA3 / 1K \uD83E\uDEA3";
        if (class_437.method_25442()) {
            oxygen = "0 \uD83E\uDEA3 / 1,000 \uD83E\uDEA3";
            if (stack.method_7985()) {
                long oxygenAmount = AdAstraOxygenNbtHelper.getOxygen(stack);
                int displayAmount = (int) Math.round((double) oxygenAmount * 1000 / AdAstraOxygenNbtHelper.MAX_AMOUNT);
                String formattedOxygen = String.format("%,d", displayAmount);
                oxygen = formattedOxygen + " \uD83E\uDEA3 / 1,000 \uD83E\uDEA3";
            }
        } else {
            if (stack.method_7985()) {
                long oxygenAmount = AdAstraOxygenNbtHelper.getOxygen(stack);
                int displayAmount = (int) Math.round((double) oxygenAmount * 1000 / AdAstraOxygenNbtHelper.MAX_AMOUNT);
                String formattedOxygen;
                if (displayAmount == 1000) {
                    formattedOxygen = "1K";
                } else {
                    formattedOxygen = String.valueOf(displayAmount);
                }
                oxygen = formattedOxygen + " \uD83E\uDEA3 / 1K \uD83E\uDEA3";
            }
        }
        tooltip.add(class_2561.method_43469("item.tlotd.oxygen_level.tooltip", oxygen).method_27692(class_124.field_1065));
        tooltip.add(class_2561.method_43470(""));
        tooltip.add(class_2561.method_43471("item.tlotd.hypoxia_proof_armor.tooltip").method_27692(class_124.field_1080));
        tooltip.add(class_2561.method_43470(" ").method_10852(class_2561.method_43471("item.tlotd.hypoxia_proof_armor.tooltip_2").method_27692(class_124.field_1078)));
        super.method_7851(stack, world, tooltip, context);
    }

    public float getProgress(class_1799 stack) {
        return AdAstraOxygenNbtHelper.MAX_AMOUNT - AdAstraOxygenNbtHelper.getOxygen(stack);
    }

    @Override
    public boolean method_31567(class_1799 stack) {
        return true;
    }

    public int method_31569(class_1799 stack) {
        return Math.round(13.0f - getProgress(stack) * 13.0f / AdAstraOxygenNbtHelper.MAX_AMOUNT);
    }

    @Override
    public int method_31571(class_1799 stack) {
        return 0x9fc5e8;
    }
}