package net.tlotd.util;

import com.mojang.brigadier.arguments.StringArgumentType;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_1792;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.tlotd.world.SignalTrackingArray;

import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;

public class ModCommands {
    public static void registerCommands() {
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> {
            dispatcher.register(class_2170.method_9247("signal")
                    .requires(source -> source.method_9259(2))
                    .then(class_2170.method_9247("add")
                            .then(class_2170.method_9244("signal", StringArgumentType.string())
                                    .suggests((context, builder) -> {
                                        class_3218 world = context.getSource().method_9225();
                                        SignalTrackingArray tracker = SignalTrackingArray.get(world);
                                        Collection<class_1792> itemsInTag = world.method_30349()
                                                .method_30530(class_7924.field_41197)
                                                .method_40270()
                                                .filter(entry -> entry.method_40220(ModTags.Items.TRANSMITTABLE_SIGNALS))
                                                .map(class_6880::comp_349)
                                                .toList();
                                        for (class_1792 item : itemsInTag) {
                                            String key = item.method_7876();
                                            if (!tracker.hasSignal(key)) {
                                                builder.suggest(key);
                                            }
                                        }
                                        return builder.buildFuture();
                                    })
                                    .executes(ctx -> {
                                        class_3218 world = ctx.getSource().method_9225();
                                        SignalTrackingArray tracker = SignalTrackingArray.get(world);
                                        String signal = StringArgumentType.getString(ctx, "signal");
                                        tracker.addSignal(signal);
                                        ctx.getSource().method_9226(() -> class_2561.method_43470("Added signal: " + signal), false);
                                        return 1;
                                    })
                            )
                            .then(class_2170.method_9247("*")
                                    .executes(ctx -> {
                                        class_3218 world = ctx.getSource().method_9225();
                                        SignalTrackingArray tracker = SignalTrackingArray.get(world);
                                        Collection<class_1792> itemsInTag = world.method_30349()
                                                .method_30530(class_7924.field_41197)
                                                .method_40270()
                                                .filter(entry -> entry.method_40220(ModTags.Items.TRANSMITTABLE_SIGNALS))
                                                .map(class_6880::comp_349)
                                                .toList();
                                        AtomicInteger addedCount = new AtomicInteger(0);
                                        itemsInTag.forEach(item -> {
                                            String key = item.method_7876();
                                            if (!tracker.hasSignal(key)) {
                                                tracker.addSignal(key);
                                                addedCount.getAndIncrement();
                                            }
                                        });
                                        ctx.getSource().method_9226(
                                                () -> class_2561.method_43470("Added " + addedCount.get() + " signals"),
                                                false
                                        );
                                        return addedCount.get();
                                    })
                            )
                    )
                    .then(class_2170.method_9247("remove")
                            .then(class_2170.method_9244("signal", StringArgumentType.string())
                                    .suggests((context, builder) -> {
                                        class_3218 world = context.getSource().method_9225();
                                        SignalTrackingArray tracker = SignalTrackingArray.get(world);
                                        for (String sig : tracker.getAllSignals()) {
                                            builder.suggest(sig);
                                        }
                                        return builder.buildFuture();
                                    })
                                    .executes(ctx -> {
                                        class_3218 world = ctx.getSource().method_9225();
                                        SignalTrackingArray tracker = SignalTrackingArray.get(world);
                                        String signal = StringArgumentType.getString(ctx, "signal");
                                        tracker.removeSignal(signal);
                                        ctx.getSource().method_9226(() -> class_2561.method_43470("Removed signal: " + signal), false);
                                        return 1;
                                    })
                            )
                    )
                    .then(class_2170.method_9247("list")
                            .executes(ctx -> {
                                class_3218 world = ctx.getSource().method_9225();
                                SignalTrackingArray tracker = SignalTrackingArray.get(world);
                                String list = String.join(", ", tracker.getAllSignals());
                                ctx.getSource().method_9226(() -> class_2561.method_43470("The " + tracker.getSignalCount() + " current signals are:" + list), false);
                                return 1;
                            })
                    )
                    .then(class_2170.method_9247("clear")
                            .executes(ctx -> {
                                class_3218 world = ctx.getSource().method_9225();
                                SignalTrackingArray tracker = SignalTrackingArray.get(world);
                                tracker.clearSignals();
                                ctx.getSource().method_9226(() -> class_2561.method_43470("Cleared all signals"), false);
                                return 1;
                            })
                    )
            );
        });
    }
}