package net.tlotd.world;

import com.google.common.collect.ImmutableList;
import net.minecraft.class_2246;
import net.minecraft.class_2960;
import net.minecraft.class_2975;
import net.minecraft.class_3031;
import net.minecraft.class_3037;
import net.minecraft.class_3124;
import net.minecraft.class_3481;
import net.minecraft.class_3798;
import net.minecraft.class_3819;
import net.minecraft.class_3825;
import net.minecraft.class_4643;
import net.minecraft.class_4651;
import net.minecraft.class_4664;
import net.minecraft.class_5140;
import net.minecraft.class_5204;
import net.minecraft.class_5209;
import net.minecraft.class_5214;
import net.minecraft.class_5321;
import net.minecraft.class_6016;
import net.minecraft.class_7891;
import net.minecraft.class_7924;
import net.minecraft.world.gen.feature.*;
import net.tlotd.TLOTD;
import net.tlotd.block.ModBlocks;

import java.util.List;

public class ModConfiguredFeatures {

    public static final class_5321<class_2975<?,?>> MARBLE_KEY = registerKey("marble");
    public static final class_5321<class_2975<?,?>> LIMESTONE_KEY = registerKey("limestone");
    public static final class_5321<class_2975<?,?>> RED_DEEPSLATE_KEY = registerKey("red_deepslate");

    public static final class_5321<class_2975<?,?>> NETHER_SULFUR_ORE_KEY = registerKey("nether_sulfur_ore");

    public static final class_5321<class_2975<?,?>> ENDSTONE_ENDURIUM_ORE_KEY = registerKey("endstone_endurium_ore");

    public static final class_5321<class_2975<?,?>> LEAD_ORE_KEY = registerKey("lead_ore");

    public static final class_5321<class_2975<?,?>> DEEPSLATE_URANIUM_ORE_KEY = registerKey("deepslate_uranium_ore");
    public static final class_5321<class_2975<?,?>> DEEPSLATE_FOSSIL_KEY = registerKey("deepslate_fossil");
    public static final class_5321<class_2975<?,?>> HELIORITE_ORE_KEY = registerKey("heliorite_ore");
    public static final class_5321<class_2975<?,?>> PALLADIUM_ORE_KEY = registerKey("palladium_ore");
    public static final class_5321<class_2975<?,?>> JURASSOLINE_ORE_KEY = registerKey("jurassoline_ore");
    public static final class_5321<class_2975<?,?>> CINNABAR_ORE_KEY = registerKey("cinnabar_ore");
    public static final class_5321<class_2975<?,?>> NEBULAR_ORE_KEY = registerKey("nebular_ore");

    public static final class_5321<class_2975<?,?>> MITHRIL_ORE_KEY = registerKey("mithril_ore");

    public static final class_5321<class_2975<?, ?>> GINKGO_KEY = registerKey("ginkgo");
    public static final class_5321<class_2975<?, ?>> MEGA_GINKGO_KEY = registerKey("mega_ginkgo");

    public static final class_5321<class_2975<?,?>> RED_GRAVEL_KEY = registerKey("red_gravel");
    public static final class_5321<class_2975<?,?>> RED_DEEPSLATE_MARBLE_KEY = registerKey("red_deepslate_marble");
    public static final class_5321<class_2975<?,?>> RED_DEEPSLATE_LIMESTONE_KEY = registerKey("red_deepslate_limestone");

    public static final class_5321<class_2975<?,?>> RED_DEEPSLATE_FOSSIL_KEY = registerKey("red_deepslate_fossil");

    public static final class_5321<class_2975<?,?>> RED_DEEPSLATE_SULFUR_ORE_KEY = registerKey("red_deepslate_sulfur_ore");
    public static final class_5321<class_2975<?,?>> RED_DEEPSLATE_QUARTZ_ORE_KEY = registerKey("red_deepslate_quartz_ore");
    public static final class_5321<class_2975<?,?>> RED_DEEPSLATE_IRON_ORE_KEY = registerKey("red_deepslate_iron_ore");
    public static final class_5321<class_2975<?,?>> RED_DEEPSLATE_COPPER_ORE_KEY = registerKey("red_deepslate_copper_ore");
    public static final class_5321<class_2975<?,?>> RED_DEEPSLATE_GOLD_ORE_KEY = registerKey("red_deepslate_gold_ore");
    public static final class_5321<class_2975<?,?>> RED_DEEPSLATE_REDSTONE_ORE_KEY = registerKey("red_deepslate_redstone_ore");
    public static final class_5321<class_2975<?,?>> RED_DEEPSLATE_EMERALD_ORE_KEY = registerKey("red_deepslate_emerald_ore");
    public static final class_5321<class_2975<?,?>> RED_DEEPSLATE_LAPIS_ORE_KEY = registerKey("red_deepslate_lapis_ore");
    public static final class_5321<class_2975<?,?>> RED_DEEPSLATE_DIAMOND_ORE_KEY = registerKey("red_deepslate_diamond_ore");

    public static final class_5321<class_2975<?,?>> RED_DEEPSLATE_ZINC_ORE_KEY = registerKey("red_deepslate_zinc_ore");

    public static final class_5321<class_2975<?,?>> MOON_ROCK_COAL_ORE_KEY = registerKey("moon_rock_coal_ore");
    public static final class_5321<class_2975<?,?>> MOON_ROCK_IRON_ORE_KEY = registerKey("moon_rock_iron_ore");
    public static final class_5321<class_2975<?,?>> MOON_ROCK_LUNAR_CALLAINUS_ORE_KEY = registerKey("moon_rock_lunar_callainus_ore");

    public static void bootstrap(class_7891<class_2975<?,?>> context) {
        class_3825 stoneReplacables = new class_3798(class_3481.field_28992);
        class_3825 deepslateReplacables = new class_3798(class_3481.field_28993);
        class_3825 bedrockReplacables = new class_3819(class_2246.field_9987);
        class_3825 netherReplacables = new class_3798(class_3481.field_25807);
        class_3825 endReplacables = new class_3819(class_2246.field_10471);

        class_3825 redDeepslateReplacables = new class_3819(ModBlocks.RED_DEEPSLATE);
        class_3825 lunarReplacables = new class_3819(ModBlocks.MEGAREGOLITH);

        List<class_3124.class_5876> redGravel =
                List.of(class_3124.method_33994(redDeepslateReplacables, ModBlocks.RED_GRAVEL.method_9564()));
        List<class_3124.class_5876> redDeepslateMarble =
                List.of(class_3124.method_33994(redDeepslateReplacables, ModBlocks.MARBLE.method_9564()));
        List<class_3124.class_5876> redDeepslateLimestone =
                List.of(class_3124.method_33994(redDeepslateReplacables, ModBlocks.LIMESTONE.method_9564()));

        List<class_3124.class_5876> redDeepslateFossil =
                List.of(class_3124.method_33994(redDeepslateReplacables, ModBlocks.RED_DEEPSLATE_FOSSIL.method_9564()));

        List<class_3124.class_5876> redDeepslateSulfurOre =
                List.of(class_3124.method_33994(redDeepslateReplacables, ModBlocks.RED_DEEPSLATE_SULFUR_ORE.method_9564()));
        List<class_3124.class_5876> redDeepslateQuartzOre =
                List.of(class_3124.method_33994(redDeepslateReplacables, ModBlocks.RED_DEEPSLATE_QUARTZ_ORE.method_9564()));

        List<class_3124.class_5876> redDeepslateIronOre =
                List.of(class_3124.method_33994(redDeepslateReplacables, ModBlocks.RED_DEEPSLATE_IRON_ORE.method_9564()));
        List<class_3124.class_5876> redDeepslateCopperOre =
                List.of(class_3124.method_33994(redDeepslateReplacables, ModBlocks.RED_DEEPSLATE_COPPER_ORE.method_9564()));
        List<class_3124.class_5876> redDeepslateGoldOre =
                List.of(class_3124.method_33994(redDeepslateReplacables, ModBlocks.RED_DEEPSLATE_GOLD_ORE.method_9564()));
        List<class_3124.class_5876> redDeepslateRedstoneOre =
                List.of(class_3124.method_33994(redDeepslateReplacables, ModBlocks.RED_DEEPSLATE_REDSTONE_ORE.method_9564()));
        List<class_3124.class_5876> redDeepslateEmeraldOre =
                List.of(class_3124.method_33994(redDeepslateReplacables, ModBlocks.RED_DEEPSLATE_EMERALD_ORE.method_9564()));
        List<class_3124.class_5876> redDeepslateLapisOre =
                List.of(class_3124.method_33994(redDeepslateReplacables, ModBlocks.RED_DEEPSLATE_LAPIS_ORE.method_9564()));
        List<class_3124.class_5876> redDeepslateDiamondOre =
                List.of(class_3124.method_33994(redDeepslateReplacables, ModBlocks.RED_DEEPSLATE_DIAMOND_ORE.method_9564()));

        List<class_3124.class_5876> redDeepslateZincOre =
                List.of(class_3124.method_33994(redDeepslateReplacables, ModBlocks.RED_DEEPSLATE_ZINC_ORE.method_9564()));

        List<class_3124.class_5876> stoneMarble =
                List.of(class_3124.method_33994(stoneReplacables, ModBlocks.MARBLE.method_9564()));

        List<class_3124.class_5876> deepslateLimestone =
                List.of(class_3124.method_33994(deepslateReplacables, ModBlocks.LIMESTONE.method_9564()));

        List<class_3124.class_5876> deepslateRedDeepslate =
                List.of(class_3124.method_33994(deepslateReplacables, ModBlocks.RED_DEEPSLATE.method_9564()));

        List<class_3124.class_5876> netherSulfurOre =
                List.of(class_3124.method_33994(netherReplacables, ModBlocks.NETHER_SULFUR_ORE.method_9564()));

        List<class_3124.class_5876> endstoneEnduriumOre =
                List.of(class_3124.method_33994(endReplacables, ModBlocks.END_ENDURIUM_ORE.method_9564()));

        List<class_3124.class_5876> leadOre =
                List.of(
                        class_3124.method_33994(deepslateReplacables, ModBlocks.LEAD_ORE.method_9564()),
                        class_3124.method_33994(redDeepslateReplacables, ModBlocks.RED_DEEPSLATE_LEAD_ORE.method_9564())
                );

        List<class_3124.class_5876> deepslateUraniumOre =
                List.of(
                        class_3124.method_33994(deepslateReplacables, ModBlocks.DEEPSLATE_URANIUM_ORE.method_9564()),
                        class_3124.method_33994(redDeepslateReplacables, ModBlocks.RED_DEEPSLATE_URANIUM_ORE.method_9564())
                );

        List<class_3124.class_5876> deepslateFossil =
                List.of(class_3124.method_33994(deepslateReplacables, ModBlocks.DEEPSLATE_FOSSIL.method_9564()));

        List<class_3124.class_5876> deepslateHelioriteOres =
                List.of(
                        class_3124.method_33994(deepslateReplacables, ModBlocks.DEEPSLATE_HELIORITE_ORE.method_9564()),
                        class_3124.method_33994(redDeepslateReplacables, ModBlocks.RED_DEEPSLATE_HELIORITE_ORE.method_9564())
                );
        List<class_3124.class_5876> deepslatePalladiumOres =
                List.of(
                        class_3124.method_33994(deepslateReplacables, ModBlocks.DEEPSLATE_PALLADIUM_ORE.method_9564()),
                        class_3124.method_33994(redDeepslateReplacables, ModBlocks.RED_DEEPSLATE_PALLADIUM_ORE.method_9564())
                );
        List<class_3124.class_5876> deepslateJurassolineOres =
                List.of(
                        class_3124.method_33994(deepslateReplacables, ModBlocks.DEEPSLATE_JURASSOLINE_ORE.method_9564()),
                        class_3124.method_33994(redDeepslateReplacables, ModBlocks.RED_DEEPSLATE_JURASSOLINE_ORE.method_9564())
                );
        List<class_3124.class_5876> deepslateCinnabarOres =
                List.of(
                        class_3124.method_33994(deepslateReplacables, ModBlocks.DEEPSLATE_CINNABAR_ORE.method_9564()),
                        class_3124.method_33994(redDeepslateReplacables, ModBlocks.RED_DEEPSLATE_CINNABAR_ORE.method_9564())
                );
        List<class_3124.class_5876> deepslateNebularOres =
                List.of(
                        class_3124.method_33994(deepslateReplacables, ModBlocks.DEEPSLATE_NEBULAR_ORE.method_9564()),
                        class_3124.method_33994(redDeepslateReplacables, ModBlocks.RED_DEEPSLATE_NEBULAR_ORE.method_9564())
                );

        List<class_3124.class_5876> bedrockMithrilOres =
                List.of(class_3124.method_33994(bedrockReplacables, ModBlocks.BEDROCK_MITHRIL_ORE.method_9564()));

        List<class_3124.class_5876> moonRockCoalOre =
                List.of(class_3124.method_33994(lunarReplacables, ModBlocks.MEGAREGOLITH_COAL_ORE.method_9564()));
        List<class_3124.class_5876> moonRockIronOre =
                List.of(class_3124.method_33994(lunarReplacables, ModBlocks.MEGAREGOLITH_IRON_ORE.method_9564()));
        List<class_3124.class_5876> moonRockLunarCallainusOre =
                List.of(class_3124.method_33994(lunarReplacables, ModBlocks.MEGAREGOLITH_LUNAR_CALLAINUS_ORE.method_9564()));

        register(context, MARBLE_KEY, class_3031.field_13517, new class_3124(stoneMarble, 32));
        register(context, LIMESTONE_KEY, class_3031.field_13517, new class_3124(deepslateLimestone, 32));
        register(context, RED_DEEPSLATE_KEY, class_3031.field_13517, new class_3124(deepslateRedDeepslate, 32));

        register(context, NETHER_SULFUR_ORE_KEY, class_3031.field_13517, new class_3124(netherSulfurOre, 8));
        register(context, ENDSTONE_ENDURIUM_ORE_KEY, class_3031.field_13517, new class_3124(endstoneEnduriumOre, 8));

        register(context, LEAD_ORE_KEY, class_3031.field_13517, new class_3124(leadOre, 8));
        register(context, DEEPSLATE_URANIUM_ORE_KEY, class_3031.field_13517, new class_3124(deepslateUraniumOre, 8));

        register(context, DEEPSLATE_FOSSIL_KEY, class_3031.field_13517, new class_3124(deepslateFossil, 4));
        register(context, HELIORITE_ORE_KEY, class_3031.field_13517, new class_3124(deepslateHelioriteOres, 8));
        register(context, PALLADIUM_ORE_KEY, class_3031.field_13517, new class_3124(deepslatePalladiumOres, 8));
        register(context, JURASSOLINE_ORE_KEY, class_3031.field_13517, new class_3124(deepslateJurassolineOres, 8));
        register(context, CINNABAR_ORE_KEY, class_3031.field_13517, new class_3124(deepslateCinnabarOres, 8));
        register(context, NEBULAR_ORE_KEY, class_3031.field_13517, new class_3124(deepslateNebularOres, 8));

        register(context, MITHRIL_ORE_KEY, class_3031.field_13517, new class_3124(bedrockMithrilOres, 8));

        register(context, RED_GRAVEL_KEY, class_3031.field_13517, new class_3124(redGravel, 32));
        register(context, RED_DEEPSLATE_MARBLE_KEY, class_3031.field_13517, new class_3124(redDeepslateMarble, 32));
        register(context, RED_DEEPSLATE_LIMESTONE_KEY, class_3031.field_13517, new class_3124(redDeepslateLimestone, 32));

        register(context, RED_DEEPSLATE_FOSSIL_KEY, class_3031.field_13517, new class_3124(redDeepslateFossil, 4));

        register(context, RED_DEEPSLATE_SULFUR_ORE_KEY, class_3031.field_13517, new class_3124(redDeepslateSulfurOre, 8));
        register(context, RED_DEEPSLATE_QUARTZ_ORE_KEY, class_3031.field_13517, new class_3124(redDeepslateQuartzOre, 8));
        register(context, RED_DEEPSLATE_IRON_ORE_KEY, class_3031.field_13517, new class_3124(redDeepslateIronOre, 8));
        register(context, RED_DEEPSLATE_COPPER_ORE_KEY, class_3031.field_13517, new class_3124(redDeepslateCopperOre, 8));
        register(context, RED_DEEPSLATE_GOLD_ORE_KEY, class_3031.field_13517, new class_3124(redDeepslateGoldOre, 8));
        register(context, RED_DEEPSLATE_REDSTONE_ORE_KEY, class_3031.field_13517, new class_3124(redDeepslateRedstoneOre, 8));
        register(context, RED_DEEPSLATE_EMERALD_ORE_KEY, class_3031.field_13517, new class_3124(redDeepslateEmeraldOre, 8));
        register(context, RED_DEEPSLATE_LAPIS_ORE_KEY, class_3031.field_13517, new class_3124(redDeepslateLapisOre, 8));
        register(context, RED_DEEPSLATE_DIAMOND_ORE_KEY, class_3031.field_13517, new class_3124(redDeepslateDiamondOre, 8));

        register(context, RED_DEEPSLATE_ZINC_ORE_KEY, class_3031.field_13517, new class_3124(redDeepslateZincOre, 8));

        register(context, MOON_ROCK_COAL_ORE_KEY, class_3031.field_13517, new class_3124(moonRockCoalOre, 8));
        register(context, MOON_ROCK_IRON_ORE_KEY, class_3031.field_13517, new class_3124(moonRockIronOre, 8));
        register(context, MOON_ROCK_LUNAR_CALLAINUS_ORE_KEY, class_3031.field_13517, new class_3124(moonRockLunarCallainusOre, 4));

        register(context, GINKGO_KEY, class_3031.field_24134, new class_4643.class_4644(
                        class_4651.method_38432(ModBlocks.GINKGO_LOG),
                        new class_5140(7, 3, 2),
                        class_4651.method_38432(ModBlocks.GINKGO_LEAVES),
                        new class_5209(
                                class_6016.method_34998(1),
                                class_6016.method_34998(0),
                                2
                        ),
                        new class_5204(1, 1, 2))
                        .method_34346(class_4651.method_38432(ModBlocks.RICH_DIRT))
                        .method_27376(ImmutableList.of(class_4664.field_24965))
                        .method_27374()
                        .method_23445()
        );

        register(context, MEGA_GINKGO_KEY, class_3031.field_24134, new class_4643.class_4644(
                        class_4651.method_38432(ModBlocks.GINKGO_LOG),
                        new class_5214(10, 4, 8),
                        class_4651.method_38432(ModBlocks.GINKGO_LEAVES),
                        new class_5209(
                                class_6016.method_34998(2),
                                class_6016.method_34998(0),
                                2
                        ),
                        new class_5204(1, 1, 2))
                        .method_34346(class_4651.method_38432(ModBlocks.RICH_DIRT))
                        .method_27376(ImmutableList.of(class_4664.field_24965))
                        .method_27374()
                        .method_23445()
        );
    }

    public static class_5321<class_2975<?,?>> registerKey(String name) {
        return class_5321.method_29179(class_7924.field_41239, new class_2960(TLOTD.MOD_ID, name));
    }

    private static <FC extends class_3037, F extends class_3031<FC>> void register(class_7891<class_2975<?,?>> context, class_5321<class_2975<?,?>> key, F feature, FC configuration) {
        context.method_46838(key, new class_2975<>(feature, configuration));
    }
}
