package net.tlotd.world;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.class_18;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_26;
import net.minecraft.class_3218;

public class SignalTrackingArray extends class_18 {
    private final Set<String> signals = new HashSet<>();

    public static SignalTrackingArray get(class_3218 world) {
        class_26 manager = world.method_17983();
        return manager.method_17924(
                SignalTrackingArray::createFromNbt,
                SignalTrackingArray::new,
                "tlotd_signals"
        );
    }

    public static SignalTrackingArray createFromNbt(class_2487 nbt) {
        SignalTrackingArray state = new SignalTrackingArray();
        class_2499 list = nbt.method_10554("signals", class_2520.field_33258);

        for (class_2520 elem : list) {
            state.signals.add(elem.method_10714());
        }

        return state;
    }

    @Override
    public class_2487 method_75(class_2487 nbt) {
        class_2499 list = new class_2499();
        for (String signal : signals) {
            list.add(class_2519.method_23256(signal));
        }
        nbt.method_10566("signals", list);
        return nbt;
    }

    public boolean hasSignal(String signal) {
        return signals.contains(signal);
    }

    public boolean hasAnySignals() {
        return !signals.isEmpty();
    }

    public int getSignalCount() {
        return signals.size();
    }

    public Set<String> getAllSignals() {
        return Set.copyOf(signals); // immutable copy
    }

    public List<String> getAllSignalsList() {
        return new ArrayList<>(signals); // index-based
    }

    public String getSignalAt(int index) {
        List<String> list = getAllSignalsList();
        if (index < 0 || index >= list.size()) {
            return null;
        }
        return list.get(index);
    }

    public void addSignal(String signal) {
        if (signals.add(signal)) {
            method_80();
        }
    }

    public void removeSignal(String signal) {
        if (signals.remove(signal)) {
            method_80();
        }
    }

    public void clearSignals() {
        if (!signals.isEmpty()) {
            signals.clear();
            method_80();
        }
    }
}