package net.tlotd.world.dimension;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_1923;
import net.minecraft.class_1966;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2794;
import net.minecraft.class_2893;
import net.minecraft.class_2902;
import net.minecraft.class_3233;
import net.minecraft.class_3756;
import net.minecraft.class_4543;
import net.minecraft.class_4966;
import net.minecraft.class_5138;
import net.minecraft.class_5539;
import net.minecraft.class_5819;
import net.minecraft.class_6748;
import net.minecraft.class_7138;
import net.minecraft.world.gen.chunk.*;
import net.tlotd.block.ModBlocks;
import net.tlotd.config.ModConfigs;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;

public class LunarChunkGenerator extends class_2794 {

    public static final Codec<LunarChunkGenerator> CODEC = RecordCodecBuilder.create(instance -> instance.group(
            class_1966.field_24713.fieldOf("biome_source").forGetter(generator -> generator.biomeSource)
    ).apply(instance, LunarChunkGenerator::new));

    private final class_1966 biomeSource;
    private final class_3756 heightNoise;

    private final int MoonBedrock = -64;

    public LunarChunkGenerator(class_1966 biomeSource) {
        super(biomeSource);
        this.field_12761 = biomeSource;
        this.heightNoise = new class_3756(class_5819.method_43049(ModConfigs.LUNAR_SEED));
    }

    @Override
    protected Codec<? extends class_2794> method_28506() {
        return field_24746;
    }

    @Override
    public void method_12108(class_3233 chunkRegion, long seed, class_7138 noiseConfig, class_4543 biomeAccess, class_5138 structureAccessor, class_2791 chunk, class_2893.class_2894 carverStep) {

    }

    @Override
    public void method_12110(class_3233 region, class_5138 structures, class_7138 noiseConfig, class_2791 chunk) {

    }

    @Override
    public void method_12107(class_3233 region) {

    }

    @Override
    public int method_12104() {
        return 320;
    }

    @Override
    public CompletableFuture<class_2791> method_12088(Executor executor, class_6748 blender, class_7138 noiseConfig, class_5138 structureAccessor, class_2791 chunk) {
        class_1923 chunkPos = chunk.method_12004();

        for (int dx = 0; dx < 16; dx++) {
            for (int dz = 0; dz < 16; dz++) {
                int worldX = chunkPos.method_8326() + dx;
                int worldZ = chunkPos.method_8328() + dz;

                double noise = heightNoise.method_33658(worldX * 0.05, 0, worldZ * 0.05);
                int height = 48 + (int)(noise * 16);

                for (int dy = MoonBedrock; dy <= height && dy < chunk.method_31600(); dy++) {
                    class_2680 state;
                    if (dy == height) { state = ModBlocks.LUNAR_REGOLITH.method_9564(); }
                    else { state = ModBlocks.MEGAREGOLITH.method_9564(); }
                    if (dy >= MoonBedrock && dy < chunk.method_31600()) {
                        chunk.method_12010(new class_2338(dx, dy, dz), state, false);
                    }
                }

                chunk.method_12010(new class_2338(dx, MoonBedrock, dz), ModBlocks.LUNAR_BEDROCK.method_9564(), false);
                for (int dy = MoonBedrock + 1; dy < MoonBedrock + 5; dy++) {
                    long seed = class_2338.method_10064(worldX, dy, worldZ) ^ ModConfigs.LUNAR_SEED ^ 0xDEADBEEFL;
                    class_5819 random = class_5819.method_43049(seed);
                    if (random.method_43048(5) > (dy - MoonBedrock)) {
                        chunk.method_12010(new class_2338(dx, dy, dz), ModBlocks.LUNAR_BEDROCK.method_9564(), false);
                    }
                }
                //Upcoming Area
                chunk.method_12010(new class_2338(dx, MoonBedrock-1, dz), class_2246.field_9987.method_9564(), false);
            }
        }
        return CompletableFuture.completedFuture(chunk);
    }

    @Override
    public int method_16398() {
        return -128;
    }

    @Override
    public int method_33730() {
        return -128;
    }

    @Override
    public int method_16397(int x, int z, class_2902.class_2903 heightmap, class_5539 world, class_7138 config) {
        double noise = heightNoise.method_33658(x * 0.05, 0, z * 0.05);
        return 48 + (int)(noise * 16);
    }

    @Override
    public class_4966 method_26261(int x, int z, class_5539 world, class_7138 config) {
        int height = method_16397(x, z, class_2902.class_2903.field_13202, world, config);
        class_2680[] states = new class_2680[height];
        Arrays.fill(states, class_2246.field_10340.method_9564());
        return new class_4966(0, states);
    }

    @Override
    public void method_40450(List<String> text, class_7138 config, class_2338 pos) {
        text.add("LunarChunkGenerator: moon terrain");
    }
}