/*
 * Decompiled with CFR 0.152.
 */
package net.tlotd.world;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.class_18;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_26;
import net.minecraft.class_3218;

public class SignalTrackingArray
extends class_18 {
    private final Set<String> signals = new HashSet<String>();

    public static SignalTrackingArray get(class_3218 world) {
        class_26 manager = world.method_17983();
        return (SignalTrackingArray)manager.method_17924(SignalTrackingArray::createFromNbt, SignalTrackingArray::new, "tlotd_signals");
    }

    public static SignalTrackingArray createFromNbt(class_2487 nbt) {
        SignalTrackingArray state = new SignalTrackingArray();
        class_2499 list = nbt.method_10554("signals", 8);
        for (class_2520 elem : list) {
            state.signals.add(elem.method_10714());
        }
        return state;
    }

    public class_2487 method_75(class_2487 nbt) {
        class_2499 list = new class_2499();
        for (String signal : this.signals) {
            list.add((Object)class_2519.method_23256((String)signal));
        }
        nbt.method_10566("signals", (class_2520)list);
        return nbt;
    }

    public boolean hasSignal(String signal) {
        return this.signals.contains(signal);
    }

    public boolean hasAnySignals() {
        return !this.signals.isEmpty();
    }

    public int getSignalCount() {
        return this.signals.size();
    }

    public Set<String> getAllSignals() {
        return Set.copyOf(this.signals);
    }

    public List<String> getAllSignalsList() {
        return new ArrayList<String>(this.signals);
    }

    public String getSignalAt(int index) {
        List<String> list = this.getAllSignalsList();
        if (index < 0 || index >= list.size()) {
            return null;
        }
        return list.get(index);
    }

    public void addSignal(String signal) {
        if (this.signals.add(signal)) {
            this.method_80();
        }
    }

    public void removeSignal(String signal) {
        if (this.signals.remove(signal)) {
            this.method_80();
        }
    }

    public void clearSignals() {
        if (!this.signals.isEmpty()) {
            this.signals.clear();
            this.method_80();
        }
    }
}

