/*
 * Decompiled with CFR 0.152.
 */
package net.tlotd.block.entity;

import java.util.Optional;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleVariantStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_3611;
import net.minecraft.class_3913;
import net.minecraft.class_3956;
import net.minecraft.class_5544;
import net.tlotd.block.ModBlocks;
import net.tlotd.block.custom.RitualisticCircleBlock;
import net.tlotd.block.custom.StickCrossBlock;
import net.tlotd.block.custom.WitchingTableBlock;
import net.tlotd.block.entity.ImplementedInventory;
import net.tlotd.block.entity.ModBlockEntities;
import net.tlotd.config.ModConfigs;
import net.tlotd.fluid.ModFluids;
import net.tlotd.gui.WitchingTableGUIHandler;
import net.tlotd.item.ModItems;
import net.tlotd.networking.ModMessages;
import net.tlotd.recipe.WitchingRecipe;
import net.tlotd.util.ModTags;
import org.jetbrains.annotations.Nullable;

public class WitchingTableBlockEntity
extends class_2586
implements ExtendedScreenHandlerFactory,
ImplementedInventory {
    private final class_2371<class_1799> inventory = class_2371.method_10213((int)12, (Object)class_1799.field_8037);
    private static final int OUTPUT_SLOT = 11;
    public final SingleVariantStorage<FluidVariant> fluidStorage = new SingleVariantStorage<FluidVariant>(){

        protected FluidVariant getBlankVariant() {
            return FluidVariant.blank();
        }

        public long getCapacity(FluidVariant fluidVariant) {
            return 648000L;
        }

        protected void onFinalCommit() {
            WitchingTableBlockEntity.this.method_5431();
            if (!WitchingTableBlockEntity.this.field_11863.method_8608()) {
                WitchingTableBlockEntity.this.sendFluidPacket();
            }
        }
    };
    protected final class_3913 propertyDelegate = new class_3913(){

        public int method_17390(int index) {
            return switch (index) {
                case 0 -> WitchingTableBlockEntity.this.progress;
                case 1 -> WitchingTableBlockEntity.this.maxProgress;
                default -> 0;
            };
        }

        public void method_17391(int index, int value) {
            switch (index) {
                case 0: {
                    WitchingTableBlockEntity.this.progress = value;
                    break;
                }
                case 1: {
                    WitchingTableBlockEntity.this.maxProgress = value;
                }
            }
        }

        public int method_17389() {
            return 2;
        }
    };
    private int progress = 0;
    private int maxProgress = 126;

    private void sendFluidPacket() {
        class_2540 data = PacketByteBufs.create();
        ((FluidVariant)this.fluidStorage.variant).toPacket(data);
        data.writeLong(this.fluidStorage.amount);
        data.method_10807(this.method_11016());
        for (class_3222 player : PlayerLookup.tracking((class_3218)((class_3218)this.field_11863), (class_2338)this.method_11016())) {
            ServerPlayNetworking.send((class_3222)player, (class_2960)ModMessages.FLUID_SYNC, (class_2540)data);
        }
    }

    public void setFluidLevel(FluidVariant fluidVariant, long fluidLevel) {
        this.fluidStorage.variant = fluidVariant;
        this.fluidStorage.amount = fluidLevel;
    }

    public WitchingTableBlockEntity(class_2338 pos, class_2680 state) {
        super(ModBlockEntities.WITCHING_TABLE_BLOCK_ENTITY, pos, state);
    }

    public class_1799 getRenderStack() {
        if (!this.method_5438(11).method_7960()) {
            return this.method_5438(11);
        }
        if (!this.method_5438(8).method_7960()) {
            return this.method_5438(8);
        }
        if (!this.method_5438(7).method_7960()) {
            return this.method_5438(7);
        }
        if (!this.method_5438(6).method_7960()) {
            return this.method_5438(6);
        }
        if (!this.method_5438(5).method_7960()) {
            return this.method_5438(5);
        }
        if (!this.method_5438(4).method_7960()) {
            return this.method_5438(4);
        }
        if (!this.method_5438(3).method_7960()) {
            return this.method_5438(3);
        }
        if (!this.method_5438(2).method_7960()) {
            return this.method_5438(2);
        }
        if (!this.method_5438(1).method_7960()) {
            return this.method_5438(1);
        }
        return this.method_5438(0);
    }

    @Override
    public void method_5431() {
        this.field_11863.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 3);
        super.method_5431();
    }

    public void writeScreenOpeningData(class_3222 serverPlayerEntity, class_2540 packetByteBuf) {
        packetByteBuf.method_10807(this.field_11867);
    }

    public class_2561 method_5476() {
        return class_2561.method_43471((String)"block.tlotd.witching_table");
    }

    @Override
    public class_2371<class_1799> getItems() {
        return this.inventory;
    }

    protected void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        class_1262.method_5426((class_2487)nbt, this.inventory);
        nbt.method_10569("witching_table.progress", this.progress);
        nbt.method_10566("witching_table.fluid", (class_2520)((FluidVariant)this.fluidStorage.variant).toNbt());
        nbt.method_10544("witching_table.fluid_amount", this.fluidStorage.amount);
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        class_1262.method_5429((class_2487)nbt, this.inventory);
        this.progress = nbt.method_10550("witching_table.progress");
        this.fluidStorage.variant = FluidVariant.fromNbt((class_2487)((class_2487)nbt.method_10580("witching_table.fluid")));
        this.fluidStorage.amount = nbt.method_10537("witching_table.fluid_amount");
    }

    public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
        this.sendFluidPacket();
        return new WitchingTableGUIHandler(syncId, playerInventory, this, this.propertyDelegate);
    }

    public void tick(class_1937 world, class_2338 pos, class_2680 state) {
        if (world.method_8608()) {
            return;
        }
        if (this.isOutputSlotEmptyOrReceivable()) {
            if (!(!this.hasRecipe() || ModConfigs.WITCHING_TABLE_NEEDS_BLOOD && !this.hasEnoughFluid() || ModConfigs.WITCHING_TABLE_NEEDS_SOULS && (Integer)state.method_11654((class_2769)WitchingTableBlock.SOUL_CHARGES) + (Integer)state.method_11654((class_2769)WitchingTableBlock.CURSED_SOUL_CHARGES) + (Integer)state.method_11654((class_2769)WitchingTableBlock.ABYSSAL_SOUL_CHARGES) <= 0)) {
                this.increaseCraftProgress();
                WitchingTableBlockEntity.method_31663((class_1937)world, (class_2338)pos, (class_2680)state);
                if (this.hasCraftingFinished()) {
                    this.craftItem();
                    if (ModConfigs.WITCHING_TABLE_NEEDS_BLOOD) {
                        this.extractFluid();
                    }
                    if (ModConfigs.WITCHING_TABLE_NEEDS_SOULS) {
                        this.consumeSoul(world, pos, state);
                    }
                    if (this.witchingTableBase()) {
                        world.method_8501(pos.method_10069(-1, -1, -1), (class_2680)ModBlocks.RITUALISTIC_FANCY_CHARRED_PLANKS.method_9564().method_11657((class_2769)RitualisticCircleBlock.STATE, (Comparable)Integer.valueOf(0)));
                        world.method_8501(pos.method_10069(0, -1, -1), (class_2680)ModBlocks.RITUALISTIC_FANCY_CHARRED_PLANKS.method_9564().method_11657((class_2769)RitualisticCircleBlock.STATE, (Comparable)Integer.valueOf(1)));
                        world.method_8501(pos.method_10069(1, -1, -1), (class_2680)ModBlocks.RITUALISTIC_FANCY_CHARRED_PLANKS.method_9564().method_11657((class_2769)RitualisticCircleBlock.STATE, (Comparable)Integer.valueOf(2)));
                        world.method_8501(pos.method_10069(-1, -1, 0), (class_2680)ModBlocks.RITUALISTIC_FANCY_CHARRED_PLANKS.method_9564().method_11657((class_2769)RitualisticCircleBlock.STATE, (Comparable)Integer.valueOf(3)));
                        world.method_8501(pos.method_10069(0, -1, 0), (class_2680)ModBlocks.RITUALISTIC_FANCY_CHARRED_PLANKS.method_9564().method_11657((class_2769)RitualisticCircleBlock.STATE, (Comparable)Integer.valueOf(4)));
                        world.method_8501(pos.method_10069(1, -1, 0), (class_2680)ModBlocks.RITUALISTIC_FANCY_CHARRED_PLANKS.method_9564().method_11657((class_2769)RitualisticCircleBlock.STATE, (Comparable)Integer.valueOf(5)));
                        world.method_8501(pos.method_10069(-1, -1, 1), (class_2680)ModBlocks.RITUALISTIC_FANCY_CHARRED_PLANKS.method_9564().method_11657((class_2769)RitualisticCircleBlock.STATE, (Comparable)Integer.valueOf(6)));
                        world.method_8501(pos.method_10069(0, -1, 1), (class_2680)ModBlocks.RITUALISTIC_FANCY_CHARRED_PLANKS.method_9564().method_11657((class_2769)RitualisticCircleBlock.STATE, (Comparable)Integer.valueOf(7)));
                        world.method_8501(pos.method_10069(1, -1, 1), (class_2680)ModBlocks.RITUALISTIC_FANCY_CHARRED_PLANKS.method_9564().method_11657((class_2769)RitualisticCircleBlock.STATE, (Comparable)Integer.valueOf(8)));
                    }
                    for (int x = -5; x <= 5; ++x) {
                        for (int y = -5; y <= 5; ++y) {
                            for (int z = -5; z <= 5; ++z) {
                                if (world.method_8320(pos.method_10069(x, y, z)).method_26164(class_3481.field_26983)) {
                                    world.method_8501(pos.method_10069(x, y, z), (class_2680)world.method_8320(pos.method_10069(x, y, z)).method_11657((class_2769)class_5544.field_27175, (Comparable)Boolean.valueOf(false)));
                                    world.method_8466((class_2394)class_2398.field_23114, true, (double)(pos.method_10263() + x) + 0.5, (double)(pos.method_10264() + y) + 0.5, (double)(pos.method_10260() + z) + 0.5, 0.0, 0.15, 0.0);
                                }
                                if (!world.method_8320(pos.method_10069(x, y, z)).method_27852(ModBlocks.STICK_CROSS)) continue;
                                world.method_8501(pos.method_10069(x, y, z), (class_2680)world.method_8320(pos.method_10069(x, y, z)).method_11657((class_2769)StickCrossBlock.FLIPPED, (Comparable)Boolean.valueOf(true)));
                                world.method_8466((class_2394)class_2398.field_23114, true, (double)(pos.method_10263() + x) + 0.5, (double)(pos.method_10264() + y) + 0.5, (double)(pos.method_10260() + z) + 0.5, 0.0, 0.15, 0.0);
                            }
                        }
                    }
                    this.resetProgress();
                    this.sendFluidPacket();
                }
            } else {
                this.resetProgress();
            }
        } else {
            this.resetProgress();
            WitchingTableBlockEntity.method_31663((class_1937)world, (class_2338)pos, (class_2680)state);
        }
        if (this.spaceForFluid()) {
            if (this.hasFluidBottleInSlot()) {
                this.transferFluidBottleToStorage();
                this.sendFluidPacket();
            } else if (this.hasFluidBucketInSlot()) {
                this.transferFluidBucketToStorage();
                this.sendFluidPacket();
            }
        }
        if (this.canBottleOrBucketBeFilled()) {
            if (this.canBucketBeFilled()) {
                this.fillBucket();
                this.sendFluidPacket();
            } else if (this.canBottleBeFilled()) {
                this.fillBottle();
                this.sendFluidPacket();
            }
        }
    }

    private void consumeSoul(class_1937 world, class_2338 pos, class_2680 state) {
        if ((Integer)state.method_11654((class_2769)WitchingTableBlock.SOUL_CHARGES) > 0) {
            world.method_8501(pos, (class_2680)state.method_11657((class_2769)WitchingTableBlock.SOUL_CHARGES, (Comparable)Integer.valueOf((Integer)state.method_11654((class_2769)WitchingTableBlock.SOUL_CHARGES) - 1)));
        } else if ((Integer)state.method_11654((class_2769)WitchingTableBlock.CURSED_SOUL_CHARGES) > 0) {
            world.method_8501(pos, (class_2680)state.method_11657((class_2769)WitchingTableBlock.CURSED_SOUL_CHARGES, (Comparable)Integer.valueOf((Integer)state.method_11654((class_2769)WitchingTableBlock.CURSED_SOUL_CHARGES) - 1)));
        } else {
            world.method_8501(pos, (class_2680)state.method_11657((class_2769)WitchingTableBlock.ABYSSAL_SOUL_CHARGES, (Comparable)Integer.valueOf((Integer)state.method_11654((class_2769)WitchingTableBlock.ABYSSAL_SOUL_CHARGES) - 1)));
        }
    }

    private boolean witchingTableBase() {
        return this.field_11863.method_8320(this.field_11867.method_10069(-1, -1, -1)).method_26164(ModTags.Blocks.WITCHING_TABLE_BASE_BLOCKS) && this.field_11863.method_8320(this.field_11867.method_10069(0, -1, -1)).method_26164(ModTags.Blocks.WITCHING_TABLE_BASE_BLOCKS) && this.field_11863.method_8320(this.field_11867.method_10069(1, -1, -1)).method_26164(ModTags.Blocks.WITCHING_TABLE_BASE_BLOCKS) && this.field_11863.method_8320(this.field_11867.method_10069(-1, -1, 0)).method_26164(ModTags.Blocks.WITCHING_TABLE_BASE_BLOCKS) && this.field_11863.method_8320(this.field_11867.method_10069(0, -1, 0)).method_26164(ModTags.Blocks.WITCHING_TABLE_BASE_BLOCKS) && this.field_11863.method_8320(this.field_11867.method_10069(1, -1, 0)).method_26164(ModTags.Blocks.WITCHING_TABLE_BASE_BLOCKS) && this.field_11863.method_8320(this.field_11867.method_10069(-1, -1, 1)).method_26164(ModTags.Blocks.WITCHING_TABLE_BASE_BLOCKS) && this.field_11863.method_8320(this.field_11867.method_10069(0, -1, 1)).method_26164(ModTags.Blocks.WITCHING_TABLE_BASE_BLOCKS) && this.field_11863.method_8320(this.field_11867.method_10069(1, -1, 1)).method_26164(ModTags.Blocks.WITCHING_TABLE_BASE_BLOCKS);
    }

    private boolean spaceForFluid() {
        return this.fluidStorage.amount <= 567000L;
    }

    private boolean canBottleOrBucketBeFilled() {
        return this.fluidStorage.amount >= 27000L && this.method_5438(10).method_7947() == 1 && (this.method_5438(10).method_7909() == class_1802.field_8469 || this.method_5438(10).method_7909() == class_1802.field_8550);
    }

    private boolean canBucketBeFilled() {
        return this.fluidStorage.amount >= 81000L && this.method_5438(10).method_7909() == class_1802.field_8550 && this.method_5438(10).method_7947() == 1;
    }

    private boolean canBottleBeFilled() {
        return this.fluidStorage.amount >= 27000L && this.method_5438(10).method_7909() == class_1802.field_8469 && this.method_5438(10).method_7947() == 1;
    }

    private void fillBucket() {
        try (Transaction transaction = Transaction.openOuter();){
            this.fluidStorage.extract((TransferVariant)FluidVariant.of((class_3611)ModFluids.STILL_BLOOD), 81000L, (TransactionContext)transaction);
            transaction.commit();
            this.method_5447(10, new class_1799((class_1935)ModFluids.BLOOD_BUCKET));
        }
    }

    private void fillBottle() {
        try (Transaction transaction = Transaction.openOuter();){
            this.fluidStorage.extract((TransferVariant)FluidVariant.of((class_3611)ModFluids.STILL_BLOOD), 27000L, (TransactionContext)transaction);
            transaction.commit();
            this.method_5447(10, new class_1799((class_1935)ModItems.BLOOD_BOTTLE));
        }
    }

    private void resetProgress() {
        this.progress = 0;
    }

    private void craftItem() {
        Optional<WitchingRecipe> recipe = this.getCurrentRecipe();
        this.method_5434(0, 1);
        this.method_5434(1, 1);
        this.method_5434(2, 1);
        this.method_5434(3, 1);
        this.method_5434(4, 1);
        this.method_5434(5, 1);
        this.method_5434(6, 1);
        this.method_5434(7, 1);
        this.method_5434(8, 1);
        this.method_5447(11, new class_1799((class_1935)recipe.get().method_8110(null).method_7909(), this.method_5438(11).method_7947() + recipe.get().method_8110(null).method_7947()));
        this.field_11863.method_8396(null, this.method_11016(), class_3417.field_23060, class_3419.field_15245, 1.0f, 1.0f);
    }

    private void extractFluid() {
        try (Transaction transaction = Transaction.openOuter();){
            this.fluidStorage.extract((TransferVariant)FluidVariant.of((class_3611)ModFluids.STILL_BLOOD), 27000L, (TransactionContext)transaction);
            transaction.commit();
        }
    }

    private boolean hasCraftingFinished() {
        return this.progress >= this.maxProgress;
    }

    private void increaseCraftProgress() {
        ++this.progress;
    }

    private boolean hasFluidBottleInSlot() {
        return this.method_5438(9).method_31573(ModTags.Items.BLOOD_BOTTLES);
    }

    private boolean hasFluidBucketInSlot() {
        return this.method_5438(9).method_31573(ModTags.Items.BLOOD_BUCKETS);
    }

    private void transferFluidBottleToStorage() {
        try (Transaction transaction = Transaction.openOuter();){
            this.fluidStorage.insert((TransferVariant)FluidVariant.of((class_3611)ModFluids.STILL_BLOOD), 27000L, (TransactionContext)transaction);
            transaction.commit();
            this.method_5447(9, new class_1799((class_1935)class_1802.field_8469));
        }
    }

    private void transferFluidBucketToStorage() {
        try (Transaction transaction = Transaction.openOuter();){
            this.fluidStorage.insert((TransferVariant)FluidVariant.of((class_3611)ModFluids.STILL_BLOOD), 81000L, (TransactionContext)transaction);
            transaction.commit();
            this.method_5447(9, new class_1799((class_1935)class_1802.field_8550));
        }
    }

    private boolean hasEnoughFluid() {
        return this.fluidStorage.amount >= 27000L;
    }

    private boolean hasRecipe() {
        Optional<WitchingRecipe> recipe = this.getCurrentRecipe();
        return recipe.isPresent() && this.canInsertAmountIntoOutputSlot(recipe.get().method_8110(null)) && this.canInsertItemIntoOutputSlot(recipe.get().method_8110(null).method_7909());
    }

    private Optional<WitchingRecipe> getCurrentRecipe() {
        class_1277 inv = new class_1277(this.method_5439());
        for (int i = 0; i < this.method_5439(); ++i) {
            inv.method_5447(i, this.method_5438(i));
        }
        return this.method_10997().method_8433().method_8132((class_3956)WitchingRecipe.Type.INSTANCE, (class_1263)inv, this.method_10997());
    }

    private boolean canInsertItemIntoOutputSlot(class_1792 item) {
        return this.method_5438(11).method_7909() == item || this.method_5438(11).method_7960();
    }

    private boolean canInsertAmountIntoOutputSlot(class_1799 result) {
        return this.method_5438(11).method_7947() + result.method_7947() <= this.method_5438(11).method_7914();
    }

    private boolean isOutputSlotEmptyOrReceivable() {
        return this.method_5438(11).method_7960() || this.method_5438(11).method_7947() < this.method_5438(11).method_7914();
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887() {
        return this.method_38244();
    }
}

