/*
 * Decompiled with CFR 0.152.
 */
package net.tlotd.util;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_1792;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.tlotd.util.ModTags;
import net.tlotd.world.SignalTrackingArray;

public class ModCommands {
    public static void registerCommands() {
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"signal").requires(source -> source.method_9259(2))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"add").then(class_2170.method_9244((String)"signal", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> {
            class_3218 world = ((class_2168)context.getSource()).method_9225();
            SignalTrackingArray tracker = SignalTrackingArray.get(world);
            List<class_1792> itemsInTag = world.method_30349().method_30530(class_7924.field_41197).method_40270().filter(entry -> entry.method_40220(ModTags.Items.TRANSMITTABLE_SIGNALS)).map(class_6880::comp_349).toList();
            for (class_1792 item : itemsInTag) {
                String key = item.method_7876();
                if (tracker.hasSignal(key)) continue;
                builder.suggest(key);
            }
            return builder.buildFuture();
        }).executes(ctx -> {
            class_3218 world = ((class_2168)ctx.getSource()).method_9225();
            SignalTrackingArray tracker = SignalTrackingArray.get(world);
            String signal = StringArgumentType.getString((CommandContext)ctx, (String)"signal");
            tracker.addSignal(signal);
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)("Added signal: " + signal)), false);
            return 1;
        }))).then(class_2170.method_9247((String)"*").executes(ctx -> {
            class_3218 world = ((class_2168)ctx.getSource()).method_9225();
            SignalTrackingArray tracker = SignalTrackingArray.get(world);
            List<class_1792> itemsInTag = world.method_30349().method_30530(class_7924.field_41197).method_40270().filter(entry -> entry.method_40220(ModTags.Items.TRANSMITTABLE_SIGNALS)).map(class_6880::comp_349).toList();
            AtomicInteger addedCount = new AtomicInteger(0);
            itemsInTag.forEach(item -> {
                String key = item.method_7876();
                if (!tracker.hasSignal(key)) {
                    tracker.addSignal(key);
                    addedCount.getAndIncrement();
                }
            });
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)("Added " + addedCount.get() + " signals")), false);
            return addedCount.get();
        })))).then(class_2170.method_9247((String)"remove").then(class_2170.method_9244((String)"signal", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> {
            class_3218 world = ((class_2168)context.getSource()).method_9225();
            SignalTrackingArray tracker = SignalTrackingArray.get(world);
            for (String sig : tracker.getAllSignals()) {
                builder.suggest(sig);
            }
            return builder.buildFuture();
        }).executes(ctx -> {
            class_3218 world = ((class_2168)ctx.getSource()).method_9225();
            SignalTrackingArray tracker = SignalTrackingArray.get(world);
            String signal = StringArgumentType.getString((CommandContext)ctx, (String)"signal");
            tracker.removeSignal(signal);
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)("Removed signal: " + signal)), false);
            return 1;
        })))).then(class_2170.method_9247((String)"list").executes(ctx -> {
            class_3218 world = ((class_2168)ctx.getSource()).method_9225();
            SignalTrackingArray tracker = SignalTrackingArray.get(world);
            String list = String.join((CharSequence)", ", tracker.getAllSignals());
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)("The " + tracker.getSignalCount() + " current signals are:" + list)), false);
            return 1;
        }))).then(class_2170.method_9247((String)"clear").executes(ctx -> {
            class_3218 world = ((class_2168)ctx.getSource()).method_9225();
            SignalTrackingArray tracker = SignalTrackingArray.get(world);
            tracker.clearSignals();
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)"Cleared all signals"), false);
            return 1;
        }))));
    }
}

