/*
 * Decompiled with CFR 0.152.
 */
package net.vibzz.immersivewind.network;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.vibzz.immersivewind.config.ModConfig;
import net.vibzz.immersivewind.wind.WindManager;
import net.vibzz.immersivewind.wind.WindMod;

public class WindNetworking {
    public static final class_2960 WIND_SYNC = new class_2960("immersivewind", "wind_sync");
    public static final class_2960 IW_PING = new class_2960("immersivewind", "iw_ping");
    public static final class_2960 IW_PONG = new class_2960("immersivewind", "iw_pong");
    private static long lastServerSendTime = 0L;

    public static void registerServerHandlers() {
        ServerPlayNetworking.registerGlobalReceiver((class_2960)IW_PING, (server, player, handler, buf, responseSender) -> {
            WindMod.LOGGER.info("Received mod ping from IW client, sending pong");
            class_2540 pongBuf = PacketByteBufs.create();
            ServerPlayNetworking.send((class_3222)player, (class_2960)IW_PONG, (class_2540)pongBuf);
        });
    }

    public static void sendWindUpdate(class_3218 world) {
        long currentTime = System.currentTimeMillis();
        if (currentTime - lastServerSendTime >= 1000L) {
            float weather = world.method_8546() ? 2.0f : (world.method_8419() ? 1.0f : 0.0f);
            class_2540 buf = PacketByteBufs.create();
            int currentDirection = WindManager.currentWindDirection;
            int targetDirection = WindManager.targetWindDirection;
            int currentStrength = WindManager.currentWindStrength;
            int targetStrength = WindManager.targetWindStrength;
            buf.method_53002(currentDirection);
            buf.method_53002(targetDirection);
            buf.method_53002(currentStrength);
            buf.method_53002(targetStrength);
            buf.method_52941(weather);
            for (class_3222 player : PlayerLookup.world((class_3218)world)) {
                ServerPlayNetworking.send((class_3222)player, (class_2960)WIND_SYNC, (class_2540)buf);
            }
            lastServerSendTime = currentTime;
            WindMod.LOGGER.debug("Sent wind update to clients - Dir: {} -> {}, Str: {} -> {}", (Object)WindManager.currentWindDirection, (Object)WindManager.targetWindDirection, (Object)WindManager.currentWindStrength, (Object)WindManager.targetWindStrength);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class WindNetworkingClient {
        private static long lastUpdateTime = 0L;
        private static boolean isUpdating = false;
        private static boolean serverHasMod = false;
        private static boolean pingSent = false;
        private static long pingSentTime = 0L;
        private static final long PING_TIMEOUT = 5000L;

        public static boolean isServerModded() {
            return serverHasMod;
        }

        public static void setServerHasMod(boolean hasMod, String context) {
            serverHasMod = hasMod;
            WindMod.LOGGER.info("Immersive Winds mod status detected ({}): {}", (Object)context, (Object)(hasMod ? "INSTALLED" : "NOT INSTALLED"));
        }

        public static void sendPingToServer(class_310 client) {
            if (client.method_1562() != null && !client.method_1542() && !pingSent) {
                class_2540 pingBuf = PacketByteBufs.create();
                ClientPlayNetworking.send((class_2960)IW_PING, (class_2540)pingBuf);
                pingSent = true;
                pingSentTime = System.currentTimeMillis();
            }
            if (client.method_1542()) {
                WindNetworkingClient.setServerHasMod(true, "Singleplayer");
            }
        }

        public static void checkPingTimeout(class_310 client) {
            if (client.method_1562() != null && !client.method_1542() && pingSent && !serverHasMod && System.currentTimeMillis() - pingSentTime > 5000L) {
                WindNetworkingClient.setServerHasMod(false, "Multiplayer Server");
                pingSent = false;
            }
        }

        public static void init() {
            WindMod.LOGGER.info("Initializing client-side wind networking...");
            ClientPlayNetworking.registerGlobalReceiver((class_2960)IW_PONG, (client, handler, buf, responseSender) -> WindNetworkingClient.setServerHasMod(true, "Multiplayer Server"));
            ClientPlayNetworking.registerGlobalReceiver((class_2960)WIND_SYNC, (client, handler, buf, responseSender) -> {
                if (isUpdating) {
                    return;
                }
                int currentDirection = buf.readInt();
                int targetDirection = buf.readInt();
                int currentStrength = buf.readInt();
                int targetStrength = buf.readInt();
                float weather = buf.readFloat();
                long currentTime = System.currentTimeMillis();
                if (currentTime - lastUpdateTime >= 1000L) {
                    isUpdating = true;
                    client.execute(() -> {
                        try {
                            if (ModConfig.getDebugMode()) {
                                WindMod.LOGGER.info("Received wind update from server - Dir: {} -> {}, Str: {} -> {}", (Object)currentDirection, (Object)targetDirection, (Object)currentStrength, (Object)targetStrength);
                            }
                            WindManager.receiveWindFromServer(currentDirection, currentStrength, targetDirection, targetStrength);
                            lastUpdateTime = currentTime;
                        }
                        finally {
                            isUpdating = false;
                        }
                    });
                }
            });
            WindMod.LOGGER.info("Client-side wind networking initialized!");
        }
    }
}

